/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.psi.PsiFile;
import com.intellij.util.AstLoadingFilter;
import org.jetbrains.annotations.Nullable;

public final class ReactUtil {
    public static final String ALT_DEFAULT_NAME = "alt.default.name";
    public static final String FRAGMENT_NAME = "Fragment";
    public static final String CONTEXT_TYPES_PROPERTY = "contextTypes";
    public static final String DISPLAY_NAME_PROPERTY = "displayName";
    public static final String CHILD_CONTEXT_TYPES_PROPERTY = "childContextTypes";
    public static final String PROP_TYPES_PROPERTY = "propTypes";
    public static final String DEFAULT_PROPS_PROPERTY = "defaultProps";
    public static final String GET_DEFAULT_PROPS_METHOD = "getDefaultProps";
    public static final String RENDER_METHOD = "render";
    public static final String CONTEXT_PROPERTY = "context";
    public static final String CHILDREN_PROPERTY = "children";
    public static final String SET_STATE_METHOD = "setState";
    public static final String PROPS = "props";
    public static final String STATE = "state";
    public static final String KEY_PROP = "key";
    public static final String REF_PROP = "ref";
    public static final String REACT_DEFAULT_MODULE_NAME = "react";
    public static final String PROP_TYPES_MODULE_NAME = "prop-types";
    public static final String REACT_NODE = "ReactNode";

    private ReactUtil() {
    }

    public static boolean isReactComponent(@Nullable JSExpression expression) {
        if (!(expression instanceof JSCallExpression)) {
            return false;
        }
        JSCallExpression callExpression = (JSCallExpression)expression;
        JSExpression methodExpression = (JSExpression)AstLoadingFilter.forceAllowTreeLoading((PsiFile)callExpression.getContainingFile(), () -> callExpression.getMethodExpression());
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return false;
        }
        return JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "React", "createClass") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "createReactClass") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "React", "forwardRef");
    }
}

