/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.javascript.frameworks.react.ReactComponent;
import com.intellij.lang.javascript.frameworks.react.ReactXmlElementDescriptor;
import com.intellij.lang.javascript.frameworks.react.references.JSXResolveUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.documentation.HtmlDocumentationProvider;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactTagDocumentationProvider
implements DocumentationProvider,
ExternalDocumentationProvider {
    private final HtmlDocumentationProvider myProvider = new HtmlDocumentationProvider();

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        if (!(originalElement instanceof XmlToken)) {
            return null;
        }
        return this.myProvider.getUrlFor(element, originalElement);
    }

    @Nullable
    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls, boolean onHover) {
        PsiElement originalElement;
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)element.getUserData(DocumentationManager.ORIGINAL_ELEMENT_KEY);
        PsiElement psiElement = pointer != null ? (PsiElement)ReadAction.compute(() -> ((SmartPsiElementPointer)pointer).getElement()) : (originalElement = element);
        if (!(originalElement instanceof XmlToken)) {
            return null;
        }
        return this.myProvider.fetchExternalDocumentation(project, element, docUrls, onHover);
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return false;
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }

    @Nullable
    private static PsiElement resolveReactComponentOrSelf(@Nullable PsiElement element, @NotNull PsiElement originalElement) {
        ReactComponent component;
        Collection<? extends PsiElement> elements;
        PsiElement parent;
        if (originalElement == null) {
            ReactTagDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (element instanceof JSCallExpression && (parent = originalElement.getParent()) instanceof XmlTag && JSXResolveUtil.isComponentName(((XmlTag)parent).getName()) && (elements = (component = ReactXmlElementDescriptor.getComponent((XmlTag)parent)).getElements()).size() == 1) {
            return (PsiElement)ContainerUtil.getFirstItem(elements);
        }
        return element;
    }

    public String generateDoc(PsiElement element, PsiElement originalElement) {
        if (!(originalElement instanceof XmlToken)) {
            return null;
        }
        return this.myProvider.generateDoc(ReactTagDocumentationProvider.resolveReactComponentOrSelf(element, originalElement), originalElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElement", "com/intellij/lang/javascript/frameworks/react/ReactTagDocumentationProvider", "resolveReactComponentOrSelf"));
    }
}

