/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.execution.filters.Filter;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.javascript.CreateRunConfigurationUtil;
import com.intellij.javascript.JSLanguageLevelGuesser;
import com.intellij.javascript.nodejs.packages.NodePackageUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.lang.javascript.boilerplate.NpxPackageDescriptor;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.UIUtil;
import icons.JavaScriptLanguageIcons;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReactCreateAppProjectGenerator
extends NpmPackageProjectGenerator {
    private static final Key<String[]> ARGUMENTS = Key.create((String)"create.react.app.scripts.version");
    private static final String PACKAGE_NAME = "create-react-app";

    @Override
    @NotNull
    protected Runnable postInstall(@NotNull Project project, @NotNull VirtualFile baseDir, File workingDir) {
        if (project == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(1);
        }
        Runnable runnable = () -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            super.postInstall(project, baseDir, workingDir).run();
            CreateRunConfigurationUtil.debugConfiguration(project, 3000);
            CreateRunConfigurationUtil.npmConfiguration(project, "start");
        });
        if (runnable == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(2);
        }
        return runnable;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = JavaScriptBundle.message((String)"create.react.app.name", (Object[])new Object[0]);
        if (string == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String getDescription() {
        return JavaScriptBundle.message((String)"create.react.app.description", (Object[])new Object[0]);
    }

    @Override
    protected Filter @NotNull [] filters(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(4);
        }
        if (baseDir == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(5);
        }
        if (Filter.EMPTY_ARRAY == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(6);
        }
        return Filter.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    protected String executable(@NotNull NodePackage pkg) {
        if (pkg == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(7);
        }
        String string = pkg.getSystemDependentPath() + File.separator + "index.js";
        if (string == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    protected String @NotNull [] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(9);
        }
        if (baseDir == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(10);
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(11);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    protected String @NotNull [] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull NpmPackageProjectGenerator.Settings settings) {
        if (project == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(12);
        }
        if (baseDir == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(14);
        }
        String[] args = new String[]{this.generateInTemp() ? baseDir.getName() : "."};
        String[] scriptsTypescript = (String[])settings.getUserData(ARGUMENTS);
        String[] stringArray = ArrayUtil.mergeArrays((String[])args, (String[])scriptsTypescript);
        if (stringArray == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(15);
        }
        return stringArray;
    }

    @Override
    protected void customizeModule(@NotNull VirtualFile baseDir, ContentEntry entry) {
        if (baseDir == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(16);
        }
        entry.addExcludeFolder(baseDir.getUrl() + "/build");
        Project project = entry.getRootModel().getModule().getProject();
        JSLanguageLevelGuesser.applyGuessedLanguageLevel(project, JSLanguageLevel.getLevelForJSX());
    }

    @Override
    protected String validateProjectPath(@NotNull String path) {
        String error;
        if (path == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(17);
        }
        if ((error = NodePackageUtil.validateNpmPackageName(PathUtil.getFileName((String)path))) != null) {
            return error;
        }
        return super.validateProjectPath(path);
    }

    @Override
    @NotNull
    protected String packageName() {
        return PACKAGE_NAME;
    }

    @Override
    @NotNull
    protected String presentablePackageName() {
        return "create-react-&app:";
    }

    @Override
    @NotNull
    protected List<NpxPackageDescriptor.NpxCommand> getNpxCommands() {
        List<NpxPackageDescriptor.NpxCommand> list2 = Collections.singletonList(new NpxPackageDescriptor.NpxCommand(PACKAGE_NAME, PACKAGE_NAME));
        if (list2 == null) {
            ReactCreateAppProjectGenerator.$$$reportNull$$$0(18);
        }
        return list2;
    }

    public Icon getIcon() {
        return JavaScriptLanguageIcons.Logos.Jsx_16;
    }

    @Override
    @NotNull
    public ProjectGeneratorPeer<NpmPackageProjectGenerator.Settings> createPeer() {
        return new NpmPackageProjectGenerator.NpmPackageGeneratorPeer(){
            private JBCheckBox typescript;

            @Override
            protected JPanel createPanel() {
                JPanel panel2 = super.createPanel();
                this.typescript = new JBCheckBox(UIUtil.replaceMnemonicAmpersand((String)JavaScriptBundle.message((String)"create.react.app.typescript.checkbox", (Object[])new Object[0])));
                panel2.add((Component)this.typescript);
                return panel2;
            }

            @Override
            public void buildUI(@NotNull SettingsStep settingsStep) {
                if (settingsStep == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.buildUI(settingsStep);
                settingsStep.addSettingsComponent((JComponent)this.typescript);
            }

            @Override
            @NotNull
            public NpmPackageProjectGenerator.Settings getSettings() {
                NpmPackageProjectGenerator.Settings settings = super.getSettings();
                ArrayList<String> args = new ArrayList<String>(3);
                if (this.typescript.isSelected()) {
                    NodePackage selected = this.getPackageField().getSelected();
                    SemVer version = selected.getVersion();
                    if (version == null || version.isGreaterOrEqualThan(3, 3, 0)) {
                        args.add("--template");
                        args.add("typescript");
                    } else {
                        args.add("--typescript");
                    }
                }
                settings.putUserData(ARGUMENTS, ArrayUtilRt.toStringArray(args));
                NpmPackageProjectGenerator.Settings settings2 = settings;
                if (settings2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return settings2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settingsStep";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/ReactCreateAppProjectGenerator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactCreateAppProjectGenerator$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSettings";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "buildUI";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/ReactCreateAppProjectGenerator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactCreateAppProjectGenerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "postInstall";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filters";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "executable";
                break;
            }
            case 11: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "generatorArgs";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpxCommands";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "postInstall";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 18: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filters";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executable";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "generatorArgs";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "customizeModule";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "validateProjectPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 15: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

