/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.frameworks.amd.JSModuleReference;
import com.intellij.lang.javascript.frameworks.modules.JSDefaultFileReferenceCompletionFilter;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.typescript.modules.TypeScriptModuleFileReferenceSet;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleFileReferenceSet
extends FileReferenceSet {
    private final String myExplicitNewFileTemplate;

    public JSModuleFileReferenceSet(String str, @NotNull PsiElement element, int startInElement, @Nullable PsiReferenceProvider provider, @Nullable String explicitNewFileTemplate) {
        if (element == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(0);
        }
        super(str, element, startInElement, provider, JSModuleFileReferenceSet.isCaseSensitiveFS(element), false, FileType.EMPTY_ARRAY, false);
        this.myExplicitNewFileTemplate = explicitNewFileTemplate;
        this.reparse();
    }

    private static boolean isCaseSensitiveFS(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(1);
        }
        if ((file2 = element.getContainingFile()) == null) {
            return false;
        }
        return file2.getViewProvider().getVirtualFile().isCaseSensitive();
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        if (this.isAbsolutePathReference()) {
            LinkedHashSet<PsiFileSystemItem> result2 = new LinkedHashSet<PsiFileSystemItem>(super.computeDefaultContexts());
            result2.addAll(this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots()));
            LinkedHashSet<PsiFileSystemItem> linkedHashSet = result2;
            if (linkedHashSet == null) {
                JSModuleFileReferenceSet.$$$reportNull$$$0(2);
            }
            return linkedHashSet;
        }
        String path = this.getPathString();
        if (JSModuleFileReferenceSet.isRelative(path)) {
            Collection collection = this.getParentDirectoryContext();
            if (collection == null) {
                JSModuleFileReferenceSet.$$$reportNull$$$0(3);
            }
            return collection;
        }
        PsiElement element = this.getElement();
        Project project = element.getProject();
        LinkedHashSet<PsiFileSystemItem> result3 = new LinkedHashSet<PsiFileSystemItem>();
        TypeScriptConfig jsConfig = TypeScriptConfigUtil.getConfigForPsiFile(this.getContainingFile(), true);
        if (jsConfig != null && jsConfig.isJSConfig()) {
            TypeScriptModuleFileReferenceSet.fillConfigRootContexts(jsConfig, element.getContainingFile(), result3);
        }
        JSModuleFileReferenceSet.addNodeModulesDirContexts(project, element, result3, this, false);
        result3.addAll(this.getAmdDirectories(element));
        result3.addAll(this.getParentDirectoryContext());
        PsiFile file2 = this.getContainingFile();
        if (file2 != null) {
            JSModuleFileReferenceSet.addDefaultRoots(project, file2, result3);
        }
        result3.addAll(super.computeDefaultContexts());
        LinkedHashSet<PsiFileSystemItem> linkedHashSet = result3;
        if (linkedHashSet == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    @NotNull
    protected Collection<PsiDirectory> getAmdDirectories(@NotNull PsiElement element) {
        if (element == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(5);
        }
        Collection<PsiDirectory> collection = JSAmdUtil.getBaseDirectories(element);
        if (collection == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(6);
        }
        return collection;
    }

    private static void addDefaultRoots(@NotNull Project project, @NotNull PsiFile file2, @NotNull Collection<PsiFileSystemItem> result2) {
        VirtualFile[] roots2;
        ModuleRootManager rootManager;
        if (project == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(8);
        }
        if (result2 == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(9);
        }
        PsiManager manager2 = file2.getManager();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
        if (module != null && (rootManager = ModuleRootManager.getInstance((Module)module)) != null && (roots2 = rootManager.getSourceRoots()).length > 0) {
            for (VirtualFile root : roots2) {
                ContainerUtil.addIfNotNull(result2, (Object)manager2.findDirectory(root));
            }
            return;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile contentRoot = index.getContentRootForFile(virtualFile);
        if (contentRoot != null) {
            ContainerUtil.addIfNotNull(result2, (Object)manager2.findDirectory(contentRoot));
        }
    }

    public FileReference createFileReference(TextRange textRange, int i, String text) {
        return new JSModuleReference(text, i, textRange, this, this.myExplicitNewFileTemplate, this.isSoft()){

            @Override
            public int getWeight() {
                return JSModuleFileReferenceSet.this.getWeight();
            }
        };
    }

    public static void addNodeModulesDirContexts(@NotNull Project project, @NotNull PsiElement element, @NotNull Collection<PsiFileSystemItem> result2, @NotNull FileReferenceSet referenceSet, boolean withTypes) {
        FileReference firstRef;
        String firstRefText;
        if (project == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(10);
        }
        if (element == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(11);
        }
        if (result2 == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(12);
        }
        if (referenceSet == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(13);
        }
        String string = firstRefText = (firstRef = (FileReference)ArrayUtil.getFirstElement((Object[])referenceSet.getAllReferences())) != null ? firstRef.getText() : null;
        if (StringUtil.isEmpty((String)firstRefText)) {
            return;
        }
        VirtualFile localNodeModulesDir = JSModuleFileReferenceSet.findUpNodeModules(element);
        if (localNodeModulesDir == null) {
            JSModuleFileReferenceSet.addNodeModulesContextsFromIndexes(project, element, result2, firstRefText, withTypes);
        } else {
            VirtualFile current = localNodeModulesDir;
            while (current != null) {
                VirtualFile packageJson = NodeModuleUtil.findPackageJsonByNodeModules(current);
                JSModuleFileReferenceSet.doAddNodeModulesContext(current, packageJson, firstRefText, result2, element.getManager());
                VirtualFile parent = current.getParent();
                current = parent == null ? null : NodeModuleUtil.findUpClosestNodeModulesResolveRoot(parent);
            }
            if (withTypes) {
                JSModuleFileReferenceSet.addTypesForNodeModulesDir(element, result2, localNodeModulesDir);
            }
        }
    }

    private static void addNodeModulesContextsFromIndexes(@NotNull Project project, @NotNull PsiElement element, @NotNull Collection<PsiFileSystemItem> result2, String firstRefText, boolean withTypes) {
        if (project == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(14);
        }
        if (element == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(15);
        }
        if (result2 == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(16);
        }
        Collection files = FilenameIndex.getVirtualFilesByName((Project)project, (String)"package.json", (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
        for (VirtualFile file2 : files) {
            VirtualFile nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(file2);
            if (nodeModulesDir == null) continue;
            JSModuleFileReferenceSet.doAddNodeModulesContext(nodeModulesDir, file2, firstRefText, result2, element.getManager());
            if (!withTypes) continue;
            JSModuleFileReferenceSet.addTypesForNodeModulesDir(element, result2, nodeModulesDir);
        }
    }

    @Nullable
    protected static VirtualFile findUpNodeModules(@NotNull PsiElement element) {
        VirtualFile currentFile;
        if (element == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(17);
        }
        if ((currentFile = element.getContainingFile().getOriginalFile().getVirtualFile()) != null) {
            VirtualFile parentNodeModules = NodeModuleSearchUtil.findAncestorNodeModulesDir(currentFile);
            if (parentNodeModules != null) {
                return parentNodeModules;
            }
            return NodeModuleUtil.findUpClosestNodeModulesResolveRoot(currentFile);
        }
        return null;
    }

    protected final Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return new JSDefaultFileReferenceCompletionFilter(this.getElement());
    }

    private static void doAddNodeModulesContext(@NotNull VirtualFile nodeModulesDir, @Nullable VirtualFile packageJson, @NotNull String firstRefText, @NotNull Collection<PsiFileSystemItem> result2, @NotNull PsiManager psiManager) {
        PackageJsonData data;
        if (nodeModulesDir == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(18);
        }
        if (firstRefText == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(19);
        }
        if (result2 == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(20);
        }
        if (psiManager == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(21);
        }
        if (packageJson != null && !(data = PackageJsonData.getOrCreate(packageJson)).containsDependencyWithScope(firstRefText) && !data.isDependencyOfAnyType(firstRefText)) {
            return;
        }
        PsiDirectory directory = psiManager.findDirectory(nodeModulesDir);
        if (directory != null) {
            result2.add((PsiFileSystemItem)directory);
        }
    }

    public static void addTypesForNodeModulesDir(@NotNull PsiElement context, @NotNull Collection<? super PsiFileSystemItem> altResolveModules, @Nullable VirtualFile nodeModulesDirectories) {
        PsiDirectory typesModules;
        VirtualFile typesFile;
        if (context == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(22);
        }
        if (altResolveModules == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(23);
        }
        if (nodeModulesDirectories != null && (typesFile = nodeModulesDirectories.findChild("@types")) != null && (typesModules = context.getManager().findDirectory(typesFile)) != null) {
            altResolveModules.add((PsiFileSystemItem)typesModules);
        }
    }

    protected boolean useIncludingFileAsContext() {
        return false;
    }

    protected int getWeight() {
        return JSModuleBaseReference.ModuleTypes.DEFAULT.weight();
    }

    public static boolean isRelative(@NotNull String pathString) {
        int length;
        if (pathString == null) {
            JSModuleFileReferenceSet.$$$reportNull$$$0(24);
        }
        if ((length = pathString.length()) == 0) {
            return false;
        }
        char firstChar = pathString.charAt(0);
        if (length == 1) {
            return firstChar == '.';
        }
        if (firstChar != '.') {
            return false;
        }
        char secondChar = pathString.charAt(1);
        return secondChar == '/' || secondChar == '\\' || secondChar == '.';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet";
                break;
            }
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 12: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceSet";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDir";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstRefText";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "altResolveModules";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSModuleFileReferenceSet";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAmdDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isCaseSensitiveFS";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAmdDirectories";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultRoots";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addNodeModulesDirContexts";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addNodeModulesContextsFromIndexes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findUpNodeModules";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doAddNodeModulesContext";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addTypesForNodeModulesDir";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isRelative";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

