/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.HtmlCodeStylePanelExtension;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.PresentableEnumUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXHtmlCodeStylePanelExtension
implements HtmlCodeStylePanelExtension {
    private static final Logger LOGGER = Logger.getInstance(JSXHtmlCodeStylePanelExtension.class);
    private static final Comparator<GridConstraints> CONSTRAINT_COMPARATOR = Comparator.comparing(el -> el.getRow()).thenComparing(el -> el.getColumn());

    @NotNull
    public HtmlCodeStylePanelExtension.HtmlPanelCustomizer getCustomizer() {
        return new HtmlCodeStylePanelExtension.HtmlPanelCustomizer(){
            private final JBLabel myLabel = new JBLabel(JavaScriptBundle.message((String)"jsx.code.style.attribute.default.value", (Object[])new Object[0]));
            private final ComboBox<JSCodeStyleSettings.JSXAttributeValuePresentation> myAttributeBox = JSXHtmlCodeStylePanelExtension.createJSXCombobox();

            public void customizeSettingsPanel(@NotNull JPanel settingsPanel) {
                LayoutManager layout;
                if (settingsPanel == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((layout = settingsPanel.getLayout()) instanceof GridLayoutManager)) {
                    LOGGER.error("Grid Layout expected for customizing jsx attribute extension ");
                    return;
                }
                GridLayoutManager gridLayoutManager = (GridLayoutManager)layout;
                Component[] components = settingsPanel.getComponents();
                Map<Component, GridConstraints> constraints = JSXHtmlCodeStylePanelExtension.getOldConstraints(components, gridLayoutManager);
                settingsPanel.removeAll();
                settingsPanel.setLayout((LayoutManager)JSXHtmlCodeStylePanelExtension.copyLayoutManagerWithExtendedRows((GridLayoutManager)layout));
                this.fillComponentsWithNewRows(settingsPanel, components, constraints);
            }

            public boolean isModified(@NotNull CodeStyleSettings rootSettings) {
                if (rootSettings == null) {
                    1.$$$reportNull$$$0(1);
                }
                JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)rootSettings.getCustomSettings(JSCodeStyleSettings.class);
                return this.myAttributeBox.getSelectedItem() != jsSettings.JSX_ATTRIBUTE_VALUE;
            }

            public void reset(@NotNull CodeStyleSettings rootSettings) {
                if (rootSettings == null) {
                    1.$$$reportNull$$$0(2);
                }
                JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)rootSettings.getCustomSettings(JSCodeStyleSettings.class);
                this.myAttributeBox.setSelectedItem((Object)jsSettings.JSX_ATTRIBUTE_VALUE);
            }

            public void apply(@NotNull CodeStyleSettings rootSettings) {
                if (rootSettings == null) {
                    1.$$$reportNull$$$0(3);
                }
                JSCodeStyleSettings jsSettings = (JSCodeStyleSettings)rootSettings.getCustomSettings(JSCodeStyleSettings.class);
                jsSettings.JSX_ATTRIBUTE_VALUE = (JSCodeStyleSettings.JSXAttributeValuePresentation)((Object)this.myAttributeBox.getSelectedItem());
            }

            private void fillComponentsWithNewRows(@NotNull JPanel settingsPanel, Component @NotNull [] components, @NotNull Map<Component, GridConstraints> constraints) {
                if (settingsPanel == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (constraints == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (components == null) {
                    1.$$$reportNull$$$0(6);
                }
                String marksText = ApplicationBundle.message((String)"generated.quote.marks", (Object[])new Object[0]);
                ContainerUtil.sort((Object[])components, Comparator.comparing(el -> (GridConstraints)constraints.get(el), CONSTRAINT_COMPARATOR));
                boolean isShiftedRow = false;
                for (int i = 0; i < components.length; ++i) {
                    Component component = components[i];
                    GridConstraints currentConstraint = constraints.get(component);
                    if (this.isNewComponentInsertionPlace(marksText, component)) {
                        this.insertJSXAttributeComponents(settingsPanel, constraints, currentConstraint, i, components);
                        isShiftedRow = true;
                    }
                    if (isShiftedRow) {
                        currentConstraint.setRow(currentConstraint.getRow() + 1);
                    }
                    settingsPanel.add(component, currentConstraint);
                }
                if (!isShiftedRow) {
                    LOGGER.error("Cannot find component anchor with text '" + marksText + "' for inserting jsx settings");
                }
            }

            private boolean isNewComponentInsertionPlace(@NotNull String marksText, @Nullable Component component) {
                if (marksText == null) {
                    1.$$$reportNull$$$0(7);
                }
                return component instanceof JLabel && marksText.equals(((JLabel)component).getText());
            }

            private void insertJSXAttributeComponents(@NotNull JPanel settingsPanel, @NotNull Map<Component, GridConstraints> constraintsList, @NotNull GridConstraints labelConstraints, int i, Component @NotNull [] components) {
                if (settingsPanel == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (constraintsList == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (labelConstraints == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (components == null) {
                    1.$$$reportNull$$$0(11);
                }
                GridConstraints newConstraintsLabel = (GridConstraints)labelConstraints.clone();
                Component nextComponent = components[i + 1];
                GridConstraints newConstraintsComponent = (GridConstraints)constraintsList.get(nextComponent).clone();
                settingsPanel.add((Component)this.myLabel, newConstraintsLabel);
                settingsPanel.add((Component)this.myAttributeBox, newConstraintsComponent);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "settingsPanel";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rootSettings";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "constraints";
                        break;
                    }
                    case 6: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "components";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "marksText";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "constraintsList";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "labelConstraints";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JSXHtmlCodeStylePanelExtension$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "customizeSettingsPanel";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isModified";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "reset";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "apply";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fillComponentsWithNewRows";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isNewComponentInsertionPlace";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "insertJSXAttributeComponents";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    private static ComboBox<JSCodeStyleSettings.JSXAttributeValuePresentation> createJSXCombobox() {
        ComboBox comboBox = PresentableEnumUtil.fill((ComboBox)new ComboBox(), JSCodeStyleSettings.JSXAttributeValuePresentation.class);
        if (comboBox == null) {
            JSXHtmlCodeStylePanelExtension.$$$reportNull$$$0(0);
        }
        return comboBox;
    }

    @NotNull
    private static Map<Component, GridConstraints> getOldConstraints(Component @NotNull [] components, @NotNull GridLayoutManager gridLayoutManager) {
        if (gridLayoutManager == null) {
            JSXHtmlCodeStylePanelExtension.$$$reportNull$$$0(1);
        }
        if (components == null) {
            JSXHtmlCodeStylePanelExtension.$$$reportNull$$$0(2);
        }
        HashMap<Component, GridConstraints> constraints = new HashMap<Component, GridConstraints>();
        for (Component component : components) {
            constraints.put(component, gridLayoutManager.getConstraintsForComponent(component));
        }
        HashMap<Component, GridConstraints> hashMap = constraints;
        if (hashMap == null) {
            JSXHtmlCodeStylePanelExtension.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @NotNull
    private static GridLayoutManager copyLayoutManagerWithExtendedRows(@NotNull GridLayoutManager gridLayout) {
        if (gridLayout == null) {
            JSXHtmlCodeStylePanelExtension.$$$reportNull$$$0(4);
        }
        int oldRowCount = gridLayout.getRowCount();
        return new GridLayoutManager(oldRowCount + 1, gridLayout.getColumnCount(), gridLayout.getMargin(), gridLayout.getHGap(), gridLayout.getVGap(), gridLayout.isSameSizeHorizontally(), gridLayout.isSameSizeVertically());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JSXHtmlCodeStylePanelExtension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gridLayoutManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gridLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createJSXCombobox";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JSXHtmlCodeStylePanelExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldConstraints";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOldConstraints";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyLayoutManagerWithExtendedRows";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

