/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.psi;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6ExpressionParser;
import com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import com.intellij.lang.javascript.flow.FlowJSElementTypes;
import com.intellij.lang.javascript.flow.psi.FlowJSPsiTypeParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import com.intellij.lang.javascript.parsing.modifiers.JSOneOfModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSOrderedModifiersStructure;
import com.intellij.lang.javascript.types.FlowJSFunctionSignatureElementType;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class FlowInJSPsiTypeParser<T extends ES6Parser<?, ?, ?, ?>>
extends TypeScriptPsiTypeParser<T> {
    protected static final Key<Boolean> ARROW_FUNCTION_RETURN_TYPE_KEY = Key.create((String)"js.parser.arrow.function.return.type");
    private static final JSModifiersStructure TYPE_MEMBER_MODIFIERS = new JSOrderedModifiersStructure(new JSModifiersStructureLeaf(JSTokenTypes.STATIC_KEYWORD), new JSOneOfModifiersStructure(JSTokenTypes.PLUS, JSTokenTypes.MINUS));

    public FlowInJSPsiTypeParser(T parser2) {
        super(parser2);
    }

    @Override
    public boolean parseUnionOrIntersectionComponent(boolean functionTypeAllowed) {
        return this.parseDistinctType(functionTypeAllowed, true);
    }

    @Override
    public boolean tryParseFunctionReturnType() {
        if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            boolean result2 = true;
            if (this.builder.getTokenType() != JSTokenTypes.PERC) {
                result2 = this.parseType();
            }
            this.tryParseTypePredicate();
            return result2;
        }
        return super.tryParseFunctionReturnType();
    }

    @Override
    protected boolean parseFunctionReturnType(PsiBuilder.Marker marker, boolean result2) {
        result2 &= FlowInJSPsiTypeParser.checkMatches(this.builder, JSTokenTypes.EQGT, "javascript.parser.message.expected.eqgt");
        boolean bl = !Boolean.TRUE.equals(this.builder.getUserData(ARROW_FUNCTION_RETURN_TYPE_KEY));
        marker.done((IElementType)FlowJSElementTypes.FUNCTION_TYPE);
        return result2 &= this.parseInUnionOrIntersectionType(true, true, bl);
    }

    @Override
    public boolean tryParseArrowFunctionReturnType() {
        return true;
    }

    @Override
    protected boolean isFunctionTypeAllowed(boolean isFirstComponent, boolean allowedByContext) {
        return allowedByContext;
    }

    @Override
    protected boolean parseDistinctType(boolean functionTypeAllowed, boolean readonlyTypeAllowed) {
        PsiBuilder.Marker functionTypeStartMarker = this.builder.mark();
        boolean result2 = this.parseDistinctTypeInner(functionTypeAllowed);
        if (Boolean.TRUE.equals(this.builder.getUserData(ARROW_FUNCTION_RETURN_TYPE_KEY))) {
            functionTypeAllowed = false;
        }
        while (functionTypeAllowed && this.builder.getTokenType() == JSTokenTypes.EQGT) {
            PsiBuilder.Marker newFunctionTypeStartMarker = functionTypeStartMarker.precede();
            functionTypeStartMarker.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterListElementType());
            functionTypeStartMarker = newFunctionTypeStartMarker;
            newFunctionTypeStartMarker = functionTypeStartMarker.precede();
            result2 &= this.parseFunctionReturnType(functionTypeStartMarker, result2);
            functionTypeStartMarker = newFunctionTypeStartMarker;
        }
        if (!result2 && this.builder.getTokenType() != JSTokenTypes.COLON) {
            functionTypeStartMarker.rollbackTo();
            this.parseDistinctTypeInner(false);
            return false;
        }
        functionTypeStartMarker.drop();
        return result2;
    }

    private boolean parseDistinctTypeInner(boolean functionTypeAllowed) {
        IElementType firstToken = this.builder.getTokenType();
        PsiBuilder.Marker markerForArrayType = this.builder.mark();
        if (firstToken == JSTokenTypes.QUEST) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            this.parseDistinctType(functionTypeAllowed, true);
            marker.done(FlowJSElementTypes.MAYBE_TYPE);
            return this.parseArrayTypeSuffix(markerForArrayType);
        }
        if (firstToken == JSTokenTypes.MULT) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(TypeScriptStubElementTypes.SINGLE_TYPE);
            return this.parseArrayTypeSuffix(markerForArrayType);
        }
        if (firstToken == JSTokenTypes.FUNCTION_KEYWORD) {
            return this.parserSingleType() & this.parseArrayTypeSuffix(markerForArrayType);
        }
        if (firstToken == JSTokenTypes.LBRACE_OR) {
            return this.parseObjectType(JSTokenTypes.OR_RBRACE, "javascript.parser.message.missing.or_rbrace") & this.parseArrayTypeSuffix(markerForArrayType);
        }
        if (firstToken == JSTokenTypes.LPAR) {
            boolean isNamedFunctionTypeParameter = functionTypeAllowed && this.isFunctionTypeExpected();
            IElementType lookahead = this.builder.lookAhead(1);
            if (!isNamedFunctionTypeParameter && lookahead != JSTokenTypes.RPAR && lookahead != JSTokenTypes.AND && lookahead != JSTokenTypes.OR) {
                PsiBuilder.Marker beforeLBrace = this.builder.mark();
                this.builder.advanceLexer();
                PsiBuilder.Marker afterLBrace = this.builder.mark();
                Boolean alreadyProcessingArrow = (Boolean)this.builder.getUserData(ARROW_FUNCTION_RETURN_TYPE_KEY);
                this.builder.putUserData(ARROW_FUNCTION_RETURN_TYPE_KEY, null);
                this.parseDistinctType(true, true);
                this.builder.putUserData(ARROW_FUNCTION_RETURN_TYPE_KEY, (Object)alreadyProcessingArrow);
                IElementType tokenAfterType = this.builder.getTokenType();
                if (tokenAfterType == JSTokenTypes.COMMA) {
                    this.parseFunctionParameters(false);
                    FlowInJSPsiTypeParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
                    afterLBrace.drop();
                    beforeLBrace.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterListElementType());
                    this.parseFunctionReturnType(beforeLBrace.precede(), true);
                } else if (tokenAfterType == JSTokenTypes.AND || tokenAfterType == JSTokenTypes.OR) {
                    this.builder.advanceLexer();
                    this.parseInUnionOrIntersectionType(tokenAfterType == JSTokenTypes.OR, false, functionTypeAllowed);
                    afterLBrace.done(TypeScriptStubElementTypes.UNION_OR_INTERSECTION_TYPE);
                    beforeLBrace.drop();
                    if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                        PsiBuilder.Marker precede = afterLBrace.precede();
                        precede.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterType());
                        this.parseFunctionParameters(false);
                    }
                    FlowInJSPsiTypeParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
                } else if (tokenAfterType == JSTokenTypes.RPAR) {
                    if (this.builder.lookAhead(1) == JSTokenTypes.EQGT && functionTypeAllowed && !Boolean.TRUE.equals(alreadyProcessingArrow)) {
                        this.builder.advanceLexer();
                        afterLBrace.drop();
                        beforeLBrace.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterListElementType());
                        this.parseFunctionReturnType(beforeLBrace.precede(), true);
                    } else {
                        this.builder.advanceLexer();
                        afterLBrace.drop();
                        beforeLBrace.drop();
                    }
                } else {
                    this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.rparen", (Object[])new Object[0]));
                    afterLBrace.drop();
                    beforeLBrace.drop();
                    markerForArrayType.drop();
                    return false;
                }
                return this.parseArrayTypeSuffix(markerForArrayType);
            }
        }
        markerForArrayType.drop();
        return super.parseDistinctType(functionTypeAllowed, true);
    }

    @Override
    public boolean parseTypeMember() {
        PsiBuilder.Marker marker = this.builder.mark();
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            this.builder.advanceLexer();
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType != JSTokenTypes.RBRACE && tokenType != JSTokenTypes.COMMA && tokenType != JSTokenTypes.SEMICOLON) {
                this.parseType();
            }
            marker.done(FlowJSElementTypes.OBJECT_TYPE_SPREAD);
            this.forceCheckForSemicolonOrComma();
            return true;
        }
        if (JSTokenTypes.GET_SET.contains(this.builder.getTokenType()) && JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.lookAhead(1))) {
            PsiBuilder.Marker mark = this.builder.mark();
            this.builder.advanceLexer();
            mark.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getAttributeListElementType());
        }
        ((ES6Parser)this.myJavaScriptParser).parseModifiers(TYPE_MEMBER_MODIFIERS, true, AFTER_TYPE_MEMBER_MODIFIERS_PREDICATE);
        return super.parseTypeMember(marker);
    }

    @Override
    public boolean isIndexSignatureProperty() {
        return this.builder.getTokenType() == JSTokenTypes.LBRACKET;
    }

    @Override
    public boolean parseIndexSignatureNoMarker(PsiBuilder.Marker marker, boolean checkSemicolon) {
        return FlowInJSPsiTypeParser.parseIndexSignatureNoMarker(marker, this.builder, (ES6Parser)this.myJavaScriptParser, checkSemicolon, false);
    }

    @Override
    @NotNull
    protected IElementType getFunctionSignatureElementType() {
        FlowJSFunctionSignatureElementType flowJSFunctionSignatureElementType = FlowJSElementTypes.FUNCTION_SIGNATURE;
        if (flowJSFunctionSignatureElementType == null) {
            FlowInJSPsiTypeParser.$$$reportNull$$$0(0);
        }
        return flowJSFunctionSignatureElementType;
    }

    @Override
    public boolean tryParseType() {
        if (Boolean.TRUE.equals(this.builder.getUserData(FlowJSPsiTypeParser.FORCED_TYPE_KEY)) && this.builder.getTokenType() != JSTokenTypes.COLON) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.colon", (Object[])new Object[0]));
        }
        return super.tryParseType();
    }

    @Override
    protected boolean parseTypeParameter() {
        PsiBuilder.Marker typeParameter = this.builder.mark();
        if (this.builder.getTokenType() == JSTokenTypes.PLUS || this.builder.getTokenType() == JSTokenTypes.MINUS) {
            this.builder.advanceLexer();
        }
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            typeParameter.drop();
            return false;
        }
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.builder.advanceLexer();
            this.parseType();
        } else if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            if (!this.parseType()) {
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.typename", (Object[])new Object[0]));
                typeParameter.done(TypeScriptStubElementTypes.TYPE_PARAMETER);
                return false;
            }
            if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                this.builder.advanceLexer();
                this.parseType();
            }
        }
        typeParameter.done(TypeScriptStubElementTypes.TYPE_PARAMETER);
        return true;
    }

    @Override
    protected boolean parseFunctionParameterList() {
        if (!this.tryParseTypeParameterList()) {
            return true;
        }
        if (this.builder.getTokenType() != JSTokenTypes.LPAR) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.lparen", (Object[])new Object[0]));
            PsiBuilder.Marker parameterList = this.builder.mark();
            parameterList.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterListElementType());
            return true;
        }
        PsiBuilder.Marker parameterList = this.builder.mark();
        this.builder.advanceLexer();
        boolean result2 = this.parseFunctionParameters(true);
        if (this.builder.getTokenType() == JSTokenTypes.RPAR) {
            this.builder.advanceLexer();
        }
        parameterList.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterListElementType());
        return result2;
    }

    private boolean parseFunctionParameters(boolean first) {
        boolean result2 = true;
        while (this.builder.getTokenType() != JSTokenTypes.RPAR) {
            if (first) {
                first = false;
            } else if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.RPAR && ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).allowLastCommaInParameterAndArgumentList()) {
                    break;
                }
            } else {
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.comma.or.rparen", (Object[])new Object[0]));
                result2 = false;
                break;
            }
            PsiBuilder.Marker parameter = this.builder.mark();
            if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
            }
            if (JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.getTokenType()) && (this.builder.lookAhead(1) == JSTokenTypes.COLON || this.builder.lookAhead(1) == JSTokenTypes.QUEST && this.builder.lookAhead(2) == JSTokenTypes.COLON)) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.QUEST) {
                    ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).parseParameterOptionalMark();
                }
                this.builder.advanceLexer();
            }
            result2 &= this.parseType();
            parameter.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterType());
        }
        return result2;
    }

    @Override
    public boolean parseTypeAliasType() {
        if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            PsiBuilder.Marker typeConstraint = this.builder.mark();
            this.parseType();
            typeConstraint.done((IElementType)TypeScriptStubElementTypes.TYPE_PARAMETER_CONSTRAINT);
        }
        if (this.builder.getTokenType() != JSTokenTypes.EQ) {
            if (!Boolean.TRUE.equals(this.builder.getUserData(FlowJSPsiTypeParser.OPAQUE_TYPE_KEY))) {
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.equal", (Object[])new Object[0]));
            }
            return false;
        }
        this.builder.advanceLexer();
        return this.parseType();
    }

    @Override
    @NotNull
    protected String getTypeNameExpectedMessage() {
        String string = JavaScriptBundle.message((String)"javascript.parser.message.expected.typename.or.*", (Object[])new Object[0]);
        if (string == null) {
            FlowInJSPsiTypeParser.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void tryParseTypePredicate() {
        if (this.builder.getTokenType() != JSTokenTypes.PERC) {
            return;
        }
        PsiBuilder.Marker typePredicate = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() != JSTokenTypes.IDENTIFIER || !"checks".equals(this.builder.getTokenText())) {
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.checks", (Object[])new Object[0]));
        }
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.LPAR) {
            ((ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parseParenthesizedExpression();
        }
        typePredicate.done(FlowJSElementTypes.TYPE_PREDICATE);
    }

    @Override
    protected boolean parseTypeOfInnerExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.LPAR) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            if (!super.parseTypeOfInnerExpression()) {
                marker.drop();
                return false;
            }
            if (this.builder.getTokenType() != JSTokenTypes.RPAR) {
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.rparen", (Object[])new Object[0]));
            } else {
                this.builder.advanceLexer();
            }
            marker.done(JSElementTypes.PARENTHESIZED_EXPRESSION);
            return true;
        }
        return super.parseTypeOfInnerExpression();
    }

    @Override
    protected boolean allowSingleTemplateLiteralInType() {
        return false;
    }

    @Override
    protected boolean allowTypeArgumentsTrailingComma() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/flow/psi/FlowInJSPsiTypeParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionSignatureElementType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNameExpectedMessage";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

