/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.lsp;

import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/lang/javascript/flow/lsp/FlowJSLanguageServiceProvider;", "Lcom/intellij/lang/javascript/service/JSLanguageServiceProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getAllServices", "", "Lcom/intellij/lang/javascript/service/JSLanguageService;", "getService", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isCandidate", "", "intellij.javascript.impl"})
public final class FlowJSLanguageServiceProvider
implements JSLanguageServiceProvider {
    @NotNull
    private final Project project;

    @Override
    @NotNull
    public List<JSLanguageService> getAllServices() {
        FlowJSServerManager flowJSServerManager = FlowJSServerManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)flowJSServerManager, (String)"FlowJSServerManager.getInstance(project)");
        List<JSLanguageService> list2 = flowJSServerManager.getAllServers();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"FlowJSServerManager.getI\u2026tance(project).allServers");
        return list2;
    }

    @Override
    @Nullable
    public JSLanguageService getService(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!file2.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(file2);
        if (psiFile == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(p\u2026File(file) ?: return null");
        PsiFile psiFile2 = psiFile;
        return FlowJSServerManager.getService(psiFile2);
    }

    @Override
    public boolean isCandidate(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return FlowJSServerService.FILES_TO_PROCESS.value((Object)file2);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public FlowJSLanguageServiceProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }
}

