/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.flowconfig;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigImpl;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfigUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowModuleMapping {
    private static final String BLACKLIST = "module.system.haste.paths.blacklist";
    private static final String WHITELIST = "module.system.haste.paths.whitelist";
    private static final String USE_NAME_REDUCER = "module.system.haste.use_name_reducers";
    private static final String MODULE_SYSTEM = "module.system";
    private static final String[] JS_EXTENSION = new String[]{".js.flow", ".js"};
    private static final String[] TARGET_EXTENSION = new String[]{".ios", ".android", ".native"};
    @NotNull
    private final List<String> myBlacklist;
    @NotNull
    private final List<String> myWhitelist;
    @NotNull
    private final VirtualFile myConfigDir;
    private final NullableLazyValue<Condition<VirtualFile>> myPredicate;

    public FlowModuleMapping(@NotNull List<String> blacklist, @NotNull List<String> whitelist, @NotNull VirtualFile configDir) {
        if (blacklist == null) {
            FlowModuleMapping.$$$reportNull$$$0(0);
        }
        if (whitelist == null) {
            FlowModuleMapping.$$$reportNull$$$0(1);
        }
        if (configDir == null) {
            FlowModuleMapping.$$$reportNull$$$0(2);
        }
        this.myPredicate = NullableLazyValue.createValue((Factory)new NullableFactory<Condition<VirtualFile>>(){

            @Nullable
            public Condition<VirtualFile> create() {
                Pattern whitelist = FlowJSConfigImpl.createPattern(FlowJSConfigUtil.getRegularExpression(FlowModuleMapping.this.myWhitelist, FlowModuleMapping.this.myConfigDir));
                if (whitelist == null) {
                    return null;
                }
                Pattern blacklist = FlowJSConfigImpl.createPattern(FlowJSConfigUtil.getRegularExpression(FlowModuleMapping.this.myBlacklist, FlowModuleMapping.this.myConfigDir));
                return file2 -> {
                    if (!VfsUtilCore.isAncestor((VirtualFile)FlowModuleMapping.this.myConfigDir, (VirtualFile)file2, (boolean)false)) {
                        return false;
                    }
                    String path = file2.getPath();
                    return FlowJSConfigImpl.checkPattern(path, whitelist) && (blacklist == null || !FlowJSConfigImpl.checkPattern(path, blacklist));
                };
            }
        });
        this.myBlacklist = blacklist;
        this.myWhitelist = whitelist;
        this.myConfigDir = configDir;
    }

    @Nullable
    public Condition<VirtualFile> getFileAcceptor() {
        return (Condition)this.myPredicate.getValue();
    }

    @NotNull
    public String reduceName(@NotNull String name) {
        if (name == null) {
            FlowModuleMapping.$$$reportNull$$$0(3);
        }
        String string = JSFileReference.getFileNameWithoutExtension(JSFileReference.getFileNameWithoutExtension(name, JS_EXTENSION), TARGET_EXTENSION);
        if (string == null) {
            FlowModuleMapping.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static FlowModuleMapping parse(@NotNull VirtualFile configDir, @NotNull Collection<String> options) {
        if (configDir == null) {
            FlowModuleMapping.$$$reportNull$$$0(5);
        }
        if (options == null) {
            FlowModuleMapping.$$$reportNull$$$0(6);
        }
        SmartList blacklist = new SmartList();
        SmartList whitelist = new SmartList();
        boolean useNameReducer = false;
        boolean isHaste = false;
        block12: for (String option : options) {
            int separator = option.indexOf("=");
            if (separator <= 0) continue;
            String id = option.substring(0, separator).trim();
            String value = option.substring(separator + 1).trim();
            if (StringUtil.isEmpty((String)value)) continue;
            switch (id) {
                case "module.system.haste.paths.blacklist": {
                    blacklist.add(value);
                    continue block12;
                }
                case "module.system.haste.paths.whitelist": {
                    whitelist.add(value);
                    continue block12;
                }
                case "module.system": {
                    isHaste = value.trim().equals("haste");
                    continue block12;
                }
                case "module.system.haste.use_name_reducers": {
                    useNameReducer = Boolean.valueOf(value);
                    continue block12;
                }
            }
        }
        return isHaste && !whitelist.isEmpty() && useNameReducer ? new FlowModuleMapping((List<String>)blacklist, (List<String>)whitelist, configDir) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blacklist";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whitelist";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/flowconfig/FlowModuleMapping";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/flowconfig/FlowModuleMapping";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "reduceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reduceName";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

