/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewElementsListener;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUsageViewElementsListener
implements UsageViewElementsListener {
    public void beforeUsageAdded(@NotNull UsageView view, @NotNull Usage usage) {
        UsageTarget[] targets;
        if (view == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(0);
        }
        if (usage == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(1);
        }
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return;
        }
        UsageInfo usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
        UsageTarget[] usageTargetArray = targets = view instanceof UsageViewImpl ? ((UsageViewImpl)view).getTargets() : UsageTarget.EMPTY_ARRAY;
        if (JSUsageViewElementsListener.checkIfJavaScriptDynamicUsage(usageInfo, targets)) {
            usageInfo.setDynamicUsage(true);
        }
    }

    public boolean isExcludedByDefault(@NotNull UsageView view, @NotNull Usage usage) {
        if (view == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(2);
        }
        if (usage == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(3);
        }
        if (!RefactoringBundle.message((String)"usageView.tabText").equals(view.getPresentation().getTabText())) {
            return false;
        }
        UsageTarget[] usageTargets = view instanceof UsageViewImpl ? ((UsageViewImpl)view).getTargets() : UsageTarget.EMPTY_ARRAY;
        return JSUsageViewElementsListener.isJavaScriptDynamicUsage(usage, usageTargets);
    }

    public static boolean isJavaScriptDynamicUsage(@NotNull Usage usage, UsageTarget @NotNull [] usageTargets) {
        if (usage == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(4);
        }
        if (usageTargets == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(5);
        }
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return false;
        }
        UsageInfo usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
        return usageInfo.isDynamicUsage() && JSUsageViewElementsListener.checkIfJavaScriptDynamicUsage(usageInfo, usageTargets);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static boolean checkIfJavaScriptDynamicUsage(@NotNull UsageInfo usageInfo, UsageTarget @NotNull [] usageTargets) {
        if (usageInfo == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(6);
        }
        if (usageTargets == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(7);
        }
        @NotNull List targets = ContainerUtil.mapNotNull((Object[])usageTargets, usageTarget -> usageTarget instanceof PsiElementUsageTarget ? ((PsiElementUsageTarget)usageTarget).getElement() : null);
        return JSUsageViewElementsListener.checkIfJavaScriptDynamicUsage(usageInfo, targets);
    }

    public static boolean checkIfJavaScriptDynamicUsage(@NotNull UsageInfo usageInfo, @NotNull Collection<PsiElement> targets) {
        PsiReference reference;
        if (usageInfo == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(8);
        }
        if (targets == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(9);
        }
        if ((reference = JSUsageViewElementsListener.extractReference(usageInfo)) instanceof JSReferenceExpression && JSResolveUtil.isDummyResolve((JSReferenceExpression)reference)) {
            return true;
        }
        if (reference instanceof JSPropertyNameReference && JSResolveUtil.isDummyResolve((JSPropertyNameReference)reference)) {
            return true;
        }
        if (reference != null && !JSResolveUtil.isResolveStrict(reference)) {
            return true;
        }
        if (reference instanceof JSReferenceExpression) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)reference;
            if (JSResolveUtil.isDummyResolve(referenceExpression)) {
                return true;
            }
            String referenceName = referenceExpression.getReferenceName();
            if (!targets.isEmpty() && referenceName != null) {
                for (PsiElement target : targets) {
                    if (!referenceExpression.isReferenceTo(target)) {
                        return false;
                    }
                    if (!JSReferenceUtil.isReferenceTo((PsiPolyVariantReference)referenceExpression, referenceName, target)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiReference extractReference(@NotNull UsageInfo usageInfo) {
        PsiElement element;
        if (usageInfo == null) {
            JSUsageViewElementsListener.$$$reportNull$$$0(10);
        }
        if (!((element = usageInfo.getElement()) instanceof JSElement)) {
            return null;
        }
        ProperTextRange rangeInElement = usageInfo.getRangeInElement();
        if (rangeInElement == null) {
            return null;
        }
        PsiReference candidate = null;
        for (PsiReference reference : element.getReferences()) {
            if (!rangeInElement.equals((Object)reference.getRangeInElement())) continue;
            if (candidate != null) {
                return null;
            }
            candidate = reference;
        }
        return candidate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageTargets";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/findUsages/JSUsageViewElementsListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeUsageAdded";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isExcludedByDefault";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isJavaScriptDynamicUsage";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIfJavaScriptDynamicUsage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "extractReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

