/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.InsetPresentation;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.editing.JSTypeHintsInlayProvider$createConfigurable$1$cases$1;
import com.intellij.lang.javascript.editing.JSTypeHintsInlayProvider$createConfigurable$1$cases$2;
import com.intellij.lang.javascript.editing.JSTypeHintsInlayProvider$createConfigurable$1$cases$3;
import com.intellij.lang.javascript.editing.JSTypeHintsInlayProvider$createConfigurable$1$cases$4;
import com.intellij.lang.javascript.editing.JSTypeHintsInlayProviderKt;
import com.intellij.lang.javascript.editing.JSTypeHintsPresentationFactory;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSFunctionReturnWrapperType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import java.awt.Container;
import java.util.Arrays;
import java.util.List;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002()B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0014J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001d\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0014\u00a2\u0006\u0002\u0010!J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0013H\u0016J\u0012\u0010%\u001a\u00020#2\b\u0010&\u001a\u0004\u0018\u00010'H\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006*"}, d2={"Lcom/intellij/lang/javascript/editing/JSTypeHintsInlayProvider;", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "Lcom/intellij/lang/javascript/editing/JSTypeHintsInlayProvider$Settings;", "()V", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "name", "", "getName", "()Ljava/lang/String;", "previewText", "getPreviewText", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "settings", "createSettings", "getBaseLanguage", "Lcom/intellij/lang/Language;", "getCollectorFor", "Lcom/intellij/codeInsight/hints/FactoryInlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "getExtraActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/openapi/actionSystem/AnAction;", "isLanguageSupported", "", "language", "isSupportedDialect", "dialectOfElement", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "Companion", "Settings", "intellij.javascript.impl"})
public class JSTypeHintsInlayProvider
implements InlayHintsProvider<Settings> {
    @NotNull
    private static final SettingsKey<Settings> ourKey;
    public static final Companion Companion;

    @NotNull
    public FactoryInlayHintsCollector getCollectorFor(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Settings settings, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        return new FactoryInlayHintsCollector(this, settings, sink, editor, editor){
            private final boolean unitTestMode;
            final /* synthetic */ JSTypeHintsInlayProvider this$0;
            final /* synthetic */ Settings $settings;
            final /* synthetic */ InlayHintsSink $sink;
            final /* synthetic */ Editor $editor;

            public final boolean getUnitTestMode() {
                return this.unitTestMode;
            }

            public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                if (DumbService.isDumb((Project)element.getProject())) {
                    return false;
                }
                if (!this.this$0.isSupportedDialect(DialectDetector.dialectOfElement(element))) {
                    return true;
                }
                if (this.unitTestMode || element instanceof JSParameter && this.shouldShowForParam((JSParameter)element) || !(element instanceof JSParameter) && this.$settings.getShowForVariablesAndFields()) {
                    this.presentFieldVariable(element);
                }
                if (this.unitTestMode || this.$settings.getShowForFunctions()) {
                    this.presentFunction(element);
                }
                return true;
            }

            private final boolean shouldShowForParam(JSParameter element) {
                PsiElement parent = element.getParent();
                if (parent instanceof JSParameterList && JSFunctionsRefactoringUtil.noBracesAroundSingleParameter((JSParameterList)parent)) {
                    return this.$settings.getShowForShorthandFunctions();
                }
                return this.$settings.getShowForInferredParameters();
            }

            private final void presentFunction(PsiElement element) {
                if (!(element instanceof JSFunction) || ((JSFunction)element).getReturnTypeElement() != null) {
                    return;
                }
                if (((JSFunction)element).isSetProperty() || ((JSFunction)element).isConstructor()) {
                    return;
                }
                JSParameterList parameterList = ((JSFunction)element).getParameterList();
                if (parameterList == null) {
                    return;
                }
                PsiElement firstChild = parameterList.getFirstChild();
                if (Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)firstChild), (Object)JSTokenTypes.LPAR) ^ true) {
                    return;
                }
                this.presentType(((JSFunction)element).getReturnType(), (PsiElement)parameterList, element);
            }

            private final void presentFieldVariable(PsiElement element) {
                if (!(element instanceof JSTypeDeclarationOwner) || ((JSTypeDeclarationOwner)element).getTypeElement() != null || !(element instanceof JSNamedElement) || element instanceof TypeScriptEnumField) {
                    return;
                }
                PsiElement elementParent = element.getParent();
                while (JSDestructuringUtil.isDestructuring(elementParent)) {
                    if (elementParent instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)elementParent).getTypeElement() != null) {
                        return;
                    }
                    PsiElement psiElement = elementParent;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"elementParent");
                    elementParent = psiElement.getParent();
                }
                PsiElement nameIdentifier = ((JSNamedElement)element).getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                JSType jsType = JSResolveUtil.getElementJSType(element);
                if (this.isFrameworkDefinedType(jsType, element)) {
                    return;
                }
                PsiElement anchor = nameIdentifier;
                PsiElement nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)nameIdentifier);
                IElementType elementType = PsiUtilCore.getElementType((PsiElement)nextElement);
                if (nextElement != null && (Intrinsics.areEqual((Object)elementType, (Object)JSTokenTypes.QUEST) || Intrinsics.areEqual((Object)elementType, (Object)JSTokenTypes.EXCL))) {
                    anchor = nextElement;
                }
                this.presentType(jsType, anchor, element);
            }

            private final boolean isFrameworkDefinedType(JSType jsType, PsiElement element) {
                return jsType != null && Intrinsics.areEqual((Object)jsType.getSourceElement(), (Object)element);
            }

            private final void presentType(JSType jsType, PsiElement anchor, PsiElement element) {
                JSType presentableType = jsType;
                if (jsType instanceof JSFunctionReturnWrapperType) {
                    presentableType = jsType.substitute();
                }
                if (presentableType != null && !JSTypeUtils.isAnyType(presentableType) && this.isSuitableType(presentableType)) {
                    Project project = anchor.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"anchor.project");
                    Project project2 = project;
                    InlayPresentation presentation = new JSTypeHintsPresentationFactory(this.getFactory(), 3).typeHintWithColon(presentableType);
                    AnAction[] anActionArray = this.this$0.getExtraActions(element);
                    InsetPresentation finalPresentation = JSTypeHintsInlayProviderKt.createPresentationWithAction(presentation, project2, this.this$0.getBaseLanguage(), this.this$0, Arrays.copyOf(anActionArray, anActionArray.length));
                    TextRange textRange = anchor.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"anchor.textRange");
                    this.$sink.addInlineElement(textRange.getEndOffset(), false, (InlayPresentation)finalPresentation, false);
                }
            }

            private final boolean isSuitableType(JSType jsType) {
                if (jsType == null) {
                    return false;
                }
                if (JSTypeUtils.isAnyType(jsType)) {
                    return false;
                }
                if (jsType instanceof JSNamedType && ((JSNamedType)jsType).getTypeContext() == JSTypeContext.STATIC) {
                    return false;
                }
                return !(jsType instanceof JSFunctionType);
            }
            {
                this.this$0 = this$0;
                this.$settings = $captured_local_variable$1;
                this.$sink = $captured_local_variable$2;
                this.$editor = $captured_local_variable$3;
                super($super_call_param$4);
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                this.unitTestMode = application.isUnitTestMode();
            }
        };
    }

    @NotNull
    protected AnAction[] getExtraActions(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"AnAction.EMPTY_ARRAY");
        return AnAction.EMPTY_ARRAY;
    }

    @NotNull
    protected Language getBaseLanguage() {
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)javascriptLanguage, (String)"JavascriptLanguage.INSTANCE");
        return (Language)javascriptLanguage;
    }

    @NotNull
    public SettingsKey<Settings> getKey() {
        return ourKey;
    }

    @NotNull
    public Settings createSettings() {
        return new Settings(false, false, false, false, 15, null);
    }

    @NotNull
    public String getName() {
        String string = JavaScriptBundle.message((String)"type.annotations", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JavaScriptBundle.message(\"type.annotations\")");
        return string;
    }

    @Nullable
    public String getPreviewText() {
        return "var z = 3;\nfunction test() { return \"a\" }\n/**\n* @param {function(number): string} p\n*/\nfunction x(p) {}\nx(p => \"a\")\nx((p) => \"a\")\n";
    }

    protected boolean isSupportedDialect(@Nullable DialectOptionHolder dialectOfElement) {
        return dialectOfElement != null && dialectOfElement.isJavaScript();
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return !JSTypeHintsInlayProviderKt.isTypeScript(language);
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new ImmediateConfigurable(settings){
            @NotNull
            private final List<ImmediateConfigurable.Case> cases;
            final /* synthetic */ Settings $settings;

            @NotNull
            public List<ImmediateConfigurable.Case> getCases() {
                return this.cases;
            }

            @NotNull
            public JPanel createComponent(@NotNull ChangeListener listener2) {
                LayoutBuilder builder$iv;
                Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
                LCFlags[] constraints$iv = new LCFlags[]{};
                String title$iv = null;
                boolean $i$f$panel = false;
                LayoutBuilder $this$panel = builder$iv = LayoutImplKt.createLayoutBuilder();
                boolean bl = false;
                DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
                builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
                LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
                return (JPanel)panel$iv;
            }

            @NotNull
            public String getMainCheckboxText() {
                return "Show type hints for:";
            }
            {
                this.$settings = $captured_local_variable$0;
                Object[] objectArray = new ImmediateConfigurable.Case[4];
                String string = JavaScriptBundle.message((String)"variables.and.fields", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JavaScriptBundle.message(\"variables.and.fields\")");
                objectArray[0] = new ImmediateConfigurable.Case(string, "variables.and.fields", (KMutableProperty0)new JSTypeHintsInlayProvider$createConfigurable$1$cases$1($captured_local_variable$0), null, 8, null);
                String string2 = JavaScriptBundle.message((String)"parameters.in.parentheses", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JavaScriptBundle.message\u2026rameters.in.parentheses\")");
                objectArray[1] = new ImmediateConfigurable.Case(string2, "parameters.in.parens", (KMutableProperty0)new JSTypeHintsInlayProvider$createConfigurable$1$cases$2($captured_local_variable$0), null, 8, null);
                String string3 = JavaScriptBundle.message((String)"non.parenthesized.single.parameter", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"JavaScriptBundle.message\u2026esized.single.parameter\")");
                objectArray[2] = new ImmediateConfigurable.Case(string3, "non.paren.single.param", (KMutableProperty0)new JSTypeHintsInlayProvider$createConfigurable$1$cases$3($captured_local_variable$0), null, 8, null);
                String string4 = JavaScriptBundle.message((String)"function.returns", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"JavaScriptBundle.message(\"function.returns\")");
                objectArray[3] = new ImmediateConfigurable.Case(string4, "function.returns", (KMutableProperty0)new JSTypeHintsInlayProvider$createConfigurable$1$cases$4($captured_local_variable$0), null, 8, null);
                this.cases = CollectionsKt.listOf((Object[])objectArray);
            }
        };
    }

    static {
        Companion = new Companion(null);
        ourKey = new SettingsKey("js.type.hints");
    }

    public boolean isVisibleInSettings() {
        return InlayHintsProvider.DefaultImpls.isVisibleInSettings((InlayHintsProvider)this);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/intellij/lang/javascript/editing/JSTypeHintsInlayProvider$Settings;", "", "showForFunctions", "", "showForVariablesAndFields", "showForInferredParameters", "showForShorthandFunctions", "(ZZZZ)V", "getShowForFunctions", "()Z", "setShowForFunctions", "(Z)V", "getShowForInferredParameters", "setShowForInferredParameters", "getShowForShorthandFunctions", "setShowForShorthandFunctions", "getShowForVariablesAndFields", "setShowForVariablesAndFields", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.javascript.impl"})
    public static final class Settings {
        private boolean showForFunctions;
        private boolean showForVariablesAndFields;
        private boolean showForInferredParameters;
        private boolean showForShorthandFunctions;

        public final boolean getShowForFunctions() {
            return this.showForFunctions;
        }

        public final void setShowForFunctions(boolean bl) {
            this.showForFunctions = bl;
        }

        public final boolean getShowForVariablesAndFields() {
            return this.showForVariablesAndFields;
        }

        public final void setShowForVariablesAndFields(boolean bl) {
            this.showForVariablesAndFields = bl;
        }

        public final boolean getShowForInferredParameters() {
            return this.showForInferredParameters;
        }

        public final void setShowForInferredParameters(boolean bl) {
            this.showForInferredParameters = bl;
        }

        public final boolean getShowForShorthandFunctions() {
            return this.showForShorthandFunctions;
        }

        public final void setShowForShorthandFunctions(boolean bl) {
            this.showForShorthandFunctions = bl;
        }

        public Settings(boolean showForFunctions, boolean showForVariablesAndFields, boolean showForInferredParameters, boolean showForShorthandFunctions) {
            this.showForFunctions = showForFunctions;
            this.showForVariablesAndFields = showForVariablesAndFields;
            this.showForInferredParameters = showForInferredParameters;
            this.showForShorthandFunctions = showForShorthandFunctions;
        }

        public /* synthetic */ Settings(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                bl3 = true;
            }
            if ((n & 8) != 0) {
                bl4 = false;
            }
            this(bl, bl2, bl3, bl4);
        }

        public Settings() {
            this(false, false, false, false, 15, null);
        }

        public final boolean component1() {
            return this.showForFunctions;
        }

        public final boolean component2() {
            return this.showForVariablesAndFields;
        }

        public final boolean component3() {
            return this.showForInferredParameters;
        }

        public final boolean component4() {
            return this.showForShorthandFunctions;
        }

        @NotNull
        public final Settings copy(boolean showForFunctions, boolean showForVariablesAndFields, boolean showForInferredParameters, boolean showForShorthandFunctions) {
            return new Settings(showForFunctions, showForVariablesAndFields, showForInferredParameters, showForShorthandFunctions);
        }

        public static /* synthetic */ Settings copy$default(Settings settings, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = settings.showForFunctions;
            }
            if ((n & 2) != 0) {
                bl2 = settings.showForVariablesAndFields;
            }
            if ((n & 4) != 0) {
                bl3 = settings.showForInferredParameters;
            }
            if ((n & 8) != 0) {
                bl4 = settings.showForShorthandFunctions;
            }
            return settings.copy(bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "Settings(showForFunctions=" + this.showForFunctions + ", showForVariablesAndFields=" + this.showForVariablesAndFields + ", showForInferredParameters=" + this.showForInferredParameters + ", showForShorthandFunctions=" + this.showForShorthandFunctions + ")";
        }

        public int hashCode() {
            int n = this.showForFunctions ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.showForVariablesAndFields ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            int n4 = (n2 + n3) * 31;
            int n5 = this.showForInferredParameters ? 1 : 0;
            if (n5 != 0) {
                n5 = 1;
            }
            int n6 = (n4 + n5) * 31;
            int n7 = this.showForShorthandFunctions ? 1 : 0;
            if (n7 != 0) {
                n7 = 1;
            }
            return n6 + n7;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Settings)) break block3;
                    Settings settings = (Settings)object;
                    if (this.showForFunctions != settings.showForFunctions || this.showForVariablesAndFields != settings.showForVariablesAndFields || this.showForInferredParameters != settings.showForInferredParameters || this.showForShorthandFunctions != settings.showForShorthandFunctions) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/editing/JSTypeHintsInlayProvider$Companion;", "", "()V", "ourKey", "Lcom/intellij/codeInsight/hints/SettingsKey;", "Lcom/intellij/lang/javascript/editing/JSTypeHintsInlayProvider$Settings;", "getOurKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "intellij.javascript.impl"})
    public static final class Companion {
        @NotNull
        public final SettingsKey<Settings> getOurKey() {
            return ourKey;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

