/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.codeInsight.editorActions.moveUpDown.XmlMover;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStatementUpDownMover
extends LineMover {
    private static final Key<PsiElement> BLOCK_STATEMENT_CONTAINER_KEY = Key.create((String)"JSStatementUpDownMover.STATEMENT_KEY");
    private static final Key<Boolean> ADD_COMMA_AFTER_LIST_ITEM_KEY = Key.create((String)"JSStatementUpDownMover.ADD_COMMA_KEY");
    private static final Condition<PsiElement> SOURCE_ELEMENT_CONDITION = element -> JSStatementUpDownMover.elementOfTypeOrOwnComment(element, JSSourceElement.class);
    private static final Condition<PsiElement> TYPE_MEMBER_CONDITION = element -> JSStatementUpDownMover.elementOfTypeOrOwnComment(element, JSFunction.class, JSVarStatement.class, TypeScriptTypeMember.class);
    private static final Condition<PsiElement> CASE_CLAUSE_CONDITION = element -> JSStatementUpDownMover.elementOfTypeOrOwnComment(element, JSCaseClause.class);
    private final Condition<PsiElement> NON_REST_DESTRUCTURING_PROPERTY_CONDITION = element -> element instanceof JSDestructuringProperty && !((JSDestructuringProperty)element).isRest();
    private final JSXMover myXmlMover = new JSXMover();

    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        PsiLanguageInjectionHost languageInjectionHost;
        if (editor == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(1);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(2);
        }
        if (!(file2 instanceof JSFile) && !(file2 instanceof XmlFile)) {
            return false;
        }
        if (!super.checkAvailable(editor, file2, info, down)) {
            return false;
        }
        if (file2 instanceof XmlFile && (languageInjectionHost = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), PsiLanguageInjectionHost.class)) != null) {
            Document document2 = editor.getDocument();
            int movedLineStartOffset = document2.getLineStartOffset(info.toMove.startLine);
            TextRange possibleInjectionRange = languageInjectionHost.getTextRange();
            if (info.toMove.endLine < document2.getLineCount() && possibleInjectionRange.containsRange(movedLineStartOffset, document2.getLineStartOffset(info.toMove.endLine)) && info.toMove2.endLine < document2.getLineCount() && possibleInjectionRange.containsRange(document2.getLineStartOffset(info.toMove2.startLine), document2.getLineStartOffset(info.toMove2.endLine))) {
                Ref result2 = new Ref();
                InjectedLanguageManager.getInstance((Project)file2.getProject()).enumerate((PsiElement)languageInjectionHost, (injectedPsi, places) -> {
                    if (injectedPsi instanceof JSFile) {
                        StatementUpDownMover.MoveInfo myInfo = new StatementUpDownMover.MoveInfo();
                        Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile((Editor)editor, (PsiFile)injectedPsi);
                        int lineNumberDiff = editor.getDocument().getLineNumber(editor.getCaretModel().getOffset()) - injectedEditor.getDocument().getLineNumber(injectedEditor.getCaretModel().getOffset());
                        myInfo.toMove = new LineRange(info.toMove.startLine - lineNumberDiff, info.toMove.endLine - lineNumberDiff);
                        myInfo.toMove2 = new LineRange(info.toMove2.startLine - lineNumberDiff, info.toMove2.endLine - lineNumberDiff);
                        if (this.moveJSElement(injectedEditor, injectedPsi, myInfo, down)) {
                            myInfo.toMove = new LineRange(myInfo.toMove.startLine + lineNumberDiff, myInfo.toMove.endLine + lineNumberDiff);
                            myInfo.toMove2 = new LineRange(myInfo.toMove2.startLine + lineNumberDiff, myInfo.toMove2.endLine + lineNumberDiff);
                            result2.set((Object)myInfo);
                        }
                    }
                });
                StatementUpDownMover.MoveInfo newInfo = (StatementUpDownMover.MoveInfo)result2.get();
                if (newInfo != null) {
                    info.toMove = newInfo.toMove;
                    info.toMove2 = newInfo.toMove2;
                    return true;
                }
            }
        }
        boolean result3 = this.moveJSElement(editor, file2, info, down);
        if (info.toMove2 == null) {
            return result3;
        }
        if (down && info.toMove.endLine > info.toMove2.startLine) {
            return false;
        }
        if (!down && info.toMove.startLine < info.toMove2.endLine) {
            return false;
        }
        return result3;
    }

    private boolean moveJSElement(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        Document document2;
        if (editor == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(4);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(5);
        }
        if (JSStatementUpDownMover.isSameNode(file2, info, document2 = editor.getDocument(), down)) {
            return false;
        }
        ElementRange movedRange = JSStatementUpDownMover.getMovableElementRange(editor, file2, info.toMove, document2);
        if (JSStatementUpDownMover.isNotValidStatementRange(movedRange)) {
            return false;
        }
        PsiElement elementAtStart = movedRange.first;
        if (elementAtStart instanceof XmlElement && DialectDetector.isJSX(elementAtStart)) {
            return this.moveJSXElement(editor, file2, info, down);
        }
        if (!DialectDetector.languageOfElement(elementAtStart).isKindOf((Language)JavascriptLanguage.INSTANCE) || !DialectDetector.hasJSSyntax(elementAtStart)) {
            return false;
        }
        info.toMove = new LineRange(Math.min(info.toMove.startLine, movedRange.rangeToMove.startLine), Math.max(movedRange.rangeToMove.endLine, info.toMove.endLine));
        if (elementAtStart instanceof TypeScriptEnumField) {
            return JSStatementUpDownMover.moveListItem(info, down, document2, movedRange, TypeScriptEnumField.class);
        }
        if (elementAtStart instanceof JSProperty) {
            return JSStatementUpDownMover.moveListItem(info, down, document2, movedRange, JSProperty.class);
        }
        if (elementAtStart instanceof ES6ImportExportSpecifier) {
            return JSStatementUpDownMover.moveListItem(info, down, document2, movedRange, ES6ImportExportSpecifier.class);
        }
        if (elementAtStart instanceof JSDestructuringProperty) {
            if (((JSDestructuringProperty)elementAtStart).isRest()) {
                info.prohibitMove();
                return true;
            }
            return JSStatementUpDownMover.moveListItem(info, down, document2, movedRange, this.NON_REST_DESTRUCTURING_PROPERTY_CONDITION);
        }
        if (JSStatementUpDownMover.isArrayElement(elementAtStart)) {
            return JSStatementUpDownMover.moveListItem(info, down, document2, movedRange, JSExpression.class);
        }
        if (JSStatementUpDownMover.isDestructuringArrayElement(elementAtStart)) {
            return JSStatementUpDownMover.moveListItem(info, down, document2, movedRange, JSVariable.class);
        }
        PsiElement parent = elementAtStart.getParent();
        if (parent instanceof JSClass || parent instanceof TypeScriptObjectType) {
            PsiElement meaningfulSibling = JSStatementUpDownMover.findSiblingByCondition(movedRange, TYPE_MEMBER_CONDITION, down);
            if (meaningfulSibling != null) {
                return JSStatementUpDownMover.moveNextTo(meaningfulSibling, info, document2);
            }
            if (JSClassUtils.isES6ClassImplementation(elementAtStart)) {
                return info.prohibitMove();
            }
            return JSStatementUpDownMover.moveElementsByLine(info, document2, movedRange, down);
        }
        if (parent instanceof JSSwitchStatement) {
            PsiElement meaningfulSibling = JSStatementUpDownMover.findSiblingByCondition(movedRange, CASE_CLAUSE_CONDITION, down);
            if (meaningfulSibling != null) {
                return JSStatementUpDownMover.moveNextTo(meaningfulSibling, info, document2);
            }
            info.prohibitMove();
            return true;
        }
        if (elementAtStart instanceof JSSourceElement) {
            return JSStatementUpDownMover.moveSourceElements(info, down, document2, movedRange);
        }
        return JSStatementUpDownMover.moveElementsByLine(info, document2, movedRange, down);
    }

    private boolean moveJSXElement(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(7);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(8);
        }
        StatementUpDownMover.MoveInfo xmlMoveInfo = new StatementUpDownMover.MoveInfo();
        boolean handledByXmlMover = this.myXmlMover.checkAvailable(editor, file2, xmlMoveInfo, down);
        if (xmlMoveInfo.toMove2 == null) {
            return info.prohibitMove();
        }
        XmlTag rootJSXTag = JSStatementUpDownMover.getRootJSXTag(editor, file2, xmlMoveInfo.toMove);
        if (rootJSXTag == null) {
            return false;
        }
        PsiElement atDestinationStart = file2.findElementAt(editor.getDocument().getLineStartOffset(xmlMoveInfo.toMove2.startLine));
        PsiElement atDestinationEnd = file2.findElementAt(editor.getDocument().getLineEndOffset(xmlMoveInfo.toMove2.endLine - 1));
        if (atDestinationStart == null || atDestinationEnd == null || !PsiTreeUtil.isAncestor((PsiElement)rootJSXTag, (PsiElement)atDestinationStart, (boolean)false) || !PsiTreeUtil.isAncestor((PsiElement)rootJSXTag, (PsiElement)atDestinationEnd, (boolean)false)) {
            return info.prohibitMove();
        }
        info.toMove = xmlMoveInfo.toMove;
        info.toMove2 = xmlMoveInfo.toMove2;
        return handledByXmlMover;
    }

    private static <T extends PsiElement> boolean moveListItem(@NotNull StatementUpDownMover.MoveInfo info, boolean down, @NotNull Document document2, @NotNull ElementRange movedRange, @NotNull Class<? extends T> siblingClass) {
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(9);
        }
        if (document2 == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(10);
        }
        if (movedRange == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(11);
        }
        if (siblingClass == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(12);
        }
        return JSStatementUpDownMover.moveListItem(info, down, document2, movedRange, (Condition<PsiElement>)Conditions.instanceOf(siblingClass));
    }

    private static boolean moveListItem(@NotNull StatementUpDownMover.MoveInfo info, boolean down, @NotNull Document document2, @NotNull ElementRange movedRange, @NotNull Condition<PsiElement> siblingCondition) {
        PsiElement arraySibling;
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(13);
        }
        if (document2 == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(14);
        }
        if (movedRange == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(15);
        }
        if (siblingCondition == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(16);
        }
        if ((arraySibling = JSStatementUpDownMover.findSiblingByCondition(movedRange, siblingCondition, down)) != null) {
            PsiElement toCheckForComma = down ? arraySibling : movedRange.second;
            boolean isLastElementWithoutComma = JSStatementUpDownMover.findSiblingByCondition(toCheckForComma, siblingCondition, true) == null && TreeUtil.findSibling((ASTNode)toCheckForComma.getNode(), (IElementType)JSTokenTypes.COMMA) == null;
            info.putUserData(ADD_COMMA_AFTER_LIST_ITEM_KEY, (Object)isLastElementWithoutComma);
            return JSStatementUpDownMover.moveNextTo(arraySibling, info, document2);
        }
        return info.prohibitMove();
    }

    @Nullable
    private static XmlTag getRootJSXTag(@NotNull Editor editor, @NotNull PsiFile file2, @Nullable LineRange lineRange) {
        PsiElement atEnd;
        if (editor == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(17);
        }
        if (file2 == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(18);
        }
        if (lineRange == null) {
            return null;
        }
        PsiElement leafAtStart = file2.findElementAt(editor.getDocument().getLineStartOffset(lineRange.startLine));
        PsiElement leafAtEnd = file2.findElementAt(editor.getDocument().getLineEndOffset(lineRange.endLine - 1));
        PsiElement atStart = PsiTreeUtil.findFirstParent((PsiElement)leafAtStart, t -> t instanceof XmlTag && !(t.getParent() instanceof XmlElement));
        return atStart == (atEnd = PsiTreeUtil.findFirstParent((PsiElement)leafAtEnd, t -> t instanceof XmlTag && !(t.getParent() instanceof XmlElement))) ? (XmlTag)atStart : null;
    }

    private static boolean moveSourceElements(StatementUpDownMover.MoveInfo info, boolean down, Document document2, ElementRange movedRange) {
        if (movedRange.first.getParent() instanceof JSPackageStatement) {
            return false;
        }
        if (movedRange.first instanceof JSStatement) {
            return JSStatementUpDownMover.moveStatements(info, down, document2, movedRange);
        }
        PsiElement sibling = JSStatementUpDownMover.findSiblingByCondition(movedRange, SOURCE_ELEMENT_CONDITION, down);
        if (sibling != null) {
            return JSStatementUpDownMover.moveNextTo(sibling, info, document2);
        }
        return JSStatementUpDownMover.moveElementsByLine(info, document2, movedRange, down);
    }

    private static boolean moveStatements(StatementUpDownMover.MoveInfo info, boolean down, Document document2, ElementRange movedRange) {
        PsiElement sibling = JSStatementUpDownMover.findSiblingByCondition(movedRange, SOURCE_ELEMENT_CONDITION, down);
        if (JSStatementUpDownMover.isBlockStatementContainer(sibling)) {
            PsiElement body = JSStatementUpDownMover.getStatementBodyOrNull(sibling, down);
            if (!(body instanceof JSBlockStatement)) {
                return JSStatementUpDownMover.moveIntoAndSurroundWithBlock(info, down, document2, sibling);
            }
            return JSStatementUpDownMover.moveIntoBlock((JSBlockStatement)body, info, document2, down);
        }
        if (sibling == null && movedRange.first.getParent() instanceof JSBlockStatement) {
            JSIfStatement ifStatement;
            PsiElement block = movedRange.second.getParent();
            JSIfStatement jSIfStatement = ifStatement = block.getParent() instanceof JSIfStatement ? (JSIfStatement)block.getParent() : null;
            if (ifStatement != null) {
                JSBlockStatement thenBlock = (JSBlockStatement)ObjectUtils.tryCast((Object)ifStatement.getThen(), JSBlockStatement.class);
                JSBlockStatement elseBlock = (JSBlockStatement)ObjectUtils.tryCast((Object)ifStatement.getElse(), JSBlockStatement.class);
                if (elseBlock != null && thenBlock != null && (block == ifStatement.getThen() && down || block == ifStatement.getElse() && !down)) {
                    TextRange additionalBlockRange = JSStatementUpDownMover.blockHeaderRange(elseBlock);
                    ASTNode rBrace = thenBlock.getNode().findChildByType(JSTokenTypes.RBRACE);
                    additionalBlockRange = new TextRange(rBrace == null ? thenBlock.getTextRange().getEndOffset() : rBrace.getStartOffset(), additionalBlockRange.getEndOffset());
                    int start = document2.getLineNumber(additionalBlockRange.getStartOffset());
                    int end = JSStatementUpDownMover.advanceToRange(document2, additionalBlockRange.getEndOffset());
                    info.toMove2 = new LineRange(start, end);
                    return true;
                }
            }
            return JSStatementUpDownMover.moveOut((JSBlockStatement)block, info, document2, down);
        }
        if (sibling != null) {
            JSBlockStatement body;
            JSFunction possibleFunction = JSStatementUpDownMover.findPossibleFunction(sibling);
            if (possibleFunction != null && JSStatementUpDownMover.isMultiline((PsiElement)possibleFunction, document2) && JSStatementUpDownMover.findPossibleFunction(movedRange.first) == null && JSStatementUpDownMover.findPossibleFunction(movedRange.second) == null && (body = possibleFunction.getBlock()) != null) {
                return JSStatementUpDownMover.moveIntoBlock(body, info, document2, down);
            }
            return JSStatementUpDownMover.moveNextTo(sibling, info, document2);
        }
        return JSStatementUpDownMover.moveElementsByLine(info, document2, movedRange, down);
    }

    private static boolean moveElementsByLine(@NotNull StatementUpDownMover.MoveInfo info, @NotNull Document document2, @NotNull ElementRange movedRange, boolean down) {
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(19);
        }
        if (document2 == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(20);
        }
        if (movedRange == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(21);
        }
        if (down) {
            int destinationLine = movedRange.rangeToMove.endLine + 1;
            if (destinationLine >= document2.getLineCount()) {
                return info.prohibitMove();
            }
            info.toMove2 = new LineRange(movedRange.rangeToMove.endLine, destinationLine);
            return true;
        }
        info.toMove2 = new LineRange(Math.max(movedRange.rangeToMove.startLine - 1, 0), movedRange.rangeToMove.startLine);
        return true;
    }

    @Nullable
    private static PsiElement findSiblingByCondition(@NotNull ElementRange range, @NotNull Condition<PsiElement> condition, boolean down) {
        if (range == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(22);
        }
        if (condition == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(23);
        }
        return JSStatementUpDownMover.findSiblingByCondition(down ? range.second : range.first, condition, down);
    }

    @Nullable
    private static PsiElement findSiblingByCondition(@NotNull PsiElement startElement, @NotNull Condition<PsiElement> condition, boolean down) {
        PsiElement child;
        if (startElement == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(24);
        }
        if (condition == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(25);
        }
        PsiElement psiElement = child = down ? startElement.getNextSibling() : startElement.getPrevSibling();
        while (child != null) {
            if (condition.value((Object)child)) {
                return child;
            }
            child = down ? child.getNextSibling() : child.getPrevSibling();
        }
        return null;
    }

    private static boolean elementOfTypeOrOwnComment(PsiElement element, Class<? extends PsiElement> ... classes) {
        if (element instanceof PsiComment) {
            return JSStatementUpDownMover.findLeadingCommentOwner((PsiComment)element) == null && JSStatementUpDownMover.findTrailingEndOfLineCommentOwner((PsiComment)element) == null;
        }
        return ContainerUtil.or((Object[])classes, aClass -> aClass.isInstance(element));
    }

    private static boolean moveIntoAndSurroundWithBlock(StatementUpDownMover.MoveInfo info, boolean down, Document document2, PsiElement sibling) {
        if (down) {
            int lineNumber = info.toMove.endLine;
            info.toMove2 = new LineRange(lineNumber, Math.min(lineNumber + 1, document2.getLineCount()));
        } else {
            int lineNumber = info.toMove.startLine;
            info.toMove2 = new LineRange(Math.max(0, lineNumber - 1), lineNumber);
        }
        info.putUserData(BLOCK_STATEMENT_CONTAINER_KEY, (Object)sibling);
        return true;
    }

    private static boolean moveOut(@NotNull JSBlockStatement blockStatement, @NotNull StatementUpDownMover.MoveInfo info, @NotNull Document document2, boolean down) {
        if (blockStatement == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(26);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(27);
        }
        if (document2 == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(28);
        }
        return JSStatementUpDownMover.moveIntoBlock(blockStatement, info, document2, !down);
    }

    private static boolean moveIntoBlock(@NotNull JSBlockStatement body, @NotNull StatementUpDownMover.MoveInfo info, @NotNull Document document2, boolean down) {
        if (body == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(29);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(30);
        }
        if (document2 == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(31);
        }
        if (down) {
            TextRange blockHeaderRange = JSStatementUpDownMover.blockHeaderRange(body);
            int start = document2.getLineNumber(blockHeaderRange.getStartOffset());
            int end = JSStatementUpDownMover.advanceToRange(document2, blockHeaderRange.getEndOffset());
            info.toMove2 = new LineRange(start, end);
        } else {
            TextRange range = JSStatementUpDownMover.blockTailRange(body);
            int start = document2.getLineNumber(range.getStartOffset());
            int end = JSStatementUpDownMover.advanceToRange(document2, range.getEndOffset());
            info.toMove2 = new LineRange(start, end);
        }
        return true;
    }

    private static boolean moveNextTo(@NotNull PsiElement destination, @NotNull StatementUpDownMover.MoveInfo info, @NotNull Document document2) {
        ElementRange destinationRange;
        if (destination == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(32);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(33);
        }
        if (document2 == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(34);
        }
        if (JSStatementUpDownMover.isNotValidStatementRange(destinationRange = new ElementRange(destination, destination, new LineRange(JSStatementUpDownMover.expandRangeBefore(destination), JSStatementUpDownMover.expandRangeAfter(destination), document2)))) {
            return false;
        }
        info.toMove2 = destinationRange.rangeToMove;
        return true;
    }

    @Nullable
    private static JSFunction findPossibleFunction(@NotNull PsiElement element) {
        JSVariable[] variables;
        JSStatement statement;
        if (element == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(35);
        }
        if (element instanceof JSFunction) {
            return (JSFunction)element;
        }
        JSExpression candidate = null;
        JSStatement jSStatement = statement = element instanceof JSStatement ? (JSStatement)element : null;
        if (statement instanceof JSExpressionStatement) {
            JSExpression expression = ((JSExpressionStatement)statement).getExpression();
            if (expression instanceof JSAssignmentExpression) {
                candidate = ((JSAssignmentExpression)expression).getROperand();
            } else if (expression instanceof JSCallExpression && ((JSCallExpression)expression).getArguments().length == 1) {
                candidate = (JSExpression)ArrayUtil.getFirstElement((Object[])((JSCallExpression)expression).getArguments());
            }
        } else if (statement instanceof JSVarStatement && (variables = ((JSVarStatement)statement).getVariables()).length == 1) {
            candidate = variables[0].getInitializer();
        }
        return (JSFunction)ObjectUtils.tryCast((Object)JSUtils.unparenthesize(candidate), JSFunctionExpression.class);
    }

    public void beforeMove(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(36);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(37);
        }
        super.beforeMove(editor, info, down);
        PsiElement blockStatementContainer = (PsiElement)info.getUserData(BLOCK_STATEMENT_CONTAINER_KEY);
        if (blockStatementContainer != null && JSStatementUpDownMover.isMultiline(blockStatementContainer, editor.getDocument())) {
            JSStatementUpDownMover.surroundWithCodeBlock(blockStatementContainer, editor, info, down);
        }
        if (Boolean.TRUE == info.getUserData(ADD_COMMA_AFTER_LIST_ITEM_KEY)) {
            JSStatementUpDownMover.addComma(editor, info, down);
        }
    }

    private static boolean isMultiline(PsiElement element, Document document2) {
        TextRange textRange = element.getTextRange();
        int start = document2.getLineNumber(textRange.getStartOffset());
        int end = document2.getLineNumber(textRange.getEndOffset());
        return end - start != 0;
    }

    private static void addComma(@NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        Project project;
        if (editor == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(38);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(39);
        }
        if ((project = editor.getProject()) == null) {
            return;
        }
        Document document2 = editor.getDocument();
        int offset = JSStatementUpDownMover.adjustOffsetForComma(editor, project, document2.getLineEndOffset((down ? info.toMove2.endLine : info.toMove.endLine) - 1), true);
        if (offset == -1) {
            return;
        }
        document2.insertString(offset, (CharSequence)",");
        offset = JSStatementUpDownMover.adjustOffsetForComma(editor, project, document2.getLineEndOffset((down ? info.toMove.endLine : info.toMove2.endLine) - 1), false);
        String text = document2.getText(new TextRange(offset - 1, offset));
        if (text.equals(",")) {
            document2.deleteString(offset - 1, offset);
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
    }

    private static int adjustOffsetForComma(@NotNull Editor editor, Project project, int offset, boolean stopIfComma) {
        if (editor == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(40);
        }
        if (!(editor instanceof EditorEx)) {
            return offset;
        }
        PsiFile file2 = PsiManager.getInstance((Project)project).findFile(((EditorEx)editor).getVirtualFile());
        if (file2 == null) {
            return offset;
        }
        PsiElement element = file2.findElementAt(offset - 1);
        while (element instanceof PsiWhiteSpace || element instanceof PsiComment) {
            offset = element.getTextOffset();
            element = element.getPrevSibling();
        }
        if (stopIfComma && PsiUtilCore.getElementType((PsiElement)element) == JSTokenTypes.COMMA) {
            return -1;
        }
        return offset;
    }

    private static void surroundWithCodeBlock(@NotNull PsiElement blockStatementContainer, @NotNull Editor editor, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        int endOffset;
        int startOffset;
        PsiElement body;
        if (blockStatementContainer == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(41);
        }
        if (editor == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(42);
        }
        if (info == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(43);
        }
        if ((body = JSStatementUpDownMover.getStatementBodyOrNull(blockStatementContainer, down)) == null || body instanceof JSBlockStatement) {
            return;
        }
        Document document2 = editor.getDocument();
        Project project = blockStatementContainer.getProject();
        PsiFile containingFile = blockStatementContainer.getContainingFile();
        if (down) {
            startOffset = document2.getLineEndOffset(info.toMove2.startLine);
            endOffset = body.getTextRange().getEndOffset() + 1;
        } else {
            startOffset = body.getTextRange().getStartOffset();
            endOffset = document2.getLineEndOffset(info.toMove.endLine - 1) + 1;
        }
        document2.insertString(startOffset, (CharSequence)"{");
        document2.insertString(endOffset, (CharSequence)"}");
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)containingFile, startOffset, endOffset + 2);
    }

    @Nullable
    private static PsiElement getStatementBodyOrNull(PsiElement statement, boolean down) {
        if (statement instanceof JSLoopStatement) {
            return ((JSLoopStatement)statement).getBody();
        }
        if (statement instanceof JSIfStatement) {
            JSIfStatement ifStatement = (JSIfStatement)statement;
            if (down) {
                return ifStatement.getThen();
            }
            JSStatement elseBranch = ifStatement.getElse();
            return JSStatementUpDownMover.getStatementBodyOrNull((PsiElement)(elseBranch == null ? ifStatement.getThen() : elseBranch), false);
        }
        return statement;
    }

    private static boolean isSameNode(PsiFile file2, StatementUpDownMover.MoveInfo info, Document document2, boolean down) {
        int endOffset;
        int startOffset;
        if (down) {
            startOffset = document2.getLineStartOffset(info.toMove.startLine);
            endOffset = document2.getLineEndOffset(info.toMove2.endLine - 1);
        } else {
            startOffset = document2.getLineStartOffset(info.toMove2.startLine);
            endOffset = document2.getLineEndOffset(info.toMove.endLine - 1);
        }
        return file2.findElementAt(startOffset) == file2.findElementAt(endOffset);
    }

    private static int advanceToRange(Document document2, int offset) {
        int afterNextLf = CharArrayUtil.shiftForwardUntil((CharSequence)document2.getCharsSequence(), (int)offset, (String)"\n") + 1;
        return afterNextLf < document2.getTextLength() ? document2.getLineNumber(afterNextLf) : document2.getLineCount();
    }

    @NotNull
    private static TextRange blockTailRange(@NotNull JSBlockStatement blockStatement) {
        if (blockStatement == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(44);
        }
        ASTNode rBrace = blockStatement.getNode().findChildByType(JSTokenTypes.RBRACE);
        assert (rBrace != null);
        return new TextRange(rBrace.getTextRange().getStartOffset(), blockStatement.getParent().getTextRange().getEndOffset());
    }

    @NotNull
    private static TextRange blockHeaderRange(@NotNull JSBlockStatement blockStatement) {
        if (blockStatement == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(45);
        }
        ASTNode lBrace = blockStatement.getNode().findChildByType(JSTokenTypes.LBRACE);
        assert (lBrace != null);
        return new TextRange(blockStatement.getNode().getTreeParent().getStartOffset(), lBrace.getTextRange().getEndOffset());
    }

    private static PsiElement expandRangeBefore(PsiElement first) {
        if (JSStatementUpDownMover.isCommentOwner(first)) {
            return JSPsiImplUtils.findLeadingCommentOrSelf(first);
        }
        return (PsiElement)ObjectUtils.coalesce((Object)JSStatementUpDownMover.expandLineCommentBlock(first.getNode(), false), (Object)first);
    }

    private static boolean isTrivialWs(PsiWhiteSpace prevElement) {
        String text = prevElement.getText();
        return text.startsWith("\n") && text.indexOf("\n", 1) == -1;
    }

    private static PsiElement expandRangeAfter(PsiElement second) {
        if (JSStatementUpDownMover.isCommentOwner(second)) {
            return (PsiElement)ObjectUtils.coalesce((Object)JSPsiImplUtils.findTrailingEndOfLineComment(second), (Object)second);
        }
        return (PsiElement)ObjectUtils.coalesce((Object)JSStatementUpDownMover.expandLineCommentBlock(second.getNode(), true), (Object)second);
    }

    private static boolean isCommentOwner(@Nullable PsiElement nextElement) {
        return nextElement instanceof JSExpressionStatement || nextElement instanceof JSQualifiedNamedElement || nextElement instanceof TypeScriptTypeMember || nextElement instanceof JSVarStatement;
    }

    @Nullable
    private static PsiElement expandLineCommentBlock(ASTNode node, boolean down) {
        if (node.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT) {
            ASTNode prev;
            do {
                prev = node;
                ASTNode aSTNode = node = down ? node.getTreeNext() : node.getTreePrev();
                if (!(node instanceof PsiWhiteSpace) || !JSStatementUpDownMover.isTrivialWs((PsiWhiteSpace)node)) continue;
                ASTNode aSTNode2 = node = down ? node.getTreeNext() : node.getTreePrev();
            } while (node != null && node.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT);
            return prev.getPsi();
        }
        return null;
    }

    @Contract(value="null -> true")
    private static boolean isNotValidStatementRange(@Nullable ElementRange range) {
        if (range == null || range.first.getParent() != range.second.getParent()) {
            return true;
        }
        if (JSStatementUpDownMover.isAdjacentToError(range.first, false)) {
            return true;
        }
        return JSStatementUpDownMover.isAdjacentToError(range.second, true);
    }

    private static boolean isAdjacentToError(@NotNull PsiElement element, boolean down) {
        PsiElement prevLeaf;
        if (element == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(46);
        }
        PsiElement psiElement = prevLeaf = down ? PsiTreeUtil.nextLeaf((PsiElement)element) : PsiTreeUtil.prevLeaf((PsiElement)element);
        while (prevLeaf instanceof PsiWhiteSpace) {
            prevLeaf = down ? PsiTreeUtil.nextLeaf((PsiElement)prevLeaf) : PsiTreeUtil.prevLeaf((PsiElement)prevLeaf);
            if (prevLeaf == null || prevLeaf.getNode() == null || prevLeaf.getNode().getElementType() != JSTokenTypes.SEMICOLON) continue;
            prevLeaf = down ? PsiTreeUtil.nextLeaf((PsiElement)prevLeaf) : PsiTreeUtil.prevLeaf((PsiElement)prevLeaf);
        }
        return prevLeaf instanceof PsiErrorElement;
    }

    @Nullable
    private static ElementRange getMovableElementRange(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull LineRange toMove, @NotNull Document document2) {
        Pair range;
        if (editor == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(47);
        }
        if (file2 == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(48);
        }
        if (toMove == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(49);
        }
        if (document2 == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(50);
        }
        if ((range = JSStatementUpDownMover.getElementRange((Editor)editor, (PsiFile)file2, (LineRange)toMove)) == null) {
            return null;
        }
        PsiElement statement = JSStatementUpDownMover.getMovableElement((PsiElement)range.first, true);
        PsiElement statement2 = JSStatementUpDownMover.getMovableElement((PsiElement)range.second, false);
        if (statement2 != null && PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)statement2, (boolean)false)) {
            statement2 = statement;
        }
        if (statement != null && PsiTreeUtil.isAncestor((PsiElement)statement2, (PsiElement)statement, (boolean)false)) {
            statement = statement2;
        }
        if (statement == null || statement2 == null) {
            return null;
        }
        LineRange rangeToMove = new LineRange(JSStatementUpDownMover.expandRangeBefore(statement), JSStatementUpDownMover.expandRangeAfter(statement2), document2);
        return new ElementRange(statement, statement2, rangeToMove);
    }

    @Nullable
    private static PsiElement findLeadingCommentOwner(@NotNull PsiComment comment) {
        PsiElement nextElement;
        if (comment == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(51);
        }
        if ((nextElement = comment.getNextSibling()) instanceof PsiWhiteSpace && JSStatementUpDownMover.isTrivialWs((PsiWhiteSpace)nextElement)) {
            nextElement = nextElement.getNextSibling();
        }
        if (JSStatementUpDownMover.isCommentOwner(nextElement)) {
            return nextElement;
        }
        return null;
    }

    @Nullable
    private static PsiElement findTrailingEndOfLineCommentOwner(@NotNull PsiComment comment) {
        if (comment == null) {
            JSStatementUpDownMover.$$$reportNull$$$0(52);
        }
        if (comment.getNode().getElementType() != JSTokenTypes.END_OF_LINE_COMMENT) {
            return null;
        }
        PsiElement prev = comment.getPrevSibling();
        return prev != null && (!(prev instanceof PsiWhiteSpace) || !prev.textContains('\n')) ? comment : null;
    }

    private static boolean isBlockStatementContainer(PsiElement parent) {
        return parent instanceof JSLoopStatement || parent instanceof JSIfStatement;
    }

    @Nullable
    private static PsiElement getMovableElement(PsiElement element, boolean isFirst) {
        if (element == null) {
            return null;
        }
        if (element.getNode().getElementType() == JSTokenTypes.COMMA || element.getNode().getElementType() == JSTokenTypes.SEMICOLON) {
            PsiElement prevElement = element.getPrevSibling();
            if (prevElement instanceof PsiWhiteSpace) {
                prevElement = prevElement.getPrevSibling();
            }
            if (prevElement == null) {
                return null;
            }
            element = prevElement;
        }
        if (element instanceof JSVarStatement && element.getParent() instanceof TypeScriptEnum) {
            Object[] variables = ((JSVarStatement)element).getVariables();
            return isFirst ? (PsiElement)ArrayUtil.getFirstElement((Object[])variables) : (PsiElement)ArrayUtil.getLastElement((Object[])variables);
        }
        return PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)false, parent -> {
            if (JSStatementUpDownMover.isArrayElement(parent) || JSStatementUpDownMover.isDestructuringArrayElement(parent)) {
                return true;
            }
            if (parent instanceof JSFunctionExpression) {
                return false;
            }
            if (parent instanceof JSSourceElement) {
                return !(parent instanceof JSBlockStatement) && !(parent instanceof JSPackageStatement);
            }
            return parent instanceof PsiComment || parent instanceof JSProperty || parent instanceof JSDestructuringProperty || parent instanceof TypeScriptTypeMember || parent instanceof TypeScriptEnumField || parent instanceof ES6ImportExportSpecifier || parent instanceof XmlElement || parent instanceof JSCaseClause;
        });
    }

    private static boolean isDestructuringArrayElement(@Nullable PsiElement parent) {
        return parent instanceof JSVariable && parent.getParent() instanceof JSDestructuringArray;
    }

    private static boolean isArrayElement(@Nullable PsiElement parent) {
        return parent instanceof JSExpression && parent.getParent() instanceof JSArrayLiteralExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 18: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 13: 
            case 19: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 10: 
            case 14: 
            case 20: 
            case 28: 
            case 31: 
            case 34: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedRange";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "siblingClass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "siblingCondition";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 26: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStatement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 35: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStatementContainer";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toMove";
                break;
            }
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/editing/JSStatementUpDownMover";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAvailable";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "moveJSElement";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "moveJSXElement";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "moveListItem";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getRootJSXTag";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "moveElementsByLine";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "findSiblingByCondition";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "moveOut";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "moveIntoBlock";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "moveNextTo";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "findPossibleFunction";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeMove";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "addComma";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustOffsetForComma";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundWithCodeBlock";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "blockTailRange";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "blockHeaderRange";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[2] = "isAdjacentToError";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[2] = "getMovableElementRange";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[2] = "findLeadingCommentOwner";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[2] = "findTrailingEndOfLineCommentOwner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class JSXMover
    extends XmlMover {
        private static final TokenSet START_TAG_END_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_TAG_END, JSTokenTypes.XML_START_TAG_LIST});
        private static final TokenSet END_TAG_START_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{XmlTokenType.XML_END_TAG_START, JSTokenTypes.XML_END_TAG_LIST});

        JSXMover() {
        }

        @NotNull
        protected TextRange getTagContentRange(@NotNull XmlTag parent) {
            if (parent == null) {
                JSXMover.$$$reportNull$$$0(0);
            }
            ASTNode startTagEnd = parent.getNode().findChildByType(START_TAG_END_TOKEN_SET);
            ASTNode endTagStart = parent.getNode().findChildByType(END_TAG_START_TOKEN_SET, startTagEnd);
            if (startTagEnd != null && endTagStart != null) {
                return new TextRange(startTagEnd.getTextRange().getEndOffset(), endTagStart.getTextRange().getStartOffset());
            }
            TextRange textRange = parent.getValue().getTextRange();
            if (textRange == null) {
                JSXMover.$$$reportNull$$$0(1);
            }
            return textRange;
        }

        protected XmlElement getDestinationElement(@NotNull PsiFile file2, @NotNull XmlElement sourceElement, int offset, boolean forward) {
            if (file2 == null) {
                JSXMover.$$$reportNull$$$0(2);
            }
            if (sourceElement == null) {
                JSXMover.$$$reportNull$$$0(3);
            }
            return JSXMover.getMeaningfulElementAtOffset((PsiFile)file2, (int)offset, (boolean)forward, t -> sourceElement instanceof XmlAttribute ? t instanceof XmlAttribute : JSXMover.isMovableXmlTagChild(t));
        }

        protected XmlElement getSourceElement(@NotNull PsiFile file2, int offset, boolean forward) {
            if (file2 == null) {
                JSXMover.$$$reportNull$$$0(4);
            }
            return JSXMover.getMeaningfulElementAtOffset((PsiFile)file2, (int)offset, (boolean)forward, candidate -> {
                if (candidate instanceof XmlAttribute) {
                    return true;
                }
                return JSXMover.isMovableXmlTagChild(candidate);
            });
        }

        private static boolean isMovableXmlTagChild(@NotNull PsiElement candidate) {
            if (candidate == null) {
                JSXMover.$$$reportNull$$$0(5);
            }
            if (candidate instanceof JSEmbeddedContent) {
                return candidate.getParent() instanceof XmlTag;
            }
            return candidate instanceof XmlTagChild;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/editing/JSStatementUpDownMover$JSXMover";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/editing/JSStatementUpDownMover$JSXMover";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTagContentRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTagContentRange";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDestinationElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getSourceElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isMovableXmlTagChild";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ElementRange {
        @NotNull
        public final PsiElement first;
        @NotNull
        public final PsiElement second;
        @NotNull
        public final LineRange rangeToMove;

        ElementRange(@NotNull PsiElement first, @NotNull PsiElement second, @NotNull LineRange rangeToMove) {
            if (first == null) {
                ElementRange.$$$reportNull$$$0(0);
            }
            if (second == null) {
                ElementRange.$$$reportNull$$$0(1);
            }
            if (rangeToMove == null) {
                ElementRange.$$$reportNull$$$0(2);
            }
            this.first = first;
            this.second = second;
            this.rangeToMove = rangeToMove;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "first";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "second";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rangeToMove";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/editing/JSStatementUpDownMover$ElementRange";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

