/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6TypeEvaluator;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveTypeTransformer;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptNotNullExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformer;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTemplateLiteralJSTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeEvaluator
extends ES6TypeEvaluator {
    private static final String THIS_TYPE_NAME = "ThisType";

    public TypeScriptTypeEvaluator(@NotNull JSEvaluateContext context, @NotNull JSTypeProcessor processor) {
        if (context == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(1);
        }
        super(context, processor);
    }

    @Nullable
    private static JSType toFalsy(@Nullable JSType type, JSTypeSource source) {
        if (JSTypeCastUtil.isFalsy(type)) {
            return type;
        }
        if (type instanceof JSStringType && !(type instanceof JSStringLiteralTypeImpl)) {
            return new JSStringLiteralTypeImpl("", false, source);
        }
        if (type instanceof JSNumberType && !(type instanceof JSNumberLiteralTypeImpl)) {
            return new JSNumberLiteralTypeImpl(0.0, false, source, "0");
        }
        if (type instanceof JSBigIntType && !(type instanceof JSBigIntLiteralTypeImpl)) {
            return new JSBigIntLiteralTypeImpl(BigInteger.ZERO, false, source, "0n");
        }
        if (type instanceof JSBooleanType && !(type instanceof JSBooleanLiteralTypeImpl)) {
            return new JSBooleanLiteralTypeImpl(false, false, source);
        }
        return null;
    }

    @Nullable
    private static JSType toFalsyTypeAfterAndOperator(@Nullable JSType type, JSTypeSource source) {
        JSType initialType = type;
        if (JSTypeUtils.isAnyType(type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type))) {
            return initialType;
        }
        if (type instanceof JSUnionType) {
            ArrayList<JSType> allFalsy = new ArrayList<JSType>();
            for (JSType part : ((JSUnionType)type).getTypes()) {
                JSType falsy = TypeScriptTypeEvaluator.toFalsy(part, source);
                if (falsy == null) continue;
                allFalsy.add(falsy);
            }
            return allFalsy.isEmpty() ? null : JSCompositeTypeFactory.createUnionType(source, allFalsy);
        }
        return TypeScriptTypeEvaluator.toFalsy(type, source);
    }

    @Override
    protected void evaluatePlusType(@NotNull JSBinaryExpression binaryExpression, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        if (binaryExpression == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(2);
        }
        super.evaluatePlusType(binaryExpression, JSTypeUtils.removeNullableComponents(lProcType), JSTypeUtils.removeNullableComponents(rProcType));
    }

    @Override
    protected void evaluateAndOrOrType(@NotNull JSExpression rawqualifier, @NotNull IElementType sign, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        JSType type;
        if (rawqualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(3);
        }
        if (sign == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(4);
        }
        if ((type = TypeScriptTypeEvaluator.getAndOrOrOrQuestType(lProcType, rProcType, sign, (PsiElement)rawqualifier)) != null) {
            this.addType(type, (PsiElement)rawqualifier);
        } else {
            this.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    @Nullable
    public static JSType getAndOrOrOrQuestType(@Nullable JSType lProcType, @Nullable JSType rProcType, @NotNull IElementType sign, @NotNull PsiElement context) {
        boolean isTypeScript;
        if (sign == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(5);
        }
        if (context == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(6);
        }
        boolean strictNullChecks = (isTypeScript = DialectDetector.isTypeScript(context)) && TypeScriptConfigUtil.strictNullChecks(context);
        JSType originalLProc = lProcType;
        if (sign == JSTokenTypes.OROR) {
            lProcType = JSTypeUtils.removeFalsyComponents(lProcType);
        } else if (sign == JSTokenTypes.QUEST_QUEST) {
            lProcType = JSTypeUtils.removeNullableComponents(lProcType);
        } else if (sign == JSTokenTypes.ANDAND) {
            lProcType = TypeScriptTypeEvaluator.toFalsyTypeAfterAndOperator(lProcType, JSTypeSourceFactory.createTypeSource(context, true));
        }
        if (isTypeScript && lProcType != null && rProcType != null && sign == JSTokenTypes.OROR) {
            return TypeScriptTypeRelations.getBestChoiceType(lProcType, rProcType, context);
        }
        if (sign == JSTokenTypes.QUEST_QUEST) {
            if (lProcType instanceof TypeScriptNeverJSTypeImpl) {
                return rProcType;
            }
            if (strictNullChecks && lProcType == originalLProc) {
                return lProcType;
            }
            return TypeScriptTypeRelations.getBestChoiceType(lProcType, rProcType, context);
        }
        if (isTypeScript && !strictNullChecks && sign != JSTokenTypes.OROR) {
            lProcType = null;
        }
        if (lProcType == null) {
            return rProcType;
        }
        if (rProcType == null) {
            return lProcType;
        }
        return JSCompositeTypeFactory.createUnionType(JSTypeSourceFactory.createTypeSource(context, true), Arrays.asList(lProcType, rProcType));
    }

    @Override
    protected void addTypeFromElementResolveResult(@Nullable PsiElement resolveResult) {
        if (resolveResult instanceof TypeScriptPropertySignature) {
            TypeScriptPropertySignature propertySignature = (TypeScriptPropertySignature)resolveResult;
            JSTypeDeclaration propertyType = propertySignature.getTypeDeclaration();
            if (propertyType instanceof JSFunction) {
                this.processFunction((JSFunction)propertyType);
            } else if (propertyType != null) {
                JSType jsType = propertySignature.getJSType();
                if (propertySignature.isOptional() && jsType != null) {
                    jsType = TypeScriptTypeGuard.wrapWithUndefined(jsType, jsType.getSource());
                }
                this.addType(jsType, resolveResult);
            }
        } else if (resolveResult instanceof TypeScriptModule) {
            this.addTypeFromModule((TypeScriptModule)resolveResult);
        } else if (resolveResult instanceof TypeScriptImportStatement) {
            this.addTypeFromImportStatement((TypeScriptImportStatement)resolveResult);
        } else if (resolveResult instanceof TypeScriptIndexSignature) {
            JSType type = ((TypeScriptIndexSignature)resolveResult).getMemberType();
            this.addType(type, resolveResult);
        } else if (!(resolveResult instanceof TypeScriptCallSignature)) {
            if (resolveResult instanceof TypeScriptGlobalModuleExportDeclaration) {
                for (PsiElement element : ((TypeScriptGlobalModuleExportDeclaration)resolveResult).getModules()) {
                    this.addTypeFromExternalModuleReferenceResolveResult(element);
                }
            } else {
                super.addTypeFromElementResolveResult(resolveResult);
            }
        }
    }

    private void addTypeFromModule(TypeScriptModule resolveResult) {
        if (resolveResult.isShorthandAmbientModule()) {
            this.addType(JSAnyType.get((PsiElement)resolveResult, true), (PsiElement)resolveResult);
            return;
        }
        this.addTypeFromLocalModule(resolveResult);
    }

    private void addTypeFromLocalModule(@NotNull TypeScriptModule resolveResult) {
        String name;
        if (resolveResult == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(7);
        }
        if (!StringUtil.isEmpty((String)(name = resolveResult.getName()))) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(resolveResult.getContext(), true);
            JSType jsType = JSNamedTypeFactory.createType(name, source, JSContext.STATIC);
            this.addType(jsType, (PsiElement)resolveResult);
        }
    }

    private void addTypeFromImportStatement(TypeScriptImportStatement importStatement) {
        TypeScriptTypeEvaluator.processWithEvaluationGuard((PsiElement)importStatement, this.myContext, () -> {
            TypeScriptEntityName internalModuleReference = importStatement.getInternalModuleReference();
            TypeScriptExternalModuleReference externalModuleReference = importStatement.getExternalModuleReference();
            if (internalModuleReference != null) {
                List<PsiElement> elements = JSResolveResult.toElements(internalModuleReference.multiResolve(false));
                this.addTypeFromInternalModules(elements);
            } else if (externalModuleReference != null) {
                Collection elements = externalModuleReference.multiResolve();
                for (PsiElement element : elements) {
                    this.addTypeFromExternalModuleReferenceResolveResult(element);
                }
            }
            return null;
        });
    }

    private void addTypeFromInternalModules(Collection<PsiElement> elements) {
        if (elements.isEmpty()) {
            return;
        }
        if (elements.size() == 1) {
            PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
            assert (item != null);
            this.addTypeFromResolveResult(item);
            return;
        }
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        if (expression == null) {
            return;
        }
        List modules = elements.stream().filter(TypeScriptModule.class::isInstance).map(TypeScriptModule.class::cast).collect(Collectors.toList());
        if (!modules.isEmpty()) {
            TypeScriptModule module = (TypeScriptModule)ContainerUtil.getFirstItem(modules);
            assert (module != null);
            this.addTypeFromLocalModule(module);
        }
        for (PsiElement element : elements) {
            if (element instanceof TypeScriptModule) continue;
            this.addTypeFromResolveResult(element);
        }
    }

    @Override
    protected void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier, @NotNull JSClass jsClass, @NotNull JSContext staticOrInstance) {
        TypeScriptTypeParameter[] parametersForOwner;
        String name;
        if (rawqualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(8);
        }
        if (jsClass == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(9);
        }
        if (staticOrInstance == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(10);
        }
        if ((name = jsClass.getQualifiedName()) != null && (parametersForOwner = TypeScriptPsiUtil.getTypeParametersForOwner((PsiElement)jsClass)).length > 0 && staticOrInstance == JSContext.INSTANCE) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
            JSTypeSource classNameSource = JSTypeSourceFactory.createTypeSource((PsiElement)jsClass, true);
            List<JSType> types2 = TypeScriptGenericTypesEvaluator.buildGenericParameters(parametersForOwner);
            JSType thisType = this.createTypeForThisExpression(JSContext.INSTANCE, jsClass, classNameSource);
            this.addType(new JSGenericTypeImpl(source, thisType, types2), (PsiElement)jsClass);
            return;
        }
        super.processThisQualifierExpression(rawqualifier, jsClass, staticOrInstance);
    }

    @Override
    @NotNull
    protected JSType createTypeForThisExpression(@NotNull JSContext staticOrInstance, @NotNull JSClass jsClass, @NotNull JSTypeSource typeSource) {
        if (staticOrInstance == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(11);
        }
        if (jsClass == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(12);
        }
        if (typeSource == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(13);
        }
        if (!DialectDetector.isTypeScript((PsiElement)jsClass)) {
            JSType jSType = super.createTypeForThisExpression(staticOrInstance, jsClass, typeSource);
            if (jSType == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(14);
            }
            return jSType;
        }
        String name = jsClass.getQualifiedName();
        if (name == null) {
            JSTypeBaseImpl baseType = jsClass instanceof JSClassExpression ? new JSClassExpressionType((JSClassExpression)jsClass, staticOrInstance) : JSAnyType.get(typeSource);
            return new TypeScriptGenericThisTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)jsClass, true), baseType);
        }
        JSType ownerType = JSNamedTypeFactory.createType(name, typeSource, staticOrInstance);
        if (staticOrInstance == JSContext.STATIC) {
            JSType jSType = ownerType;
            if (jSType == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(15);
            }
            return jSType;
        }
        return new TypeScriptGenericThisTypeImpl(typeSource, ownerType);
    }

    @Override
    public void addTypeFromExternalModuleReferenceResolveResult(@NotNull PsiElement moduleCandidate, boolean fromRequire) {
        TypeScriptExportAssignment exportAssignment;
        if (moduleCandidate == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(16);
        }
        if ((exportAssignment = TypeScriptPsiUtil.findExportAssignment(moduleCandidate)) != null) {
            this.evaluateExportAssignment((JSExportAssignment)exportAssignment);
            return;
        }
        super.addTypeFromExternalModuleReferenceResolveResult(moduleCandidate, fromRequire);
    }

    @Override
    protected void evaluateExportAssignment(@NotNull JSExportAssignment assignment) {
        String reference;
        if (assignment == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(17);
        }
        if (assignment instanceof TypeScriptExportAssignment && (reference = assignment.getInitializerReference()) != null) {
            List<PsiElement> elements = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(reference, (PsiElement)assignment);
            for (PsiElement element : elements) {
                this.addTypeFromResolveResult(element);
            }
            if (!elements.isEmpty()) {
                return;
            }
        }
        super.evaluateExportAssignment(assignment);
    }

    @Override
    protected boolean evaluateDialectSpecificTypes(JSExpression rawQualifier) {
        if (rawQualifier instanceof TypeScriptCastExpression) {
            TypeScriptType typeScriptType = ((TypeScriptCastExpression)rawQualifier).getType();
            if (((TypeScriptCastExpression)rawQualifier).isConstCast()) {
                this.addType(this.getExpressionTypeInContext(((TypeScriptCastExpression)rawQualifier).getExpression()), (PsiElement)rawQualifier);
                return true;
            }
            if (typeScriptType != null) {
                JSType type = typeScriptType.getJSType();
                this.addType(type, (PsiElement)rawQualifier);
                return true;
            }
        } else if (rawQualifier instanceof TypeScriptNotNullExpression) {
            JSExpression expression = ((TypeScriptNotNullExpression)rawQualifier).getExpression();
            JSType type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(this.getExpressionTypeInContext(expression));
            this.addType(JSTypeUtils.removeNullableComponents(type), (PsiElement)rawQualifier);
            return true;
        }
        return super.evaluateDialectSpecificTypes(rawQualifier);
    }

    @Override
    protected void addTypeFromClassWithQName(@NotNull JSClass resolveResult) {
        if (resolveResult == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(18);
        }
        if (!DialectDetector.isTypeScript((PsiElement)resolveResult)) {
            super.addTypeFromClassWithQName(resolveResult);
            return;
        }
        JSReferenceExpression processedExpression = this.myContext.getProcessedExpression();
        PsiElement source = this.getSourceForTypeContext((PsiElement)resolveResult, processedExpression);
        this.addType(resolveResult.getStaticJSType(), source);
    }

    private PsiElement getSourceForTypeContext(PsiElement resolveResult, JSReferenceExpression processedExpression) {
        return processedExpression != null && resolveResult.getContainingFile().isEquivalentTo((PsiElement)this.myContext.targetFile) ? processedExpression : resolveResult;
    }

    @Override
    @NotNull
    public List<JSType> getComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        JSRecordType.PropertySignature member;
        String value;
        if (type instanceof JSArrayType || type == null || type instanceof JSUnionType && !JSTypeCastUtil.isStrictTypeScriptUnionType((JSUnionType)type)) {
            List<JSType> list2 = super.getComponentTypeFromProcessor(rawqualifier, type);
            if (list2 == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(19);
            }
            return list2;
        }
        if (!(rawqualifier instanceof JSIndexedPropertyAccessExpression)) {
            List<JSType> candidates = this.getComponentTypeWithExpandingComposite(rawqualifier, type);
            if (!candidates.isEmpty()) {
                List<JSType> list3 = candidates;
                if (list3 == null) {
                    TypeScriptTypeEvaluator.$$$reportNull$$$0(20);
                }
                return list3;
            }
            List<JSType> list4 = Collections.singletonList(new JSIterableComponentTypeImpl(type, type.getSource()));
            if (list4 == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(21);
            }
            return list4;
        }
        JSRecordType recordType = type.asRecordType();
        if (!recordType.hasMembers()) {
            List<JSType> list5 = super.getComponentTypeFromProcessor(rawqualifier, type);
            if (list5 == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(22);
            }
            return list5;
        }
        JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)rawqualifier).getIndexExpression();
        Object propertyName = null;
        if (indexExpression instanceof JSLiteralExpression && (value = ((JSLiteralExpression)indexExpression).getStringValue()) != null) {
            propertyName = value;
        }
        if (JSPsiImplUtils.isSymbolRef(indexExpression)) {
            propertyName = "[" + indexExpression.getText() + "]";
        }
        if (propertyName != null && (member = recordType.findPropertySignature((String)propertyName)) != null) {
            List<JSType> list6 = Collections.singletonList(member.getJSType());
            if (list6 == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(23);
            }
            return list6;
        }
        ArrayList indexSignatures = new ArrayList();
        ContainerUtil.addIfNotNull(indexSignatures, (Object)recordType.findIndexer(JSRecordType.IndexSignatureKind.STRING));
        ContainerUtil.addIfNotNull(indexSignatures, (Object)recordType.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC));
        if (!indexSignatures.isEmpty()) {
            JSType expressionTypeType = indexExpression != null ? this.getExpressionTypeInContext(indexExpression) : null;
            ProcessingContext processingContext = JSTypeComparingContextService.createProcessingContextWithCache((PsiElement)indexExpression);
            for (JSRecordType.IndexSignature signature : indexSignatures) {
                if (!JSResolveUtil.isAssignableJSType(signature.getMemberParameterType(), expressionTypeType, processingContext)) continue;
                List<JSType> list7 = Collections.singletonList(signature.getMemberType());
                if (list7 == null) {
                    TypeScriptTypeEvaluator.$$$reportNull$$$0(24);
                }
                return list7;
            }
        }
        List<JSType> list8 = Collections.singletonList(JSAnyType.get((PsiElement)rawqualifier, false));
        if (list8 == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(25);
        }
        return list8;
    }

    @Override
    @Nullable
    protected JSType getIndexedPropertyAccessType(@NotNull JSIndexedPropertyAccessExpression rawqualifier) {
        JSType type;
        List<JSType> results;
        if (rawqualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(26);
        }
        if (!DialectDetector.isTypeScript((PsiElement)rawqualifier)) {
            return super.getIndexedPropertyAccessType(rawqualifier);
        }
        JSExpression qualifier = rawqualifier.getQualifier();
        JSType qualifierTypeType = this.getExpressionTypeInContext(qualifier);
        JSExpression indexExpression = rawqualifier.getIndexExpression();
        JSType indexExpressionType = this.getExpressionTypeInContext(indexExpression);
        if (qualifierTypeType == null || indexExpressionType == null || JSPsiImplUtils.isSymbolRef(indexExpression)) {
            return super.getIndexedPropertyAccessType(rawqualifier);
        }
        if (indexExpressionType instanceof JSNumberType && (results = this.getComponentTypeFromArrayExpression((JSExpression)rawqualifier, rawqualifier.getQualifier())).size() == 1 && (type = results.get(0)).isSourceStrict()) {
            return type;
        }
        return JSCompositeTypeFactory.createIndexedAccessType(qualifierTypeType, indexExpressionType, JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true));
    }

    @Override
    @NotNull
    protected JSType getArrayTypeFromExpressions(@NotNull JSArrayLiteralExpression rawQualifier, @NotNull Stream<JSExpression> expressions) {
        DialectOptionHolder holder;
        if (rawQualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(27);
        }
        if (expressions == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(28);
        }
        AtomicInteger typesToEvaluateLimit = (holder = DialectDetector.dialectOfElement((PsiElement)rawQualifier)) != null && holder.isJavaScript() ? new AtomicInteger(5) : null;
        List types2 = expressions.map(expression -> TypeScriptTypeEvaluator.getTypeOrSpread(expression, this.getExpressionTypeForArrayLiteral((JSExpression)rawQualifier, (JSExpression)expression, typesToEvaluateLimit))).collect(Collectors.toList());
        JSType type = JSCompositeTypeFactory.createTupleType(JSTypeSourceFactory.createTypeSource((PsiElement)rawQualifier, true), types2, false, -1, false);
        if (JSDestructuringUtil.arrayLiteralCorrespondsToDestructuringArray((JSExpression)rawQualifier)) {
            JSType jSType = type;
            if (jSType == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(29);
            }
            return jSType;
        }
        if (this.isContextualOverloadEvaluation()) {
            JSType jSType = type;
            if (jSType == null) {
                TypeScriptTypeEvaluator.$$$reportNull$$$0(30);
            }
            return jSType;
        }
        JSType jSType = JSWidenType.createWidening(type, (PsiElement)rawQualifier);
        if (jSType == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(31);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType getExpressionTypeForArrayLiteral(@Nullable JSExpression arrayLiteralExpression, @Nullable JSExpression expression, @Nullable AtomicInteger typesToEvaluateLimit) {
        JSType expressionType = super.getExpressionTypeForArrayLiteral(arrayLiteralExpression, expression, typesToEvaluateLimit);
        if (expressionType == null) {
            expressionType = this.createNullType(arrayLiteralExpression);
        }
        JSType jSType = expressionType;
        if (jSType == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(32);
        }
        return jSType;
    }

    @Override
    protected JSType getWidenedPropertyType(@NotNull JSProperty contextualOwner) {
        JSType exprType;
        if (contextualOwner == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(33);
        }
        if ((exprType = contextualOwner.getJSType()) == null || this.isContextualOverloadEvaluation()) {
            return exprType;
        }
        if (!(exprType instanceof JSEvaluableType) && !JSTypeUtils.isLiteralOrCompositeWithLiteralType(exprType)) {
            return exprType;
        }
        return JSWidenType.createWidening(exprType, (PsiElement)contextualOwner);
    }

    @Override
    protected boolean addTypeFromAmdModuleReference(@NotNull JSParameter parameter) {
        if (parameter == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(34);
        }
        return !DialectDetector.isTypeScript((PsiElement)parameter) && super.addTypeFromAmdModuleReference(parameter);
    }

    @Override
    protected void processThisQualifierInExecutionScope(@NotNull JSThisExpression thisQualifier, PsiElement thisScope) {
        if (thisQualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(35);
        }
        if (thisScope instanceof TypeScriptFunction) {
            JSType type;
            PsiElement context = thisScope;
            if (thisScope instanceof JSFunctionExpression) {
                context = JSContextResolver.findContextElement((PsiElement)thisQualifier);
            }
            if (context instanceof TypeScriptFunction && (type = this.computeThisType((TypeScriptFunction)context)) != null) {
                this.addType(type, (PsiElement)thisQualifier);
                return;
            }
        }
        super.processThisQualifierInExecutionScope(thisQualifier, thisScope);
    }

    @Nullable
    public JSType computeThisType(@NotNull TypeScriptFunction function2) {
        JSType thisType;
        JSType contextualType;
        JSType explicitThisType;
        if (function2 == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(36);
        }
        if ((explicitThisType = function2.getExplicitThisType()) != null) {
            return explicitThisType;
        }
        if (function2 instanceof JSExpression && (contextualType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)function2, JSExpectedTypeKind.CONTEXTUAL)) instanceof JSFunctionTypeImpl && (thisType = ((JSFunctionTypeImpl)contextualType).getThisType()) != null) {
            return thisType;
        }
        TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(function2.getContainingFile());
        if (config2 == null || !config2.noImplicitThis()) {
            return null;
        }
        PsiElement context = function2.getContext();
        JSAssignmentExpression parentAssignment = (JSAssignmentExpression)ObjectUtils.tryCast((Object)context, JSAssignmentExpression.class);
        if (parentAssignment != null) {
            return this.computeThisTypeFromAssignment(parentAssignment);
        }
        JSObjectLiteralExpression parentLiteral = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)context, JSObjectLiteralExpression.class);
        if (parentLiteral != null) {
            return this.computeThisTypeFromLiteral(parentLiteral);
        }
        return null;
    }

    @Nullable
    private JSType computeThisTypeFromAssignment(@NotNull JSAssignmentExpression assignment) {
        JSExpression qualifier;
        JSDefinitionExpression definitionExpression;
        if (assignment == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(37);
        }
        if ((definitionExpression = assignment.getDefinitionExpression()) == null) {
            return null;
        }
        JSExpression expression = definitionExpression.getExpression();
        JSReferenceExpression referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)expression, JSReferenceExpression.class);
        JSIndexedPropertyAccessExpression indexer = (JSIndexedPropertyAccessExpression)ObjectUtils.tryCast((Object)expression, JSIndexedPropertyAccessExpression.class);
        Object object = referenceExpression != null ? referenceExpression.getQualifier() : (qualifier = indexer != null ? indexer.getQualifier() : null);
        if (qualifier == null) {
            return null;
        }
        return this.getExpressionTypeInContext(qualifier);
    }

    @Nullable
    private JSType computeThisTypeFromLiteral(@NotNull JSObjectLiteralExpression parentLiteral) {
        JSType contextualType;
        if (parentLiteral == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(38);
        }
        return (contextualType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)parentLiteral, this.getContextualExpectedTypeKind())) == null ? TypeScriptTypeEvaluator.createTypeOfLiteralType(parentLiteral) : TypeScriptTypeEvaluator.extractThisType(contextualType);
    }

    @Nullable
    private static JSType extractThisType(@Nullable JSType contextualType) {
        Ref thisTypeRef = Ref.create();
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            JSType thisType = TypeScriptTypeEvaluator.doExtractThisType(t);
            if (thisType != null) {
                thisTypeRef.set((Object)thisType);
                return false;
            }
            return true;
        }), contextualType, false, true, true);
        return thisTypeRef.isNull() ? contextualType : (JSType)thisTypeRef.get();
    }

    @Nullable
    private static JSType doExtractThisType(@Nullable JSType type) {
        JSType expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type);
        JSType thisType = TypeScriptTypeEvaluator.getTypeFromThisType(expanded);
        if (thisType != null) {
            return thisType;
        }
        if (expanded instanceof JSIntersectionType) {
            for (JSType jsType : ((JSIntersectionType)expanded).getTypes()) {
                thisType = TypeScriptTypeEvaluator.getTypeFromThisType(jsType);
                if (thisType == null) continue;
                return thisType;
            }
        }
        return null;
    }

    @Nullable
    private static JSType getTypeFromThisType(JSType expanded) {
        JSGenericTypeImpl genericType = (JSGenericTypeImpl)ObjectUtils.tryCast((Object)expanded, JSGenericTypeImpl.class);
        if (genericType == null) {
            return null;
        }
        JSNamedType namedType = (JSNamedType)ObjectUtils.tryCast((Object)genericType.getType(), JSNamedType.class);
        if (namedType == null || !THIS_TYPE_NAME.equals(namedType.getQualifiedName().getQualifiedName())) {
            return null;
        }
        List<JSType> arguments = genericType.getArguments();
        if (arguments.size() != 1) {
            return null;
        }
        return arguments.get(0);
    }

    @NotNull
    private static JSCodeBasedType createTypeOfLiteralType(@NotNull JSObjectLiteralExpression parentLiteral) {
        if (parentLiteral == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(39);
        }
        return new JSTypeofTypeImpl((JSExpression)parentLiteral, JSTypeSourceFactory.createTypeSource((PsiElement)parentLiteral, DialectDetector.isTypeScript((PsiElement)parentLiteral)));
    }

    @Override
    protected void processSuperQualifierExpression(JSSuperExpression rawqualifier, @Nullable JSClass jsClass) {
        if (jsClass != null && !jsClass.isInterface()) {
            JSReferenceListMember member;
            JSReferenceList extendsList = jsClass.getExtendsList();
            if (extendsList == null) {
                return;
            }
            JSReferenceExpression processedExpression = this.myContext.getProcessedExpression();
            Object[] members = extendsList.getMembers();
            if (members.length == 1 && (member = (JSReferenceListMember)ArrayUtil.getFirstElement((Object[])members)) != null) {
                Collection jsClasses = member.getClasses();
                if (jsClasses.isEmpty()) {
                    super.processSuperQualifierExpression(rawqualifier, jsClass);
                    return;
                }
                JSTypeDeclaration[] arguments = member.getTypeArguments();
                if (arguments.length > 0) {
                    List<JSType> types2 = JSClassUtils.buildTypeArguments(member);
                    for (JSClass aClass : jsClasses) {
                        JSType type = aClass.getStaticJSType();
                        PsiElement source = this.getSourceForTypeContext((PsiElement)aClass, processedExpression);
                        this.addType(new JSGenericTypeImpl(type.getSource(), type, types2), source);
                    }
                    return;
                }
            }
        }
        super.processSuperQualifierExpression(rawqualifier, jsClass);
    }

    @Override
    protected JSType substituteThisType(@Nullable JSType type, @Nullable JSFieldVariable jsVariable) {
        JSType parentType;
        if (!JSTypeUtils.hasTypes(type, TypeScriptGenericThisTypeImpl.class)) {
            return type;
        }
        JSClass context = JSResolveUtil.getClassOfContext((PsiElement)jsVariable);
        if (context == null) {
            return type;
        }
        JSTypeSource source = type.getSource();
        String name = context.getQualifiedName();
        JSType jSType = parentType = name == null ? null : JSNamedTypeFactory.createType(name, source, JSContext.INSTANCE);
        if (parentType == null) {
            return type;
        }
        return type.transformTypeHierarchy((JSRecursiveTypeTransformer)new JSCacheableTypeTransformer((Function<JSType, JSType>)((Function)jsType -> {
            if (jsType instanceof TypeScriptGenericThisTypeImpl) {
                JSType owner = ((TypeScriptGenericThisTypeImpl)jsType).getOwnerType();
                JSTypeSource currentSource = jsType.getSource();
                if (!(currentSource.getSourceElement() == context || owner != null && owner.isEquivalentTo(parentType, null))) {
                    JSTypeSource newSource = JSTypeSourceFactory.copyTypeSource(currentSource, (PsiElement)context);
                    return new TypeScriptGenericThisTypeImpl(newSource, parentType);
                }
            }
            return jsType;
        })));
    }

    @Override
    protected JSType evaluateTypeFromInlineComment(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(40);
        }
        if (DialectDetector.isTypeScript((PsiElement)rawqualifier)) {
            return null;
        }
        return super.evaluateTypeFromInlineComment(rawqualifier);
    }

    @Override
    protected void addTypeFromLiteralExpression(@NotNull JSExpression rawQualifier) {
        JSExpression[] arguments;
        if (rawQualifier == null) {
            TypeScriptTypeEvaluator.$$$reportNull$$$0(41);
        }
        if (rawQualifier instanceof JSStringTemplateExpression && JSWidenType.isConstContext((PsiElement)rawQualifier) && (arguments = ((JSStringTemplateExpression)rawQualifier).getArguments()).length > 0) {
            ProcessingContext context = JSTypeComparingContextService.createProcessingContextWithCache((PsiElement)rawQualifier);
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rawQualifier, true);
            JSType constraintType = TypeScriptTypeRelations.createTemplateLiteralConstraintType(source);
            ArrayList<String> texts = new ArrayList<String>();
            ArrayList<JSType> types2 = new ArrayList<JSType>();
            String text = rawQualifier.getText();
            TextRange[] ranges = ((JSStringTemplateExpression)rawQualifier).getStringRangesWithEmpty();
            for (int i = 0; i < ranges.length; ++i) {
                TextRange range = ranges[i];
                texts.add(range.substring(text));
                if (i == ranges.length - 1) continue;
                JSExpression expression = i < arguments.length ? arguments[i] : null;
                JSType expressionType = JSResolveUtil.getExpressionJSType(expression, false);
                types2.add((JSType)(expressionType != null && constraintType.isDirectlyAssignableType(expressionType, context) ? expressionType : new JSStringType(true, source, JSTypeContext.INSTANCE)));
            }
            this.doAddType(TypeScriptTemplateLiteralJSTypeImpl.createType(texts, types2, false, source), (PsiElement)rawQualifier);
            return;
        }
        super.addTypeFromLiteralExpression(rawQualifier);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 3: 
            case 8: 
            case 26: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawqualifier";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleCandidate";
                break;
            }
            case 17: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 27: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawQualifier";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextualOwner";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisQualifier";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptTypeEvaluator";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeForThisExpression";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeFromProcessor";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayTypeFromExpressions";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionTypeForArrayLiteral";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePlusType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evaluateAndOrOrType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAndOrOrOrQuestType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromLocalModule";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierExpression";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTypeForThisExpression";
                break;
            }
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromExternalModuleReferenceResolveResult";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExportAssignment";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClassWithQName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyAccessType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getArrayTypeFromExpressions";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getWidenedPropertyType";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromAmdModuleReference";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierInExecutionScope";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "computeThisType";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "computeThisTypeFromAssignment";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "computeThisTypeFromLiteral";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createTypeOfLiteralType";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypeFromInlineComment";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromLiteralExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

