/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSFileCachedDataEvaluator;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;

public class TypeScriptFileCachedDataEvaluator
extends JSFileCachedDataEvaluator {
    public TypeScriptFileCachedDataEvaluator(@NotNull JSFileCachedData outCachedData) {
        if (outCachedData == null) {
            TypeScriptFileCachedDataEvaluator.$$$reportNull$$$0(0);
        }
        super(outCachedData);
    }

    public void visitJSAssignmentExpression(JSAssignmentExpression node) {
    }

    public void visitTypeScriptExportAssignment(TypeScriptExportAssignment exportAssignment) {
        this.myCachedData.applyModuleStatus(JSFile.ModuleStatus.ES6);
    }

    @Override
    public void visitJSVariable(JSVariable node) {
        this.checkIfExportStatement((JSAttributeListOwner)node);
        this.setSkipChildren();
    }

    public void visitTypeScriptImportStatement(TypeScriptImportStatement importStatement) {
        TypeScriptExternalModuleReference externalModuleReference = importStatement.getExternalModuleReference();
        if (externalModuleReference != null) {
            ASTNode referenceNode = externalModuleReference.findReferenceNode();
            String qName = importStatement.getQualifiedName();
            if (referenceNode != null && qName != null) {
                this.myCachedData.addReferencedPath(StringUtil.unquoteString((String)referenceNode.getText()));
            }
            this.myCachedData.applyModuleStatus(JSFile.ModuleStatus.ES6);
        }
        this.checkIfExportStatement((JSAttributeListOwner)importStatement);
        this.setSkipChildren();
    }

    public void visitTypeScriptImplicitModule(TypeScriptImplicitModule module) {
        this.checkIfExportStatement((JSAttributeListOwner)module);
        this.visitElement((PsiElement)module);
    }

    public void visitComment(@NotNull PsiComment comment) {
        PsiElement prev;
        String text;
        Matcher matcher;
        if (comment == null) {
            TypeScriptFileCachedDataEvaluator.$$$reportNull$$$0(1);
        }
        if (comment.getTokenType() == JSTokenTypes.END_OF_LINE_COMMENT && comment.getParent() instanceof JSFile && (matcher = TypeScriptPsiUtil.TYPESCRIPT_REFERENCE_PATH.matcher(text = comment.getText())).matches() && ((prev = PsiTreeUtil.skipSiblingsBackward((PsiElement)comment, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) instanceof PsiComment || prev == null)) {
            boolean isLib = "lib".equals(matcher.group(1));
            String fileOrLib = TypeScriptPsiUtil.getPathText(matcher);
            this.myCachedData.addReferencedPath((String)(!isLib ? fileOrLib : "lib." + fileOrLib + ".d.ts"));
        }
        this.setSkipChildren();
    }

    private void checkIfExportStatement(@NotNull JSAttributeListOwner node) {
        JSAttributeList attributeList;
        if (node == null) {
            TypeScriptFileCachedDataEvaluator.$$$reportNull$$$0(2);
        }
        if ((attributeList = node.getAttributeList()) != null && attributeList.getNode().findChildByType(JSTokenTypes.EXPORT_KEYWORD) != null) {
            this.myCachedData.applyModuleStatus(JSFile.ModuleStatus.ES6);
        }
    }

    @Override
    public void visitJSFile(JSFile file2) {
        this.visitFile((PsiFile)file2);
    }

    @Override
    public void visitES6ExportDefaultAssignment(ES6ExportDefaultAssignment node) {
        this.myCachedData.applyModuleStatus(JSFile.ModuleStatus.ES6);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outCachedData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptFileCachedDataEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitComment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIfExportStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

