/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCompileTimeType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCommentImpl;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSDestructuringContext;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDocumentationUtils {
    private static final String NO_NAME_CHARS = ".~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}";
    private static final String IDENTIFIER_NAME = "[\\p{L}_$][\\p{LD}_$]*";
    public static final String NAME = "[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+";
    private static final String NAME_IN_TYPE = "[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}/]+";
    private static final String DOUBLE_QUOTED_NAME = "\"(?:[^\"\\\\]|\\\\.)+\"";
    private static final String SINGLE_QUOTED_NAME = "'(?:[^'\\\\]|\\\\.)+'";
    private static final String IMPORT_TYPE_NAME = "import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)";
    private static final String SPECIAL_NAME_PREFIX = "(?:module:|event:|external:)";
    private static final String NAME_OR_QUOTED = "(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')";
    private static final String NAMEPATH_START = "import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+";
    private static final String NAMEPATH_IN_TYPE_START = "(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}/]+";
    private static final String NAMEPATH_PART = "(?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')";
    public static final String NAMEPATH_SEPARATORS = ".#~";
    public static final String NAMEPATH = "(?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?";
    private static final String NAMEPATH_IN_TYPE = "(?:[.#~])?(?:(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}/]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?";
    private static final Pattern NAMEPATH_START_PATTERN = Pattern.compile("import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+");
    private static final Pattern NAMEPATH_PART_PATTERN = Pattern.compile("(?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')");
    public static final Pattern NAMEPATH_PATTERN = Pattern.compile("(?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?");
    public static final Pattern NAMEPATH_IN_TYPE_PATTERN = Pattern.compile("(?:[.#~])?(?:(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}/]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?");
    private static final String NAMEPATH_OPTIONAL = "(?:\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)\\s*|(\\s.*)?)";
    private static final String PARAM_FIELD = "((?:(?:\\[\\])*\\.[\\p{L}_$][\\p{LD}_$]*)+)?";
    private static final String MODULE_PATTERN = "^\\s*%s(?:\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?))?(.*)$";
    private static final Pattern ourDojoParametersPattern = Pattern.compile("^\\s*([\\p{L}_$][\\p{LD}_$]*):(.*)$", 64);
    private static final Pattern ourJSDocParametersPattern = Pattern.compile("^\\s*@param((:? |\\s*\\{).*)$");
    private static final Pattern ourJSDocParametersRestPattern = Pattern.compile("^\\s*(?:(\\[?\\(?\\{?`?([\\p{L}_$][\\p{LD}_$]*(?:\\|[\\p{L}_$][\\p{LD}_$]*)*)((?:(?:\\[\\])*\\.[\\p{L}_$][\\p{LD}_$]*)+)?(\\.\\.\\.)?`?(?:\\s*=\\s*((?:\\[[^\\]]*\\])|[^\\]\\s]*|(?:'[^']*')|(?:\"[^\"]*\")))?\\)?\\]?)(?:\\s:\\s(\\S+))?)?(?:\\s*-\\s*)?(.*)$");
    private static final Pattern ourYuiDocParametersPattern = Pattern.compile("^\\s*([\\p{L}_$][\\p{LD}_$]*)\\s*(\\{.*)$");
    private static final Pattern ourJSDocEventPattern = Pattern.compile("^\\s*@event\\s*((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)(?:\\s:\\s(\\S+))?(?:\\s*-\\s*)?(.*)$");
    private static final Pattern ourJSDocRemarkPattern = Pattern.compile("^\\s*@remarks (.*)$");
    private static final Pattern ourJSDocMethodPattern = Pattern.compile("^\\s*@method(?:\\s+([^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(.*))?$");
    private static final Pattern ourJSDocClassPattern = Pattern.compile("^\\s*@class(?:\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)\\s*|(\\s.*)?)$");
    private static final Pattern ourJSDocDeprecatedPattern = Pattern.compile("^\\s*@deprecated\\s*(.*)$");
    private static final Pattern ourJSDocConstructorPattern = Pattern.compile("^\\s*@constructor(?:\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)\\s*|(\\s.*)?)$");
    private static final Pattern ourJSDocConstructsPattern = Pattern.compile("^\\s*@construct(?:s?)\\s*$");
    private static final Pattern ourJSDocConstantPattern = Pattern.compile("^\\s*@const(?:ant)?(?:\\s+(.*))?$");
    private static final Pattern ourJSDocFinalPattern = Pattern.compile("^\\s*@final\\s*$");
    private static final Pattern ourJSDocPrivatePattern = Pattern.compile("^\\s*@private(?:\\s+(.+)|\\s*)$");
    private static final Pattern ourJSDocPublicPattern = Pattern.compile("^\\s*@public(?:\\s+(.+)|\\s*)$");
    private static final Pattern ourJSDocProtectedPattern = Pattern.compile("^\\s*@protected(?:\\s+(.+)|\\s*)$");
    private static final Pattern ourJSDocOptionalPattern = Pattern.compile("^\\s*@optional(.*)$");
    private static final Pattern ourJSDocStaticPattern = Pattern.compile("^\\s*@static\\s*$");
    private static final Pattern ourJSDocSeePattern = Pattern.compile("^\\s*@see (.*)$");
    private static final Pattern ourJSDocDescriptionPattern = Pattern.compile("^\\s*@description\\s*(.+)$");
    private static final Pattern ourJSDocReturnPattern = Pattern.compile("^\\s*@return(?:s)?\\s*(?::)?\\s*(.+)?$");
    private static final Pattern ourJSDocNamespacePattern = Pattern.compile("^\\s*@namespace\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)?(.*)$");
    private static final Pattern ourJSDocNamePattern = Pattern.compile("^\\s*@name\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)(.*)$");
    private static final Pattern ourJSDocAliasPattern = Pattern.compile("^\\s*@alias\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)(.*)$");
    private static final Pattern ourJSDocConfigPattern = Pattern.compile("^\\s*@config\\s*(\\{)?(.*)$");
    private static final Pattern ourJSDocPropertyPattern = Pattern.compile("^\\s*@prop(?:erty)?\\s*(\\{)?(.*)$");
    private static final Pattern ourJSDocPropertyRestPattern = Pattern.compile("^\\s*(\\[?)((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)(?:\\s*=\\s*([^\\]\\s]*|(?:'[^']*')|(?:\"[^\"]*\")))?\\]?(?:\\s*-\\s*)?(.*)$");
    private static final Pattern ourJSDocTypePattern = Pattern.compile("^\\s*@type([ {].*)$");
    private static final Pattern ourJSDocRequiresPattern = Pattern.compile("^\\s*@requires\\s*(\\S+)(.*)$");
    private static final Pattern ourJSDocDefaultPattern = Pattern.compile("^\\s*@default\\s*(.*)$");
    private static final Pattern ourJSDocExtendsPattern = Pattern.compile("^\\s*@extends(.*)$");
    private static final Pattern ourJSDocAugmentsPattern = Pattern.compile("^\\s*@augments(.*)$");
    private static final Pattern ourJSDocLendsPattern = Pattern.compile("^\\s*@lends(.*)$");
    private static final Pattern ourJSDocThrowsPattern = Pattern.compile("^\\s*@throws(?:\\s+(.*))$");
    private static final Pattern ourJSDocExceptionPattern = Pattern.compile("^\\s*@exception\\s*(?:\\s*-\\s*)?(.*)$");
    private static final Pattern ourJSDocLinkPattern = Pattern.compile("(\\[[^\\]]+\\])?\\{@link(?:code|plain)?\\s+([^\\}]+)\\}");
    private static final Pattern ourJSDocBrowserPattern = Pattern.compile("^\\s*@browser\\s+(.*)$");
    private static final Pattern ourJSDocInheritDocPattern = Pattern.compile("^\\s*@inherit[Dd]oc(.*)$");
    private static final Pattern ourJSDocTypedefPattern = Pattern.compile("^\\s*@typedef\\s+(.*)$");
    private static final Pattern ourJSDocNameTailPattern = Pattern.compile("^((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)?(.*)$");
    private static final Pattern ourJSDocEnumPattern = Pattern.compile("^\\s*@enum(.*)$");
    private static final Pattern ourJSDocInterfacePattern = Pattern.compile("^\\s*@interface(?:\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?))?(\\s*)$");
    private static final Pattern ourJSDocImplementsPattern = Pattern.compile("^\\s*@implements(.*)$");
    private static final Pattern ourJSDocOverridePattern = Pattern.compile("^\\s*@override(.*)$");
    private static final Pattern ourJSDocThisPattern = Pattern.compile("^\\s*@this(.*)$");
    private static final Pattern ourJSDocMixinPattern = Pattern.compile("^\\s*@mixin(?:|[^s](.*))$");
    private static final Pattern ourJSDocMixesPattern = Pattern.compile("^\\s*@mix(?:es|ins)(.*)$");
    private static final Pattern ourJSDocFunctionPattern = Pattern.compile("^\\s*@func(?:tion)?(?:\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?))?(\\s*)$");
    private static final Pattern ourJSDocExportsPattern = Pattern.compile("^\\s*@exports(?:\\s+(?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?\\s+as)?\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)(.*)$");
    private static final Pattern ourJSDocTemplatePattern = Pattern.compile("^\\s*@template\\s+(.*)$");
    private static final Pattern ourJSDocTemplateNamesPattern = Pattern.compile("^\\s*((?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|[\\s,])+)(.*)$");
    private static final Pattern ourJSDocAuthorPattern = Pattern.compile("^\\s*@author\\s+(.*)$");
    private static final Pattern ourJSDocSincePattern = Pattern.compile("^\\s*@since\\s+(.*)$");
    private static final Pattern ourJSDocVersionPattern = Pattern.compile("^\\s*@version\\s+(.*)$");
    private static final Pattern ourJSDocSummaryPattern = Pattern.compile("^\\s*@summary\\s+(.*)$");
    private static final Pattern ourJSDocExamplePattern = Pattern.compile("^\\s*@example(?:|(.*))$");
    private static final Pattern ourJSDocFileOverviewPattern = Pattern.compile("^\\s*@fileOverview\\s+(.*)$");
    private static final Pattern ourJSDocMemberOfPattern = Pattern.compile("^\\s*@member[Oo]f!?\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)(.*)$");
    private static final Pattern ourJSDocMethodOfPattern = Pattern.compile("^\\s*@methodOf\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)(.*)$");
    private static final Pattern ourJSDocFieldOfPattern = Pattern.compile("^\\s*@fieldOf\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)(.*)$");
    private static final Pattern ourJSDocAbstractPattern = Pattern.compile("^\\s*@abstract(\\s.*)?$");
    private static final Pattern ourJSDocVirtualPattern = Pattern.compile("^\\s*@virtual(\\s.*)?$");
    private static final Pattern ourJSDocCallbackPattern = Pattern.compile("^\\s*@callback\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)(.*)?$");
    private static final Pattern ourJSDocExternalPattern = Pattern.compile("^\\s*@external\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)(.*)?$");
    private static final Pattern ourJSDocHostPattern = Pattern.compile("^\\s*@host\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)(.*)?$");
    private static final Pattern ourJSDocGlobalPattern = Pattern.compile("^\\s*@global(\\s.*)?$");
    private static final Pattern ourJSDocMemberPattern = Pattern.compile("^\\s*@member\\s+(.*)$");
    private static final Pattern ourJSDocVarPattern = Pattern.compile("^\\s*@var\\s+(.*)$");
    private static final Pattern ourJSDocModulePattern = Pattern.compile(String.format("^\\s*%s(?:\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?))?(.*)$", "@module"));
    private static final Pattern ourProvideModulesPattern = Pattern.compile(String.format("^\\s*%s(?:\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?))?(.*)$", "@providesModule"));
    private static final Pattern ourJSDocFiresPattern = Pattern.compile("^\\s*@fires\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)(.*)$");
    private static final Pattern ourJSDocEmitsPattern = Pattern.compile("^\\s*@emits\\s+((?:[.#~])?(?:import\\s*\\((?:'(?:[^\"\\\\]|\\\\.)+'|\"(?:[^\"\\\\]|\\\\.)+\")\\)|(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)(.*)$");
    private static final Pattern ourJSDocTodoPattern = Pattern.compile("^\\s*@todo(?:\\s+(.*))?$");
    private static final Pattern ourJSDocInstancePattern = Pattern.compile("^\\s*@instance(?:\\s+(.*))?$");
    private static final Pattern ourJSDocExtendedTypeNamePattern = Pattern.compile("^[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+$");
    private static final Map<Pattern, String> patternToHintMap = new THashMap();
    private static final Map<Pattern, JSDocumentationProcessor.MetaDocType> patternToMetaDocTypeMap = new THashMap();
    private static final Map<Pattern, JSDocumentationProcessor.MetaDocType> inlinePatternToMetaDocTypeMap = new THashMap();
    static final String HYPERLINK_SEPARATOR = "%";
    static final String INDEX_POSITION_SEPARATOR = ":";
    @NonNls
    private static final Map<Pattern, String> prefixToPatternToHintMap;
    private static final TokenSet DOC_COMMENT_ALLOWED_AFTER;
    public static final TokenSet ourPrimitiveTypeFilter;

    public static void processDocumentationTextFromComment(ASTNode _initialComment, JSDocumentationProcessor processor) {
        Enumeration<Object> commentLineIterator;
        boolean eolComment;
        ASTNode prev = _initialComment.getTreePrev();
        if (prev != null && prev.getPsi() instanceof OuterLanguageElement) {
            while (prev != null && prev.getPsi() instanceof OuterLanguageElement) {
                prev = prev.getTreePrev();
            }
        } else {
            prev = null;
        }
        if (prev != null && !(prev.getPsi() instanceof PsiComment)) {
            prev = null;
        }
        final ASTNode initialComment = prev != null ? prev : _initialComment;
        boolean bl = eolComment = initialComment.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT;
        if (eolComment) {
            commentLineIterator = new Enumeration<Object>(){
                ASTNode commentNode;
                {
                    this.commentNode = initialComment;
                }

                @Override
                public boolean hasMoreElements() {
                    return this.commentNode != null;
                }

                @Override
                public String nextElement() {
                    String text;
                    ASTNode resultCommentNode = this.commentNode;
                    this.commentNode = this.commentNode.getTreeNext();
                    if (this.commentNode != null && this.commentNode.getElementType() == TokenType.WHITE_SPACE) {
                        this.commentNode = this.commentNode.getTreeNext();
                    }
                    if (this.commentNode != null && this.commentNode.getElementType() != JSTokenTypes.END_OF_LINE_COMMENT) {
                        this.commentNode = null;
                    }
                    if ((text = resultCommentNode.getText()).startsWith("//")) {
                        return text.substring(2);
                    }
                    return "";
                }
            };
        } else {
            String text = initialComment.getText();
            text = JSDocumentationUtils.unwrapCommentDelimiters(text);
            commentLineIterator = new StringTokenizer(text, "\r\n");
        }
        boolean needPlainCharData = processor.needsPlainCommentData();
        String lastParameterName = null;
        DocTagBuilder tag = null;
        StringBuilder multilineCommentTag = new StringBuilder();
        while (commentLineIterator.hasMoreElements()) {
            String commentText;
            String s = (String)commentLineIterator.nextElement();
            if (s.indexOf(64) == -1 && s.indexOf(58) == -1 && !needPlainCharData && (tag == null || !tag.continueType)) continue;
            if (needPlainCharData && s.contains("{@link")) {
                Matcher m = ourJSDocLinkPattern.matcher(s);
                StringBuilder b = new StringBuilder();
                int lastEnd = 0;
                while (m.find()) {
                    String text;
                    StringBuilder b2 = new StringBuilder();
                    String linkText = m.group(1);
                    String linkUrl = m.group(2).trim();
                    if (linkText != null && linkText.length() > 2) {
                        text = linkText.substring(1, linkText.length() - 1).trim();
                    } else {
                        int separatorIndex = StringUtil.indexOfAny((String)linkUrl, (String)" |");
                        if (separatorIndex >= 0) {
                            text = linkUrl.substring(separatorIndex + 1).trim();
                            linkUrl = linkUrl.substring(0, separatorIndex);
                        } else {
                            text = null;
                        }
                    }
                    if (BrowserUtil.isAbsoluteURL((String)linkUrl)) {
                        b2.append("<a href=\"").append(linkUrl).append("\">").append(text != null ? text : linkUrl).append("</a>");
                    } else {
                        JSDocumentationUtils.appendHyperLinkToElement(null, linkUrl, b2, StringUtil.isEmpty((String)text) ? linkUrl : text, true, true, 0);
                    }
                    b.append(s, lastEnd, m.start());
                    lastEnd = m.end();
                    b.append((CharSequence)b2);
                }
                b.append(s.substring(lastEnd));
                s = b.toString();
            }
            if ((tag = JSDocumentationUtils.handlePossiblyMultilinedTag(tag, multilineCommentTag, commentText = JSDocumentationUtils.prepareCommentLine(s), lastParameterName, processor, eolComment)) != null) {
                if (tag.breakEnd) break;
                lastParameterName = tag.lastParameterName;
                continue;
            }
            if (!needPlainCharData || processor.onCommentLine(commentText)) continue;
            break;
        }
        processor.postProcess();
    }

    @Nullable
    private static DocTagBuilder handlePossiblyMultilinedTag(@Nullable DocTagBuilder previousTag, @NotNull StringBuilder multilineCommentTag, @NotNull String commentLine, @Nullable String lastParameterName, @Nullable JSDocumentationProcessor processor, boolean eolComment) {
        if (multilineCommentTag == null) {
            JSDocumentationUtils.$$$reportNull$$$0(0);
        }
        if (commentLine == null) {
            JSDocumentationUtils.$$$reportNull$$$0(1);
        }
        if (previousTag != null && previousTag.continueType && !commentLine.contains("@")) {
            multilineCommentTag.append(commentLine);
            return JSDocumentationUtils.handleCommentLine(multilineCommentTag.toString(), lastParameterName, processor, patternToMetaDocTypeMap);
        }
        multilineCommentTag.setLength(0);
        DocTagBuilder tag = JSDocumentationUtils.handleCommentLine(commentLine, lastParameterName, processor, eolComment ? inlinePatternToMetaDocTypeMap : patternToMetaDocTypeMap);
        if (tag != null && tag.continueType) {
            multilineCommentTag.append(commentLine);
        }
        return tag;
    }

    @NotNull
    private static String prepareCommentLine(String s) {
        String commentText = s.replace('\t', ' ');
        for (Map.Entry<Pattern, String> entry : prefixToPatternToHintMap.entrySet()) {
            Matcher matcher = commentText.contains(entry.getValue()) ? entry.getKey().matcher(commentText) : null;
            if (matcher == null || !matcher.matches()) continue;
            commentText = matcher.group(1);
            break;
        }
        String string = commentText;
        if (string == null) {
            JSDocumentationUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static String trimBrackets(String type) {
        boolean outerBrackets = true;
        int length = type.length();
        int begin = 0;
        int end = length - 1;
        while (begin <= end) {
            if (Character.isSpaceChar(type.charAt(begin))) {
                ++begin;
                continue;
            }
            if (Character.isSpaceChar(type.charAt(end))) {
                --end;
                continue;
            }
            if (!outerBrackets || type.charAt(begin) != '{' || type.charAt(end) != '}') break;
            outerBrackets = false;
            ++begin;
            --end;
        }
        if (begin < length && type.charAt(begin) == '{') {
            int nextNonWs;
            for (nextNonWs = begin + 1; nextNonWs < length && Character.isSpaceChar(type.charAt(nextNonWs)); ++nextNonWs) {
            }
            int matchedClosingBracketPos = type.lastIndexOf(125, end - 1);
            if (nextNonWs < length && type.charAt(nextNonWs) == '{' && matchedClosingBracketPos > 0) {
                begin = nextNonWs;
                end = matchedClosingBracketPos;
            }
        }
        return type.substring(begin, end + 1);
    }

    private static int getTypeStringLength(@NotNull String tailText) {
        int i;
        if (tailText == null) {
            JSDocumentationUtils.$$$reportNull$$$0(3);
        }
        boolean startsWithBrace = false;
        for (i = 0; i < tailText.length() && tailText.charAt(i) == ' '; ++i) {
        }
        if (i < tailText.length() && tailText.charAt(i) == '{') {
            ++i;
            startsWithBrace = true;
        }
        if (startsWithBrace && tailText.indexOf(123, i) == -1 && tailText.indexOf(125, i) >= 0) {
            return tailText.indexOf(125, i) + 1;
        }
        JSTypeParser parser2 = new JSTypeParser(tailText.substring(i), JSTypeSource.EMPTY);
        JSParameterTypeDecorator type = parser2.parseParameterType(true);
        if (type != null) {
            if (startsWithBrace) {
                i += parser2.getTypeStringLength();
                while (i < tailText.length() && tailText.charAt(i) == ' ') {
                    ++i;
                }
                return i < tailText.length() && tailText.charAt(i) == '}' ? i + 1 : tailText.length() + 1;
            }
            return i + parser2.getTypeStringLength();
        }
        return startsWithBrace ? tailText.length() + 1 : 0;
    }

    private static String createParameterOrParameterFieldReference(String matchName, String fieldName) {
        if (fieldName == null) {
            return matchName;
        }
        if (!StringUtil.startsWithChar((CharSequence)fieldName, (char)'.') && !StringUtil.startsWithChar((CharSequence)fieldName, (char)'[')) {
            fieldName = "." + (String)fieldName;
        }
        return matchName + (String)fieldName;
    }

    public static String unwrapCommentDelimiters(String text) {
        String marker;
        block7: {
            block8: {
                block6: {
                    marker = "/**";
                    if (!text.startsWith("/**")) break block6;
                    text = text.substring(marker.length());
                    break block7;
                }
                marker = "/*";
                if (text.startsWith("/*")) break block8;
                marker = "//";
                if (!text.startsWith("//")) break block7;
            }
            text = text.substring(marker.length());
        }
        marker = "*/";
        if (text.endsWith("*/")) {
            text = text.substring(0, text.length() - marker.length());
        }
        marker = "-->";
        if (text.endsWith("-->")) {
            text = text.substring(0, text.length() - marker.length());
        }
        marker = "<!---";
        if (text.startsWith("<!---")) {
            text = text.substring(marker.length());
        }
        return text;
    }

    @Nullable
    private static ASTNode findTrailingCommentInFunctionBody(@NotNull JSFunction function2) {
        ASTNode block;
        if (function2 == null) {
            JSDocumentationUtils.$$$reportNull$$$0(4);
        }
        if ((block = function2.getNode().findChildByType((IElementType)JSElementTypes.BLOCK_STATEMENT)) == null) {
            return null;
        }
        for (ASTNode prev = block.getLastChildNode(); prev != null; prev = prev.getTreePrev()) {
            if (prev.getElementType() == JSStubElementTypes.RETURN_STATEMENT) {
                PsiElement prevLeaf;
                ASTNode comment = block.findChildByType(JSTokenTypes.COMMENTS, prev);
                if (comment != null && (prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)comment.getPsi())) instanceof PsiWhiteSpace && prevLeaf.textContains('\n')) {
                    comment = null;
                }
                return comment;
            }
            if (JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(prev.getElementType())) break;
        }
        return null;
    }

    @Nullable
    static ASTNode findLeadingCommentInFunctionBody(@NotNull PsiElement element) {
        ASTNode node;
        ASTNode functionNode;
        ASTNode block;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(5);
        }
        ASTNode aSTNode = block = (functionNode = element.getNode()) != null ? functionNode.findChildByType((IElementType)JSElementTypes.BLOCK_STATEMENT) : null;
        if (block == null) {
            return null;
        }
        ASTNode firstChildNode = block.getFirstChildNode();
        ASTNode aSTNode2 = node = firstChildNode != null ? firstChildNode.getTreeNext() : null;
        while (node != null) {
            IElementType nodeType = node.getElementType();
            if (nodeType != TokenType.WHITE_SPACE) {
                if (JSTokenTypes.COMMENTS.contains(nodeType)) {
                    return node;
                }
                return null;
            }
            node = node.getTreeNext();
        }
        return null;
    }

    @Nullable
    public static JSType findTypeFromInlineComment(@NotNull PsiElement element) {
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(6);
        }
        PsiElement prevSibling = element.getPrevSibling();
        while (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        if (prevSibling instanceof JSDocComment) {
            String type = ((JSDocComment)prevSibling).getType();
            return JSTypeUtils.createTypeFromJSDoc(type, JSTypeSourceFactory.createTypeSource(prevSibling, true));
        }
        return null;
    }

    @Nullable
    public static JSDocComment findOwnDocComment(@NotNull PsiElement element) {
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(7);
        }
        if (element instanceof JSExpression) {
            PsiElement anchor = element instanceof JSDefinitionExpression ? element.getParent() : element;
            PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchor);
            if (prevSibling instanceof JSDocComment) {
                return (JSDocComment)prevSibling;
            }
        } else if (element instanceof JSVariable || element instanceof JSFunction || element instanceof JSClass || element instanceof JSNamespaceDeclaration || element instanceof JSExportAssignment || element instanceof JSProperty) {
            PsiElement parent;
            JSDocComment comment = JSDocumentationUtils.getStartingChildDocComment(element);
            if (comment != null) {
                return comment;
            }
            if (element instanceof JSVariable && (parent = element.getParent()) instanceof JSVarStatement && (comment = JSDocumentationUtils.getStartingChildDocComment(parent)) != null && JSDocumentationUtils.hasSingleVariable((JSVarStatement)parent)) {
                return comment;
            }
        }
        return null;
    }

    private static boolean hasSingleVariable(@NotNull JSVarStatement statement) {
        JSInitializerOwner[] declarations;
        if (statement == null) {
            JSDocumentationUtils.$$$reportNull$$$0(8);
        }
        return (declarations = statement.getDeclarations()).length == 1 && declarations[0] instanceof JSVariable;
    }

    @Nullable
    public static PsiComment findScopeComment(@NotNull JSElement element) {
        PsiElement scope;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(9);
        }
        if ((scope = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSFunction.class, JSClass.class})) != null) {
            JSClass clazz;
            PsiComment scopeComment = JSDocumentationUtils.findDocComment(scope);
            if (scopeComment != null) {
                return scopeComment;
            }
            if (scope instanceof JSFunction && (clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)scope, JSClass.class)) != null) {
                return JSDocumentationUtils.findDocComment((PsiElement)clazz);
            }
        }
        return null;
    }

    public static PsiComment findDocComment(@NotNull PsiElement element) {
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(10);
        }
        return JSDocumentationUtils.findDocComment(element, null, null);
    }

    @NotNull
    private static PsiElement findAttributeListAnchor(@NotNull PsiElement element, @Nullable PsiElement context) {
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(11);
        }
        if (!(element instanceof JSAttributeListOwner) || context != null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                JSDocumentationUtils.$$$reportNull$$$0(12);
            }
            return psiElement;
        }
        JSAttributeListOwner jsClass = (JSAttributeListOwner)element;
        JSAttributeList attributeList = jsClass.getAttributeList();
        PsiElement anchor = null;
        if (attributeList == null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                JSDocumentationUtils.$$$reportNull$$$0(13);
            }
            return psiElement;
        }
        for (ASTNode currentNode = attributeList.getNode().getLastChildNode(); currentNode != null; currentNode = currentNode.getTreePrev()) {
            IElementType nodeType = currentNode.getElementType();
            if (JSTokenTypes.MODIFIERS.contains(nodeType) || nodeType == JSStubElementTypes.ES6_DECORATOR || nodeType == JSTokenTypes.WHITE_SPACE || nodeType == JSElementTypes.REFERENCE_EXPRESSION || nodeType == JSStubElementTypes.ATTRIBUTE) continue;
            ASTNode nextNode = currentNode.getTreeNext();
            if (nextNode == null) break;
            anchor = nextNode.getPsi();
            break;
        }
        if (anchor != null) {
            PsiElement psiElement = anchor;
            if (psiElement == null) {
                JSDocumentationUtils.$$$reportNull$$$0(14);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JSDocumentationUtils.$$$reportNull$$$0(15);
        }
        return psiElement;
    }

    static PsiComment findDocComment(@NotNull PsiElement element, @Nullable PsiElement context, @Nullable Ref<? super PsiElement> elementToAttach) {
        JSDocComment _docComment;
        PsiElement parentToSearchDocComment;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(16);
        }
        ProgressManager.checkCanceled();
        if (element instanceof JSDocComment) {
            return (JSDocComment)element;
        }
        if (element instanceof TypeScriptProxyImplicitElement && (element = ((TypeScriptProxyImplicitElement)element).getExplicitElement()) == null) {
            return null;
        }
        if ((element = JSDocumentationUtils.findAttributeListAnchor(element, context)) instanceof PsiFileSystemItem) {
            return null;
        }
        if (element instanceof ImplicitJSVariableImpl) {
            return null;
        }
        PsiComment docComment = null;
        if (element instanceof JSParameter) {
            JSFunction function2;
            PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
            if (prevSibling instanceof PsiComment) {
                docComment = (PsiComment)prevSibling;
            }
            if ((function2 = ((JSParameter)element).getDeclaringFunction()) != null) {
                element = function2;
            }
        }
        if (element instanceof JSFunctionExpression || element instanceof JSDefinitionExpression) {
            element = JSDocumentationUtils.getElementOverAssignmentParent(element);
        }
        if (element instanceof JSFieldVariable) {
            JSDocComment _docComment2 = JSDocumentationUtils.getStartingChildDocComment(element);
            if (_docComment2 != null) {
                docComment = _docComment2;
            } else {
                PsiElement parent = element.getParent();
                if (!(parent instanceof TypeScriptObjectType)) {
                    element = parent;
                }
            }
        }
        if ((parentToSearchDocComment = JSDocumentationUtils.getParentToSearchDocComment(element)) != null && (_docComment = JSDocumentationUtils.getStartingChildDocComment(parentToSearchDocComment)) != null) {
            docComment = _docComment;
        }
        if (docComment == null) {
            docComment = JSDocumentationUtils.searchPreviousNonDocComment(element);
        }
        if (docComment != null) {
            docComment = JSDocumentationUtils.skipOuterElements(docComment);
        }
        if (docComment != null && JSDocumentationUtils.isSelfSufficientComment(docComment)) {
            return null;
        }
        if (elementToAttach != null) {
            elementToAttach.set((Object)JSDocumentationUtils.getAssociatedElement(element, parentToSearchDocComment));
        }
        return docComment;
    }

    private static boolean isSelfSufficientComment(@NotNull PsiComment comment) {
        if (comment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(17);
        }
        if (!(comment instanceof JSDocComment)) {
            return false;
        }
        List typedefs = ((JSDocComment)comment).getTypedefs();
        return !typedefs.isEmpty() && typedefs.stream().noneMatch(pair -> StringUtil.isEmpty((String)((String)pair.first)));
    }

    @Nullable
    private static PsiComment searchPreviousNonDocComment(@Nullable PsiElement element) {
        boolean searchInPrevExprStatementWithSameName = false;
        String propName = JSDocumentationUtils.getPropertyNameFromExprStatement(element);
        if (propName != null) {
            searchInPrevExprStatementWithSameName = true;
        }
        PsiElement parent = element;
        PsiElement elementToProcess = element;
        PsiComment docComment = null;
        while (docComment == null) {
            String propNameFromPrev;
            if (elementToProcess instanceof JSExpressionStatement && searchInPrevExprStatementWithSameName && propName.equals(propNameFromPrev = JSDocumentationUtils.getPropertyNameFromExprStatement(elementToProcess))) {
                JSDocComment ownComment = JSDocumentationUtils.getStartingChildDocComment(elementToProcess);
                Object object = elementToProcess = ownComment != null ? ownComment : elementToProcess.getPrevSibling();
            }
            if (elementToProcess instanceof PsiComment) {
                docComment = (PsiComment)elementToProcess;
            } else if (elementToProcess instanceof PsiWhiteSpace || elementToProcess == parent) {
                elementToProcess = elementToProcess.getPrevSibling();
                continue;
            }
            if (!(parent instanceof JSExpression)) break;
            elementToProcess = parent = parent.getParent();
            if (!(parent instanceof PsiFile)) continue;
        }
        if (docComment != null) {
            PsiElement docCommentNextSibling;
            PsiElement docCommentPrevSibling = docComment.getPrevSibling();
            if (docCommentPrevSibling != null && !JSUtils.isLineBreakWhiteSpace(docCommentPrevSibling) && docCommentPrevSibling.getPrevSibling() instanceof JSSourceElement) {
                docComment = null;
            }
            if (docComment != null && !(docComment instanceof JSDocComment) && (docCommentNextSibling = docComment.getNextSibling()) instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)docCommentNextSibling.getText()) > 1) {
                docComment = null;
            }
        }
        return docComment;
    }

    @NotNull
    private static PsiComment skipOuterElements(@NotNull PsiComment docComment) {
        PsiElement siblingSibling;
        if (docComment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(18);
        }
        while (docComment.getPrevSibling() instanceof OuterLanguageElement && (siblingSibling = docComment.getPrevSibling().getPrevSibling()) instanceof PsiComment) {
            docComment = (PsiComment)siblingSibling;
        }
        PsiComment psiComment = docComment;
        if (psiComment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(19);
        }
        return psiComment;
    }

    @Nullable
    private static PsiElement getParentToSearchDocComment(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(20);
        }
        if ((parent = element.getParent()) instanceof JSExportAssignment) {
            return parent;
        }
        if (element instanceof JSFunction || element instanceof JSClass || element instanceof JSExpressionStatement || element instanceof JSNamespaceDeclaration || element instanceof TypeScriptTypeMember || element instanceof JSVarStatement || element instanceof JSExportAssignment) {
            return element;
        }
        if (element instanceof JSProperty) {
            JSProperty property = (JSProperty)element;
            return property.isGetProperty() || property.isSetProperty() ? property.getValue() : element;
        }
        return null;
    }

    @NotNull
    private static PsiElement getElementOverAssignmentParent(@NotNull PsiElement element) {
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(21);
        }
        PsiElement parent = element.getParent();
        while (parent instanceof JSAssignmentExpression) {
            element = parent;
            parent = parent.getParent();
        }
        if (parent instanceof JSProperty || parent instanceof JSVariable || parent instanceof JSExportAssignment) {
            element = parent;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JSDocumentationUtils.$$$reportNull$$$0(22);
        }
        return psiElement;
    }

    @Nullable
    private static PsiElement getAssociatedElement(@NotNull PsiElement element, @Nullable PsiElement parentToSearchDocComment) {
        PsiElement associatedElement;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(23);
        }
        PsiElement psiElement = associatedElement = parentToSearchDocComment != null ? parentToSearchDocComment : element;
        if (associatedElement instanceof JSFunction || associatedElement instanceof JSVarStatement || associatedElement instanceof JSProperty || associatedElement instanceof JSClass) {
            associatedElement = associatedElement.getFirstChild();
            while (associatedElement instanceof OuterLanguageElement) {
                associatedElement = associatedElement.getNextSibling();
            }
        }
        return associatedElement;
    }

    @Nullable
    private static JSDocComment getStartingChildDocComment(@NotNull PsiElement element) {
        ASTNode node;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(24);
        }
        if ((node = element.getNode()) == null) {
            return null;
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (type == JSStubElementTypes.DOC_COMMENT) {
                return (JSDocComment)child.getPsi();
            }
            if (!DOC_COMMENT_ALLOWED_AFTER.contains(type)) break;
        }
        return null;
    }

    public static void createOrUpdateTagsInDocComment(@NotNull PsiElement element, @Nullable List<String> tagsToCreate, @Nullable Map<Integer, String> tagsToUpdate, @Nullable Set<Integer> tagsToDelete) {
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(25);
        }
        ArrayList<Pair> indexedTagsToCreate = null;
        if (tagsToCreate != null) {
            indexedTagsToCreate = new ArrayList<Pair>(tagsToCreate.size());
            for (String s : tagsToCreate) {
                indexedTagsToCreate.add(Pair.create((Object)Integer.MAX_VALUE, (Object)s));
            }
        }
        JSDocumentationUtils.createOrUpdateTagsWithInsertionIndexes(element, indexedTagsToCreate, tagsToUpdate, tagsToDelete);
    }

    public static void createOrUpdateTagsWithInsertionIndexes(@NotNull PsiElement element, @Nullable List<Pair<Integer, String>> tagsToCreate, @Nullable Map<Integer, String> tagsToUpdate, @Nullable Set<Integer> tagsToDelete) {
        Ref elementToAttachRef;
        PsiComment docComment;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(26);
        }
        if (tagsToCreate != null) {
            tagsToCreate.sort(Comparator.comparing(o -> (Integer)o.first));
        }
        if (!((docComment = JSDocumentationUtils.findDocComment(element, null, (Ref<? super PsiElement>)(elementToAttachRef = Ref.create(null)))) instanceof JSDocComment)) {
            PsiElement elementToAttach = (PsiElement)elementToAttachRef.get();
            if (elementToAttach == null) {
                return;
            }
            StringBuilder comment = new StringBuilder("/**\n");
            if (tagsToCreate != null) {
                for (Pair<Integer, String> tag : tagsToCreate) {
                    comment.append(" * @").append((String)tag.second).append("\n");
                }
            }
            comment.append(" */");
            JSDocComment newDocComment = JSPsiElementFactory.createJSDocComment(comment.toString(), elementToAttach);
            elementToAttach.getParent().addBefore((PsiElement)newDocComment, elementToAttach);
            JSChangeUtil.addWs(elementToAttach.getParent().getNode(), elementToAttach.getNode(), "\n");
        } else {
            String newComment;
            JSDocComment jsDocComment = (JSDocComment)docComment;
            String oldText = docComment.getText();
            StringBuilder comment = new StringBuilder(oldText);
            int modifiedCommentLengthDelta = 0;
            JSDocTag[] tags = jsDocComment.getTags();
            ListIterator<Pair<Integer, String>> tagsToCreateIterator = tagsToCreate != null ? tagsToCreate.listIterator() : null;
            for (int i = 0; i < tags.length; ++i) {
                int tagEnd;
                String newTagValue;
                JSDocTag tag = tags[i];
                while (tagsToCreateIterator != null && tagsToCreateIterator.hasNext()) {
                    Pair<Integer, String> next = tagsToCreateIterator.next();
                    if ((Integer)next.first == i) {
                        char c;
                        int offsetInParent = modifiedCommentLengthDelta + tag.getStartOffsetInParent();
                        StringBuilder spacesPrefix = new StringBuilder();
                        for (int j = tag.getStartOffsetInParent() - 1; j >= 0 && ((c = oldText.charAt(j)) == ' ' || c == '\t' || c == '*' && j > 0 && oldText.charAt(j - 1) != '*'); --j) {
                            spacesPrefix.insert(0, c);
                        }
                        String tagToInsert = "@" + (String)next.second + "\n" + spacesPrefix;
                        comment.insert(offsetInParent, tagToInsert);
                        modifiedCommentLengthDelta += tagToInsert.length();
                        continue;
                    }
                    tagsToCreateIterator.previous();
                    break;
                }
                String string = newTagValue = tagsToUpdate != null ? tagsToUpdate.get(i) : null;
                if (newTagValue != null) {
                    JSDocTagValue oldTagValue = tag.getValue();
                    int offsetInParent = modifiedCommentLengthDelta + (oldTagValue != null ? oldTagValue.getStartOffsetInParent() + tag.getStartOffsetInParent() : tag.getStartOffsetInParent() + tag.getTextLength());
                    int oldLength = oldTagValue != null ? oldTagValue.getTextLength() : 0;
                    comment.replace(offsetInParent, offsetInParent + oldLength, newTagValue);
                    modifiedCommentLengthDelta += newTagValue.length() - oldLength;
                    continue;
                }
                if (tagsToDelete == null || !tagsToDelete.contains(i)) continue;
                int tagStart = oldText.lastIndexOf(10, tag.getStartOffsetInParent());
                if (tagStart == -1) {
                    tagStart = tag.getStartOffsetInParent();
                }
                if ((tagEnd = oldText.indexOf(10, tag.getStartOffsetInParent())) == -1) {
                    tagEnd = tag.getStartOffsetInParent() + tag.getTextLength();
                }
                comment.delete(tagStart + modifiedCommentLengthDelta, tagEnd + modifiedCommentLengthDelta);
                modifiedCommentLengthDelta -= tagEnd - tagStart;
            }
            if (tagsToCreateIterator != null && tagsToCreateIterator.hasNext()) {
                int newTagOffset;
                newComment = comment.toString();
                int lastIndexOfNewline = newComment.lastIndexOf(10);
                if (lastIndexOfNewline != -1) {
                    newTagOffset = lastIndexOfNewline + 1;
                } else {
                    comment.insert(comment.length() - 2, '\n');
                    newTagOffset = comment.length() - 2;
                }
                while (tagsToCreateIterator.hasNext()) {
                    String tag = (String)tagsToCreateIterator.next().second;
                    comment.insert(newTagOffset, "\n").insert(newTagOffset, tag).insert(newTagOffset, " * @");
                    newTagOffset += tag.length() + 1 + 4;
                }
            }
            if ((newComment = comment.toString()).replaceAll("[\\s*/]", "").isEmpty()) {
                jsDocComment.delete();
            } else {
                jsDocComment.replace((PsiElement)JSPsiElementFactory.createJSDocComment(newComment, (PsiElement)docComment));
            }
        }
    }

    @Nullable
    private static String getPropertyNameFromExprStatement(@NotNull PsiElement element) {
        JSExpression rOperand;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(27);
        }
        String propName = null;
        if (element instanceof JSExpressionStatement) {
            element = ((JSExpressionStatement)element).getExpression();
        }
        if (element instanceof JSAssignmentExpression && (rOperand = ((JSAssignmentExpression)element).getROperand()) instanceof JSFunctionExpression) {
            String name = rOperand.getName();
            propName = JSDocumentationUtils.getPropertyName(name);
        }
        return propName;
    }

    @Nullable
    public static String getPropertyName(String name) {
        if (name != null && name.length() > 3 && (StringUtil.startsWith((CharSequence)name, (CharSequence)"get") || StringUtil.startsWith((CharSequence)name, (CharSequence)"set"))) {
            return name.substring(3);
        }
        return null;
    }

    @Nullable
    private static JSType getTypeFromPreceedingComment(JSVariable variable) {
        if (variable instanceof JSParameter) {
            JSParameterTypeDecorator paramType = JSDocumentationUtils.getParameterTypeFromPrecedingComment((JSParameter)variable);
            return paramType != null ? paramType.getSimpleType() : null;
        }
        PsiElement prevSibling = JSDocumentationUtils.getReasonablePrevElement(variable);
        if (prevSibling instanceof PsiComment) {
            return JSDocumentationUtils.tryCreateTypeFromComment((PsiComment)prevSibling, false, false, false);
        }
        return null;
    }

    public static JSParameterTypeDecorator getParameterTypeFromPrecedingComment(@NotNull JSParameter parameter) {
        PsiElement prevSibling;
        if (parameter == null) {
            JSDocumentationUtils.$$$reportNull$$$0(28);
        }
        if ((prevSibling = JSDocumentationUtils.getReasonablePrevElement((JSVariable)parameter)) == null) {
            prevSibling = JSDocCommentImpl.findPossiblyRelatedCommentForArrowFunctionParam(parameter);
        }
        if (prevSibling instanceof PsiComment && prevSibling.getNode().getElementType() != JSTokenTypes.END_OF_LINE_COMMENT && JSDocumentationUtils.isTypeStringAcceptable(JSDocumentationUtils.unwrapCommentDelimiters(prevSibling.getText()), true)) {
            return JSTypeUtils.createParameterType(JSDocumentationUtils.unwrapCommentDelimiters(prevSibling.getText()), JSTypeSourceFactory.createTypeSource(prevSibling, true), true, true);
        }
        return null;
    }

    private static PsiElement getReasonablePrevElement(@NotNull JSVariable variable) {
        PsiElement prevSibling;
        if (variable == null) {
            JSDocumentationUtils.$$$reportNull$$$0(29);
        }
        if ((prevSibling = variable.getFirstChild()) != null && JSVariableBaseImpl.IDENTIFIER_TOKENS_SET.contains(prevSibling.getNode().getElementType())) {
            prevSibling = variable.getPrevSibling();
        }
        if (prevSibling instanceof PsiWhiteSpace) {
            prevSibling = prevSibling.getPrevSibling();
        }
        return prevSibling;
    }

    @Nullable
    private static JSType rawGetTypeForVariable(JSVariable variable) {
        String typeString;
        JSType typeFromPreceedingComment = JSDocumentationUtils.getTypeFromPreceedingComment(variable);
        if (typeFromPreceedingComment != null) {
            return typeFromPreceedingComment;
        }
        PsiComment docComment = JSDocumentationUtils.findDocComment((PsiElement)variable);
        if (docComment instanceof JSDocComment && (typeString = JSDocumentationUtils.getTypeFromComment((JSDocComment)docComment)) != null) {
            return JSTypeUtils.createTypeFromJSDoc(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)docComment, true));
        }
        return null;
    }

    @Nullable
    public static PsiComment findDocCommentWider(@Nullable PsiElement _anchor) {
        PsiElement anchor = _anchor;
        PsiComment docComment = null;
        if (_anchor instanceof JSExpression && (docComment = JSDocumentationUtils.findDocComment(_anchor)) == null) {
            anchor = PsiTreeUtil.getParentOfType((PsiElement)_anchor, (Class[])new Class[]{JSStatement.class, JSProperty.class});
        }
        if (anchor != null && docComment == null) {
            docComment = JSDocumentationUtils.findDocComment(anchor);
        }
        return docComment;
    }

    @Nullable
    public static String findType(@Nullable PsiElement def) {
        PsiComment docComment = JSDocumentationUtils.findDocCommentWider(def);
        if (docComment instanceof JSDocComment) {
            return ((JSDocComment)docComment).getType();
        }
        return null;
    }

    @Nullable
    private static String getTypeFromComment(@NotNull JSDocComment comment) {
        if (comment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(30);
        }
        return comment.getType();
    }

    @Nullable
    public static JSType findContextType(@Nullable PsiElement anchor) {
        JSType thisType;
        JSType type;
        String fromType;
        if (anchor == null) {
            return null;
        }
        PsiComment element = JSDocumentationUtils.findDocCommentWider(anchor);
        if (element instanceof JSDocComment) {
            JSQualifiedName contextType;
            String fromTag = ((JSDocComment)element).getThisType();
            if (fromTag != null) {
                return JSTypeUtils.createTypeFromJSDoc(fromTag, JSTypeSourceFactory.createTypeSource((PsiElement)element, true));
            }
            JSDocComment docComment = (JSDocComment)element;
            JSQualifiedName namespace = docComment.getNamespace();
            String name = docComment.getExplicitName();
            JSQualifiedName jSQualifiedName = docComment.getJSContext() == JSContext.INSTANCE ? namespace : (contextType = name != null ? JSQualifiedNameImpl.create(name, namespace) : null);
            if (contextType != null) {
                return JSNamedType.createType(contextType.getQualifiedName(), JSTypeSourceFactory.createTypeSource((PsiElement)element), JSContext.INSTANCE);
            }
        }
        if ((fromType = JSDocumentationUtils.findType(anchor)) != null && (type = JSTypeUtils.createTypeFromJSDoc(fromType, JSTypeSource.EMPTY)) instanceof JSFunctionTypeImpl && (thisType = ((JSFunctionTypeImpl)type).getThisType()) != null) {
            return thisType;
        }
        return null;
    }

    public static String findEnumType(PsiElement anchor) {
        PsiComment docComment = JSDocumentationUtils.findDocCommentWider(anchor);
        return docComment instanceof JSDocComment ? ((JSDocComment)docComment).getEnumType() : null;
    }

    @Contract(value="null, _ -> false")
    public static boolean hasJSDocTag(@Nullable PsiElement anchor, JSDocumentationProcessor.MetaDocType ... docTypesArray) {
        PsiComment docComment = JSDocumentationUtils.findDocCommentWider(anchor);
        if (docTypesArray.length == 0) {
            return false;
        }
        final EnumSet<JSDocumentationProcessor.MetaDocType[]> docTypes = EnumSet.of(docTypesArray[0], docTypesArray);
        if (docComment != null) {
            final Ref hasNeededTag = Ref.create((Object)Boolean.FALSE);
            JSDocumentationUtils.processDocumentationTextFromComment(docComment.getNode(), new JSDocumentationProcessor(){

                @Override
                public boolean needsPlainCommentData() {
                    return false;
                }

                @Override
                public boolean onCommentLine(@NotNull String line) {
                    if (line == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return true;
                }

                @Override
                public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType type, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
                    if (type == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (line == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (patternMatched == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    if (docTypes.contains((Object)type)) {
                        hasNeededTag.set((Object)Boolean.TRUE);
                        return false;
                    }
                    return true;
                }

                @Override
                public void postProcess() {
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "line";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "type";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "patternMatched";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationUtils$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onCommentLine";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onPatternMatch";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            return (Boolean)hasNeededTag.get();
        }
        return false;
    }

    public static boolean isDeprecated(PsiElement element) {
        return element instanceof JSElementBase && ((JSElementBase)element).isDeprecated();
    }

    public static boolean calculateDeprecated(PsiElement element) {
        return (Boolean)JSDocumentationUtils.calculateConstAndDeprecated((PsiElement)element).second;
    }

    public static boolean calculateConst(PsiElement element) {
        return (Boolean)JSDocumentationUtils.calculateConstAndDeprecated((PsiElement)element).first;
    }

    @NotNull
    private static Couple<Boolean> calculateConstAndDeprecated(PsiElement element) {
        PsiComment docComment;
        if (element instanceof JSParameter) {
            Couple couple = Couple.of((Object)Boolean.FALSE, (Object)Boolean.FALSE);
            if (couple == null) {
                JSDocumentationUtils.$$$reportNull$$$0(31);
            }
            return couple;
        }
        if (element instanceof JSExpression) {
            element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSStatement.class, JSProperty.class});
        }
        PsiComment psiComment = docComment = element != null ? JSDocumentationUtils.findDocComment(element) : null;
        if (docComment != null) {
            final Ref myIsConst = Ref.create((Object)Boolean.FALSE);
            final Ref myIsDeprecated = Ref.create((Object)Boolean.FALSE);
            JSDocumentationUtils.processDocumentationTextFromComment(docComment.getNode(), new JSDocumentationProcessor(){

                @Override
                public boolean needsPlainCommentData() {
                    return false;
                }

                @Override
                public boolean onCommentLine(@NotNull String line) {
                    if (line == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return true;
                }

                @Override
                public boolean onPatternMatch(@NotNull JSDocumentationProcessor.MetaDocType type, @Nullable String matchName, @Nullable String matchValue, @Nullable String remainingLineContent, @NotNull String line, @NotNull String patternMatched) {
                    if (type == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (line == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    if (patternMatched == null) {
                        3.$$$reportNull$$$0(3);
                    }
                    if (type == JSDocumentationProcessor.MetaDocType.DEPRECATED) {
                        myIsDeprecated.set((Object)Boolean.TRUE);
                    } else if (type == JSDocumentationProcessor.MetaDocType.FINAL) {
                        myIsConst.set((Object)Boolean.TRUE);
                    }
                    return true;
                }

                @Override
                public void postProcess() {
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "line";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "type";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "patternMatched";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationUtils$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onCommentLine";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onPatternMatch";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            Couple couple = Couple.of((Object)((Boolean)myIsConst.get()), (Object)((Boolean)myIsDeprecated.get()));
            if (couple == null) {
                JSDocumentationUtils.$$$reportNull$$$0(32);
            }
            return couple;
        }
        Couple couple = Couple.of((Object)Boolean.FALSE, (Object)Boolean.FALSE);
        if (couple == null) {
            JSDocumentationUtils.$$$reportNull$$$0(33);
        }
        return couple;
    }

    public static void appendHyperLinkToElement(@Nullable PsiElement element, String elementName, StringBuilder buffer, String presentableName, boolean addElementName, boolean addFilename, int elementId) {
        String prefix;
        PsiFile containingFile = element != null ? element.getContainingFile() : null;
        String fileName = containingFile == null ? null : containingFile.getViewProvider().getVirtualFile().getName();
        String path = containingFile != null && !JSResolveUtil.isFromPredefinedFile(containingFile) ? containingFile.getVirtualFile().getPresentableUrl() : fileName;
        boolean isJsElement = element instanceof JSElementBase;
        JSQualifiedName namespace = isJsElement ? ((JSElementBase)element).getNamespace() : null;
        String string = prefix = path != null ? FileUtilRt.toSystemIndependentName((String)path) + HYPERLINK_SEPARATOR : "";
        String linkText = prefix + elementName + (String)(namespace != null ? HYPERLINK_SEPARATOR + namespace.getQualifiedName() : (isJsElement ? "%null" : ""));
        if (elementId > 0) {
            linkText = linkText + INDEX_POSITION_SEPARATOR + elementId;
        }
        String quote = element != null ? "`" : "";
        DocumentationManagerUtil.createHyperlink((StringBuilder)buffer, (String)linkText, (String)((String)(addElementName ? quote + presentableName + quote : "") + (String)(StringUtil.isEmpty((String)fileName) || !addFilename ? "" : (addElementName ? " in " : "") + fileName)), (boolean)true);
    }

    @Nullable
    public static PsiComment findFunctionComment(JSFunction _anchor) {
        PsiComment docComment;
        JSFunction anchor = _anchor;
        if (anchor instanceof JSFunctionExpression) {
            docComment = JSDocumentationUtils.findDocComment((PsiElement)anchor);
            if (docComment instanceof JSDocComment && JSDocumentationUtils.findFunctionAppliedTo((JSDocComment)docComment) == _anchor) {
                return docComment;
            }
            PsiElement parent = anchor.getParent();
            PsiElement grandparent = parent.getParent();
            anchor = parent instanceof JSVariable && grandparent.getNode().findChildByType(JSElementTypes.BODY_VARIABLES) != parent.getNode() ? parent : PsiTreeUtil.getParentOfType((PsiElement)anchor, (Class[])new Class[]{JSStatement.class, JSProperty.class});
        }
        if (anchor != null && (docComment = JSDocumentationUtils.findDocComment((PsiElement)anchor)) instanceof JSDocComment && JSDocumentationUtils.findFunctionAppliedTo((JSDocComment)docComment) == _anchor) {
            return docComment;
        }
        return null;
    }

    @Nullable
    public static JSFunction findFunctionAppliedTo(@NotNull JSDocComment comment) {
        JSExpression assignedExpression;
        PsiElement parent;
        if (comment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(34);
        }
        if ((parent = comment.getParent()) instanceof JSFunction) {
            return (JSFunction)parent;
        }
        if (parent instanceof JSExpressionStatement) {
            parent = ((JSExpressionStatement)parent).getExpression();
        }
        if (parent instanceof JSVarStatement) {
            parent = PsiTreeUtil.getNextSiblingOfType((PsiElement)comment, JSVariable.class);
        }
        if ((assignedExpression = JSPsiImplUtils.getAssignedExpression(parent)) instanceof JSFunction) {
            return (JSFunction)assignedExpression;
        }
        return null;
    }

    @Nullable
    public static JSType getTypeFromTrailingComment(JSFunction function2) {
        ASTNode lastCommentInFunctionBody = JSDocumentationUtils.findTrailingCommentInFunctionBody(function2);
        if (lastCommentInFunctionBody != null) {
            JSType type = JSDocumentationUtils.tryCreateTypeFromComment((PsiComment)lastCommentInFunctionBody.getPsi(), false, true, false);
            if (!(type instanceof JSSpecialNamedTypeImpl)) {
                type = JSTypeUtils.copyWithStrict(type, false);
            }
            return type;
        }
        return null;
    }

    @Nullable
    public static JSType getTypeFromReturnTypeComment(JSFunction function2) {
        JSParameterList list2 = function2.getParameterList();
        JSType type = null;
        if (list2 != null) {
            PsiElement reasonableNextElement = list2.getNextSibling();
            if (reasonableNextElement instanceof PsiWhiteSpace) {
                reasonableNextElement = reasonableNextElement.getNextSibling();
            }
            if (reasonableNextElement instanceof JSDocComment) {
                type = JSDocumentationUtils.tryCreateTypeFromComment((PsiComment)((JSDocComment)reasonableNextElement), false, true, false);
            }
        }
        return type;
    }

    public static JSType tryCreateTypeFromComment(@NotNull PsiComment comment, boolean spaceAllowed, boolean allowEOLComment, boolean allowCommentAfterType) {
        if (comment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(35);
        }
        if (!allowEOLComment && comment.getNode().getElementType() == JSTokenTypes.END_OF_LINE_COMMENT) {
            return null;
        }
        String body = JSDocumentationUtils.unwrapCommentDelimiters(comment.getText());
        if (allowEOLComment) {
            body = body.trim();
        }
        if (!JSDocumentationUtils.isTypeStringAcceptable(body, spaceAllowed)) {
            return null;
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)comment, true);
        return JSTypeUtils.createType(body, typeSource, allowCommentAfterType);
    }

    private static boolean isTypeStringAcceptable(String typeString, boolean spaceAllowed) {
        if (typeString.indexOf(10) != -1) {
            return false;
        }
        if (!spaceAllowed && typeString.indexOf(32) != -1) {
            return false;
        }
        return !(typeString = typeString.trim()).equals("TODO") && !typeString.equals("INTERNAL") && typeString.length() != 0 && !typeString.endsWith(",") && !typeString.startsWith(",");
    }

    @Nullable
    public static JSType findTypeFromComments(JSNamedElement element) {
        if (element instanceof JSVariable) {
            return JSDocumentationUtils.rawGetTypeForVariable((JSVariable)element);
        }
        if (element instanceof JSFunction) {
            JSType type = JSDocumentationUtils.getTypeFromTrailingComment((JSFunction)element);
            if (type != null) {
                return type;
            }
            PsiComment docComment = JSDocumentationUtils.findDocCommentWider((PsiElement)element);
            if (docComment instanceof JSDocComment) {
                String returnType = ((JSDocComment)docComment).getReturnType();
                if (returnType == null) {
                    returnType = ((JSDocComment)docComment).getType();
                }
                if (returnType != null) {
                    return JSTypeUtils.createTypeFromJSDoc(returnType, JSTypeSourceFactory.createTypeSource((PsiElement)element, true));
                }
            }
        }
        return null;
    }

    @Nullable
    @Contract(value="!null -> !null")
    public static String doCapitalizeCommentTypeIfNeeded(String comment) {
        if (!StringUtil.isEmpty((String)comment)) {
            if (comment.equals("number") || comment.equals("string") || comment.equals("function") || comment.equals("boolean") || comment.equals("object") || comment.equals("array")) {
                comment = StringUtil.capitalize((String)comment);
            } else if ("Integer".equals(comment)) {
                comment = "int";
            }
        }
        return comment;
    }

    @Nullable
    public static String stripTypeDecorations(@Nullable String textFragment) {
        int commaIndex;
        if (textFragment == null) {
            return null;
        }
        textFragment = textFragment.trim();
        textFragment = StringUtil.trimStart((String)textFragment, (String)"...");
        int i = (textFragment = StringUtil.trimStart((String)textFragment, (String)"!")).indexOf(63);
        if (i != -1) {
            textFragment = i == 0 ? textFragment.substring(1) : textFragment.substring(0, i);
        }
        if (i < 1 && (i = textFragment.indexOf(61)) != -1) {
            textFragment = textFragment.substring(0, i);
        }
        if ((textFragment = StringUtil.trimEnd((String)textFragment, (String)".")).startsWith("(") && textFragment.endsWith(")")) {
            textFragment = textFragment.substring(1, textFragment.length() - 1);
        }
        if ((commaIndex = textFragment.indexOf(44)) != -1 && textFragment.indexOf(123) == -1) {
            textFragment = textFragment.substring(0, commaIndex).trim();
        }
        return textFragment;
    }

    @NotNull
    public static String getLibDocRelativeUrl(@NotNull String baseUrl, @NotNull String elementFQN) {
        String[] rules;
        String baseKey;
        if (baseUrl == null) {
            JSDocumentationUtils.$$$reportNull$$$0(36);
        }
        if (elementFQN == null) {
            JSDocumentationUtils.$$$reportNull$$$0(37);
        }
        if ((baseKey = JSExternalLibraryDocBundle.getBaseURLKey(baseUrl)) == null) {
            return "";
        }
        String directUrl = JSExternalLibraryDocBundle.getElementUrl(baseKey, elementFQN);
        if (directUrl != null) {
            String string = directUrl;
            if (string == null) {
                JSDocumentationUtils.$$$reportNull$$$0(38);
            }
            return string;
        }
        String prefix = JSExternalLibraryDocBundle.getPrefix(baseKey);
        String relativeUrl = elementFQN;
        String rulesStr = JSExternalLibraryDocBundle.getRules(baseKey);
        for (String rule : rules = rulesStr.split(";")) {
            String replacement;
            if (rule.trim().length() <= 0) continue;
            String[] args = rule.split(",");
            String opType = args[0].trim();
            String sample = args.length > 1 ? args[1].trim() : "";
            String string = replacement = args.length > 2 ? args[2].trim() : "";
            if (opType.startsWith("S")) {
                relativeUrl = relativeUrl.replace(sample, replacement);
                continue;
            }
            if (opType.startsWith("R")) {
                relativeUrl = relativeUrl.replaceAll(sample, replacement);
                continue;
            }
            if (opType.startsWith("L")) {
                relativeUrl = StringUtil.toLowerCase((String)relativeUrl);
                continue;
            }
            assert (false) : "Don't know how to handle " + opType + " in rule " + rule + " must be R or S";
        }
        if (JSExternalLibraryDocBundle.isLowerCase(baseKey)) {
            relativeUrl = StringUtil.toLowerCase((String)relativeUrl);
        }
        String string = prefix + relativeUrl;
        if (string == null) {
            JSDocumentationUtils.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Nullable
    public static String getBaseKey(@NotNull String libUrl) {
        if (libUrl == null) {
            JSDocumentationUtils.$$$reportNull$$$0(40);
        }
        for (String baseKey : JSExternalLibraryDocBundle.getBasePatternKeys()) {
            String patterns = JSExternalLibraryDocBundle.getPatterns(baseKey);
            if (patterns == null) continue;
            for (String pattern : patterns.split(";")) {
                String tp = pattern.trim();
                if (tp.length() <= 0 || !libUrl.matches(tp)) continue;
                return baseKey;
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement findAssociatedElement(@NotNull PsiComment psiComment) {
        JSVariable[] variables;
        if (psiComment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(41);
        }
        PsiElement parent = psiComment.getParent();
        PsiElement next = null;
        if (parent instanceof JSExpressionStatement) {
            JSExpression expression = ((JSExpressionStatement)parent).getExpression();
            if (expression instanceof JSAssignmentExpression) {
                JSExpression lOperand = ((JSAssignmentExpression)expression).getLOperand();
                if (lOperand instanceof JSDefinitionExpression || lOperand instanceof JSReferenceExpression) {
                    next = lOperand;
                }
            } else if (expression instanceof JSReferenceExpression) {
                next = expression;
            }
        } else if (parent instanceof JSProperty || parent instanceof JSFunction || parent instanceof JSVariable || parent instanceof JSClass) {
            next = parent;
        } else if (parent instanceof JSVarStatement && (variables = ((JSVarStatement)parent).getVariables()).length > 0) {
            next = variables[0];
        }
        return next;
    }

    @Nullable
    public static PsiElement findAttachedElementFromComment(PsiComment psiComment) {
        PsiElement next;
        PsiElement strictElement = JSDocumentationUtils.findAssociatedElement(psiComment);
        if (strictElement != null) {
            return strictElement;
        }
        for (next = psiComment.getNextSibling(); next instanceof PsiWhiteSpace || next instanceof PsiComment || next != null && !(next instanceof JSElement); next = next.getNextSibling()) {
        }
        PsiComment associatedComment = JSDocumentationUtils.findDocCommentWider(next);
        if (associatedComment != null && associatedComment != psiComment) {
            return null;
        }
        return next;
    }

    @Nullable
    public static String getQualifiedNameFromPsi(@Nullable PsiElement namedElement) {
        JSQualifiedName name;
        if (namedElement instanceof JSDefinitionExpression) {
            namedElement = ((JSDefinitionExpression)namedElement).getExpression();
        }
        if (namedElement instanceof JSNamedElement && !(namedElement instanceof JSProperty)) {
            return ((JSNamedElement)namedElement).getName();
        }
        if (namedElement instanceof JSReferenceExpression && (name = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)namedElement)) != null) {
            return name.getQualifiedName();
        }
        return null;
    }

    @NotNull
    public static JSElementBase.ClassOrInterface isClassOrInterface(JSQualifiedNamedElement element) {
        if (element instanceof JSParameter) {
            JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.NONE;
            if (classOrInterface == null) {
                JSDocumentationUtils.$$$reportNull$$$0(42);
            }
            return classOrInterface;
        }
        JSDocComment comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)element);
        JSElementBase.ClassOrInterface classOrInterface = comment != null && comment.hasInterfaceTag() ? JSElementBase.ClassOrInterface.INTERFACE : (comment != null && comment.isClassExplicitly() ? JSElementBase.ClassOrInterface.CLASS : JSElementBase.ClassOrInterface.NONE);
        if (classOrInterface == null) {
            JSDocumentationUtils.$$$reportNull$$$0(43);
        }
        return classOrInterface;
    }

    public static int findNextNamepathSeparator(@NotNull String namepath, int startOffset) {
        if (namepath == null) {
            JSDocumentationUtils.$$$reportNull$$$0(44);
        }
        Pattern pattern = startOffset == 0 ? NAMEPATH_START_PATTERN : NAMEPATH_PART_PATTERN;
        Matcher partMatcher = pattern.matcher(namepath.subSequence(startOffset, namepath.length()));
        return !partMatcher.lookingAt() ? -1 : startOffset + partMatcher.end();
    }

    @NotNull
    public static String appendPrefixToName(@NotNull String name, @NotNull String prefix) {
        int lastPartOffset;
        if (name == null) {
            JSDocumentationUtils.$$$reportNull$$$0(45);
        }
        if (prefix == null) {
            JSDocumentationUtils.$$$reportNull$$$0(46);
        }
        if (!name.startsWith(prefix, lastPartOffset = JSDocumentationUtils.findLastNamepathPartOffset(name))) {
            name = new StringBuilder(name).insert(lastPartOffset, prefix).toString();
        }
        String string = name;
        if (string == null) {
            JSDocumentationUtils.$$$reportNull$$$0(47);
        }
        return string;
    }

    private static int findLastNamepathPartOffset(@NotNull String namepath) {
        if (namepath == null) {
            JSDocumentationUtils.$$$reportNull$$$0(48);
        }
        int startOffset = 0;
        int prevDot = -1;
        while (true) {
            int nextDot;
            if ((nextDot = JSDocumentationUtils.findNextNamepathSeparator(namepath, prevDot + 1)) - prevDot > 1) {
                startOffset = prevDot + 1;
            }
            if (nextDot >= namepath.length() || nextDot <= prevDot) break;
            prevDot = nextDot;
        }
        return startOffset;
    }

    public static boolean mayRelateTo(@NotNull JSDocComment docComment, @NotNull PsiElement element) {
        Collection typedefs;
        JSElementIndexingData indexingData;
        if (docComment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(49);
        }
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(50);
        }
        if ((indexingData = docComment.getIndexingData()) != null && element instanceof JSPsiNamedElementBase && (typedefs = indexingData.getTypedefs()) != null && typedefs.size() == 1) {
            Pair pair = (Pair)ContainerUtil.getFirstItem((Collection)typedefs);
            assert (pair != null) : "typedef element must not be null";
            if (pair.first != null && !((String)pair.first).equals(((JSPsiNamedElementBase)element).getName())) {
                return false;
            }
        }
        return true;
    }

    public static void moveJSDoc(@Nullable PsiComment docComment, @NotNull PsiElement newElement) {
        if (newElement == null) {
            JSDocumentationUtils.$$$reportNull$$$0(51);
        }
        JSDocComment existingComment = (JSDocComment)PsiTreeUtil.getChildOfType((PsiElement)newElement, JSDocComment.class);
        if (!(docComment == null || existingComment != null && docComment.getText().equals(existingComment.getText()))) {
            JSDocumentationUtils.copyJSDocComment(docComment, newElement);
            docComment.getParent().deleteChildRange((PsiElement)docComment, (PsiElement)docComment);
        }
    }

    public static void copyJSDocComment(@Nullable PsiComment docComment, @NotNull PsiElement newElement) {
        if (newElement == null) {
            JSDocumentationUtils.$$$reportNull$$$0(52);
        }
        if (docComment == null || newElement.getFirstChild() == null) {
            return;
        }
        JSDocComment existingComment = (JSDocComment)PsiTreeUtil.getChildOfType((PsiElement)newElement, JSDocComment.class);
        if (docComment instanceof JSDocComment && existingComment == null) {
            PsiElement firstChild = newElement.getFirstChild();
            newElement.addBefore(docComment.copy(), firstChild);
            JSDocumentationUtils.addNewLineBeforeIfNoNewlineNow(firstChild);
            JSDocumentationUtils.addNewLineBeforeIfNoNewlineNow(newElement);
        } else {
            PsiElement added = newElement.getParent().addBefore(docComment.copy(), newElement);
            JSDocumentationUtils.addNewLineBeforeIfNoNewlineNow(added);
            JSDocumentationUtils.addNewLineBeforeIfNoNewlineNow(newElement);
        }
    }

    private static void addNewLineBeforeIfNoNewlineNow(@NotNull PsiElement newElement) {
        if (newElement == null) {
            JSDocumentationUtils.$$$reportNull$$$0(53);
        }
        if (newElement.getPrevSibling() instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)newElement.getPrevSibling().getText()) > 0) {
            return;
        }
        JSChangeUtil.addWs(newElement.getParent().getNode(), newElement.getNode(), "\n");
    }

    @Nullable
    public static PsiElement findCommentForImplicitElement(@Nullable PsiElement implicitElementParent) {
        boolean hasStub = implicitElementParent instanceof StubBasedPsiElement && ((StubBasedPsiElement)implicitElementParent).getStub() != null;
        PsiElement expression = PsiTreeUtil.getNonStrictParentOfType((PsiElement)implicitElementParent, (Class[])new Class[]{hasStub ? JSExpression.class : JSStatement.class, JSProperty.class, JSFunction.class, JSDocComment.class});
        return expression != null ? JSDocumentationUtils.findDocComment(expression) : null;
    }

    @Nullable
    public static JSDocComment findOwnDocCommentForImplicitElement(@NotNull PsiElement implicitElementParent) {
        JSDocComment comment;
        if (implicitElementParent == null) {
            JSDocumentationUtils.$$$reportNull$$$0(54);
        }
        if ((comment = JSDocumentationUtils.findOwnDocComment(implicitElementParent)) != null) {
            return comment;
        }
        PsiElement elementToCheck = implicitElementParent.getParent();
        if (elementToCheck instanceof JSArgumentList) {
            elementToCheck = elementToCheck.getParent();
        }
        if (elementToCheck instanceof JSCallExpression) {
            elementToCheck = elementToCheck.getParent();
        }
        if (elementToCheck instanceof JSExpressionStatement) {
            return JSDocumentationUtils.getStartingChildDocComment(elementToCheck);
        }
        return null;
    }

    @Nullable
    public static DocTag getDocTag(String commentText) {
        List lines = StringUtil.split((String)commentText, (String)"\n");
        DocTagBuilder tag = null;
        StringBuilder multilineCommentTag = new StringBuilder();
        for (String line : lines) {
            String commentLine = JSDocumentationUtils.prepareCommentLine(line);
            tag = JSDocumentationUtils.handlePossiblyMultilinedTag(tag, multilineCommentTag, commentLine, null, null, false);
        }
        return tag != null ? tag.toDocTag() : null;
    }

    @Nullable
    private static DocTagBuilder handleCommentLine(String commentText, @Nullable String lastParameterName, @Nullable JSDocumentationProcessor processor, @NotNull Map<Pattern, JSDocumentationProcessor.MetaDocType> patternToMetaDocTypeMap) {
        if (patternToMetaDocTypeMap == null) {
            JSDocumentationUtils.$$$reportNull$$$0(55);
        }
        for (Map.Entry<Pattern, String> entry : patternToHintMap.entrySet()) {
            JSDocumentationProcessor.MetaDocType docType;
            Pattern pattern = entry.getKey();
            Matcher matcher = commentText.contains(entry.getValue()) ? pattern.matcher(commentText) : null;
            if (matcher == null || !matcher.matches() || (docType = patternToMetaDocTypeMap.get(pattern)) == null) continue;
            DocTagBuilder docTag = new DocTagBuilder(docType);
            docTag.breakEnd = false;
            int groupCount = matcher.groupCount();
            String remainingLineContent = groupCount > 0 ? matcher.group(groupCount) : null;
            String matchName = groupCount > 1 ? matcher.group(1) : null;
            Object matchValue = groupCount > 2 ? matcher.group(2) : null;
            boolean reportAboutOptionalParameter = false;
            boolean reportAboutFieldInParameter = false;
            boolean reportAboutDefaultValue = false;
            int groupForInitialValue = -1;
            String fieldName = null;
            if (pattern == ourJSDocParametersPattern) {
                String text = matcher.group(1);
                Matcher tailMatcher = ourYuiDocParametersPattern.matcher(text);
                if (tailMatcher.matches()) {
                    String typeWithTailText = tailMatcher.group(2);
                    int typeLength = JSDocumentationUtils.getTypeStringLength(typeWithTailText);
                    if (typeLength > typeWithTailText.length()) {
                        docTag.continueType = true;
                        docTag.matchName = tailMatcher.group(1);
                        docTag.matchValue = typeWithTailText;
                        return docTag;
                    }
                    matchName = tailMatcher.group(1);
                    matchValue = JSDocumentationUtils.trimBrackets(typeWithTailText.substring(0, typeLength));
                    remainingLineContent = typeWithTailText.substring(typeLength);
                } else {
                    boolean hasType = text.trim().startsWith("{");
                    int typeLength = 0;
                    if (hasType) {
                        typeLength = JSDocumentationUtils.getTypeStringLength(text);
                        if (typeLength > text.length()) {
                            docTag.continueType = true;
                            docTag.matchValue = text;
                            return docTag;
                        }
                        matchValue = JSDocumentationUtils.trimBrackets(text.substring(0, typeLength));
                    } else {
                        matchValue = null;
                    }
                    matcher = ourJSDocParametersRestPattern.matcher(text.substring(typeLength));
                    if (matcher.matches()) {
                        matchName = matcher.group(2);
                        remainingLineContent = matcher.group(7);
                        String typeAfterParamName = matcher.group(6);
                        if (typeAfterParamName != null) {
                            matchValue = typeAfterParamName;
                        } else {
                            fieldName = matcher.group(3);
                            reportAboutFieldInParameter = fieldName != null;
                            groupForInitialValue = 5;
                            reportAboutDefaultValue = matcher.group(5) != null;
                            String matchTypeDecorated = matcher.group(1);
                            boolean bl = reportAboutOptionalParameter = matchTypeDecorated != null && (matchTypeDecorated.startsWith("[") || matchTypeDecorated.startsWith("("));
                        }
                        if (matcher.group(4) != null) {
                            if (matchValue == null) {
                                matchValue = "*";
                            }
                            matchValue = "..." + (String)matchValue;
                        }
                    }
                }
                lastParameterName = matchName;
            } else if (pattern == ourJSDocPropertyPattern || pattern == ourJSDocConfigPattern) {
                if (matcher.start(1) != -1) {
                    String typeWithTailText = commentText.substring(matcher.start(1));
                    int typeLength = JSDocumentationUtils.getTypeStringLength(typeWithTailText);
                    if (typeLength > typeWithTailText.length()) {
                        docTag.continueType = true;
                        docTag.matchValue = typeWithTailText;
                        return docTag;
                    }
                    matchValue = JSDocumentationUtils.trimBrackets(typeWithTailText.substring(0, typeLength));
                    remainingLineContent = typeWithTailText.substring(typeLength);
                } else {
                    matchValue = null;
                    remainingLineContent = matcher.group(2);
                }
                matcher = ourJSDocPropertyRestPattern.matcher(remainingLineContent);
                if (matcher.matches()) {
                    reportAboutOptionalParameter = !StringUtil.isEmpty((String)matcher.group(1));
                    matchName = matcher.group(2);
                    remainingLineContent = StringUtil.trim((String)matcher.group(4));
                    if (pattern == ourJSDocConfigPattern) {
                        fieldName = matchName;
                        if (fieldName != null) {
                            reportAboutOptionalParameter = true;
                            reportAboutFieldInParameter = true;
                            groupForInitialValue = 3;
                            reportAboutDefaultValue = matcher.group(3) != null;
                        }
                        matchName = lastParameterName;
                    }
                }
            } else if ((JSDocumentationProcessor.TYPE_AS_VALUE_TAGS.contains((Object)docType) || JSDocumentationProcessor.NAMEPATH_AS_NAME_TAGS.contains((Object)docType)) && pattern != ourDojoParametersPattern && pattern != ourJSDocFinalPattern) {
                if (remainingLineContent != null && (pattern != ourJSDocThrowsPattern && !JSDocumentationUtils.isTypeAndNamePattern(pattern) || JSDocumentationUtils.startsWithTypeInBraces(remainingLineContent))) {
                    int typeLength = JSDocumentationUtils.getTypeStringLength(remainingLineContent);
                    if (typeLength > remainingLineContent.length()) {
                        docTag.continueType = true;
                        docTag.matchValue = JSDocumentationUtils.trimBrackets(remainingLineContent);
                        return docTag;
                    }
                    String typeOrNamepath = JSDocumentationUtils.trimBrackets(remainingLineContent.substring(0, typeLength));
                    String newRemainingLineContent = remainingLineContent.substring(typeLength).trim();
                    if (JSDocumentationUtils.startsWithTypeInBraces(remainingLineContent) || newRemainingLineContent.isEmpty()) {
                        remainingLineContent = newRemainingLineContent;
                        if (JSDocumentationProcessor.TYPE_AS_VALUE_TAGS.contains((Object)docType)) {
                            matchName = null;
                            matchValue = typeOrNamepath;
                        } else {
                            matchName = typeOrNamepath;
                            matchValue = null;
                        }
                    }
                }
                if (pattern == ourJSDocTemplatePattern) {
                    if (StringUtil.isNotEmpty((String)remainingLineContent) && (matcher = ourJSDocTemplateNamesPattern.matcher(remainingLineContent)).matches() && matcher.group(1) != null) {
                        matchName = matcher.group(1);
                        remainingLineContent = matcher.group(2);
                    }
                } else if (JSDocumentationUtils.isTypeAndNamePattern(pattern)) {
                    if (StringUtil.isNotEmpty((String)remainingLineContent) && (matcher = ourJSDocNameTailPattern.matcher(remainingLineContent)).matches() && matcher.group(1) != null) {
                        matchName = matcher.group(1);
                        remainingLineContent = matcher.group(2);
                    }
                } else if (groupCount != 1) {
                    Logger.getInstance(JSDocumentationUtils.class).error(pattern.pattern() + " expected to have one group having type and comment");
                }
            }
            if (remainingLineContent != null && remainingLineContent.trim().startsWith("-")) {
                remainingLineContent = remainingLineContent.trim().substring(1).trim();
            }
            String matched = pattern.pattern();
            docTag.matchName = matchName;
            docTag.matchValue = matchValue;
            docTag.lastParameterName = lastParameterName;
            if (reportAboutFieldInParameter) {
                docTag.matchName = JSDocumentationUtils.createParameterOrParameterFieldReference(matchName, fieldName);
                docTag.type = JSDocumentationProcessor.MetaDocType.FIELD;
            }
            if (processor != null) {
                if (reportAboutFieldInParameter) {
                    if (!processor.onPatternMatch(JSDocumentationProcessor.MetaDocType.FIELD, JSDocumentationUtils.createParameterOrParameterFieldReference(matchName, fieldName), (String)matchValue, remainingLineContent, commentText, matched)) {
                        return docTag;
                    }
                } else if (!processor.onPatternMatch(docType, matchName, (String)matchValue, remainingLineContent, commentText, matched)) {
                    docTag.breakEnd = true;
                }
                if (reportAboutOptionalParameter && !processor.onPatternMatch(JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS, JSDocumentationUtils.createParameterOrParameterFieldReference(matchName, fieldName), null, null, commentText, matched)) {
                    return docTag;
                }
                if (reportAboutDefaultValue) {
                    processor.onPatternMatch(JSDocumentationProcessor.MetaDocType.DEFAULT, JSDocumentationUtils.createParameterOrParameterFieldReference(matchName, fieldName), null, matcher.group(groupForInitialValue), commentText, matched);
                }
            }
            return docTag;
        }
        return null;
    }

    private static boolean startsWithTypeInBraces(@NotNull String string) {
        if (string == null) {
            JSDocumentationUtils.$$$reportNull$$$0(56);
        }
        return string.trim().startsWith("{");
    }

    private static boolean isTypeAndNamePattern(Pattern pattern) {
        return pattern == ourJSDocTypedefPattern || pattern == ourJSDocMemberPattern || pattern == ourJSDocVarPattern || pattern == ourJSDocConstantPattern || pattern == ourJSDocTemplatePattern;
    }

    @NotNull
    public static List<PsiElement> getElementsForExternalDocumentation(PsiElement original) {
        SmartList elements = new SmartList();
        if (original instanceof TypeScriptCompileTimeType && JSDocumentationUtils.isFromCoreLibFile(original)) {
            PsiElement parent = JSResolveUtil.findParent(original);
            String name = ((TypeScriptCompileTimeType)original).getName();
            if (name != null && parent != null) {
                List<PsiElement> all = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(name, parent);
                all.stream().filter(el -> !(el instanceof TypeScriptCompileTimeType)).findAny().ifPresent(((List)elements)::add);
            }
            SmartList smartList = elements;
            if (smartList == null) {
                JSDocumentationUtils.$$$reportNull$$$0(57);
            }
            return smartList;
        }
        if (!(original instanceof JSReferenceExpression)) {
            elements.add(original);
        }
        SmartList smartList = elements;
        if (smartList == null) {
            JSDocumentationUtils.$$$reportNull$$$0(58);
        }
        return smartList;
    }

    public static boolean isFromCoreLibFile(@NotNull PsiElement original) {
        if (original == null) {
            JSDocumentationUtils.$$$reportNull$$$0(59);
        }
        VirtualFile originalFile = original.getContainingFile().getVirtualFile();
        return TypeScriptLibraryProvider.isLibraryOrBundledLibraryFile(original.getProject(), originalFile) || JSCorePredefinedLibrariesProvider.isCoreLibraryFile(originalFile);
    }

    @Nullable
    public static JSDocParametersMappingToFunctionInfo checkDocCommentMatchesFunctionSignature(@NotNull JSDocComment docComment, @NotNull JSFunction function2) {
        if (docComment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(60);
        }
        if (function2 == null) {
            JSDocumentationUtils.$$$reportNull$$$0(61);
        }
        JSParameter[] parameters = function2.getParameterVariables();
        HashMap<String, Integer> actualParameters = new HashMap<String, Integer>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            actualParameters.put(parameters[i].getName(), i);
        }
        HashMap<String, Integer> matchingTagIndexes = new HashMap<String, Integer>();
        HashMap<Integer, String> tagNames = new HashMap<Integer, String>();
        JSTagToParameterMap tagsToParameters = JSDocumentationUtils.getTagToParameterMap(docComment, function2, tagNames);
        for (Object entry : Int2ObjectMaps.fastIterable(tagsToParameters.getMatchedTags())) {
            JSParameterListElement paramElement = (JSParameterListElement)entry.getValue();
            if (!(paramElement instanceof JSParameter)) continue;
            matchingTagIndexes.put(paramElement.getName(), entry.getIntKey());
        }
        HashMap<Integer, String> paramsToRemove = new HashMap<Integer, String>();
        for (Integer nonMatchedTag : tagsToParameters.getNonMatchedTags()) {
            paramsToRemove.put(nonMatchedTag, (String)tagNames.get(nonMatchedTag));
        }
        if (!paramsToRemove.isEmpty()) {
            Iterator iterator = paramsToRemove.values().iterator();
            while (iterator.hasNext()) {
                JSParameter[] type = (JSParameter[])iterator.next();
                if (!"arguments".equals(type)) continue;
                iterator.remove();
                break;
            }
        }
        List<Pair<Integer, String>> parametersToAdd = Collections.emptyList();
        if (matchingTagIndexes.size() < actualParameters.size()) {
            parametersToAdd = new ArrayList();
            for (JSParameter parameter : parameters) {
                String parameterName = parameter.getName();
                Integer tagIndex = (Integer)matchingTagIndexes.get(parameterName);
                if (tagIndex != null) continue;
                if (JSDestructuringUtil.isDestructuring(parameter.getParent())) {
                    JSDestructuringContext context = JSDestructuringContext.findDestructuringParents((PsiElement)parameter, JSDestructuringParameter.class::isInstance);
                    if (context.getOuterElement() != null && tagsToParameters.getMatchedTags().containsValue((Object)context.getOuterElement())) continue;
                }
                int insertionPlace = -1;
                int insertedParameterIndex = (Integer)actualParameters.get(parameterName);
                for (Map.Entry entry : matchingTagIndexes.entrySet()) {
                    if (insertedParameterIndex < (Integer)actualParameters.get(entry.getKey())) {
                        insertionPlace = insertionPlace == -1 ? (Integer)entry.getValue() : Math.min(insertionPlace, (Integer)entry.getValue());
                        continue;
                    }
                    if (insertedParameterIndex <= (Integer)actualParameters.get(entry.getKey())) continue;
                    insertionPlace = Math.max(insertionPlace, (Integer)entry.getValue() + 1);
                }
                parametersToAdd.add((Pair<Integer, String>)Pair.create((Object)(insertionPlace == -1 ? Integer.MAX_VALUE : insertionPlace), (Object)parameterName));
            }
        }
        if (parametersToAdd.isEmpty() && paramsToRemove.isEmpty()) {
            return null;
        }
        boolean hasParamTag = !tagsToParameters.isEmpty();
        return new JSDocParametersMappingToFunctionInfo(parametersToAdd, paramsToRemove, hasParamTag);
    }

    @NotNull
    public static JSTagToParameterMap getTagToParameterMap(@NotNull JSDocComment docComment, @NotNull JSFunction function2, @Nullable Map<Integer, String> outTagNames) {
        if (docComment == null) {
            JSDocumentationUtils.$$$reportNull$$$0(62);
        }
        if (function2 == null) {
            JSDocumentationUtils.$$$reportNull$$$0(63);
        }
        JSParameter[] parameters = function2.getParameterVariables();
        HashMap<String, JSParameter> actualParameters = new HashMap<String, JSParameter>(parameters.length);
        for (JSParameter parameter : parameters) {
            actualParameters.put(parameter.getName(), parameter);
        }
        JSDocTag[] tags = docComment.getTags();
        Int2ObjectOpenHashMap matchedTags = new Int2ObjectOpenHashMap();
        THashSet unmatchedTags = new THashSet();
        int restIndex = -1;
        HashMap<String, JSDestructuringParameter> dummyNameToDestructuringParameter = new HashMap<String, JSDestructuringParameter>();
        JSParameterListElement[] parameterElements = function2.getParameters();
        int destructuringParameterElement = 0;
        for (int i = 0; i < tags.length; ++i) {
            List<String> qName;
            String outerName;
            JSDestructuringParameter destructuringParameter;
            JSDocTag tag = tags[i];
            DocTag docTag = JSDocumentationUtils.getDocTag(tag.getText());
            if (docTag == null) continue;
            if (docTag.type == JSDocumentationProcessor.MetaDocType.PARAMETER) {
                if (outTagNames != null) {
                    outTagNames.put(i, docTag.matchName);
                }
                if (actualParameters.containsKey(docTag.matchName)) {
                    JSParameter jsParameter = (JSParameter)actualParameters.get(docTag.matchName);
                    matchedTags.put(i, (Object)jsParameter);
                    JSDestructuringParameter destructuringParameter2 = JSDocumentationUtils.getOuterParameterForRestPropertyParameter(jsParameter);
                    if (destructuringParameter2 == null) continue;
                    dummyNameToDestructuringParameter.put(docTag.matchName, destructuringParameter2);
                    continue;
                }
                boolean rest = false;
                if (docTag.matchValue != null) {
                    JSParameterTypeDecorator parameterType = new JSTypeParser(docTag.matchValue, JSTypeSource.EMPTY).parseParameterType();
                    boolean bl = rest = parameterType != null && parameterType.isRest();
                }
                if (rest) {
                    restIndex = i;
                    continue;
                }
                boolean isDestructuring = false;
                while (destructuringParameterElement < parameterElements.length) {
                    if (parameterElements[destructuringParameterElement] instanceof JSDestructuringParameter) {
                        if (dummyNameToDestructuringParameter.containsKey(docTag.matchName)) {
                            ++destructuringParameterElement;
                            continue;
                        }
                        dummyNameToDestructuringParameter.put(docTag.matchName, (JSDestructuringParameter)parameterElements[destructuringParameterElement]);
                        matchedTags.put(i, (Object)parameterElements[destructuringParameterElement]);
                        isDestructuring = true;
                        ++destructuringParameterElement;
                        break;
                    }
                    ++destructuringParameterElement;
                }
                if (isDestructuring) continue;
                unmatchedTags.add(i);
                continue;
            }
            if (docTag.type != JSDocumentationProcessor.MetaDocType.FIELD || (destructuringParameter = (JSDestructuringParameter)dummyNameToDestructuringParameter.getOrDefault(outerName = (String)ContainerUtil.getFirstItem(qName = JSQualifiedNameImpl.fromQualifiedName(docTag.matchName).toComponents()), null)) == null) continue;
            JSDestructuringContainer target = destructuringParameter.getTarget();
            for (int componentIndex = 1; componentIndex < qName.size(); ++componentIndex) {
                JSDestructuringProperty property;
                if (!(target instanceof JSDestructuringObject) || (property = ((JSDestructuringObject)target).findProperty(qName.get(componentIndex))) == null) {
                    target = null;
                    break;
                }
                target = property.getDestructuringElement();
            }
            if (!(target instanceof JSParameter)) continue;
            matchedTags.put(i, (Object)((JSParameter)target));
        }
        return new JSTagToParameterMap((Int2ObjectMap<JSParameterListElement>)matchedTags, (Set<Integer>)unmatchedTags, restIndex);
    }

    @Nullable
    private static JSDestructuringParameter getOuterParameterForRestPropertyParameter(@NotNull JSParameter parameter) {
        PsiElement destructuringParameter;
        PsiElement grandParent;
        PsiElement parent;
        if (parameter == null) {
            JSDocumentationUtils.$$$reportNull$$$0(64);
        }
        if ((parent = parameter.getParent()) instanceof JSDestructuringProperty && ((JSDestructuringProperty)parent).isRest() && (grandParent = parent.getParent()) instanceof JSDestructuringObject && (destructuringParameter = grandParent.getParent()) instanceof JSDestructuringParameter) {
            return (JSDestructuringParameter)destructuringParameter;
        }
        return null;
    }

    public static JSContext findJSContext(@NotNull PsiElement element) {
        PsiComment comment;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(65);
        }
        if ((comment = JSDocumentationUtils.findDocComment(element)) instanceof JSDocComment) {
            return ((JSDocComment)comment).getJSContext();
        }
        return JSContext.UNKNOWN;
    }

    public static boolean isExtendedTypeName(CharSequence type) {
        return ourJSDocExtendedTypeNamePattern.matcher(type).matches();
    }

    @NotNull
    public static List<TextRange> getParameterNameRanges(@NotNull JSDocTag paramTag) {
        int tailStart;
        PsiElement data;
        if (paramTag == null) {
            JSDocumentationUtils.$$$reportNull$$$0(66);
        }
        if ((data = paramTag.getDocCommentData()) == null) {
            List<TextRange> list2 = Collections.emptyList();
            if (list2 == null) {
                JSDocumentationUtils.$$$reportNull$$$0(67);
            }
            return list2;
        }
        Matcher matcher = ourJSDocParametersRestPattern.matcher(data.getText());
        if (!matcher.matches() || matcher.groupCount() < 2) {
            List<TextRange> list3 = Collections.emptyList();
            if (list3 == null) {
                JSDocumentationUtils.$$$reportNull$$$0(68);
            }
            return list3;
        }
        int offsetInParent = data.getStartOffsetInParent();
        int start = matcher.start(2);
        int end = matcher.end(2);
        SmartList result2 = new SmartList();
        if (start >= 0 && end >= 0 && end > start) {
            result2.add(TextRange.create((int)start, (int)end).shiftRight(offsetInParent));
        }
        if ((tailStart = matcher.start(3)) != -1) {
            String tail = matcher.group(3);
            int currentStart = 0;
            while (currentStart < tail.length()) {
                int indexOfDot = tail.indexOf(46, currentStart);
                if (indexOfDot == -1) {
                    indexOfDot = tail.length();
                }
                if (currentStart < indexOfDot) {
                    result2.add(TextRange.create((int)currentStart, (int)indexOfDot).shiftRight(offsetInParent + tailStart));
                }
                currentStart = indexOfDot + 1;
            }
        }
        SmartList smartList = result2;
        if (smartList == null) {
            JSDocumentationUtils.$$$reportNull$$$0(69);
        }
        return smartList;
    }

    @Nullable
    public static JSNamespace getNamespaceFromJSDoc(@NotNull JSNamedElement element) {
        JSDocComment jsDocComment;
        PsiComment docComment;
        if (element == null) {
            JSDocumentationUtils.$$$reportNull$$$0(70);
        }
        if (DialectDetector.isJavaScript((PsiElement)element) && (docComment = JSDocumentationUtils.findDocComment((PsiElement)element)) instanceof JSDocComment && ((jsDocComment = (JSDocComment)docComment).getExplicitName() != null || jsDocComment.isNamespaceExplicitlyDeclared())) {
            return JSNamedTypeFactory.createNamespace(jsDocComment.getNamespace(), JSTypeSourceFactory.createTypeSource((PsiElement)jsDocComment, true), JSTypeContext.fromJSContext(jsDocComment.getJSContext()), false);
        }
        return null;
    }

    static {
        patternToHintMap.put(ourJSDocParametersPattern, "@pa");
        patternToMetaDocTypeMap.put(ourJSDocParametersPattern, JSDocumentationProcessor.MetaDocType.PARAMETER);
        patternToHintMap.put(ourDojoParametersPattern, INDEX_POSITION_SEPARATOR);
        inlinePatternToMetaDocTypeMap.put(ourDojoParametersPattern, JSDocumentationProcessor.MetaDocType.PARAMETER);
        patternToHintMap.put(ourJSDocMethodPattern, "@m");
        patternToMetaDocTypeMap.put(ourJSDocMethodPattern, JSDocumentationProcessor.MetaDocType.METHOD);
        patternToHintMap.put(ourJSDocOptionalPattern, "@op");
        patternToMetaDocTypeMap.put(ourJSDocOptionalPattern, JSDocumentationProcessor.MetaDocType.OPTIONAL_PARAMETERS);
        patternToHintMap.put(ourJSDocEventPattern, "@ev");
        patternToMetaDocTypeMap.put(ourJSDocEventPattern, JSDocumentationProcessor.MetaDocType.EVENT);
        patternToHintMap.put(ourJSDocConfigPattern, "@conf");
        patternToMetaDocTypeMap.put(ourJSDocConfigPattern, JSDocumentationProcessor.MetaDocType.CONFIG);
        patternToHintMap.put(ourJSDocExtendsPattern, "@ext");
        patternToMetaDocTypeMap.put(ourJSDocExtendsPattern, JSDocumentationProcessor.MetaDocType.EXTENDS);
        patternToHintMap.put(ourJSDocAugmentsPattern, "@au");
        patternToMetaDocTypeMap.put(ourJSDocAugmentsPattern, JSDocumentationProcessor.MetaDocType.EXTENDS);
        patternToHintMap.put(ourJSDocThrowsPattern, "@th");
        patternToMetaDocTypeMap.put(ourJSDocThrowsPattern, JSDocumentationProcessor.MetaDocType.THROWS);
        patternToHintMap.put(ourJSDocExceptionPattern, "@exc");
        patternToMetaDocTypeMap.put(ourJSDocExceptionPattern, JSDocumentationProcessor.MetaDocType.THROWS);
        patternToHintMap.put(ourJSDocRemarkPattern, "@rem");
        patternToMetaDocTypeMap.put(ourJSDocRemarkPattern, JSDocumentationProcessor.MetaDocType.NOTE);
        patternToHintMap.put(ourJSDocReturnPattern, "@ret");
        patternToMetaDocTypeMap.put(ourJSDocReturnPattern, JSDocumentationProcessor.MetaDocType.RETURN);
        patternToHintMap.put(ourJSDocBrowserPattern, "@b");
        patternToMetaDocTypeMap.put(ourJSDocBrowserPattern, JSDocumentationProcessor.MetaDocType.BROWSER);
        patternToHintMap.put(ourJSDocPublicPattern, "@pu");
        patternToMetaDocTypeMap.put(ourJSDocPublicPattern, JSDocumentationProcessor.MetaDocType.PUBLIC);
        patternToHintMap.put(ourJSDocProtectedPattern, "@prot");
        patternToMetaDocTypeMap.put(ourJSDocProtectedPattern, JSDocumentationProcessor.MetaDocType.PROTECTED);
        patternToHintMap.put(ourJSDocStaticPattern, "@st");
        patternToMetaDocTypeMap.put(ourJSDocStaticPattern, JSDocumentationProcessor.MetaDocType.STATIC);
        patternToHintMap.put(ourJSDocSeePattern, "@se");
        patternToMetaDocTypeMap.put(ourJSDocSeePattern, JSDocumentationProcessor.MetaDocType.SEE);
        patternToHintMap.put(ourJSDocDescriptionPattern, "@des");
        patternToMetaDocTypeMap.put(ourJSDocDescriptionPattern, JSDocumentationProcessor.MetaDocType.DESCRIPTION);
        patternToHintMap.put(ourJSDocDeprecatedPattern, "@dep");
        patternToMetaDocTypeMap.put(ourJSDocDeprecatedPattern, JSDocumentationProcessor.MetaDocType.DEPRECATED);
        patternToHintMap.put(ourJSDocConstructorPattern, "@cons");
        patternToMetaDocTypeMap.put(ourJSDocConstructorPattern, JSDocumentationProcessor.MetaDocType.CONSTRUCTOR);
        patternToHintMap.put(ourJSDocConstructsPattern, "@cons");
        patternToMetaDocTypeMap.put(ourJSDocConstructsPattern, JSDocumentationProcessor.MetaDocType.CONSTRUCTS);
        patternToHintMap.put(ourJSDocClassPattern, "@cl");
        patternToMetaDocTypeMap.put(ourJSDocClassPattern, JSDocumentationProcessor.MetaDocType.CLASS);
        patternToHintMap.put(ourJSDocLendsPattern, "@le");
        patternToMetaDocTypeMap.put(ourJSDocLendsPattern, JSDocumentationProcessor.MetaDocType.LENDS);
        patternToHintMap.put(ourJSDocPrivatePattern, "@pri");
        patternToMetaDocTypeMap.put(ourJSDocPrivatePattern, JSDocumentationProcessor.MetaDocType.PRIVATE);
        patternToHintMap.put(ourJSDocNamespacePattern, "@n");
        patternToMetaDocTypeMap.put(ourJSDocNamespacePattern, JSDocumentationProcessor.MetaDocType.NAMESPACE);
        patternToHintMap.put(ourJSDocNamePattern, "@n");
        patternToMetaDocTypeMap.put(ourJSDocNamePattern, JSDocumentationProcessor.MetaDocType.NAME);
        patternToHintMap.put(ourJSDocPropertyPattern, "@prop");
        patternToMetaDocTypeMap.put(ourJSDocPropertyPattern, JSDocumentationProcessor.MetaDocType.PROPERTY);
        patternToHintMap.put(ourJSDocTypePattern, "@ty");
        patternToMetaDocTypeMap.put(ourJSDocTypePattern, JSDocumentationProcessor.MetaDocType.TYPE);
        patternToHintMap.put(ourJSDocFinalPattern, "@f");
        patternToMetaDocTypeMap.put(ourJSDocFinalPattern, JSDocumentationProcessor.MetaDocType.FINAL);
        patternToHintMap.put(ourJSDocConstantPattern, "@const");
        patternToMetaDocTypeMap.put(ourJSDocConstantPattern, JSDocumentationProcessor.MetaDocType.FINAL);
        patternToHintMap.put(ourJSDocRequiresPattern, "@req");
        patternToMetaDocTypeMap.put(ourJSDocRequiresPattern, JSDocumentationProcessor.MetaDocType.REQUIRES);
        patternToHintMap.put(ourJSDocDefaultPattern, "@def");
        patternToMetaDocTypeMap.put(ourJSDocDefaultPattern, JSDocumentationProcessor.MetaDocType.DEFAULT);
        patternToHintMap.put(ourJSDocInheritDocPattern, "@inh");
        patternToMetaDocTypeMap.put(ourJSDocInheritDocPattern, JSDocumentationProcessor.MetaDocType.INHERIT_DOC);
        patternToHintMap.put(ourJSDocTypedefPattern, "@typ");
        patternToMetaDocTypeMap.put(ourJSDocTypedefPattern, JSDocumentationProcessor.MetaDocType.TYPEDEF);
        patternToHintMap.put(ourJSDocEnumPattern, "@en");
        patternToMetaDocTypeMap.put(ourJSDocEnumPattern, JSDocumentationProcessor.MetaDocType.ENUM);
        patternToHintMap.put(ourJSDocInterfacePattern, "@int");
        patternToMetaDocTypeMap.put(ourJSDocInterfacePattern, JSDocumentationProcessor.MetaDocType.INTERFACE);
        patternToHintMap.put(ourJSDocImplementsPattern, "@imp");
        patternToMetaDocTypeMap.put(ourJSDocImplementsPattern, JSDocumentationProcessor.MetaDocType.IMPLEMENTS);
        patternToHintMap.put(ourJSDocOverridePattern, "@ov");
        patternToMetaDocTypeMap.put(ourJSDocOverridePattern, JSDocumentationProcessor.MetaDocType.OVERRIDE);
        patternToHintMap.put(ourJSDocThisPattern, "@th");
        patternToMetaDocTypeMap.put(ourJSDocThisPattern, JSDocumentationProcessor.MetaDocType.THIS);
        patternToHintMap.put(ourJSDocMixinPattern, "@mix");
        patternToMetaDocTypeMap.put(ourJSDocMixinPattern, JSDocumentationProcessor.MetaDocType.MIXIN);
        patternToHintMap.put(ourJSDocMixesPattern, "@mix");
        patternToMetaDocTypeMap.put(ourJSDocMixesPattern, JSDocumentationProcessor.MetaDocType.MIXES);
        patternToHintMap.put(ourJSDocFunctionPattern, "@fun");
        patternToMetaDocTypeMap.put(ourJSDocFunctionPattern, JSDocumentationProcessor.MetaDocType.FUNCTION);
        patternToHintMap.put(ourJSDocExportsPattern, "@exp");
        patternToMetaDocTypeMap.put(ourJSDocExportsPattern, JSDocumentationProcessor.MetaDocType.EXPORTS);
        patternToHintMap.put(ourJSDocTemplatePattern, "@tem");
        patternToMetaDocTypeMap.put(ourJSDocTemplatePattern, JSDocumentationProcessor.MetaDocType.TEMPLATE);
        patternToHintMap.put(ourJSDocAuthorPattern, "@aut");
        patternToMetaDocTypeMap.put(ourJSDocAuthorPattern, JSDocumentationProcessor.MetaDocType.AUTHOR);
        patternToHintMap.put(ourJSDocExamplePattern, "@exa");
        patternToMetaDocTypeMap.put(ourJSDocExamplePattern, JSDocumentationProcessor.MetaDocType.EXAMPLE);
        patternToHintMap.put(ourJSDocFileOverviewPattern, "@fil");
        patternToMetaDocTypeMap.put(ourJSDocFileOverviewPattern, JSDocumentationProcessor.MetaDocType.FILE_OVERVIEW);
        patternToHintMap.put(ourJSDocSincePattern, "@sin");
        patternToMetaDocTypeMap.put(ourJSDocSincePattern, JSDocumentationProcessor.MetaDocType.SINCE);
        patternToHintMap.put(ourJSDocVersionPattern, "@ver");
        patternToMetaDocTypeMap.put(ourJSDocVersionPattern, JSDocumentationProcessor.MetaDocType.VERSION);
        patternToHintMap.put(ourJSDocMemberOfPattern, "@mem");
        patternToMetaDocTypeMap.put(ourJSDocMemberOfPattern, JSDocumentationProcessor.MetaDocType.MEMBER_OF);
        patternToHintMap.put(ourJSDocFieldOfPattern, "@fie");
        patternToMetaDocTypeMap.put(ourJSDocFieldOfPattern, JSDocumentationProcessor.MetaDocType.MEMBER_OF);
        patternToHintMap.put(ourJSDocMethodOfPattern, "@met");
        patternToMetaDocTypeMap.put(ourJSDocMethodOfPattern, JSDocumentationProcessor.MetaDocType.MEMBER_OF);
        patternToHintMap.put(ourJSDocAbstractPattern, "@abs");
        patternToMetaDocTypeMap.put(ourJSDocAbstractPattern, JSDocumentationProcessor.MetaDocType.ABSTRACT);
        patternToHintMap.put(ourJSDocVirtualPattern, "@vir");
        patternToMetaDocTypeMap.put(ourJSDocVirtualPattern, JSDocumentationProcessor.MetaDocType.ABSTRACT);
        patternToHintMap.put(ourJSDocAliasPattern, "@ali");
        patternToMetaDocTypeMap.put(ourJSDocAliasPattern, JSDocumentationProcessor.MetaDocType.ALIAS);
        patternToHintMap.put(ourJSDocCallbackPattern, "@cal");
        patternToMetaDocTypeMap.put(ourJSDocCallbackPattern, JSDocumentationProcessor.MetaDocType.CALLBACK);
        patternToHintMap.put(ourJSDocExternalPattern, "@ext");
        patternToMetaDocTypeMap.put(ourJSDocExternalPattern, JSDocumentationProcessor.MetaDocType.EXTERNAL);
        patternToHintMap.put(ourJSDocHostPattern, "@hos");
        patternToMetaDocTypeMap.put(ourJSDocHostPattern, JSDocumentationProcessor.MetaDocType.EXTERNAL);
        patternToHintMap.put(ourJSDocGlobalPattern, "@glo");
        patternToMetaDocTypeMap.put(ourJSDocGlobalPattern, JSDocumentationProcessor.MetaDocType.GLOBAL);
        patternToHintMap.put(ourJSDocMemberPattern, "@mem");
        patternToMetaDocTypeMap.put(ourJSDocMemberPattern, JSDocumentationProcessor.MetaDocType.MEMBER);
        patternToHintMap.put(ourJSDocVarPattern, "@var");
        patternToMetaDocTypeMap.put(ourJSDocVarPattern, JSDocumentationProcessor.MetaDocType.MEMBER);
        patternToHintMap.put(ourJSDocModulePattern, "@mod");
        patternToMetaDocTypeMap.put(ourJSDocModulePattern, JSDocumentationProcessor.MetaDocType.MODULE);
        patternToHintMap.put(ourProvideModulesPattern, "@provi");
        patternToMetaDocTypeMap.put(ourProvideModulesPattern, JSDocumentationProcessor.MetaDocType.MODULE);
        patternToHintMap.put(ourJSDocFiresPattern, "@fir");
        patternToMetaDocTypeMap.put(ourJSDocFiresPattern, JSDocumentationProcessor.MetaDocType.FIRES);
        patternToHintMap.put(ourJSDocEmitsPattern, "@emi");
        patternToMetaDocTypeMap.put(ourJSDocEmitsPattern, JSDocumentationProcessor.MetaDocType.FIRES);
        patternToHintMap.put(ourJSDocTodoPattern, "@tod");
        patternToMetaDocTypeMap.put(ourJSDocTodoPattern, JSDocumentationProcessor.MetaDocType.TODO);
        patternToHintMap.put(ourJSDocSummaryPattern, "@summ");
        patternToMetaDocTypeMap.put(ourJSDocSummaryPattern, JSDocumentationProcessor.MetaDocType.SUMMARY);
        patternToHintMap.put(ourJSDocInstancePattern, "@ins");
        patternToMetaDocTypeMap.put(ourJSDocInstancePattern, JSDocumentationProcessor.MetaDocType.INSTANCE);
        prefixToPatternToHintMap = new THashMap();
        prefixToPatternToHintMap.put(Pattern.compile("^\\s*description:(.*)$"), "descr");
        prefixToPatternToHintMap.put(Pattern.compile("^ summary(?:\\:)?(.*)$"), "summ");
        prefixToPatternToHintMap.put(Pattern.compile("^\\s*\\*(?:\\*)?(.*)$"), "*");
        prefixToPatternToHintMap.put(Pattern.compile("^[/]+(.*)$"), "/");
        prefixToPatternToHintMap.put(Pattern.compile("^\\s*Parameters:(.*)$"), "Parame");
        DOC_COMMENT_ALLOWED_AFTER = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.COMMENTS_AND_WHITESPACES, JSStubElementTypes.ATTRIBUTE_LISTS});
        ourPrimitiveTypeFilter = JSKeywordSets.PRIMITIVE_TYPES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 47: 
            case 57: 
            case 58: 
            case 67: 
            case 68: 
            case 69: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 47: 
            case 57: 
            case 58: 
            case 67: 
            case 68: 
            case 69: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multilineCommentTag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentLine";
                break;
            }
            case 2: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 47: 
            case 57: 
            case 58: 
            case 67: 
            case 68: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocumentationUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tailText";
                break;
            }
            case 4: 
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 50: 
            case 65: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 17: 
            case 30: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 18: 
            case 49: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 28: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFQN";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libUrl";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiComment";
                break;
            }
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namepath";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitElementParent";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternToMetaDocTypeMap";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareCommentLine";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findAttributeListAnchor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "skipOuterElements";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementOverAssignmentParent";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateConstAndDeprecated";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibDocRelativeUrl";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "appendPrefixToName";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsForExternalDocumentation";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterNameRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handlePossiblyMultilinedTag";
                break;
            }
            case 2: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 47: 
            case 57: 
            case 58: 
            case 67: 
            case 68: 
            case 69: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeStringLength";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTrailingCommentInFunctionBody";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findLeadingCommentInFunctionBody";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTypeFromInlineComment";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findOwnDocComment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasSingleVariable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findScopeComment";
                break;
            }
            case 10: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findAttributeListAnchor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isSelfSufficientComment";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "skipOuterElements";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getParentToSearchDocComment";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getElementOverAssignmentParent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedElement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getStartingChildDocComment";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createOrUpdateTagsInDocComment";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createOrUpdateTagsWithInsertionIndexes";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNameFromExprStatement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeFromPrecedingComment";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getReasonablePrevElement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromComment";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionAppliedTo";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "tryCreateTypeFromComment";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getLibDocRelativeUrl";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getBaseKey";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findAssociatedElement";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findNextNamepathSeparator";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "appendPrefixToName";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findLastNamepathPartOffset";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "mayRelateTo";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "moveJSDoc";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "copyJSDocComment";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addNewLineBeforeIfNoNewlineNow";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findOwnDocCommentForImplicitElement";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "handleCommentLine";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "startsWithTypeInBraces";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isFromCoreLibFile";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "checkDocCommentMatchesFunctionSignature";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getTagToParameterMap";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getOuterParameterForRestPropertyParameter";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "findJSContext";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getParameterNameRanges";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceFromJSDoc";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 47: 
            case 57: 
            case 58: 
            case 67: 
            case 68: 
            case 69: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class JSTagToParameterMap {
        private final Int2ObjectMap<JSParameterListElement> myMatchedTags;
        private final Set<Integer> myNonMatchedTags;
        private final int myRestDocTagIndex;

        public JSTagToParameterMap(@NotNull Int2ObjectMap<JSParameterListElement> matchedTags, @NotNull Set<Integer> nonMatchedTags, int restDocTagIndex) {
            if (matchedTags == null) {
                JSTagToParameterMap.$$$reportNull$$$0(0);
            }
            if (nonMatchedTags == null) {
                JSTagToParameterMap.$$$reportNull$$$0(1);
            }
            this.myMatchedTags = matchedTags;
            this.myNonMatchedTags = nonMatchedTags;
            this.myRestDocTagIndex = restDocTagIndex;
        }

        public Int2ObjectMap<JSParameterListElement> getMatchedTags() {
            return this.myMatchedTags;
        }

        public Set<Integer> getNonMatchedTags() {
            return this.myNonMatchedTags;
        }

        public int getRestDocTagIndex() {
            return this.myRestDocTagIndex;
        }

        public int getTagForParameter(@NotNull JSParameterListElement parameter) {
            if (parameter == null) {
                JSTagToParameterMap.$$$reportNull$$$0(2);
            }
            for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(this.myMatchedTags)) {
                JSParameterListElement element = (JSParameterListElement)entry.getValue();
                if (!parameter.equals(element) && (!(element instanceof JSParameter) || !parameter.equals(JSDocumentationUtils.getOuterParameterForRestPropertyParameter((JSParameter)element)))) continue;
                return entry.getIntKey();
            }
            return -1;
        }

        public boolean isEmpty() {
            return this.myMatchedTags.isEmpty() && this.myNonMatchedTags.isEmpty() && this.myRestDocTagIndex == -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchedTags";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nonMatchedTags";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationUtils$JSTagToParameterMap";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTagForParameter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class JSDocParametersMappingToFunctionInfo {
        private final List<Pair<Integer, String>> myParamsToAdd;
        private final Map<Integer, String> myParamsToRemove;
        private final boolean myHasParamTag;

        public JSDocParametersMappingToFunctionInfo(List<Pair<Integer, String>> paramsToAdd, Map<Integer, String> paramsToRemove, boolean hasParamTag) {
            this.myParamsToAdd = paramsToAdd;
            this.myParamsToRemove = paramsToRemove;
            this.myHasParamTag = hasParamTag;
        }

        public List<Pair<Integer, String>> getParamsToAdd() {
            return this.myParamsToAdd;
        }

        public Map<Integer, String> getParamsToRemove() {
            return this.myParamsToRemove;
        }

        public boolean hasParamTag() {
            return this.myHasParamTag;
        }
    }

    public static class DocTag {
        public final JSDocumentationProcessor.MetaDocType type;
        public final String matchName;
        public final String matchValue;

        public DocTag(JSDocumentationProcessor.MetaDocType type, String matchName, String matchValue) {
            this.type = type;
            this.matchName = matchName;
            this.matchValue = matchValue;
        }
    }

    private static class DocTagBuilder {
        @NotNull
        public JSDocumentationProcessor.MetaDocType type;
        public String matchName;
        public String matchValue;
        public String lastParameterName;
        public boolean breakEnd;
        public boolean continueType;

        DocTagBuilder(@NotNull JSDocumentationProcessor.MetaDocType type) {
            if (type == null) {
                DocTagBuilder.$$$reportNull$$$0(0);
            }
            this.type = type;
        }

        @NotNull
        DocTag toDocTag() {
            return new DocTag(this.type, this.matchName, this.matchValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/documentation/JSDocumentationUtils$DocTagBuilder", "<init>"));
        }
    }
}

