/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.completion.JSLookupElementRenderer;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.JSReferenceCompletionProvider;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.evaluation.JSCodeBasedTypeFactory;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.types.evaluable.JSUnwrapPromiseType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ProcessingContext;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAwaitCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            JSAwaitCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSAwaitCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            JSAwaitCompletionProvider.$$$reportNull$$$0(2);
        }
        PsiElement parent = parameters.getPosition().getParent();
        assert (parent instanceof JSReferenceExpression);
        if (JSReferenceCompletionProvider.skipReferenceCompletionByContext(parameters.getPosition())) {
            return;
        }
        JSFunction parentFunction = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)parent, (Class[])new Class[]{JSFunction.class});
        if (parentFunction == null || !JSPsiImplUtils.hasModifier((JSAttributeListOwner)parentFunction, JSAttributeList.ModifierType.ASYNC)) {
            return;
        }
        JSReferenceExpression referenceExpression = (JSReferenceExpression)parent;
        boolean isInsideAwait = ES6PsiUtil.isAwaitExpression(referenceExpression.getParent());
        JSAwaitCompletionProvider.handleCompletionWithExtraItemToApply(parameters, result2, referenceExpression, (Consumer<? super PsiElement>)((Consumer)element -> JSAwaitCompletionProvider.handleInsert(isInsideAwait, element)), isInsideAwait ? " (+())" : " (+await)", (Condition<? super JSType>)((Condition)t -> JSTypeUtils.isPromiseLikeType(t)), (typeEvaluator, qualifier) -> {
            JSType qualifierCodeBasedType = JSCodeBasedTypeFactory.getCodeBasedType(qualifier, true, false);
            if (qualifierCodeBasedType == null) {
                return;
            }
            JSUnwrapPromiseType type = new JSUnwrapPromiseType(qualifierCodeBasedType, qualifierCodeBasedType.getSource());
            typeEvaluator.addType(type, (PsiElement)qualifier);
        }, true, JSLookupPriority.LOWEST_PRIORITY);
    }

    static void handleCompletionWithExtraItemToApply(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, @NotNull JSReferenceExpression referenceExpression, @NotNull Consumer<? super PsiElement> handler, @NotNull String lookupItemPostfix, @NotNull Condition<? super JSType> isAcceptableType, @NotNull BiConsumer<JSTypeEvaluator, JSExpression> typeInContextApplier, boolean ownHandlerFirst, @Nullable JSLookupPriority modifiedPriority) {
        JSExpression qualifier;
        JSType qualifierType;
        if (parameters == null) {
            JSAwaitCompletionProvider.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            JSAwaitCompletionProvider.$$$reportNull$$$0(4);
        }
        if (referenceExpression == null) {
            JSAwaitCompletionProvider.$$$reportNull$$$0(5);
        }
        if (handler == null) {
            JSAwaitCompletionProvider.$$$reportNull$$$0(6);
        }
        if (lookupItemPostfix == null) {
            JSAwaitCompletionProvider.$$$reportNull$$$0(7);
        }
        if (isAcceptableType == null) {
            JSAwaitCompletionProvider.$$$reportNull$$$0(8);
        }
        if (typeInContextApplier == null) {
            JSAwaitCompletionProvider.$$$reportNull$$$0(9);
        }
        if (!isAcceptableType.value((Object)(qualifierType = JSResolveUtil.getExpressionJSType(qualifier = referenceExpression.getQualifier())))) {
            return;
        }
        CompletionResultSink sink = new CompletionResultSink((PsiElement)qualifier, result2.getPrefixMatcher(), new HashSet<String>(), !parameters.isExtendedCompletion(), false);
        PsiFile containingFile = qualifier.getContainingFile();
        QualifiedItemProcessor<? extends ResultSink> typeProcessor = JSDialectSpecificHandlersFactory.forElement((PsiElement)qualifier).createCompletionItemProcessor(sink, containingFile);
        JSEvaluateContext evaluateContext = new JSEvaluateContext(containingFile);
        JSTypeEvaluator typeEvaluator = JSTypeEvaluator.createEvaluator(typeProcessor, (PsiElement)qualifier, evaluateContext);
        typeInContextApplier.accept(typeEvaluator, qualifier);
        List<LookupElement> items = sink.getResultsAsObjects();
        JSAwaitCompletionProvider.transformItems(result2, items, handler, lookupItemPostfix, ownHandlerFirst, modifiedPriority);
    }

    private static void transformItems(@NotNull CompletionResultSet result2, @NotNull List<LookupElement> items, @NotNull Consumer<? super PsiElement> handler, @NotNull String lookupItemPostfix, boolean ownHandlerFirst, @Nullable JSLookupPriority modifiedPriority) {
        if (result2 == null) {
            JSAwaitCompletionProvider.$$$reportNull$$$0(10);
        }
        if (items == null) {
            JSAwaitCompletionProvider.$$$reportNull$$$0(11);
        }
        if (handler == null) {
            JSAwaitCompletionProvider.$$$reportNull$$$0(12);
        }
        if (lookupItemPostfix == null) {
            JSAwaitCompletionProvider.$$$reportNull$$$0(13);
        }
        for (LookupElement item : items) {
            Double priority;
            LookupElementBuilder builder = LookupElementBuilder.create((Object)item.getObject(), (String)item.getLookupString());
            PsiElement psiElement = item.getPsiElement();
            String withAwait = item.getLookupString() + lookupItemPostfix;
            builder = psiElement != null ? new JSLookupElementRenderer(withAwait, JSLookupPriority.LOWEST_PRIORITY, false, null).applyToBuilder(builder) : builder.withPresentableText(withAwait);
            Double d = priority = modifiedPriority == null ? null : Double.valueOf(modifiedPriority.getPriorityValue());
            if (priority == null && item instanceof PrioritizedLookupElement) {
                priority = ((PrioritizedLookupElement)item).getPriority();
            }
            LookupElementBuilder newElement = builder.withInsertHandler((c, i) -> {
                if (ownHandlerFirst) {
                    item.handleInsert(c);
                } else {
                    handler.consume((Object)c.getFile().findElementAt(c.getStartOffset()));
                }
                PsiDocumentManager.getInstance((Project)c.getProject()).doPostponedOperationsAndUnblockDocument(c.getDocument());
                if (!ownHandlerFirst) {
                    item.handleInsert(c);
                } else {
                    handler.consume((Object)c.getFile().findElementAt(c.getStartOffset()));
                }
            });
            result2.addElement((LookupElement)(priority == null ? newElement : PrioritizedLookupElement.withPriority((LookupElement)newElement, (double)priority)));
        }
    }

    private static void handleInsert(boolean isInnerExpression, PsiElement element) {
        JSQualifiedExpression refExp = (JSQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSQualifiedExpression.class);
        if (refExp == null) {
            return;
        }
        JSExpression refExpQualifier = refExp.getQualifier();
        if (refExpQualifier == null) {
            return;
        }
        refExpQualifier.replace(JSPsiElementFactory.createJSExpression("(await " + refExpQualifier.getText() + ")", (PsiElement)refExpQualifier));
        if (isInnerExpression) {
            JSPrefixExpression prefixExpression = (JSPrefixExpression)PsiTreeUtil.getParentOfType((PsiElement)refExp, JSPrefixExpression.class);
            if (!ES6PsiUtil.isAwaitExpression((PsiElement)prefixExpression)) {
                return;
            }
            prefixExpression.replace(prefixExpression.getExpression());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupItemPostfix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isAcceptableType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeInContextApplier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSAwaitCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "handleCompletionWithExtraItemToApply";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "transformItems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

