/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtApplicationService;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskTreeView;
import com.intellij.lang.javascript.buildTools.base.JsbtToolWindowManager;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsUtil;
import com.intellij.lang.javascript.buildTools.npm.NpmTaskTreeView;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonBuildFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmConfigurationType;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class NpmScriptsService
extends JsbtService {
    public static final NpmScriptsApplicationService APPLICATION_SERVICE = new NpmScriptsApplicationService();
    private static final Logger LOG = Logger.getInstance(PackageJsonBuildFileManager.class);
    private static final Key<CachedValue<NpmScriptsStructure>> STRUCTURE_KEY = Key.create((String)NpmScriptsService.class.getName());

    public NpmScriptsService(@NotNull Project project) {
        if (project == null) {
            NpmScriptsService.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @NotNull
    public static NpmScriptsService getInstance(@NotNull Project project) {
        if (project == null) {
            NpmScriptsService.$$$reportNull$$$0(1);
        }
        NpmScriptsService npmScriptsService = APPLICATION_SERVICE.getProjectService(project);
        if (npmScriptsService == null) {
            NpmScriptsService.$$$reportNull$$$0(2);
        }
        return npmScriptsService;
    }

    @Override
    @NotNull
    public JsbtApplicationService getApplicationService() {
        NpmScriptsApplicationService npmScriptsApplicationService = APPLICATION_SERVICE;
        if (npmScriptsApplicationService == null) {
            NpmScriptsService.$$$reportNull$$$0(3);
        }
        return npmScriptsApplicationService;
    }

    @Override
    @NotNull
    public JsbtFileManager getFileManager() {
        PackageJsonBuildFileManager packageJsonBuildFileManager = PackageJsonBuildFileManager.getInstance(this.myProject);
        if (packageJsonBuildFileManager == null) {
            NpmScriptsService.$$$reportNull$$$0(4);
        }
        return packageJsonBuildFileManager;
    }

    @Override
    @NotNull
    protected JsbtToolWindowManager createToolWindowManager() {
        return new JsbtToolWindowManager(this.myProject, "npm", JavaScriptLanguageIcons.BuildTools.Npm.Npm_13, "reference.tool.window.npm", this);
    }

    @Override
    @NotNull
    public JsbtTaskTreeView createTaskTreeView(@Nullable String layoutPlace) {
        return new NpmTaskTreeView(this, this.myProject, layoutPlace);
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfiles() {
        if (DumbService.isDumb((Project)this.myProject)) {
            List<VirtualFile> list2 = this.detectAllBuildfilesInContentRoots(false, false);
            if (list2 == null) {
                NpmScriptsService.$$$reportNull$$$0(5);
            }
            return list2;
        }
        List list3 = (List)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return Collections.emptyList();
            }
            GlobalSearchScope scope = JSLibraryUtil.getContentScopeWithoutLibraries(this.myProject);
            Collection files = FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)"package.json", (GlobalSearchScope)scope);
            return new ArrayList(files);
        });
        if (list3 == null) {
            NpmScriptsService.$$$reportNull$$$0(6);
        }
        return list3;
    }

    @Override
    @NotNull
    public List<VirtualFile> detectAllBuildfilesInContentRoots(boolean webModulesOnly, boolean filterOutEmptyBuildfiles) {
        SmartList buildfiles = new SmartList();
        JsbtUtil.iterateOverContentRoots(this.myProject, webModulesOnly, (Consumer<? super VirtualFile>)((Consumer)arg_0 -> this.lambda$detectAllBuildfilesInContentRoots$1(filterOutEmptyBuildfiles, (List)buildfiles, arg_0)));
        SmartList smartList = buildfiles;
        if (smartList == null) {
            NpmScriptsService.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    private static boolean hasScripts(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            NpmScriptsService.$$$reportNull$$$0(8);
        }
        if (packageJson == null) {
            NpmScriptsService.$$$reportNull$$$0(9);
        }
        try {
            NpmScriptsStructure structure = NpmScriptsUtil.listTasks(project, packageJson);
            return !structure.getTaskNames().isEmpty();
        }
        catch (JsbtTaskFetchException jsbtTaskFetchException) {
            return false;
        }
    }

    @Override
    public boolean isBuildfile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            NpmScriptsService.$$$reportNull$$$0(10);
        }
        return PackageJsonUtil.isPackageJsonFile(file2);
    }

    @Override
    @Nullable
    public VirtualFile findBuildfileInDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            NpmScriptsService.$$$reportNull$$$0(11);
        }
        return PackageJsonUtil.findChildPackageJsonFile(dir);
    }

    @Override
    @NotNull
    public JsbtFileStructure createEmptyFileStructure(@NotNull VirtualFile buildfile) {
        if (buildfile == null) {
            NpmScriptsService.$$$reportNull$$$0(12);
        }
        return new NpmScriptsStructure(buildfile);
    }

    @Override
    @NotNull
    public NpmScriptsStructure fetchBuildfileStructure(@NotNull VirtualFile packageJson) throws JsbtTaskFetchException {
        if (packageJson == null) {
            NpmScriptsService.$$$reportNull$$$0(13);
        }
        NpmScriptsStructure npmScriptsStructure = (NpmScriptsStructure)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                throw JsbtTaskFetchException.newGenericException(packageJson, this.myProject + " is disposed already");
            }
            if (!packageJson.isValid()) {
                throw JsbtTaskFetchException.newBuildfileSyntaxError(packageJson);
            }
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(packageJson);
            if (psiFile == null) {
                throw JsbtTaskFetchException.newGenericException(packageJson, "Cannot find PSI file");
            }
            return (NpmScriptsStructure)CachedValuesManager.getCachedValue((PsiElement)psiFile, STRUCTURE_KEY, () -> {
                NpmScriptsStructure value;
                try {
                    value = NpmScriptsUtil.listTasks(this.myProject, packageJson);
                }
                catch (JsbtTaskFetchException ignored) {
                    value = new NpmScriptsStructure(packageJson);
                }
                return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{psiFile});
            });
        });
        if (npmScriptsStructure == null) {
            NpmScriptsService.$$$reportNull$$$0(14);
        }
        return npmScriptsStructure;
    }

    @Override
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        NpmConfigurationType npmConfigurationType = NpmConfigurationType.getInstance();
        if (npmConfigurationType == null) {
            NpmScriptsService.$$$reportNull$$$0(15);
        }
        return npmConfigurationType;
    }

    @Override
    public boolean isConfigurationMatched(@NotNull RunConfiguration runConfiguration, @NotNull Object patternObject) {
        if (runConfiguration == null) {
            NpmScriptsService.$$$reportNull$$$0(16);
        }
        if (patternObject == null) {
            NpmScriptsService.$$$reportNull$$$0(17);
        }
        if (runConfiguration instanceof NpmRunConfiguration) {
            NpmRunSettings runSettings = ((NpmRunConfiguration)runConfiguration).getRunSettings();
            NodePackageRef preferredNpmPackageRef = NpmScriptsService.APPLICATION_SERVICE.myPreferredNpmPackageRef;
            if (preferredNpmPackageRef != null && !preferredNpmPackageRef.equals(runSettings.getPackageManagerPackageRef())) {
                return false;
            }
            if (patternObject instanceof NpmRunSettings) {
                NpmRunSettings patternRunSettings = (NpmRunSettings)patternObject;
                return patternRunSettings.getCommand() == runSettings.getCommand() && JsbtUtil.equalsOrderless(patternRunSettings.getScriptNames(), runSettings.getScriptNames()) && patternRunSettings.getPackageJsonSystemIndependentPath().equals(runSettings.getPackageJsonSystemIndependentPath());
            }
            if (patternObject instanceof JsbtTaskSet) {
                JsbtTaskSet patternTaskSet = (JsbtTaskSet)patternObject;
                return runSettings.getCommand() == NpmCommand.RUN_SCRIPT && JsbtUtil.equalsOrderless(patternTaskSet.getTaskNames(), runSettings.getScriptNames()) && patternTaskSet.getStructure().getBuildfile().getPath().equals(runSettings.getPackageJsonSystemIndependentPath());
            }
        }
        return false;
    }

    @Override
    public void setupRunConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull JsbtTaskSet taskSet) {
        if (runConfiguration == null) {
            NpmScriptsService.$$$reportNull$$$0(18);
        }
        if (taskSet == null) {
            NpmScriptsService.$$$reportNull$$$0(19);
        }
        NpmScriptsStructure structure = (NpmScriptsStructure)taskSet.getStructure();
        NpmRunConfiguration npmRunConfiguration = (NpmRunConfiguration)runConfiguration;
        NpmRunSettings.Builder builder = npmRunConfiguration.getRunSettings().toBuilder().setPackageJsonPath(structure.getBuildfile().getPath()).setCommand(NpmCommand.RUN_SCRIPT).setScriptNames(taskSet.getTaskNames());
        NodePackageRef preferredNpmPackageRef = NpmScriptsService.APPLICATION_SERVICE.myPreferredNpmPackageRef;
        if (preferredNpmPackageRef != null) {
            builder.setPackageManagerPackageRef(preferredNpmPackageRef);
        }
        NpmRunSettings merged = builder.build();
        NpmRunConfigurationProducer.setupConfigurationFromSettings(npmRunConfiguration, merged);
    }

    @Override
    public boolean showTaskListingSettingsDialog(@Nullable VirtualFile contextBuildfile) {
        this.editConfigurations();
        return true;
    }

    private /* synthetic */ void lambda$detectAllBuildfilesInContentRoots$1(boolean filterOutEmptyBuildfiles, List buildfiles, VirtualFile contentRoot) {
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(contentRoot);
        LOG.info("Found package.json in " + contentRoot.getPath() + ": " + packageJson);
        if (packageJson != null && (!filterOutEmptyBuildfiles || NpmScriptsService.hasScripts(this.myProject, packageJson))) {
            buildfiles.add(packageJson);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfile";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternObject";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileManager";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllBuildfiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllBuildfilesInContentRoots";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchBuildfileStructure";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasScripts";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isBuildfile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findBuildfileInDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyFileStructure";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fetchBuildfileStructure";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationMatched";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setupRunConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class NpmScriptsApplicationService
    extends JsbtApplicationService {
        private NodePackageRef myPreferredNpmPackageRef;

        private NpmScriptsApplicationService() {
        }

        @Override
        @NotNull
        public NpmScriptsService getProjectService(@NotNull Project project) {
            if (project == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(0);
            }
            NpmScriptsService npmScriptsService = (NpmScriptsService)ServiceManager.getService((Project)project, NpmScriptsService.class);
            if (npmScriptsService == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(1);
            }
            return npmScriptsService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runWithPreferredNpmPackage(@NotNull NodePackageRef preferredNpmPackageRef, @NotNull Runnable runnable) {
            if (preferredNpmPackageRef == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(2);
            }
            if (runnable == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(3);
            }
            NodePackageRef prevPreferredNpmPackage = this.myPreferredNpmPackageRef;
            this.myPreferredNpmPackageRef = preferredNpmPackageRef;
            try {
                runnable.run();
            }
            finally {
                this.myPreferredNpmPackageRef = prevPreferredNpmPackage;
            }
        }

        @Override
        @NotNull
        @NlsSafe
        public String getName() {
            return "npm";
        }

        @Override
        @NotNull
        public String getShowTasksActionName() {
            String string = JavaScriptBundle.message((String)"buildTools.JsbtShowTasksAction.npm.text", (Object[])new Object[0]);
            if (string == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public String getSearchEverywhereDescription(@NotNull String taskName) {
            if (taskName == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(5);
            }
            String string = JavaScriptBundle.message((String)"buildTools.searchEverywhere.npm.text", (Object[])new Object[]{taskName});
            if (string == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        @NotNull
        public String getReloadTasksActionName() {
            String string = JavaScriptBundle.message((String)"buildTools.JsbtReloadTasksAction.npm.text", (Object[])new Object[0]);
            if (string == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Override
        @NotNull
        public String getToolWindowSettingsActionName() {
            String string = JavaScriptBundle.message((String)"buildTools.ShowSettingsAction.npm.text", (Object[])new Object[0]);
            if (string == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(8);
            }
            return string;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = JavaScriptLanguageIcons.BuildTools.Npm.Npm_16;
            if (icon == null) {
                NpmScriptsApplicationService.$$$reportNull$$$0(9);
            }
            return icon;
        }

        @Override
        @NotNull
        public String getBuildfileCommonName() {
            return "package.json";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService$NpmScriptsApplicationService";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preferredNpmPackageRef";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/NpmScriptsService$NpmScriptsApplicationService";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProjectService";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getShowTasksActionName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchEverywhereDescription";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReloadTasksActionName";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getToolWindowSettingsActionName";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getProjectService";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "runWithPreferredNpmPackage";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getSearchEverywhereDescription";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

