/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base.actions;

import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtApplicationService;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtRunTaskAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtAddBuildfileAction
extends DefaultActionGroup
implements DumbAware {
    private final JsbtApplicationService myService;

    public JsbtAddBuildfileAction(@NotNull JsbtApplicationService service) {
        if (service == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(0);
        }
        super(JavaScriptBundle.messagePointer((String)"buildTools.JsbtAddBuildfileAction.text", (Object[])new Object[]{service.getBuildfileCommonName()}), true);
        this.myService = service;
        this.getTemplatePresentation().setIcon(AllIcons.General.Add);
        this.setShortcutSet(CommonShortcuts.getNewForDialogs());
    }

    @Nullable
    public static Shortcut getKeyboardShortcut() {
        Object[] shortcuts = CommonShortcuts.getNewForDialogs().getShortcuts();
        return (Shortcut)ContainerUtil.findInstance((Object[])shortcuts, KeyboardShortcut.class);
    }

    public boolean canBePerformed(@NotNull DataContext context) {
        if (context == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(1);
        }
        return true;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(2);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List<VirtualFile> all = this.myService.getProjectService(project).detectAllBuildfiles();
            List filtered = ContainerUtil.filter(all, file2 -> {
                JsbtFileManager fileManager = this.myService.getProjectService(project).getFileManager();
                return !fileManager.containsBuildfile((VirtualFile)file2);
            });
            UIUtil.invokeLaterIfNeeded(() -> {
                InputEvent inputEvent = e.getInputEvent();
                Component component = inputEvent.getComponent();
                if (component == null) {
                    return;
                }
                ListPopup popup = JsbtAddBuildfileAction.createPopup(project, this.myService, filtered);
                if (inputEvent instanceof MouseEvent) {
                    popup.show(new RelativePoint(component, ((MouseEvent)inputEvent).getPoint()));
                } else {
                    popup.showInCenterOf(component);
                }
            });
        });
    }

    @NotNull
    private static ListPopup createPopup(final @NotNull Project project, final @NotNull JsbtApplicationService service, @NotNull List<VirtualFile> files) {
        if (project == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(4);
        }
        if (service == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(5);
        }
        if (files == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(6);
        }
        ArrayList<VirtualFile> values = new ArrayList<VirtualFile>(files);
        values.add(null);
        BaseListPopupStep<VirtualFile> step = new BaseListPopupStep<VirtualFile>(null, values){

            @NotNull
            public String getTextFor(VirtualFile value) {
                if (value != null) {
                    String string = JsbtUtil.getRelativePath(project, value);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                String string = JavaScriptBundle.message((String)"buildTools.choose_buildfile.text", (Object[])new Object[]{service.getBuildfileCommonName()}) + "...";
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public Icon getIconFor(VirtualFile file2) {
                if (file2 != null) {
                    return file2.getFileType().getIcon();
                }
                return null;
            }

            public PopupStep onChosen(VirtualFile selectedValue, boolean finalChoice) {
                JsbtFileManager fileManager = service.getProjectService(project).getFileManager();
                if (selectedValue != null) {
                    fileManager.addBuildfile(selectedValue);
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
                        fileChooserDescriptor.setTitle(JavaScriptBundle.message((String)"buildTools.choose_buildfile.text", (Object[])new Object[]{service.getBuildfileCommonName()}));
                        boolean popupShown = JsbtRunTaskAction.hidePopup(project);
                        FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)project, null, files1 -> {
                            VirtualFile file2 = (VirtualFile)ContainerUtil.getFirstItem((List)files1);
                            if (file2 != null) {
                                fileManager.addBuildfile(file2);
                            }
                        });
                        if (popupShown) {
                            new Alarm(Alarm.ThreadToUse.SWING_THREAD).addRequest(() -> JsbtRunTaskAction.showPopup(project), 50);
                        }
                    });
                }
                return FINAL_CHOICE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction$1", "getTextFor"));
            }
        };
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        if (listPopup == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(7);
        }
        return listPopup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canBePerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

