/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.google.common.base.Splitter;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.bower.BowerAvailablePackagesManager;
import com.intellij.lang.javascript.bower.BowerCommandLineUtil;
import com.intellij.lang.javascript.bower.BowerInstalledPackage;
import com.intellij.lang.javascript.bower.BowerInstalledPackagesParser;
import com.intellij.lang.javascript.bower.BowerPackageInfo;
import com.intellij.lang.javascript.bower.BowerPackageInfoManager;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackageManagementServiceEx;
import com.intellij.webcore.packaging.RepoPackage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerPackagingService
extends PackageManagementServiceEx {
    private static final Logger LOG = Logger.getInstance(BowerPackagingService.class);
    private final Project myProject;
    private final BowerSettings mySettings;
    private final BowerPackageInfoManager myPackageInfoManager;

    public BowerPackagingService(@NotNull Project project, @NotNull BowerSettings settings) {
        if (project == null) {
            BowerPackagingService.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            BowerPackagingService.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.mySettings = settings;
        this.myPackageInfoManager = new BowerPackageInfoManager(settings);
    }

    @NotNull
    public BowerSettings getSettings() {
        BowerSettings bowerSettings = this.mySettings;
        if (bowerSettings == null) {
            BowerPackagingService.$$$reportNull$$$0(2);
        }
        return bowerSettings;
    }

    @Nullable
    public String getID() {
        return "Bower";
    }

    public List<RepoPackage> getAllPackages() throws IOException {
        return this.doGetPackages(false);
    }

    public List<RepoPackage> reloadAllPackages() throws IOException {
        return this.doGetPackages(true);
    }

    private List<RepoPackage> doGetPackages(boolean forceReload) throws IOException {
        List<String> packages = BowerAvailablePackagesManager.getInstance().getOrLoadAvailablePackages(this.mySettings, forceReload);
        return ContainerUtil.map(packages, packageName -> new RepoPackage(packageName, ""));
    }

    public Collection<InstalledPackage> getInstalledPackages() throws IOException {
        try {
            ProcessOutput output = this.runCommand("list", "--json");
            List<InstalledPackage> packages = BowerInstalledPackagesParser.parse(output.getStdout());
            return packages;
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    public void installPackage(RepoPackage repoPackage, @Nullable String version, boolean forceUpgrade, @Nullable String extraOptions, PackageManagementService.Listener listener2, boolean installToUser) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> this.doInstallPackage(repoPackage.getName(), version, extraOptions, listener2));
    }

    private void doInstallPackage(@NotNull String packageName, @Nullable String version, @Nullable String extraOptions, @NotNull PackageManagementService.Listener listener2) {
        if (packageName == null) {
            BowerPackagingService.$$$reportNull$$$0(3);
        }
        if (listener2 == null) {
            BowerPackagingService.$$$reportNull$$$0(4);
        }
        listener2.operationStarted(packageName);
        Object endpoint = packageName;
        if (version != null) {
            endpoint = (String)endpoint + "#" + version;
        }
        if (extraOptions == null) {
            extraOptions = "--save";
        }
        ArrayList args = ContainerUtil.newArrayList((Object[])new String[]{"install", endpoint, "--force"});
        if (!extraOptions.trim().isEmpty()) {
            Iterable extraArgs = Splitter.on((String)" ").trimResults().split((CharSequence)extraOptions);
            ContainerUtil.addAll((Collection)args, (Iterable)extraArgs);
        }
        try {
            String[] argArray = ArrayUtilRt.toStringArray((Collection)args);
            ProcessOutput output = this.runCommand(argArray);
            LOG.info("Package installation output: " + output.getStdout());
            listener2.operationFinished(packageName, null);
            this.refreshBowerComponents();
        }
        catch (ExecutionException e) {
            listener2.operationFinished(packageName, PackageManagementService.ErrorDescription.fromMessage((String)e.getMessage()));
        }
    }

    private void refreshBowerComponents() {
        GuiUtils.invokeLaterIfNeeded(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            VirtualFile bowerJsonDir;
            VirtualFile rootDir = ProjectUtil.guessProjectDir((Project)this.myProject);
            VirtualFile bowerJson = VfsUtil.findFileByIoFile((File)new File(this.mySettings.getBowerJsonPath()), (boolean)false);
            if (bowerJson != null && bowerJson.isValid() && (bowerJsonDir = bowerJson.getParent()) != null && bowerJsonDir.isDirectory() && bowerJsonDir.isValid()) {
                rootDir = bowerJsonDir;
            }
            if (rootDir != null) {
                rootDir.refresh(true, true);
            }
        }), (ModalityState)ModalityState.defaultModalityState());
    }

    public void uninstallPackages(List<InstalledPackage> installedPackages, PackageManagementService.Listener listener2) {
        ArrayList<BowerInstalledPackage> bowerInstalledPackages = new ArrayList<BowerInstalledPackage>();
        for (InstalledPackage installedPackage : installedPackages) {
            BowerInstalledPackage pkg = (BowerInstalledPackage)((Object)ObjectUtils.tryCast((Object)installedPackage, BowerInstalledPackage.class));
            if (pkg == null) continue;
            bowerInstalledPackages.add(pkg);
        }
        this.uninstallBowerPackages(bowerInstalledPackages, listener2);
    }

    private void uninstallBowerPackages(@NotNull List<BowerInstalledPackage> packages, @NotNull PackageManagementService.Listener listener2) {
        if (packages == null) {
            BowerPackagingService.$$$reportNull$$$0(5);
        }
        if (listener2 == null) {
            BowerPackagingService.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            for (BowerInstalledPackage pkg : packages) {
                this.doUninstallPackage(pkg, listener2, true);
            }
        });
    }

    private void doUninstallPackage(BowerInstalledPackage pkg, PackageManagementService.Listener listener2, boolean refreshFsOnFinish) {
        listener2.operationStarted(pkg.getName());
        try {
            this.runCommand("uninstall", "--save", pkg.getName());
            listener2.operationFinished(pkg.getName(), null);
            if (refreshFsOnFinish) {
                this.refreshBowerComponents();
            }
        }
        catch (ExecutionException e) {
            listener2.operationFinished(pkg.getName(), PackageManagementService.ErrorDescription.fromMessage((String)e.getMessage()));
        }
    }

    public void fetchPackageVersions(String packageName, final CatchingConsumer<List<String>, Exception> consumer) {
        this.myPackageInfoManager.fetchPackageInfo(new BowerPackageInfoManager.PackageInfoConsumer(packageName, true){

            @Override
            public void onPackageInfo(@Nullable BowerPackageInfo packageInfo) {
                List<Object> versions = Collections.emptyList();
                if (packageInfo != null) {
                    versions = packageInfo.getVersions();
                }
                consumer.consume(versions);
            }

            @Override
            public void onException(@NotNull Exception e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                consumer.consume((Throwable)e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/bower/BowerPackagingService$1", "onException"));
            }
        });
    }

    public void fetchPackageDetails(String packageName, final CatchingConsumer<@Nls String, Exception> consumer) {
        this.myPackageInfoManager.fetchPackageInfo(new BowerPackageInfoManager.PackageInfoConsumer(packageName, true){

            @Override
            public void onPackageInfo(@Nullable BowerPackageInfo packageInfo) {
                String html = JavaScriptBundle.message((String)"bower.no_description_available.text", (Object[])new Object[0]);
                if (packageInfo != null) {
                    html = packageInfo.formatHtmlDescription();
                }
                consumer.consume((Object)html);
            }

            @Override
            public void onException(@NotNull Exception e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                consumer.consume((Throwable)e);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/bower/BowerPackagingService$2", "onException"));
            }
        });
    }

    public void updatePackage(@NotNull InstalledPackage installedPackage, @Nullable String version, @NotNull PackageManagementService.Listener listener2) {
        BowerInstalledPackage pkg;
        if (installedPackage == null) {
            BowerPackagingService.$$$reportNull$$$0(7);
        }
        if (listener2 == null) {
            BowerPackagingService.$$$reportNull$$$0(8);
        }
        if ((pkg = (BowerInstalledPackage)((Object)ObjectUtils.tryCast((Object)installedPackage, BowerInstalledPackage.class))) != null) {
            String packageName = pkg.getName();
            listener2.operationStarted(packageName);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                final Ref errorDescriptionRef = Ref.create();
                PackageManagementService.Listener innerListener = new PackageManagementService.Listener(){

                    public void operationStarted(String packageName1) {
                    }

                    public void operationFinished(String packageName1, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                        errorDescriptionRef.set((Object)errorDescription);
                    }
                };
                listener2.operationStarted(packageName);
                this.doUninstallPackage(pkg, innerListener, false);
                if (errorDescriptionRef.get() == null) {
                    this.doInstallPackage(packageName, version, "--save", innerListener);
                }
                listener2.operationFinished(packageName, (PackageManagementService.ErrorDescription)errorDescriptionRef.get());
            });
        }
    }

    public void fetchLatestVersion(@NotNull InstalledPackage pkg, @NotNull CatchingConsumer<String, Exception> consumer) {
        if (pkg == null) {
            BowerPackagingService.$$$reportNull$$$0(9);
        }
        if (consumer == null) {
            BowerPackagingService.$$$reportNull$$$0(10);
        }
        String latestVersion = null;
        if (pkg instanceof BowerInstalledPackage) {
            BowerInstalledPackage bowerPkg = (BowerInstalledPackage)pkg;
            latestVersion = bowerPkg.getLatestVersion();
        }
        consumer.consume(latestVersion);
    }

    @NotNull
    public ProcessOutput runCommand(String ... commands) throws ExecutionException {
        ProcessOutput processOutput = BowerCommandLineUtil.runBowerCommand(null, this.mySettings, commands);
        if (processOutput == null) {
            BowerPackagingService.$$$reportNull$$$0(11);
        }
        return processOutput;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/bower/BowerPackagingService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPackage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/bower/BowerPackagingService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "runCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doInstallPackage";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "uninstallBowerPackages";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updatePackage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fetchLatestVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

