/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadService;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadableInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodePackage;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.packages.NodePackageUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class NpxPackageDescriptor
extends NodePackageDescriptor {
    private static final String NPX_BIN_FILE = "bin" + File.separator + "npx-cli.js";
    private static final String NPX = "npx";
    private static final String NPX_SPACE = "npx ";
    private final List<? extends NpxCommand> myCommands;

    NpxPackageDescriptor(@NotNull List<String> packageNames, @NotNull List<? extends NpxCommand> commands) {
        if (packageNames == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(0);
        }
        if (commands == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(1);
        }
        super(packageNames);
        this.myCommands = commands;
    }

    @Override
    @NotNull
    public List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject) {
        if (project == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(2);
        }
        ArrayList<NodePackage> results = new ArrayList<NodePackage>();
        if (NpxPackageDescriptor.getNpxBinFilePath(interpreter) != null) {
            for (NpxCommand npxCommand : this.myCommands) {
                results.add(npxCommand.createPackage());
            }
        }
        NodeJsInterpreter forSearchingGlobalPackages = !directDependenciesInsideProject ? interpreter : null;
        results.addAll(super.listAvailable(project, forSearchingGlobalPackages, contextFileOrDirectory, directDependenciesInsideProject));
        ArrayList<NodePackage> arrayList = results;
        if (arrayList == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public NodePackage createPackage(@NotNull String path) {
        if (path == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(4);
        }
        if (path.startsWith(NPX_SPACE)) {
            return new NpxNodePackage(path.substring(NPX_SPACE.length()));
        }
        NodePackage nodePackage = super.createPackage(path);
        if (nodePackage == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(5);
        }
        return nodePackage;
    }

    @Nullable
    public static NpxNodePackage createIfAvailable(@Nullable NodeJsInterpreter interpreter, @NotNull NpxCommand command) {
        NodeJsLocalInterpreter localInterpreter;
        if (command == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(6);
        }
        if ((localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter)) == null) {
            return command.createPackage();
        }
        String bin = NpxPackageDescriptor.getNpxBinFilePath(localInterpreter);
        if (bin != null) {
            return command.createPackage();
        }
        return null;
    }

    @Nullable
    public static String getNpxBinFilePath(@Nullable NodeJsInterpreter interpreter) {
        NodePackage npmPkg = NpxPackageDescriptor.getNpmPackage(interpreter);
        if (npmPkg != null && !npmPkg.isEmptyPath()) {
            String path = npmPkg.getSystemIndependentPath() + "/" + NPX_BIN_FILE;
            if (npmPkg instanceof WslNodePackage) {
                return FileUtil.toSystemIndependentName((String)path);
            }
            if (interpreter instanceof NodeJsLocalInterpreter && !new File(path).isFile()) {
                return null;
            }
            return FileUtil.toSystemDependentName((String)path);
        }
        return null;
    }

    @Nullable
    public static NodePackage getNpmPackage(@Nullable NodeJsInterpreter interpreter) {
        if (interpreter instanceof NodeJsLocalInterpreter) {
            return new NodePackage(((NodeJsLocalInterpreter)interpreter).getNpmPackageDir());
        }
        if (interpreter instanceof WslNodeInterpreter) {
            return WslNodePackage.resolvePackageRefAsWsl((WslNodeInterpreter)interpreter, NodePackageRef.create("npm"));
        }
        if (interpreter instanceof NodeJsDownloadableInterpreter) {
            return new NodePackage(NodeJsDownloadService.getNpmInstallDirectory((NodeJsDownloadableInterpreter)interpreter));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/boilerplate/NpxPackageDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/boilerplate/NpxPackageDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "listAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "listAvailable";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPackage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createIfAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class NpxNodePackage
    extends NodePackage {
        private final List<String> myArguments;

        NpxNodePackage(@NotNull List<String> arguments) {
            if (arguments == null) {
                NpxNodePackage.$$$reportNull$$$0(0);
            }
            this(ParametersListUtil.join(arguments));
        }

        NpxNodePackage(@NotNull String npxArguments) {
            if (npxArguments == null) {
                NpxNodePackage.$$$reportNull$$$0(1);
            }
            super(NpxPackageDescriptor.NPX_SPACE + npxArguments);
            this.myArguments = ParametersListUtil.parse((String)npxArguments);
        }

        @Nullable
        private static String getPackageName(@NotNull List<String> arguments) {
            int ind;
            if (arguments == null) {
                NpxNodePackage.$$$reportNull$$$0(2);
            }
            if ((ind = arguments.indexOf("--package")) >= 0 && ind + 1 < arguments.size()) {
                return arguments.get(ind + 1);
            }
            return (String)ContainerUtil.find(arguments, arg -> !arg.startsWith("-"));
        }

        @Override
        @NotNull
        public String getPresentablePath() {
            String string = this.getSystemIndependentPath();
            if (string == null) {
                NpxNodePackage.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public boolean isValid() {
            return !this.myArguments.isEmpty();
        }

        @Override
        @NotNull
        public Promise<SemVer> getVersionPromise(@Nullable Project project) {
            String packageName = NpxNodePackage.getPackageName(this.myArguments);
            if (packageName == null || NodePackageUtil.validateNpmPackageName(packageName) != null) {
                Promise promise = Promises.resolvedPromise(null);
                if (promise == null) {
                    NpxNodePackage.$$$reportNull$$$0(4);
                }
                return promise;
            }
            AvailablePackageVersions cachedVersions = NpmRegistryService.getInstance().getCachedPackageVersions(packageName);
            if (cachedVersions != null) {
                Promise promise = Promises.resolvedPromise((Object)cachedVersions.findVersionByLatestDistTag());
                if (promise == null) {
                    NpxNodePackage.$$$reportNull$$$0(5);
                }
                return promise;
            }
            Promise promise = NpmRegistryService.getInstance().asyncUpdateAndGetPackageVersions(packageName).then(versions -> versions != null ? versions.findVersionByLatestDistTag() : null);
            if (promise == null) {
                NpxNodePackage.$$$reportNull$$$0(6);
            }
            return promise;
        }

        @Override
        @Nullable
        public String getErrorMessage(@NotNull String packageName) {
            if (packageName == null) {
                NpxNodePackage.$$$reportNull$$$0(7);
            }
            return this.isValid() ? null : JavaScriptBundle.message((String)"dialog.message.invalid.npx.command", (Object[])new Object[0]);
        }

        @Nullable
        @NlsContexts.DialogMessage
        public String getErrorMessage(@NotNull NodeJsInterpreter interpreter) {
            if (interpreter == null) {
                NpxNodePackage.$$$reportNull$$$0(8);
            }
            if (!this.isValid()) {
                return JavaScriptBundle.message((String)"dialog.message.invalid.npx.command", (Object[])new Object[0]);
            }
            if (NpxPackageDescriptor.getNpxBinFilePath(interpreter) == null) {
                return NpxNodePackage.getNpxNotFoundErrorMessage(interpreter);
            }
            return null;
        }

        @NotNull
        public List<String> getArguments(@NotNull NodeJsInterpreter interpreter) throws ExecutionException {
            String binPath;
            if (interpreter == null) {
                NpxNodePackage.$$$reportNull$$$0(9);
            }
            if ((binPath = NpxPackageDescriptor.getNpxBinFilePath(interpreter)) == null) {
                throw new ExecutionException(NpxNodePackage.getNpxNotFoundErrorMessage(interpreter));
            }
            ImmutableList.Builder args = ImmutableList.builder().add((Object)binPath);
            if (NpxNodePackage.isNpm7(interpreter)) {
                args.add((Object)"--yes");
            } else {
                args.add((Object)"--ignore-existing");
            }
            ImmutableList immutableList = args.add((Object[])new String[0]).addAll(this.myArguments).build();
            if (immutableList == null) {
                NpxNodePackage.$$$reportNull$$$0(10);
            }
            return immutableList;
        }

        private static boolean isNpm7(@NotNull NodeJsInterpreter interpreter) {
            NodePackage npmPkg;
            SemVer npmVersion;
            if (interpreter == null) {
                NpxNodePackage.$$$reportNull$$$0(11);
            }
            SemVer semVer = npmVersion = (npmPkg = NpxPackageDescriptor.getNpmPackage(interpreter)) != null ? npmPkg.getVersion() : null;
            if (npmVersion != null) {
                return npmVersion.isGreaterOrEqualThan(7, 0, 0);
            }
            Ref<SemVer> version = interpreter.getCachedVersion();
            SemVer interpreterVersion = version != null ? (SemVer)version.get() : null;
            return version != null && interpreterVersion.isGreaterOrEqualThan(15, 0, 0);
        }

        @NotNull
        @NlsContexts.DialogMessage
        private static String getNpxNotFoundErrorMessage(@NotNull NodeJsInterpreter interpreter) {
            if (interpreter == null) {
                NpxNodePackage.$$$reportNull$$$0(12);
            }
            String string = JavaScriptBundle.message((String)"dialog.message.cannot.find.npx.bundled.with", (Object[])new Object[]{interpreter.getPresentableName()});
            if (string == null) {
                NpxNodePackage.$$$reportNull$$$0(13);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "npxArguments";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/boilerplate/NpxPackageDescriptor$NpxNodePackage";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 8: 
                case 9: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/boilerplate/NpxPackageDescriptor$NpxNodePackage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentablePath";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersionPromise";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArguments";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNpxNotFoundErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPackageName";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 13: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getArguments";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "isNpm7";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getNpxNotFoundErrorMessage";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 10: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class NpxCommand {
        private final String myPackageName;
        private final String myCommand;

        public NpxCommand(@NotNull String packageName, @NotNull String command) {
            if (packageName == null) {
                NpxCommand.$$$reportNull$$$0(0);
            }
            if (command == null) {
                NpxCommand.$$$reportNull$$$0(1);
            }
            this.myPackageName = packageName;
            this.myCommand = command;
        }

        @NotNull
        private NpxNodePackage createPackage() {
            if (this.myPackageName.equals(this.myCommand)) {
                return new NpxNodePackage(Collections.singletonList(this.myCommand));
            }
            return new NpxNodePackage(Arrays.asList("--package", this.myPackageName, this.myCommand));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "packageName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "command";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/boilerplate/NpxPackageDescriptor$NpxCommand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

