/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSStringUtil {
    public static final char SIMPLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    private static final Pattern EXT_UNICODE_CHAR = Pattern.compile("\\\\u\\{[0-9a-fA-F]+}");
    public static final Map<Condition<String>, JSLiteralExpressionKind> NUMERIC_MATCHERS = new LinkedHashMap<Condition<String>, JSLiteralExpressionKind>();

    private JSStringUtil() {
    }

    public static boolean isSingleQuoteStringLiteral(PsiElement expression) {
        String value = expression.getText();
        return value != null && value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'';
    }

    public static boolean isDoubleQuoteStringLiteral(PsiElement expression) {
        String value = expression.getText();
        return JSStringUtil.isDoubleQuotedString(value);
    }

    public static boolean isDoubleQuotedString(@Nullable String value) {
        return value != null && value.length() > 0 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    @NotNull
    public static String changeQuotes(String jsStringLiteral) {
        char newQuote;
        char oldQuote;
        if (jsStringLiteral.startsWith("'")) {
            oldQuote = '\'';
            newQuote = '\"';
        } else if (jsStringLiteral.startsWith("\"")) {
            oldQuote = '\"';
            newQuote = '\'';
        } else {
            String string = jsStringLiteral;
            if (string == null) {
                JSStringUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        StringBuilder stringBuilder = JSStringUtil.changeQuotesInternal(jsStringLiteral, oldQuote, newQuote, 1, jsStringLiteral.length() - 1);
        stringBuilder.setCharAt(0, newQuote);
        stringBuilder.setCharAt(stringBuilder.length() - 1, newQuote);
        String string = stringBuilder.toString();
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String changeQuotesInLiteralValue(String value, char oldQuote, char newQuote) {
        String string = JSStringUtil.changeQuotesInternal(value, oldQuote, newQuote, 0, value.length()).toString();
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static StringBuilder changeQuotesInternal(String source, char oldQuote, char newQuote, int startIndex, int endIndex) {
        StringBuilder buffer = new StringBuilder(source);
        boolean screened = false;
        int bufferIndex = startIndex;
        for (int i = startIndex; i < endIndex; ++i) {
            char c = source.charAt(i);
            if (screened) {
                if (c == oldQuote) {
                    buffer.deleteCharAt(bufferIndex - 1);
                } else {
                    ++bufferIndex;
                }
                screened = false;
                continue;
            }
            if (c == '\\') {
                screened = true;
            } else if (c == newQuote) {
                buffer.insert(bufferIndex++, '\\');
            }
            ++bufferIndex;
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            JSStringUtil.$$$reportNull$$$0(3);
        }
        return stringBuilder;
    }

    @NotNull
    public static String unescapeSimpleStringChars(@NotNull String chars) {
        if (chars == null) {
            JSStringUtil.$$$reportNull$$$0(4);
        }
        int index = 0;
        StringBuilder outChars = new StringBuilder();
        block12: while (index < chars.length()) {
            char c = chars.charAt(index);
            ++index;
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index >= chars.length()) break;
            c = chars.charAt(index);
            ++index;
            if (c == 'u' || c == 'x') {
                outChars.append('\\').append(c);
                continue;
            }
            switch (c) {
                case 'b': {
                    outChars.append('\b');
                    continue block12;
                }
                case 't': {
                    outChars.append('\t');
                    continue block12;
                }
                case 'n': {
                    outChars.append('\n');
                    continue block12;
                }
                case 'f': {
                    outChars.append('\f');
                    continue block12;
                }
                case 'r': {
                    outChars.append('\r');
                    continue block12;
                }
                case '\"': {
                    outChars.append('\"');
                    continue block12;
                }
                case '/': {
                    outChars.append('/');
                    continue block12;
                }
                case '\n': {
                    outChars.append('\n');
                    continue block12;
                }
                case '\'': {
                    outChars.append('\'');
                    continue block12;
                }
                case '\\': {
                    outChars.append('\\');
                    continue block12;
                }
            }
            outChars.append(c);
        }
        String string = outChars.toString();
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static String escapeTemplateStringChars(@NotNull String source, boolean escapeSlash, boolean escapeWhitespace, @NotNull PsiElement context) {
        if (source == null) {
            JSStringUtil.$$$reportNull$$$0(6);
        }
        if (context == null) {
            JSStringUtil.$$$reportNull$$$0(7);
        }
        StringBuilder result2 = new StringBuilder();
        int index = 0;
        while (index < source.length()) {
            char ch = source.charAt(index);
            if (ch == '$' && index < source.length() - 1 && source.charAt(index + 1) == '{' && (index == 0 || source.charAt(index - 1) != '/')) {
                int end = JSStringUtil.findTemplateArgumentEnd(source, index + 2, context);
                result2.append(source, index, end);
                index = end;
                continue;
            }
            JSStringUtil.escapeSingleChar(source, '`', escapeSlash, false, escapeWhitespace, false, result2, index);
            ++index;
        }
        return result2.toString();
    }

    private static int findTemplateArgumentEnd(@NotNull String source, int startIndex, @NotNull PsiElement context) {
        if (source == null) {
            JSStringUtil.$$$reportNull$$$0(8);
        }
        if (context == null) {
            JSStringUtil.$$$reportNull$$$0(9);
        }
        DialectOptionHolder dialect = (DialectOptionHolder)ObjectUtils.coalesce((Object)DialectDetector.dialectOfElement(context), (Object)JavaScriptSupportLoader.ECMA_SCRIPT_6.getOptionHolder());
        JSFlexAdapter lexer = new JSFlexAdapter(dialect);
        lexer.start(source, startIndex, source.length());
        int depth = 0;
        while (lexer.getTokenType() != null) {
            if (lexer.getTokenType() == JSTokenTypes.DOLLAR) {
                lexer.advance();
                if (lexer.getTokenType() == JSTokenTypes.LBRACE) {
                    ++depth;
                }
            } else if (lexer.getTokenType() == JSTokenTypes.LBRACE) {
                ++depth;
            } else if (lexer.getTokenType() == JSTokenTypes.RBRACE && --depth == -1) {
                return lexer.getTokenEnd();
            }
            lexer.advance();
        }
        return source.length();
    }

    public static void escapeSimpleStringChars(@NotNull String str, char quote, boolean escapeNewlines, boolean escapeWhitespace, boolean escapeTemplateStringArg, @NotNull StringBuilder buffer) {
        if (str == null) {
            JSStringUtil.$$$reportNull$$$0(10);
        }
        if (buffer == null) {
            JSStringUtil.$$$reportNull$$$0(11);
        }
        for (int idx = 0; idx < str.length(); ++idx) {
            JSStringUtil.escapeSingleChar(str, quote, true, escapeNewlines, escapeWhitespace, escapeTemplateStringArg, buffer, idx);
        }
    }

    private static void escapeSingleChar(@NotNull String str, char quote, boolean escapeSlash, boolean escapeNewlines, boolean escapeWhitespace, boolean escapeTemplateStringArg, @NotNull StringBuilder buffer, int idx) {
        char previous;
        if (str == null) {
            JSStringUtil.$$$reportNull$$$0(12);
        }
        if (buffer == null) {
            JSStringUtil.$$$reportNull$$$0(13);
        }
        char ch = str.charAt(idx);
        char c = previous = idx > 0 ? str.charAt(idx - 1) : (char)'\u0000';
        if (escapeSlash && ch == '\\') {
            char afterNext;
            char next = idx < str.length() - 1 ? str.charAt(idx + 1) : (char)'\u0000';
            char c2 = afterNext = idx < str.length() - 2 ? str.charAt(idx + 2) : (char)'\u0000';
            if ((next == 'u' || next == 'x') && StringUtil.isHexDigit((char)afterNext)) {
                buffer.append('\\');
            } else {
                buffer.append("\\\\");
            }
        } else if (ch == quote) {
            if (previous != '\\') {
                buffer.append("\\");
            }
            buffer.append(ch);
        } else if (escapeTemplateStringArg && ch == '{') {
            if (previous == '$') {
                buffer.append("\\").append(ch);
            } else {
                buffer.append(ch);
            }
        } else {
            if (escapeWhitespace) {
                if (ch == '\b') {
                    buffer.append("\\b");
                    return;
                }
                if (ch == '\t') {
                    buffer.append("\\t");
                    return;
                }
                if (ch == '\f') {
                    buffer.append("\\f");
                    return;
                }
                if (ch == '\r') {
                    buffer.append("\\r");
                    return;
                }
            }
            if (escapeNewlines && ch == '\n') {
                buffer.append("\\n");
                return;
            }
            buffer.append(ch);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteAndUnescapeString(@NotNull String s) {
        if (s == null) {
            JSStringUtil.$$$reportNull$$$0(14);
        }
        return JSStringUtil.unquoteString(s, true);
    }

    @NotNull
    @Contract(pure=true)
    private static String unquoteString(@NotNull String s, boolean unescape) {
        if (s == null) {
            JSStringUtil.$$$reportNull$$$0(15);
        }
        if (StringUtil.isQuotedString((String)s)) {
            String unquotedString = s.substring(1, s.length() - 1);
            String string = unescape ? JSStringUtil.unescapeStringLiteralValue(unquotedString) : unquotedString;
            if (string == null) {
                JSStringUtil.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = unescape ? JSStringUtil.replaceUnicodeEscapeSequences(s) : s;
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteAndUnescapeStringLiteralValue(@NotNull String quotedString) {
        if (quotedString == null) {
            JSStringUtil.$$$reportNull$$$0(18);
        }
        return JSStringUtil.unquoteAndUnescapeStringLiteralValue(quotedString, true);
    }

    public static boolean isStartedWithQuote(@Nullable CharSequence text) {
        return StringUtil.startsWithChar((CharSequence)text, (char)'\"') || StringUtil.startsWithChar((CharSequence)text, (char)'\'');
    }

    public static String replaceUnicodeEscapeSequences(@NotNull String text) {
        if (text == null) {
            JSStringUtil.$$$reportNull$$$0(19);
        }
        if (!text.contains("\\u")) {
            return text;
        }
        text = StringUtil.replaceUnicodeEscapeSequences((String)text);
        Matcher matcher = EXT_UNICODE_CHAR.matcher(text);
        int lastEnd = 0;
        StringBuilder sb = new StringBuilder(text.length());
        while (matcher.find()) {
            sb.append(text, lastEnd, matcher.start());
            String item = matcher.group().substring(3);
            item = item.substring(0, item.length() - 1);
            try {
                char c = (char)Integer.parseInt(item, 16);
                sb.append(c);
                lastEnd = matcher.end();
            }
            catch (NumberFormatException ex) {
                return text;
            }
        }
        sb.append(text.substring(lastEnd));
        return sb.toString();
    }

    @NotNull
    @Contract(pure=true)
    public static String unquoteStringLiteralValue(@NotNull String quotedString) {
        if (quotedString == null) {
            JSStringUtil.$$$reportNull$$$0(20);
        }
        return JSStringUtil.unquoteAndUnescapeStringLiteralValue(quotedString, false);
    }

    @NotNull
    @Contract(pure=true)
    private static String unquoteAndUnescapeStringLiteralValue(@NotNull String quotedString, boolean unescape) {
        char firstChar;
        if (quotedString == null) {
            JSStringUtil.$$$reportNull$$$0(21);
        }
        if (!(StringUtil.isQuotedString((String)quotedString) || quotedString.length() <= 0 || (firstChar = quotedString.charAt(0)) != '\"' && firstChar != '\'')) {
            String unquotedString = quotedString.substring(1);
            String string = unescape ? JSStringUtil.unescapeStringLiteralValue(unquotedString) : unquotedString;
            if (string == null) {
                JSStringUtil.$$$reportNull$$$0(22);
            }
            return string;
        }
        return JSStringUtil.unquoteString(quotedString, unescape);
    }

    @NotNull
    @Contract(pure=true)
    public static String unescapeStringLiteralValue(@NotNull String value) {
        if (value == null) {
            JSStringUtil.$$$reportNull$$$0(23);
        }
        return JSStringUtil.unescapeSimpleStringChars(JSStringUtil.replaceUnicodeEscapeSequences(value));
    }

    public static double parseNumericValue(@NotNull String value) throws NumberFormatException {
        if (value == null) {
            JSStringUtil.$$$reportNull$$$0(24);
        }
        return JSStringUtil.parseNumericValue(value, 0, false).getValue();
    }

    @NotNull
    public static String wrapQualifiedNameComponent(@NotNull String name) {
        if (name == null) {
            JSStringUtil.$$$reportNull$$$0(25);
        }
        boolean hasUnquotedDot = false;
        char quote = '\u0000';
        boolean isEscaped = false;
        for (int i = 0; i < name.length(); ++i) {
            if (isEscaped) continue;
            isEscaped = false;
            char c = name.charAt(i);
            if (quote == '\u0000') {
                if (!(c != '\"' && c != '\'' || i != 0 && name.charAt(i - 1) == '\\')) {
                    quote = c;
                    continue;
                }
                if (c != '.') continue;
                hasUnquotedDot = true;
                break;
            }
            if (c == '\\') {
                isEscaped = true;
                continue;
            }
            if (c != '\"' && c != '\'' || quote != c) continue;
            quote = '\u0000';
        }
        if (hasUnquotedDot || quote != '\u0000') {
            StringBuilder buf = new StringBuilder(name);
            StringUtil.escapeChar((StringBuilder)buf, (char)'\\');
            StringUtil.escapeChar((StringBuilder)buf, (char)'\"');
            buf.insert(0, '\"').append('\"');
            String string = buf.toString();
            if (string == null) {
                JSStringUtil.$$$reportNull$$$0(26);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    public static String unwrapQualifiedNameComponent(@NotNull String s) {
        if (s == null) {
            JSStringUtil.$$$reportNull$$$0(28);
        }
        if (s.length() >= 2 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            String body = s.substring(1, s.length() - 1);
            body = StringUtil.unescapeChar((String)body, (char)'\"');
            String string = body = StringUtil.unescapeChar((String)body, (char)'\\');
            if (string == null) {
                JSStringUtil.$$$reportNull$$$0(29);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public static NumberParseResult parseNumericValue(@NotNull String value, int startOffset, boolean allowPlus) throws NumberFormatException {
        char ch0;
        boolean signed;
        if (value == null) {
            JSStringUtil.$$$reportNull$$$0(31);
        }
        int offset = startOffset;
        int totalLength = value.length();
        if (totalLength == 0) {
            throw new NumberFormatException("Value cannot be empty");
        }
        if (offset >= totalLength) {
            throw new NumberFormatException("Offset " + offset + " cannot be greater than string length " + totalLength);
        }
        char sign = value.charAt(offset);
        boolean bl = signed = sign == '-' || allowPlus && sign == '+';
        if (signed) {
            ++offset;
        }
        if (Character.isDigit(ch0 = value.charAt(offset)) || ch0 == '.') {
            String s;
            char ch = ch0;
            StringBuilder builder = new StringBuilder();
            if (signed) {
                builder.append(sign);
            }
            if (ch == '0') {
                if (++offset >= totalLength) {
                    return new NumberParseResult(0.0);
                }
                ch = value.charAt(offset);
                if (ch == '.') {
                    builder.append("0");
                } else {
                    int radix;
                    Function allowedCharFilter;
                    switch (ch) {
                        case 'B': 
                        case 'b': {
                            allowedCharFilter = c -> c.charValue() == '0' || c.charValue() == '1';
                            radix = 2;
                            break;
                        }
                        case 'O': 
                        case 'o': {
                            allowedCharFilter = StringUtil::isOctalDigit;
                            radix = 8;
                            break;
                        }
                        case 'X': 
                        case 'x': {
                            allowedCharFilter = StringUtil::isHexDigit;
                            radix = 16;
                            break;
                        }
                        default: {
                            return new NumberParseResult(0.0);
                        }
                    }
                    if (++offset < totalLength) {
                        ch = value.charAt(offset);
                        while (((Boolean)allowedCharFilter.fun((Object)Character.valueOf(ch))).booleanValue()) {
                            builder.append(ch);
                            if (++offset >= totalLength) break;
                            ch = value.charAt(offset);
                            if (ch != '_') continue;
                            if (++offset >= totalLength) break;
                            ch = value.charAt(offset);
                        }
                    }
                    String s2 = builder.toString();
                    return new NumberParseResult(Long.parseLong(s2, radix));
                }
            }
            if (ch == '.') {
                if (++offset < totalLength) {
                    builder.append(ch);
                    ch = value.charAt(offset);
                } else if (totalLength == 1) {
                    throw new NumberFormatException("Invalid numeric value " + value);
                }
            }
            boolean hadDot = false;
            boolean hadExp = false;
            while (Character.isDigit(ch)) {
                builder.append(ch);
                if (++offset >= totalLength) break;
                ch = value.charAt(offset);
                if (ch == '_') {
                    if (++offset >= totalLength) break;
                    ch = value.charAt(offset);
                }
                if (!hadDot && ch == '.') {
                    builder.append(ch);
                    if (++offset >= totalLength) break;
                    ch = value.charAt(offset);
                    hadDot = true;
                    continue;
                }
                if (hadExp || ch != 'e' && ch != 'E') continue;
                if (++offset >= totalLength) {
                    s = builder.toString();
                    return new NumberParseResult(Double.parseDouble(s));
                }
                ch = value.charAt(offset);
                hadDot = true;
                hadExp = true;
                Character signChar = null;
                if (ch == '+' || ch == '-') {
                    signChar = Character.valueOf(ch);
                    if (++offset >= totalLength) break;
                    ch = value.charAt(offset);
                }
                if (!Character.isDigit(ch)) {
                    String s3 = builder.toString();
                    return new NumberParseResult(Double.parseDouble(s3));
                }
                builder.append("e");
                if (signChar == null) continue;
                builder.append(signChar);
            }
            s = builder.toString();
            return new NumberParseResult(Double.parseDouble(s));
        }
        throw new NumberFormatException("Invalid numeric value " + value);
    }

    public static boolean isNumericValueStart(@NotNull String value, boolean allowPlus) {
        if (value == null) {
            JSStringUtil.$$$reportNull$$$0(32);
        }
        return JSStringUtil.isNumericValueStart(value, allowPlus, 0);
    }

    public static boolean isNumericValueStart(@NotNull String value, boolean allowPlus, int offset) {
        int length;
        if (value == null) {
            JSStringUtil.$$$reportNull$$$0(33);
        }
        if ((length = value.length()) <= offset) {
            return false;
        }
        int shift = offset;
        char ch0 = value.charAt(shift);
        if (ch0 == '-' || allowPlus && ch0 == '+') {
            if (length < shift + 2) {
                return false;
            }
            ch0 = value.charAt(shift + 1);
            ++shift;
        }
        if (Character.isDigit(ch0)) {
            return true;
        }
        if (length <= shift + 1) {
            return false;
        }
        char ch1 = value.charAt(shift + 1);
        return ch0 == '.' && Character.isDigit(ch1);
    }

    private static boolean numberMatchesByPrefix(String text, String prefix1, String prefix2, boolean allowE) {
        if (StringUtil.containsChar((String)text, (char)'.')) {
            return false;
        }
        if (!allowE && (StringUtil.containsChar((String)text, (char)'e') || StringUtil.containsChar((String)text, (char)'E'))) {
            return false;
        }
        return StringUtil.startsWith((CharSequence)text, (CharSequence)prefix1) || StringUtil.startsWith((CharSequence)text, (CharSequence)prefix2);
    }

    static {
        NUMERIC_MATCHERS.put((Condition<String>)((Condition)s -> "0".equals(s)), JSLiteralExpressionKind.DEC);
        NUMERIC_MATCHERS.put((Condition<String>)((Condition)s -> "0n".equals(s)), JSLiteralExpressionKind.DEC_BIGINT);
        NUMERIC_MATCHERS.put((Condition<String>)((Condition)s -> JSStringUtil.numberMatchesByPrefix(s, "0x", "0X", true)), JSLiteralExpressionKind.HEX);
        NUMERIC_MATCHERS.put((Condition<String>)((Condition)s -> JSStringUtil.numberMatchesByPrefix(s, "0b", "0B", false)), JSLiteralExpressionKind.BIN);
        NUMERIC_MATCHERS.put((Condition<String>)((Condition)s -> JSStringUtil.numberMatchesByPrefix(s, "0o", "0O", false)), JSLiteralExpressionKind.OCT);
        NUMERIC_MATCHERS.put((Condition<String>)((Condition)s -> s.length() > 1 && s.charAt(0) == '0' && s.charAt(1) != '.'), JSLiteralExpressionKind.OBSOLETE_OCT);
        NUMERIC_MATCHERS.put((Condition<String>)((Condition)s -> !StringUtil.containsAnyChar((String)s, (String)".eE")), JSLiteralExpressionKind.DEC);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSStringUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 14: 
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotedString";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: 
            case 24: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "changeQuotes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "changeQuotesInLiteralValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "changeQuotesInternal";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSStringUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeSimpleStringChars";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteAndUnescapeStringLiteralValue";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapQualifiedNameComponent";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapQualifiedNameComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unescapeSimpleStringChars";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "escapeTemplateStringChars";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findTemplateArgumentEnd";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "escapeSimpleStringChars";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "escapeSingleChar";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "unquoteAndUnescapeString";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
            case 18: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "unquoteAndUnescapeStringLiteralValue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "replaceUnicodeEscapeSequences";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "unquoteStringLiteralValue";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "unescapeStringLiteralValue";
                break;
            }
            case 24: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "parseNumericValue";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "wrapQualifiedNameComponent";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "unwrapQualifiedNameComponent";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isNumericValueStart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NumberParseResult {
        private final double value;

        public NumberParseResult(double value) {
            this.value = value;
        }

        public double getValue() {
            return this.value;
        }
    }
}

