/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNumberParser {
    @Nullable
    public static Double tryParseNumericValue(@NotNull String value, boolean throwOnError) {
        if (value == null) {
            JSNumberParser.$$$reportNull$$$0(0);
        }
        try {
            return JSStringUtil.parseNumericValue(value);
        }
        catch (Exception e) {
            if (throwOnError && ApplicationManager.getApplication().isUnitTestMode()) {
                throw e;
            }
            return null;
        }
    }

    @NotNull
    private static String getNumericLiteralText(@NotNull String text, JSLiteralExpressionKind kind) {
        int endIndex;
        if (text == null) {
            JSNumberParser.$$$reportNull$$$0(1);
        }
        if (!kind.isNumeric()) {
            String string = text;
            if (string == null) {
                JSNumberParser.$$$reportNull$$$0(2);
            }
            return string;
        }
        int n = endIndex = kind.isBigInteger() ? text.length() - 1 : text.length();
        if (kind.isBin() || kind.isHex() || kind == JSLiteralExpressionKind.OCT || kind == JSLiteralExpressionKind.OCT_BIGINT) {
            String string = text.substring(2, endIndex);
            if (string == null) {
                JSNumberParser.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (kind == JSLiteralExpressionKind.OBSOLETE_OCT) {
            String string = text.substring(1, endIndex);
            if (string == null) {
                JSNumberParser.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = text.substring(0, endIndex);
        if (string == null) {
            JSNumberParser.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static BigInteger tryParseBigInt(String valueText) {
        return JSNumberParser.tryParseBigInt(valueText, JSLiteralExpressionImpl.getNumericExpressionKind(valueText));
    }

    @Nullable
    public static BigInteger tryParseBigInt(String expressionText, JSLiteralExpressionKind kind) {
        if (!kind.isBigInteger()) {
            return null;
        }
        int radix = 10;
        if (kind.isHex()) {
            radix = 16;
        }
        if (kind.isOct()) {
            radix = 8;
        }
        if (kind.isBin()) {
            radix = 2;
        }
        String prefix = "";
        if (StringUtil.startsWithChar((CharSequence)expressionText, (char)'-')) {
            expressionText = expressionText.substring(1);
            prefix = "-";
        }
        Object numberValue = JSNumberParser.getNumericLiteralText(expressionText, kind);
        numberValue = prefix + StringUtil.replace((String)numberValue, (String)"_", (String)"");
        try {
            return new BigInteger((String)numberValue, radix);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSNumberParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSNumberParser";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumericLiteralText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryParseNumericValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNumericLiteralText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

