/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.psi.ES6DoExpression;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6NamespaceExport;
import com.intellij.lang.ecmascript6.psi.Es6MetaProperty;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.evaluation.JSCodeBasedTypeFactory;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.FlowJSDeclareExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluationHelper;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.ES6ImportCallType;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.intellij.lang.regexp.RegExpFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6TypeEvaluator
extends JSTypeEvaluator {
    public ES6TypeEvaluator(@NotNull JSEvaluateContext context, @NotNull JSTypeProcessor processor) {
        if (context == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(1);
        }
        super(context, processor);
    }

    @Deprecated
    public ES6TypeEvaluator(JSEvaluateContext context, JSTypeProcessor processor, JSTypeEvaluationHelper helper) {
        super(context, processor);
    }

    @Override
    protected void addTypeFromElementResolveResult(@Nullable PsiElement resolveResult) {
        if (resolveResult instanceof ES6NamespaceExport) {
            Collection elements = ((ES6NamespaceExport)resolveResult).findReferencedElements();
            for (PsiElement element : elements) {
                this.addTypeFromResolveResult(element);
            }
        }
        if (resolveResult instanceof ES6ExportSpecifierAlias) {
            if ((resolveResult = resolveResult.getParent()) instanceof ES6ExportSpecifier) {
                ES6ExportSpecifier specifier = (ES6ExportSpecifier)resolveResult;
                ES6TypeEvaluator.processWithEvaluationGuard((PsiElement)specifier, this.myContext, () -> {
                    ResolveResult[] exportSpecifierResults;
                    for (ResolveResult result2 : exportSpecifierResults = specifier.multiResolve(false)) {
                        PsiElement element;
                        if (!result2.isValidResult() || (element = result2.getElement()) == null) continue;
                        this.addTypeFromResolveResult(element);
                    }
                    return null;
                });
            }
        } else if (resolveResult instanceof ES6ImportedExportedDefaultBinding) {
            String type;
            JSDocComment docComment;
            Collection referencedElements = ((ES6ImportedExportedDefaultBinding)resolveResult).findReferencedElements();
            for (PsiElement referencedElement : referencedElements) {
                this.addTypeFromResolveResult(referencedElement);
            }
            PsiElement parent = resolveResult.getParent();
            if (parent instanceof ES6ImportDeclaration && ((ES6ImportDeclaration)parent).getImportSpecifiers().length == 0 && (!DialectDetector.isTypeScript(parent) || referencedElements.size() == 0) && (docComment = JSStubBasedPsiTreeUtil.findDocComment(parent)) != null && (type = docComment.getType()) != null) {
                this.addType(JSTypeUtils.createType(type, JSTypeSourceFactory.createTypeSource((PsiElement)docComment, true)), resolveResult);
            }
            this.addTypeFromLocalName((PsiNamedElement)resolveResult);
        } else if (resolveResult instanceof ES6ImportSpecifierAlias) {
            this.addTypeFromES6ImportSpecifier((ES6ImportSpecifierAlias)resolveResult);
        } else if (resolveResult instanceof JSExportAssignment) {
            this.evaluateExportAssignment((JSExportAssignment)resolveResult);
        } else {
            super.addTypeFromElementResolveResult(resolveResult);
        }
    }

    private void addTypeFromES6ImportSpecifier(ES6ImportSpecifierAlias resolveResult) {
        PsiElement aliasedElement = resolveResult.findAliasedElement();
        if (aliasedElement != null) {
            ES6TypeEvaluator.processWithEvaluationGuard(aliasedElement, this.myContext, () -> {
                this.addTypeFromResolveResult(aliasedElement);
                return null;
            });
        }
        this.addTypeFromLocalName((PsiNamedElement)resolveResult);
    }

    protected void evaluateExportAssignment(@NotNull JSExportAssignment assignment) {
        JSType type;
        if (assignment == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(2);
        }
        JSElement element = assignment.getStubSafeElement();
        if (assignment instanceof FlowJSDeclareExportDeclaration) {
            JSType type2 = assignment.getJSType();
            if (type2 != null) {
                this.addType(type2, EXPLICIT_TYPE_MARKER_ELEMENT);
            }
            return;
        }
        if (element instanceof JSClass || element != null && !(element instanceof JSExpression)) {
            this.addTypeFromResolveResult((PsiElement)element);
            return;
        }
        if (element instanceof JSFunction) {
            this.processFunction((JSFunction)element);
            return;
        }
        if (element instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)element, false);
            return;
        }
        if (DialectDetector.isTypeScript((PsiElement)assignment)) {
            String reference = assignment.getInitializerReference();
            if (reference != null) {
                JSTypeResolveResult result2 = TypeScriptImportHandler.getInstance().resolveName(reference, (PsiElement)assignment);
                Collection<? extends PsiElement> elements = result2.getElements();
                for (PsiElement psiElement : elements) {
                    JSType type3 = JSResolveUtil.getElementJSType(psiElement, this.isContextualOverloadEvaluation());
                    this.addType(type3, null);
                }
                return;
            }
        } else if (element instanceof JSAssignmentExpression) {
            JSDefinitionExpression definitionExpression = ((JSAssignmentExpression)element).getDefinitionExpression();
            if (definitionExpression != null) {
                this.addTypeFromDefExpr(definitionExpression);
                return;
            }
        } else if (element != null) {
            this.runWithContext(this.myContext.withTargetFile(element.getContainingFile()), () -> this.addType(JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)element, this.myContext), null));
            return;
        }
        if ((type = assignment.getJSType()) != null) {
            this.addType(type, (PsiElement)assignment);
        }
    }

    @Override
    protected boolean evaluateDialectSpecificTypes(JSExpression rawqualifier) {
        JSType expressionType;
        if (rawqualifier instanceof JSSpreadExpression && (expressionType = this.getExpressionTypeInContext(((JSSpreadExpression)rawqualifier).getExpression())) != null) {
            this.addType(new JSSpreadTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true), expressionType), (PsiElement)rawqualifier);
            return true;
        }
        if (rawqualifier instanceof Es6MetaProperty && ((Es6MetaProperty)rawqualifier).getKind() == Es6MetaProperty.Kind.ImportMeta) {
            this.addType(JSNamedTypeFactory.createType("ImportMeta", JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, DialectDetector.isTypeScript((PsiElement)rawqualifier)), JSTypeContext.INSTANCE), (PsiElement)rawqualifier);
        } else {
            if (rawqualifier instanceof JSClassExpression) {
                this.addTypeFromClassExpression((JSClassExpression)rawqualifier);
                return true;
            }
            if (rawqualifier instanceof ES6DoExpression) {
                JSExpression expression;
                JSExpressionStatement expressionStatement;
                ES6DoExpression doExpression = (ES6DoExpression)rawqualifier;
                JSSourceElement lastStatement = (JSSourceElement)ArrayUtil.getLastElement((Object[])doExpression.getStatementListItems());
                JSExpressionStatement jSExpressionStatement = expressionStatement = lastStatement instanceof JSExpressionStatement ? (JSExpressionStatement)lastStatement : null;
                if (expressionStatement != null && (expression = expressionStatement.getExpression()) != null) {
                    this.evaluateTypes(expression);
                }
            } else {
                if (rawqualifier instanceof ES6ImportCall) {
                    boolean isImportType;
                    ES6ImportCall importCall = (ES6ImportCall)rawqualifier;
                    ES6ImportCallType type = new ES6ImportCallType(importCall);
                    boolean bl = isImportType = importCall.getContext() != null && importCall.getContext().getContext() instanceof TypeScriptSingleType;
                    if (!isImportType) {
                        type = JSTypeUtils.wrapInPromiseType(type, type.getSource());
                    }
                    this.addType(type, null);
                    return true;
                }
                if (rawqualifier instanceof ES6TaggedTemplateExpression) {
                    this.addCodeBasedType(rawqualifier);
                    return true;
                }
            }
        }
        return super.evaluateDialectSpecificTypes(rawqualifier);
    }

    @Override
    protected void evaluateCallExpressionTypes(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(3);
        }
        if (DialectDetector.isTypeScript((PsiElement)callExpression) && this.addUniqueSymbolForConst(callExpression)) {
            return;
        }
        super.evaluateCallExpressionTypes(callExpression);
    }

    private boolean addUniqueSymbolForConst(@NotNull JSCallExpression callExpression) {
        JSFieldVariable variable;
        if (callExpression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(4);
        }
        if ((variable = (JSFieldVariable)PsiTreeUtil.getContextOfType((PsiElement)callExpression, (Class[])new Class[]{JSFieldVariable.class})) == null || !variable.isConst() || variable.getInitializerOrStub() != callExpression) {
            return false;
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return false;
        }
        JSReferenceExpression invoked = (JSReferenceExpression)methodExpression;
        String referencedName = invoked.getReferenceName();
        if (!"Symbol".equals(referencedName)) {
            return false;
        }
        this.addType(new JSUniqueSymbolTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)variable, true), JSTypeContext.INSTANCE, true), (PsiElement)variable);
        return true;
    }

    @Nullable
    public static JSType getTypeForRegexpGroups(@NotNull JSLiteralExpression regexp) {
        RegExpFile injectedRegexpFile;
        if (regexp == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(5);
        }
        if ((injectedRegexpFile = ES6TypeEvaluator.findInjectedRegexpFile((PsiElement)regexp)) == null) {
            return null;
        }
        return ES6TypeEvaluator.getTypeForRegexpGroups((PsiElement)regexp, injectedRegexpFile);
    }

    @Nullable
    public static JSLiteralExpression findLiteralForRegexpExecCall(@NotNull JSReferenceExpression methodExpression) {
        if (methodExpression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(6);
        }
        if (!"exec".equals(methodExpression.getReferenceName()) || !DialectDetector.isES6((PsiElement)methodExpression)) {
            return null;
        }
        boolean isRegexpExec = ContainerUtil.exists((Object[])methodExpression.multiResolve(false), r -> {
            PsiElement element = r.getElement();
            if (!(element instanceof TypeScriptFunction)) {
                return false;
            }
            JSQualifiedName ns = ((TypeScriptFunction)element).getJSNamespace().getQualifiedName();
            return ns != null && ns.getParent() == null && "RegExp".equals(ns.getName());
        });
        if (!isRegexpExec) {
            return null;
        }
        JSExpression qualifier = methodExpression.getQualifier();
        if (qualifier == null) {
            return null;
        }
        JSType qualifierType = JSResolveUtil.getExpressionJSType(qualifier);
        if (qualifierType == null) {
            return null;
        }
        PsiElement sourceElement = qualifierType.getSourceElement();
        if (!(sourceElement instanceof JSLiteralExpression) || !((JSLiteralExpression)sourceElement).isRegExpLiteral()) {
            return null;
        }
        return (JSLiteralExpression)sourceElement;
    }

    @NotNull
    private static JSType getTypeForRegexpGroups(@NotNull PsiElement context, @NotNull RegExpFile injectedFile) {
        if (context == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(7);
        }
        if (injectedFile == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(8);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(context, true);
        List properties = ContainerUtil.mapNotNull((Collection)injectedFile.getGroups(), group -> {
            String name = group.isAnyNamedGroup() ? group.getGroupName() : null;
            JSType jsStringType = JSNamedTypeFactory.createType("string", typeSource, JSTypeContext.INSTANCE);
            if (name == null) {
                return null;
            }
            JSLocalImplicitElementImpl groupElement = new JSLocalImplicitElementImpl(name, jsStringType, context, JSImplicitElement.Type.Property);
            return new JSRecordTypeImpl.PropertySignatureImpl(name, jsStringType, true, false, (PsiElement)groupElement);
        });
        JSSimpleRecordTypeImpl groupsType = new JSSimpleRecordTypeImpl(typeSource, properties);
        JSLocalImplicitElementImpl groupsElement = new JSLocalImplicitElementImpl("groups", groupsType, context, JSImplicitElement.Type.Property);
        return new JSSimpleRecordTypeImpl(typeSource, Collections.singletonList(new JSRecordTypeImpl.PropertySignatureImpl("groups", (JSType)groupsType, false, false, (PsiElement)groupsElement)));
    }

    @Nullable
    private static RegExpFile findInjectedRegexpFile(@NotNull PsiElement expression) {
        List files;
        if (expression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(9);
        }
        return (files = InjectedLanguageManager.getInstance((Project)expression.getProject()).getInjectedPsiFiles(expression)) == null || files.isEmpty() ? null : (RegExpFile)ObjectUtils.tryCast((Object)((Pair)files.get((int)0)).first, RegExpFile.class);
    }

    @Override
    public void addTypeFromClassExpression(@NotNull JSClassExpression classExpression) {
        String qualifiedName;
        if (classExpression == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(10);
        }
        if ((qualifiedName = classExpression.getQualifiedName()) == null || ES6PsiUtil.isLocalClass((JSClass)classExpression)) {
            this.addType(new JSClassExpressionType(classExpression, JSContext.STATIC), null);
            return;
        }
        this.addTypeFromClassWithQName((JSClass)classExpression);
    }

    @Override
    protected void addTypeFromClassCandidate(@NotNull JSClass resolveResult) {
        if (resolveResult == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(11);
        }
        if (resolveResult instanceof JSClassExpression) {
            this.addTypeFromClassExpression((JSClassExpression)resolveResult);
        } else {
            this.addTypeFromClassWithQName(resolveResult);
        }
    }

    protected void addTypeFromClassWithQName(@NotNull JSClass resolveResult) {
        JSNamespace namespace;
        if (resolveResult == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(12);
        }
        if ((namespace = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)resolveResult, true)) == null || namespace.getQualifiedName() == null) {
            return;
        }
        this.addType((JSType)namespace, (PsiElement)resolveResult);
    }

    @Override
    protected void processSuperQualifierExpression(JSSuperExpression rawqualifier, @Nullable JSClass jsClass) {
        if (jsClass != null) {
            for (JSClass aClass : jsClass.getSuperClasses()) {
                this.addTypeFromClassCandidate(aClass);
            }
        }
    }

    @Override
    protected void addTypeFromLiteralExpression(@NotNull JSExpression rawQualifier) {
        if (rawQualifier == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(13);
        }
        if (rawQualifier instanceof JSXXmlLiteralExpressionImpl) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rawQualifier, true);
            this.addType(JSNamedTypeFactory.createType("JSX.Element", source, JSTypeContext.INSTANCE), (PsiElement)rawQualifier);
            return;
        }
        super.addTypeFromLiteralExpression(rawQualifier);
    }

    @Override
    public void addTypeFromExternalModuleReferenceResolveResult(@NotNull PsiElement resolve, boolean fromRequire) {
        if (resolve == null) {
            ES6TypeEvaluator.$$$reportNull$$$0(14);
        }
        if (resolve instanceof JSExportAssignment) {
            this.evaluateExportAssignment((JSExportAssignment)resolve);
            return;
        }
        super.addTypeFromExternalModuleReferenceResolveResult(resolve, fromRequire);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexp";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classExpression";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawQualifier";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/ES6TypeEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateExportAssignment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateCallExpressionTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addUniqueSymbolForConst";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeForRegexpGroups";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findLiteralForRegexpExecCall";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findInjectedRegexpFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypeFromClassExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypeFromClassCandidate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypeFromClassWithQName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypeFromLiteralExpression";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypeFromExternalModuleReferenceResolveResult";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

