/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.lang.ecmascript6.refactoring.FilePathWithBrowseButton;
import com.intellij.lang.ecmascript6.refactoring.FilePathWithCompletionField;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.FlowJSFileType;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ES6MoveSymbolDialog
extends RefactoringDialog {
    private static final String MOVE_ES6_MEMBERS = "Move.ES6.Members";
    private static final String RECENT_KEYS = "es6.move.members.recent.items";
    private static final List<FileType> JS_FILE_TYPES_WITHOUT_FLOW = ContainerUtil.filter((Object[])DialectDetector.JAVASCRIPT_FILE_TYPES_ARRAY, t -> t != FlowJSFileType.INSTANCE);
    @NotNull
    protected final FilePathWithBrowseButton myModuleField;
    @NotNull
    protected final JPanel myCenterPanel;
    @NotNull
    protected final JPanel myNorthPanel;
    @NotNull
    protected final JBTextField myFromField;

    @NotNull
    public static FilePathWithBrowseButton createDestinationFileField(@NotNull PsiElement context, String defaultPath) {
        if (context == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(0);
        }
        FileType[] fileTypes = ES6MoveSymbolDialog.getSupportedFileTypes(context);
        FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)context.getProject());
        VirtualFile sourceVFile = context.getContainingFile().getVirtualFile();
        boolean isSourceFileExcluded = sourceVFile != null && fileIndex.isExcluded(sourceVFile);
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withFileFilter(virtualFile -> {
            if (ContainerUtil.find((Object[])fileTypes, fileType -> fileTypeRegistry.isFileOfType(virtualFile, fileType)) != null) {
                return isSourceFileExcluded || !fileIndex.isExcluded(virtualFile);
            }
            return false;
        });
        descriptor2.setRoots(ProjectRootManager.getInstance((Project)context.getProject()).getContentRoots());
        descriptor2.withTreeRootVisible(true);
        TextComponentAccessor<FilePathWithCompletionField> accessor = new TextComponentAccessor<FilePathWithCompletionField>(){

            public String getText(FilePathWithCompletionField component) {
                return component.getText();
            }

            public void setText(FilePathWithCompletionField component, @NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                component.setText(text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/ecmascript6/refactoring/ES6MoveSymbolDialog$1", "setText"));
            }
        };
        FilePathWithBrowseButton moduleField = new FilePathWithBrowseButton(context.getProject(), descriptor2, defaultPath);
        List entries = RecentsManager.getInstance((Project)context.getProject()).getRecentEntries(RECENT_KEYS);
        String message = JavaScriptBundle.message((String)"es6.move.module.members.refactoring.dialog.move.member.to", (Object[])new Object[0]);
        FilePathWithCompletionField component = (FilePathWithCompletionField)((Object)moduleField.getChildComponent());
        if (entries != null) {
            for (String item : entries) {
                if (item.equals(defaultPath)) continue;
                component.addItem(item);
            }
        }
        moduleField.addBrowseFolderListener(message, null, context.getProject(), descriptor2, (TextComponentAccessor)accessor);
        FilePathWithBrowseButton filePathWithBrowseButton = moduleField;
        if (filePathWithBrowseButton == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(1);
        }
        return filePathWithBrowseButton;
    }

    ES6MoveSymbolDialog(@NotNull Project project, @NotNull String fromPath, @NotNull String toPath, @NotNull PsiElement context) {
        if (project == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(2);
        }
        if (fromPath == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(3);
        }
        if (toPath == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(4);
        }
        if (context == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(5);
        }
        super(project, true, true);
        this.myCenterPanel = new JPanel(new BorderLayout(5, 0));
        FormBuilder builder = FormBuilder.createFormBuilder();
        this.myFromField = new JBTextField();
        this.myFromField.setText(fromPath);
        this.myFromField.setEnabled(false);
        this.myModuleField = ES6MoveSymbolDialog.createDestinationFileField(context, toPath);
        this.myModuleField.setText(toPath);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myModuleField);
        builder.addLabeledComponent(JavaScriptBundle.message((String)"es6.move.module.members.refactoring.dialog.field.from", (Object[])new Object[0]), (JComponent)this.myFromField);
        builder.addLabeledComponent(JavaScriptBundle.message((String)"es6.move.module.members.refactoring.dialog.field.to", (Object[])new Object[0]), (JComponent)((Object)this.myModuleField));
        this.myNorthPanel = builder.getPanel();
    }

    @NotNull
    protected String getRefactoringId() {
        return MOVE_ES6_MEMBERS;
    }

    protected static FileType[] getSupportedFileTypes(@NotNull PsiElement sourceModuleOrFile) {
        if (sourceModuleOrFile == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(6);
        }
        HashSet<Object> result2 = new HashSet<Object>();
        result2.add(sourceModuleOrFile.getContainingFile().getFileType());
        if (DialectDetector.isTypeScript(sourceModuleOrFile)) {
            result2.addAll(Arrays.asList(TypeScriptUtil.TYPESCRIPT_FILE_TYPES_ARRAY));
        } else if (DialectDetector.isFlow(sourceModuleOrFile)) {
            result2.add(FlowJSFileType.INSTANCE);
        } else {
            result2.addAll(JS_FILE_TYPES_WITHOUT_FLOW);
        }
        return result2.toArray(FileType.EMPTY_ARRAY);
    }

    protected void doAction() {
        String text = ((FilePathWithCompletionField)((Object)this.myModuleField.getChildComponent())).getText();
        if (!StringUtil.isEmpty((String)text)) {
            RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENT_KEYS, text);
        }
    }

    protected void init() {
        super.init();
    }

    public void show() {
        super.show();
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return this.myNorthPanel;
    }

    protected JComponent createCenterPanel() {
        return this.myCenterPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myModuleField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveSymbolDialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceModuleOrFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveSymbolDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDestinationFileField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDestinationFileField";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedFileTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

