/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ModuleMemberInfo
extends MemberInfoBase<JSQualifiedNamedElement> {
    public ES6ModuleMemberInfo(@NotNull JSQualifiedNamedElement member) {
        if (member == null) {
            ES6ModuleMemberInfo.$$$reportNull$$$0(0);
        }
        super((PsiElement)member);
        this.displayName = new JSNamedElementPresenter((PsiElement)member).getShortName();
    }

    public static ES6ModuleMemberInfo create(@NotNull JSQualifiedNamedElement element) {
        if (element == null) {
            ES6ModuleMemberInfo.$$$reportNull$$$0(1);
        }
        return new ES6ModuleMemberInfo(element);
    }

    @NotNull
    public static List<ES6ModuleMemberInfo> getModuleMembers(@NotNull PsiElement module, @NotNull Collection<JSQualifiedNamedElement> selectedElements) {
        if (module == null) {
            ES6ModuleMemberInfo.$$$reportNull$$$0(2);
        }
        if (selectedElements == null) {
            ES6ModuleMemberInfo.$$$reportNull$$$0(3);
        }
        ArrayList<ES6ModuleMemberInfo> result2 = new ArrayList<ES6ModuleMemberInfo>();
        for (PsiElement element : module.getChildren()) {
            JSQualifiedNamedElement candidate = ES6ModuleMemberInfo.getMember(element);
            if (candidate == null || !ES6PsiUtil.isElementCanBeExported((PsiElement)candidate)) continue;
            ES6ModuleMemberInfo el = ES6ModuleMemberInfo.create(candidate);
            if (selectedElements.contains(candidate)) {
                el.setChecked(true);
            }
            result2.add(el);
        }
        ArrayList<ES6ModuleMemberInfo> arrayList = result2;
        if (arrayList == null) {
            ES6ModuleMemberInfo.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public static JSQualifiedNamedElement getMember(@NotNull PsiElement element) {
        if (element == null) {
            ES6ModuleMemberInfo.$$$reportNull$$$0(5);
        }
        PsiElement candidate = element;
        if (element instanceof JSVarStatement) {
            JSVariable[] variables = ((JSVarStatement)element).getVariables();
            if (variables.length != 1) {
                return null;
            }
            candidate = variables[0];
        }
        if (element instanceof ES6ExportDefaultAssignment) {
            JSElement defaultElement = ((ES6ExportDefaultAssignment)element).getStubSafeElement();
            return defaultElement instanceof JSQualifiedNamedElement ? (JSQualifiedNamedElement)defaultElement : null;
        }
        return candidate instanceof JSQualifiedNamedElement ? (JSQualifiedNamedElement)candidate : null;
    }

    @NotNull
    public static PsiElement getTopLevelDeclaration(@NotNull JSQualifiedNamedElement element) {
        PsiElement parent;
        if (element == null) {
            ES6ModuleMemberInfo.$$$reportNull$$$0(6);
        }
        if ((parent = element.getParent()) instanceof ES6ExportDefaultAssignment || parent instanceof JSVarStatement) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                ES6ModuleMemberInfo.$$$reportNull$$$0(7);
            }
            return psiElement;
        }
        JSQualifiedNamedElement jSQualifiedNamedElement = element;
        if (jSQualifiedNamedElement == null) {
            ES6ModuleMemberInfo.$$$reportNull$$$0(8);
        }
        return jSQualifiedNamedElement;
    }

    @NotNull
    public static MovedElementRange findMovedRange(@NotNull JSQualifiedNamedElement element) {
        PsiElement nextCandidate;
        if (element == null) {
            ES6ModuleMemberInfo.$$$reportNull$$$0(9);
        }
        PsiElement topLevelDeclaration = ES6ModuleMemberInfo.getTopLevelDeclaration(element);
        PsiElement first = JSPsiImplUtils.findLeadingCommentOrSelf(topLevelDeclaration, true);
        PsiElement last = topLevelDeclaration;
        while (ES6ModuleMemberInfo.isTargetPropertyDefinition(nextCandidate = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)last), element)) {
            last = nextCandidate;
        }
        last = (PsiElement)ObjectUtils.coalesce((Object)JSPsiImplUtils.findTrailingEndOfLineComment(last), (Object)last);
        return new MovedElementRange(element, first, last);
    }

    private static boolean isTargetPropertyDefinition(@Nullable PsiElement candidate, @NotNull JSQualifiedNamedElement target) {
        if (target == null) {
            ES6ModuleMemberInfo.$$$reportNull$$$0(10);
        }
        if (!(candidate instanceof JSExpressionStatement)) {
            return false;
        }
        JSExpression expression = ((JSExpressionStatement)candidate).getExpression();
        if (!(expression instanceof JSAssignmentExpression)) {
            return false;
        }
        JSDefinitionExpression definitionExpression = ((JSAssignmentExpression)expression).getDefinitionExpression();
        if (definitionExpression == null) {
            return false;
        }
        JSQualifiedName namespace = definitionExpression.getNamespace();
        if (namespace == null) {
            return false;
        }
        List components = namespace.toComponents();
        return components.size() > 0 && StringUtil.equals((CharSequence)((CharSequence)components.get(0)), (CharSequence)target.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedElements";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/refactoring/ES6ModuleMemberInfo";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6ModuleMemberInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleMembers";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModuleMembers";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMember";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelDeclaration";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findMovedRange";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTargetPropertyDefinition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MovedElementRange {
        @NotNull
        public final JSQualifiedNamedElement main;
        @NotNull
        public final PsiElement first;
        @NotNull
        public final PsiElement last;

        public MovedElementRange(@NotNull JSQualifiedNamedElement main, @NotNull PsiElement first, @NotNull PsiElement last) {
            if (main == null) {
                MovedElementRange.$$$reportNull$$$0(0);
            }
            if (first == null) {
                MovedElementRange.$$$reportNull$$$0(1);
            }
            if (last == null) {
                MovedElementRange.$$$reportNull$$$0(2);
            }
            this.main = main;
            this.first = first;
            this.last = last;
        }

        @NotNull
        public List<PsiElement> getElements() {
            List<PsiElement> list2 = JSPsiImplUtils.getSiblingsForward(this.first, this.last);
            if (list2 == null) {
                MovedElementRange.$$$reportNull$$$0(3);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "main";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "last";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ecmascript6/refactoring/ES6ModuleMemberInfo$MovedElementRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6ModuleMemberInfo$MovedElementRange";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

