/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.ecmascript6.psi.impl.JSSymlinkLinkedProject;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TypeScriptSymlinkLinkedProject
extends JSSymlinkLinkedProject {
    @NotNull
    private final VirtualFile mySourceRoot;
    @NotNull
    private final VirtualFile myOutDir;

    TypeScriptSymlinkLinkedProject(@NotNull VirtualFile importRoot, @NotNull VirtualFile linkedPackage, @NotNull VirtualFile sourceRoot, @NotNull VirtualFile outDir, @NotNull String packageName) {
        if (importRoot == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(0);
        }
        if (linkedPackage == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(1);
        }
        if (sourceRoot == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(2);
        }
        if (outDir == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(3);
        }
        if (packageName == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(4);
        }
        super(importRoot, linkedPackage, packageName);
        this.mySourceRoot = sourceRoot;
        this.myOutDir = outDir;
    }

    @Override
    @Nullable
    public String getLinkedPath(@NotNull VirtualFile sourceFile) {
        String path;
        if (sourceFile == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(5);
        }
        if ((path = VfsUtilCore.getRelativePath((VirtualFile)sourceFile, (VirtualFile)this.mySourceRoot)) == null) {
            return null;
        }
        Object pathToFile = path.isEmpty() ? "" : "/" + path;
        String outPath = VfsUtilCore.getRelativePath((VirtualFile)this.myOutDir, (VirtualFile)this.getImportRoot());
        if (outPath == null) {
            return null;
        }
        Object pathToOutputDir = outPath.isEmpty() ? "" : "/" + outPath;
        return this.getPackageName() + (String)pathToOutputDir + (String)pathToFile;
    }

    @Override
    @Nullable
    public VirtualFile getSourceFileByLinkedFile(@NotNull VirtualFile file2) {
        VirtualFile directory;
        VirtualFile canonicalFile;
        if (file2 == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(6);
        }
        if ((canonicalFile = file2.getCanonicalFile()) == null) {
            return null;
        }
        boolean isDirectory = file2.isDirectory();
        String relativeOutPath = VfsUtilCore.getRelativePath((VirtualFile)(isDirectory ? canonicalFile : canonicalFile.getParent()), (VirtualFile)this.myOutDir);
        VirtualFile virtualFile = directory = relativeOutPath == null ? null : this.mySourceRoot.findFileByRelativePath(relativeOutPath);
        if (directory == null) {
            return null;
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)this.getImportRoot(), (VirtualFile)directory, (boolean)false)) {
            return null;
        }
        if (isDirectory) {
            return directory;
        }
        return (VirtualFile)ContainerUtil.getFirstItem(TypeScriptSymlinkLinkedProject.findSiblingSourceFiles(file2, directory));
    }

    @NotNull
    private static List<VirtualFile> findSiblingSourceFiles(@NotNull VirtualFile dtsFile, @NotNull VirtualFile parent) {
        if (dtsFile == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(8);
        }
        String name = JSFileReference.getFileNameWithoutExtension(dtsFile.getName(), TypeScriptUtil.TYPESCRIPT_EXTENSIONS);
        SmartList result2 = new SmartList();
        for (String dt : TypeScriptUtil.TYPESCRIPT_EXTENSIONS_WITHOUT_DTS) {
            ContainerUtil.addIfNotNull((Collection)result2, (Object)parent.findChild(name + dt));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            TypeScriptSymlinkLinkedProject.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedPackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dtsFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/TypeScriptSymlinkLinkedProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/TypeScriptSymlinkLinkedProject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findSiblingSourceFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFileByLinkedFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findSiblingSourceFiles";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

