/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.ecmascript6.actions.ES6AddImportExecutor;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSAnyModuleImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.JSImportDescriptorProcessor;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfiguration;
import com.intellij.lang.ecmascript6.psi.impl.JSSymlinkLinkedProject;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptInES6ImportPathBuilder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.JSModuleNameInfoImpl;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.JSImportedElementDescriptor;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.modules.imports.JSSimpleImportDescriptor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileExportsImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.lang.typescript.tsconfig.graph.TypeScriptImportGraph;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import gnu.trove.THashSet;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSImportPathBuilder {
    private static final Logger LOGGER = Logger.getInstance(JSImportPathBuilder.class);
    @NotNull
    private final NodeModuleDirectorySearchProcessor mySearchProcessor;
    @Nullable
    protected final PsiElement myElementToImport;
    @NotNull
    protected final PsiElement myPlace;
    @NotNull
    protected final VirtualFile myPlaceFile;
    @NotNull
    protected final VirtualFile myFileToImport;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final PsiElement myPlaceModule;
    private final String @NotNull [] myExtensions;
    @NotNull
    protected final JSImportPathConfiguration myConfiguration;
    private final JSImportExportType myImportType;
    @Nullable
    private final String myImportedName;

    protected JSImportPathBuilder(@NotNull JSImportPathConfiguration configuration) {
        if (configuration == null) {
            JSImportPathBuilder.$$$reportNull$$$0(0);
        }
        this.myConfiguration = configuration;
        PsiElement place = this.myConfiguration.getPlace();
        this.myProject = place.getProject();
        String[] extensions = (String[])ArrayUtil.copyOf((Object[])configuration.extensions());
        Arrays.sort(extensions, Comparator.comparing(el -> -el.length()));
        this.myExtensions = extensions;
        PsiFile originalFile = place.getContainingFile().getOriginalFile();
        PsiElement originalElement = CompletionUtil.getOriginalElement((PsiElement)place);
        if (originalElement == null) {
            originalElement = originalFile;
        }
        this.myPlaceModule = ES6PsiUtil.isExternalModule(originalElement) ? originalElement : (PsiElement)ObjectUtils.coalesce((Object)ES6PsiUtil.findExternalModule(place), (Object)originalFile);
        this.myPlace = place;
        this.myPlaceFile = originalFile.getVirtualFile();
        this.myElementToImport = configuration.getElementToImport();
        this.myFileToImport = configuration.getFileToImport();
        JSImportExportType candidateType = this.myElementToImport == null ? null : new ES6AddImportExecutor(null, this.myPlace).getImportType(this.myElementToImport);
        this.myImportType = (JSImportExportType)ObjectUtils.coalesce(candidateType, (Object)ES6ImportPsiUtil.ImportExportType.BARE);
        this.myImportedName = configuration.getImportedName();
        this.mySearchProcessor = DialectDetector.isTypeScript(this.myPlace) ? new TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor(extensions) : new NodeModuleDirectorySearchProcessor(extensions);
    }

    @NotNull
    public static JSImportPathBuilder createBuilder(@NotNull JSImportPathConfiguration configuration) {
        PsiElement place;
        if (configuration == null) {
            JSImportPathBuilder.$$$reportNull$$$0(1);
        }
        if (DialectDetector.isTypeScript(place = configuration.getPlace())) {
            return new TypeScriptImportPathBuilder(configuration);
        }
        PsiElement toImport = configuration.getElementToImport();
        if (toImport != null && DialectDetector.isTypeScript(toImport)) {
            return new TypeScriptInES6ImportPathBuilder(configuration);
        }
        return new JSAnyModuleImportPathBuilder(configuration);
    }

    protected boolean processRootPaths(@NotNull JSImportDescriptorProcessor processor, @NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        String rootPath;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(2);
        }
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(3);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(4);
        }
        if ((rootPath = this.getPathRelativeToRoots(moduleFileOrDirectory)) != null) {
            return this.processModuleNameInfo(processor, this.createModuleNameInfo(rootPath, moduleFileOrDirectory, resolvedModuleFile));
        }
        return true;
    }

    @NotNull
    protected final JSModuleNameInfo createModuleNameInfo(@NotNull String rootPath, @NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        if (rootPath == null) {
            JSImportPathBuilder.$$$reportNull$$$0(5);
        }
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(6);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(7);
        }
        return this.createModuleNameInfo(rootPath, moduleFileOrDirectory, resolvedModuleFile, this.myConfiguration.getPathSettings());
    }

    @NotNull
    protected final JSModuleNameInfo createModuleNameInfo(@NotNull String rootPath, @NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile, @NotNull JSModuleNameInfo.ExtensionSettings settings) {
        if (rootPath == null) {
            JSImportPathBuilder.$$$reportNull$$$0(8);
        }
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(9);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            JSImportPathBuilder.$$$reportNull$$$0(11);
        }
        return new JSModuleNameInfoImpl(rootPath, moduleFileOrDirectory, resolvedModuleFile, this.myPlace, this.myExtensions, settings);
    }

    public final void processDirectModuleNames(boolean checkNodeResolution, @NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(12);
        }
        this.processDirectImportDescriptors(checkNodeResolution, JSImportDescriptorProcessor.createModuleInfoProcessor(processor, this.myImportType));
    }

    protected final boolean processDirectImportDescriptors(boolean checkNodeResolution, @NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(13);
        }
        if (checkNodeResolution && this.useNodeResolution()) {
            if (!this.processForNodeResolutionSymlinks(processor)) {
                return false;
            }
            if (!this.processModuleFileWithNodeResolution(processor)) {
                return false;
            }
        }
        return this.processForModuleFile(processor, this.getInfoElementToImport(), this.myFileToImport, this.myFileToImport);
    }

    protected boolean processForNodeResolutionSymlinks(@NotNull JSImportDescriptorProcessor processor) {
        String pathFromImportRoot;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(14);
        }
        if (this.myFileToImport.isDirectory() || NodeModuleUtil.hasNodeModulesDirInPath(this.myFileToImport, ProjectUtil.guessProjectDir((Project)this.myProject))) {
            return true;
        }
        VirtualFile placeRoot = NodeModuleUtil.getMainModuleRoot(this.myPlace);
        if (placeRoot == null) {
            return true;
        }
        VirtualFile importRoot = NodeModuleUtil.findMainModuleRoot(this.myProject, this.myFileToImport);
        if (importRoot == null || placeRoot.equals(importRoot)) {
            return true;
        }
        VirtualFile importPackageJson = PackageJsonUtil.findChildPackageJsonFile(importRoot);
        if (importPackageJson == null) {
            return true;
        }
        VirtualFile commonParent = VfsUtilCore.getCommonAncestor((VirtualFile)placeRoot, (VirtualFile)importRoot);
        if (commonParent == null || importRoot.equals(commonParent)) {
            return true;
        }
        PackageJsonData importData = PackageJsonData.getOrCreate(importPackageJson);
        String importPackageName = importData.getName();
        if (importPackageName == null) {
            importPackageName = importRoot.getName();
        }
        if ((pathFromImportRoot = VfsUtilCore.getRelativePath((VirtualFile)this.myFileToImport, (VirtualFile)importRoot)) == null) {
            return true;
        }
        VirtualFile placeRootNodeModules = placeRoot.findChild("node_modules");
        if (!this.processSymlinkForNodeModules(processor, this.getLinkedProject(importRoot, placeRootNodeModules, importPackageName))) {
            return false;
        }
        VirtualFile rootProject = NodeModuleUtil.findMainModuleRoot(this.myProject, commonParent);
        if (rootProject == null) {
            return true;
        }
        VirtualFile commonRootNodeModules = rootProject.findChild("node_modules");
        return this.processSymlinkForNodeModules(processor, this.getLinkedProject(importRoot, commonRootNodeModules, importPackageName));
    }

    private boolean processSymlinkForNodeModules(@NotNull JSImportDescriptorProcessor processor, @Nullable JSSymlinkLinkedProject linkedProject) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(15);
        }
        if (linkedProject == null) {
            return true;
        }
        VirtualFile importRoot = linkedProject.getImportRoot();
        for (VirtualFile packageResolveFile : this.resolveFileAsNpmPackage(linkedProject.getLinkedPackage())) {
            JSModuleNameInfo info;
            ResolvedElement resolved;
            VirtualFile sourceFile;
            if (packageResolveFile == null || (sourceFile = linkedProject.getSourceFileByLinkedFile(packageResolveFile)) == null || (resolved = this.checkSymbol(sourceFile, false)) == null || processor.processDescriptor(new JSSimpleImportDescriptor(info = this.createModuleNameInfo(linkedProject.getPackageName(), importRoot, sourceFile), resolved.importedDescriptor))) continue;
            return false;
        }
        return this.processHierarchy(importRoot, (candidate, resolvedFile, descriptor2) -> {
            String path = linkedProject.getLinkedPath(candidate);
            if (path == null) {
                return true;
            }
            return processor.processDescriptor(new JSSimpleImportDescriptor(this.createModuleNameInfo(path, candidate, resolvedFile), descriptor2));
        });
    }

    private boolean processModuleFileWithNodeResolution(@NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(16);
        }
        VirtualFile importDirectory = this.myFileToImport.getParent();
        VirtualFile sourceRoot = ProjectFileIndex.getInstance((Project)this.myProject).getContentRootForFile(importDirectory);
        if (VfsUtilCore.isAncestor((VirtualFile)importDirectory, (VirtualFile)this.myPlaceFile, (boolean)true)) {
            return true;
        }
        VirtualFile placeDirectory = this.myPlaceFile.getParent();
        if (placeDirectory == null) {
            return true;
        }
        return this.iterateParentDirectoriesForNodeResolution(processor, importDirectory, placeDirectory, sourceRoot);
    }

    private boolean iterateParentDirectoriesForNodeResolution(@NotNull JSImportDescriptorProcessor processor, @NotNull VirtualFile toIterateDirectory, @NotNull VirtualFile placeDirectory, @Nullable VirtualFile sourceRoot) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(17);
        }
        if (toIterateDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(18);
        }
        if (placeDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(19);
        }
        Object parent = new SmartList();
        while (!(toIterateDirectory == null || sourceRoot != null && sourceRoot.equals(toIterateDirectory) || VfsUtilCore.isAncestor((VirtualFile)toIterateDirectory, (VirtualFile)placeDirectory, (boolean)false))) {
            parent.add(toIterateDirectory);
            toIterateDirectory = toIterateDirectory.getParent();
        }
        parent = ContainerUtil.reverse((List)parent);
        Iterator iterator = parent.iterator();
        while (iterator.hasNext()) {
            VirtualFile moduleFileOrDirectory = (VirtualFile)iterator.next();
            ResolvedElement resolved = this.checkSymbol(moduleFileOrDirectory, true);
            if (resolved == null || this.processForModuleFile(processor, resolved.importedDescriptor, resolved.moduleFileOrDirectory, resolved.resolvedFile)) continue;
            return false;
        }
        return true;
    }

    private boolean processForModuleFile(@NotNull JSImportDescriptorProcessor processor, @NotNull JSImportedElementDescriptor importedDescriptor, @NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        JSModuleNameInfo info;
        JSSimpleImportDescriptor descriptor2;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(20);
        }
        if (importedDescriptor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(21);
        }
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(22);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(23);
        }
        if (!this.processContributorsForModuleFile(processor, descriptor2 = new JSSimpleImportDescriptor(info = this.buildInfoForModuleFile(moduleFileOrDirectory, resolvedModuleFile), importedDescriptor))) {
            return false;
        }
        if (this.myConfiguration.isProcessRootPaths() && !this.processRootPaths(processor, moduleFileOrDirectory, resolvedModuleFile)) {
            return false;
        }
        return processor.processDescriptor(descriptor2);
    }

    @NotNull
    private JSModuleNameInfo buildInfoForModuleFile(VirtualFile moduleFileOrDirectory, VirtualFile resolvedModuleFile) {
        Object externalModuleName = VfsUtilCore.findRelativePath((VirtualFile)this.myPlaceFile, (VirtualFile)moduleFileOrDirectory, (char)'/');
        if (externalModuleName == null) {
            externalModuleName = VfsUtilCore.findRelativePath((VirtualFile)this.myPlaceFile, (VirtualFile)this.myFileToImport, (char)'/');
            if (externalModuleName == null) {
                externalModuleName = this.myFileToImport.getName();
            }
            moduleFileOrDirectory = this.myFileToImport;
            resolvedModuleFile = this.myFileToImport;
        }
        if (!((String)externalModuleName).startsWith(".") && !((String)externalModuleName).startsWith(File.separator)) {
            externalModuleName = "./" + (String)externalModuleName;
        }
        return this.createModuleNameInfo((String)externalModuleName, moduleFileOrDirectory, resolvedModuleFile);
    }

    private boolean processContributorsForModuleFile(@NotNull JSImportDescriptorProcessor processor, @NotNull JSImportDescriptor descriptor2) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(24);
        }
        if (descriptor2 == null) {
            JSImportPathBuilder.$$$reportNull$$$0(25);
        }
        for (JSModuleReferenceContributor contributor : JSModuleReferenceContributor.getSortedExtensions()) {
            if (!contributor.isApplicable(this.myPlace)) continue;
            List<JSImportDescriptor> candidates = contributor.getImportDescriptors(this.myConfiguration, descriptor2);
            for (JSImportDescriptor candidate : candidates) {
                if (candidate.equals(descriptor2) || processor.processDescriptor(candidate)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean processPathForRoot(@NotNull JSImportDescriptorProcessor processor, @NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile, @NotNull VirtualFile rootFile) {
        String path;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(26);
        }
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(27);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(28);
        }
        if (rootFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(29);
        }
        if ((path = VfsUtilCore.findRelativePath((VirtualFile)rootFile, (VirtualFile)moduleFileOrDirectory, (char)'/')) == null) {
            path = VfsUtilCore.findRelativePath((VirtualFile)rootFile, (VirtualFile)this.myFileToImport, (char)'/');
        }
        if (path == null) {
            return true;
        }
        return this.processModuleNameInfo(processor, this.createModuleNameInfo(path, moduleFileOrDirectory, resolvedModuleFile));
    }

    protected boolean useNodeResolution() {
        return JSCodeStyleSettings.isUseNodeResolution(this.myPlace);
    }

    public final void processDescriptorsWithModuleName(@NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(30);
        }
        this.processDescriptors(JSImportDescriptorProcessor.createModuleInfoProcessor(processor, this.myImportType));
    }

    public final void processModuleNames(@NotNull Processor<? super JSModuleNameInfo> processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(31);
        }
        this.processDescriptors(JSImportDescriptorProcessor.moduleInfoWrapper(processor, this.myImportType));
    }

    public final void processDescriptors(@NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(32);
        }
        if (this.myElementToImport instanceof TypeScriptModule && ((TypeScriptModule)this.myElementToImport).isExternal()) {
            return;
        }
        if (!this.processExistingImports(processor)) {
            return;
        }
        this.processModuleNamesWithoutExistingImports(processor);
    }

    protected boolean processModuleNamesWithoutExistingImports(@NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(33);
        }
        return this.processDirectImportDescriptors(true, processor);
    }

    protected boolean processExistingImports(@NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(34);
        }
        if (!this.myConfiguration.useExistingImports() || !(this.myElementToImport instanceof JSElement)) {
            return true;
        }
        VirtualFile elementToExportFile = this.myElementToImport.getContainingFile().getVirtualFile();
        boolean isLibraryFile = JSLibraryUtil.isProbableLibraryFile(elementToExportFile, this.myProject);
        List<ES6ImportDeclaration> declarations = ES6ImportPsiUtil.getImportDeclarations(this.myPlaceModule);
        THashSet visitedModules = new THashSet();
        block0: for (ES6ImportDeclaration declaration : declarations) {
            PsiElement object;
            ES6FromClause clause = declaration.getFromClause();
            Collection<Object> objects = clause == null ? Collections.emptyList() : clause.resolveReferencedElements();
            Iterator<Object> iterator = objects.iterator();
            while (iterator.hasNext() && visitedModules.add(object = (PsiElement)iterator.next())) {
                VirtualFile virtualFile;
                if (!(object instanceof JSFile) || (virtualFile = ((JSFile)object).getVirtualFile()) == null) continue;
                if (JSLibraryUtil.isProbableLibraryFile(virtualFile, this.myProject) != isLibraryFile) continue block0;
                JSImportedElementDescriptor result2 = ES6CreateImportUtil.resolveSymbolInModule((JSElement)this.myElementToImport, this.myPlace, (JSElement)((JSFile)object));
                if (result2 == null) continue;
                String path = JSStringUtil.unquoteStringLiteralValue(StringUtil.notNullize((String)clause.getReferenceText()));
                return this.processModuleNameInfo(processor, this.createModuleNameInfo(path, virtualFile, virtualFile, JSModuleNameInfo.ExtensionSettings.EXACT));
            }
        }
        return true;
    }

    @NotNull
    public static JSImportDescriptorProcessor createSearchProcessor(@NotNull Ref<? super JSImportDescriptor> ref, String @NotNull [] excludedNames) {
        if (ref == null) {
            JSImportPathBuilder.$$$reportNull$$$0(35);
        }
        if (excludedNames == null) {
            JSImportPathBuilder.$$$reportNull$$$0(36);
        }
        boolean hasExcludedNames = excludedNames.length > 0;
        HashSet<String> excludedNamesSet = hasExcludedNames ? new HashSet<String>() : Collections.emptySet();
        SmartList excludePatterns = hasExcludedNames ? new SmartList() : Collections.emptyList();
        for (String name : excludedNames) {
            excludedNamesSet.add(name);
            if (!name.contains("*")) continue;
            excludePatterns.add(name);
        }
        PathMatcher matcher = TypeScriptConfigUtil.getPathMatcher((Collection<String>)excludePatterns);
        JSImportDescriptorProcessor jSImportDescriptorProcessor = info -> {
            JSModuleDescriptor descriptor2 = info.getModuleDescriptor();
            if (!hasExcludedNames || !JSImportPathBuilder.isExcludedName(excludedNamesSet, matcher, descriptor2)) {
                if (ref.get() != null) {
                    LOGGER.error("Processor wasn't stop properly. Please make sure that all places use the returned value for stop");
                    return false;
                }
                ref.set((Object)info);
                return false;
            }
            return true;
        };
        if (jSImportDescriptorProcessor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(37);
        }
        return jSImportDescriptorProcessor;
    }

    public static boolean isExcludedName(@NotNull Set<String> excludedNames, @Nullable PathMatcher matcher, @NotNull JSModuleDescriptor info) {
        String path;
        if (excludedNames == null) {
            JSImportPathBuilder.$$$reportNull$$$0(38);
        }
        if (info == null) {
            JSImportPathBuilder.$$$reportNull$$$0(39);
        }
        if (excludedNames.contains(path = info.getModuleName())) {
            return true;
        }
        if (matcher == null || path.contains("*") || path.contains(":")) {
            return false;
        }
        try {
            return matcher.matches(Paths.get(path, new String[0]));
        }
        catch (InvalidPathException e) {
            LOGGER.warn((Throwable)e);
            return false;
        }
    }

    @Nullable
    protected final ResolvedElement checkSymbol(@NotNull VirtualFile moduleFileOrDirectory, boolean useResolvedIfNoNodeResolution) {
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(40);
        }
        if (moduleFileOrDirectory.equals(this.myFileToImport)) {
            return new ResolvedElement(moduleFileOrDirectory, moduleFileOrDirectory, this.getInfoElementToImport());
        }
        Collection<VirtualFile> resolvedFiles = Collections.singleton(moduleFileOrDirectory);
        if (moduleFileOrDirectory.isDirectory()) {
            resolvedFiles = this.resolveFileAsNpmPackage(moduleFileOrDirectory);
        }
        if (resolvedFiles.isEmpty()) {
            return null;
        }
        VirtualFile candidate = (VirtualFile)ContainerUtil.find(resolvedFiles, el -> el.equals(this.myFileToImport));
        if (candidate != null) {
            if (!this.supportsNodeResolution(candidate)) {
                if (!useResolvedIfNoNodeResolution) {
                    return null;
                }
                moduleFileOrDirectory = candidate;
            }
            return new ResolvedElement(moduleFileOrDirectory, candidate, this.getInfoElementToImport());
        }
        if (this.myElementToImport == null) {
            return null;
        }
        for (VirtualFile resolvedFile : resolvedFiles) {
            JSImportedElementDescriptor descriptor2 = ES6CreateImportUtil.resolveSymbolInFile(this.myProject, resolvedFile, this.myElementToImport, this.myPlace, this.myImportType != ES6ImportPsiUtil.ImportExportType.BARE);
            if (descriptor2 == null) continue;
            descriptor2 = this.normalizeNameForImportDescriptor(descriptor2);
            if (!this.supportsNodeResolution(resolvedFile)) {
                if (!useResolvedIfNoNodeResolution) continue;
                moduleFileOrDirectory = resolvedFile;
            }
            return new ResolvedElement(moduleFileOrDirectory, resolvedFile, descriptor2);
        }
        return null;
    }

    private boolean supportsNodeResolution(@NotNull VirtualFile resolveCandidate) {
        String extension;
        if (resolveCandidate == null) {
            JSImportPathBuilder.$$$reportNull$$$0(41);
        }
        if (TypeScriptImportsResolverProvider.isMjsContext(this.myPlace, extension = JSFileReference.findExtension(resolveCandidate.getName(), this.myConfiguration.extensions()))) {
            return false;
        }
        if (DialectDetector.isTypeScript(this.myPlace)) {
            for (TypeScriptImportsResolverProvider provider : TypeScriptImportsResolverProvider.EP.getExtensionList()) {
                if (!provider.useExplicitExtension(extension)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    protected JSImportedElementDescriptor normalizeNameForImportDescriptor(@NotNull JSImportedElementDescriptor descriptor2) {
        String name;
        if (descriptor2 == null) {
            JSImportPathBuilder.$$$reportNull$$$0(42);
        }
        if (Objects.equals(name = descriptor2.getImportedName(), this.myImportedName)) {
            JSImportedElementDescriptor jSImportedElementDescriptor = descriptor2;
            if (jSImportedElementDescriptor == null) {
                JSImportPathBuilder.$$$reportNull$$$0(43);
            }
            return jSImportedElementDescriptor;
        }
        return new ES6ImportPsiUtil.CreateImportExportInfo(this.myImportedName, descriptor2.getExportedName(), descriptor2.getImportType(), descriptor2.getImportExportPrefixKind());
    }

    @NotNull
    protected Collection<VirtualFile> resolveFileAsNpmPackage(@NotNull VirtualFile moduleFileOrDirectory) {
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(44);
        }
        List list2 = ContainerUtil.createMaybeSingletonList((Object)this.resolveAsNpmPackage(moduleFileOrDirectory));
        if (list2 == null) {
            JSImportPathBuilder.$$$reportNull$$$0(45);
        }
        return list2;
    }

    @Nullable
    private VirtualFile resolveAsNpmPackage(@NotNull VirtualFile pathFile) {
        if (pathFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(46);
        }
        return JSExactFileReference.resolveForNpmPackages(pathFile, this.mySearchProcessor);
    }

    @Nullable
    private String getPathRelativeToRoots(@NotNull VirtualFile moduleFile) {
        String path;
        ModuleRootManager rootManager;
        Object[] sourceRoots;
        String path2;
        VirtualFile url;
        String path3;
        WebResourcesPathsConfiguration pathsConfiguration;
        if (moduleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(47);
        }
        if ((pathsConfiguration = WebResourcesPathsConfiguration.getInstance((Project)this.myProject)) != null && (path3 = JSFileReferencesUtil.getShortestPathInContexts(moduleFile, pathsConfiguration.getResourceDirectories(), false)) != null) {
            return path3;
        }
        TypeScriptConfig jsConfig = TypeScriptConfigUtil.getConfigForPsiFile(this.myPlace.getContainingFile(), true);
        if (jsConfig != null && jsConfig.isJSConfig() && (url = jsConfig.getBaseUrl()) != null && (path2 = JSFileReferencesUtil.getShortestPathInContexts(moduleFile, Collections.singleton(url), false)) != null) {
            return path2;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myPlace);
        if (module != null && (sourceRoots = (rootManager = ModuleRootManager.getInstance((Module)module)).getSourceRoots()).length > 0 && (path = JSFileReferencesUtil.getShortestPathInContexts(moduleFile, ContainerUtil.newArrayList((Object[])sourceRoots), false)) != null) {
            return path;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getContentRootForFile(this.myPlaceFile);
        return contentRoot != null ? VfsUtilCore.findRelativePath((VirtualFile)contentRoot, (VirtualFile)moduleFile, (char)'/') : null;
    }

    @Nullable
    protected final NodeModuleUtil.NodeModuleStructure getNodeModuleStructureForImportedFile() {
        return NodeModuleUtil.getNodeModuleStructure(this.myProject, this.myFileToImport);
    }

    @NotNull
    protected JSModuleNameInfo createNodeModuleNameInfo(@NotNull NodeModuleUtil.NodeModuleStructure structure, @NotNull VirtualFile moduleOrFileToImport, @NotNull VirtualFile resolvedFile) {
        if (structure == null) {
            JSImportPathBuilder.$$$reportNull$$$0(48);
        }
        if (moduleOrFileToImport == null) {
            JSImportPathBuilder.$$$reportNull$$$0(49);
        }
        if (resolvedFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(50);
        }
        String path = JSImportPathBuilder.getNodeModulePath(structure.moduleDirectory, structure.directoryToCalcModuleName, moduleOrFileToImport);
        return this.createModuleNameInfo(path, moduleOrFileToImport, resolvedFile);
    }

    @Nullable
    protected JSImportDescriptor getModuleNameForMapping(@NotNull VirtualFile baseUrl, @NotNull JSModulePathSubstitution substitution, @NotNull String mapping) {
        String pattern;
        if (baseUrl == null) {
            JSImportPathBuilder.$$$reportNull$$$0(51);
        }
        if (substitution == null) {
            JSImportPathBuilder.$$$reportNull$$$0(52);
        }
        if (mapping == null) {
            JSImportPathBuilder.$$$reportNull$$$0(53);
        }
        if (StringUtil.isEmpty((String)(pattern = substitution.getPattern()))) {
            return null;
        }
        if ("*".equals(pattern) && ("*".equals(mapping) || "./*".equals(mapping))) {
            return null;
        }
        if ((mapping = FileUtil.toSystemIndependentName((String)mapping)).isEmpty()) {
            return null;
        }
        VirtualFile placeDirectory = this.myPlaceFile.getParent();
        if (substitution.isExact() || !substitution.includeExactMapping()) {
            VirtualFile pathFile = this.getPossibleFileWithExtension(baseUrl, mapping);
            if (pathFile != null) {
                VirtualFile file2;
                if (!JSImportPathBuilder.isFromNestedDirectory(pathFile, this.myFileToImport)) {
                    return null;
                }
                ResolvedElement resolved = this.checkSymbol(pathFile, false);
                VirtualFile virtualFile = file2 = resolved != null ? resolved.resolvedFile : null;
                if (file2 != null) {
                    if (Objects.equals(placeDirectory, file2.getParent()) && JSImportPathBuilder.isIndexFile(file2)) {
                        return null;
                    }
                    if (this.checkCircularDependency(file2)) {
                        return null;
                    }
                    JSModuleNameInfo info = this.createModuleNameInfo(pattern, pathFile, file2, JSModuleNameInfo.ExtensionSettings.EXACT);
                    return new JSSimpleImportDescriptor(info, resolved.importedDescriptor);
                }
            }
            if (substitution.isExact()) {
                return null;
            }
        }
        VirtualFile startDirectory = baseUrl;
        String pathPrefix = substitution.getPathPrefix(mapping);
        if (pathPrefix != null) {
            startDirectory = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, pathPrefix);
        }
        if (startDirectory == null) {
            return null;
        }
        List<VirtualFile> parents = JSImportPathBuilder.collectParents(this.myFileToImport, startDirectory);
        if (parents.isEmpty()) {
            return null;
        }
        if (this.myConfiguration.relativeForSamePathMappings() && this.isPlaceFromSamePaths(startDirectory)) {
            return null;
        }
        String partOfString = substitution.getMappedString(mapping);
        for (VirtualFile pathFile : ContainerUtil.reverse(parents)) {
            ResolvedElement resolved;
            if (pathFile.equals(placeDirectory)) continue;
            if (NodeModuleUtil.isTypesDir(pathFile) && NodeModuleUtil.isNodeModules(pathFile.getParent()) && !pattern.contains("@types/")) {
                return null;
            }
            String stringToCheckPattern = VfsUtilCore.findRelativePath((VirtualFile)startDirectory, (VirtualFile)pathFile, (char)'/');
            if (StringUtil.isEmpty((String)stringToCheckPattern)) continue;
            JSModulePattern pathSubstitution = JSPathMappingsUtil.createPatternForString(partOfString, substitution.canStartWith());
            Pair matchedStar = JSPathMappingsUtil.findMaxElementByPaths((pathPrefix != null ? "/" : "") + stringToCheckPattern, ContainerUtil.createMaybeSingletonList((Object)pathSubstitution));
            if (matchedStar == null || (resolved = this.checkSymbol(pathFile, false)) == null) continue;
            JSModuleNameInfo info = this.createModuleNameInfo(substitution.applyPattern((String)matchedStar.second), resolved.resolvedFile, pathFile, this.myConfiguration.getPathSettings());
            return new JSSimpleImportDescriptor(info, resolved.importedDescriptor);
        }
        return null;
    }

    private boolean checkCircularDependency(@NotNull VirtualFile resolvedModuleFile) {
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(54);
        }
        TypeScriptFileExportsImpl exports = TypeScriptFileExportsImpl.create(this.myProject, this.myConfiguration.getTsConfig(), resolvedModuleFile);
        return new TypeScriptImportGraph(exports).containsFile(this.myPlaceFile);
    }

    private static boolean isIndexFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSImportPathBuilder.$$$reportNull$$$0(55);
        }
        return file2.getName().startsWith("index.");
    }

    private boolean isPlaceFromSamePaths(@NotNull VirtualFile startDirectory) {
        if (startDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(56);
        }
        return VfsUtilCore.isAncestor((VirtualFile)startDirectory, (VirtualFile)this.myPlaceFile, (boolean)true);
    }

    @Nullable
    private VirtualFile getPossibleFileWithExtension(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            JSImportPathBuilder.$$$reportNull$$$0(57);
        }
        if (mapping == null) {
            JSImportPathBuilder.$$$reportNull$$$0(58);
        }
        if (JSFileReference.findExtension(mapping, this.myExtensions) != null) {
            return JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping);
        }
        for (String extension : this.myExtensions) {
            VirtualFile possibleFile = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping + extension);
            if (possibleFile == null) continue;
            return possibleFile;
        }
        return JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping);
    }

    private static boolean isFromNestedDirectory(VirtualFile parentFile, VirtualFile dstFile) {
        if (parentFile.equals(dstFile)) {
            return true;
        }
        if (!parentFile.isDirectory()) {
            parentFile = parentFile.getParent();
        }
        return VfsUtilCore.isAncestor((VirtualFile)parentFile, (VirtualFile)dstFile, (boolean)false);
    }

    protected final boolean processModuleNameUsingNodeModules(@NotNull JSImportDescriptorProcessor processor) {
        NodeModuleUtil.NodeModuleStructure nodeModuleStructure;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(59);
        }
        if ((nodeModuleStructure = this.getNodeModuleStructureForImportedFile()) == null) {
            return true;
        }
        if (!this.processModuleUsingNodeModules(processor, nodeModuleStructure)) {
            return false;
        }
        return NodeModuleUtil.hasNodeModulesDirInPath(this.myPlaceFile, null);
    }

    protected abstract boolean processModuleUsingNodeModules(@NotNull JSImportDescriptorProcessor var1, @NotNull NodeModuleUtil.NodeModuleStructure var2);

    @Nullable
    protected static String getNodeModulePath(@NotNull VirtualFile moduleDirectory, @NotNull VirtualFile directoryToCalcModuleName, @NotNull VirtualFile moduleOrFileToImport) {
        String path;
        if (moduleDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(60);
        }
        if (directoryToCalcModuleName == null) {
            JSImportPathBuilder.$$$reportNull$$$0(61);
        }
        if (moduleOrFileToImport == null) {
            JSImportPathBuilder.$$$reportNull$$$0(62);
        }
        if ((path = VfsUtilCore.findRelativePath((VirtualFile)directoryToCalcModuleName, (VirtualFile)moduleOrFileToImport, (char)'/')) == null || !NodeModuleUtil.isTypesDir(directoryToCalcModuleName)) {
            return path;
        }
        String name = moduleDirectory.getName();
        if (!path.startsWith(name)) {
            return path;
        }
        int separatorIndex = name.indexOf("__");
        if (separatorIndex <= 0) {
            return path;
        }
        String convertedName = ES6CreateImportUtil.convertScopedTypesName(name);
        if (convertedName.equals(name)) {
            return path;
        }
        String subPath = path.substring(name.length());
        return convertedName + subPath;
    }

    protected boolean processHierarchy(@NotNull VirtualFile parentToStop, @NotNull HierarchyProcessor parentFileProcessor) {
        if (parentToStop == null) {
            JSImportPathBuilder.$$$reportNull$$$0(63);
        }
        if (parentFileProcessor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(64);
        }
        return this.processElements(ContainerUtil.reverse(JSImportPathBuilder.collectParents(this.myFileToImport, parentToStop)), parentFileProcessor);
    }

    protected boolean processElements(@NotNull List<VirtualFile> elementsToProcess, @NotNull HierarchyProcessor fileProcessor) {
        if (elementsToProcess == null) {
            JSImportPathBuilder.$$$reportNull$$$0(65);
        }
        if (fileProcessor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(66);
        }
        for (VirtualFile moduleFileOrDirectory : elementsToProcess) {
            ProgressManager.checkCanceled();
            ResolvedElement resolved = this.checkSymbol(moduleFileOrDirectory, true);
            if (resolved == null || fileProcessor.process(resolved.moduleFileOrDirectory, resolved.resolvedFile, resolved.importedDescriptor)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected static List<VirtualFile> collectParents(@NotNull VirtualFile dstFile, @NotNull VirtualFile parentToStop) {
        if (dstFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(67);
        }
        if (parentToStop == null) {
            JSImportPathBuilder.$$$reportNull$$$0(68);
        }
        ArrayList parents = ContainerUtil.newArrayList((Object[])new VirtualFile[]{dstFile});
        boolean hasParent = false;
        for (VirtualFile parent = dstFile.getParent(); parent != null; parent = parent.getParent()) {
            ProgressManager.checkCanceled();
            if (parentToStop.equals(parent)) {
                hasParent = true;
                break;
            }
            parents.add(parent);
        }
        if (!hasParent) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSImportPathBuilder.$$$reportNull$$$0(69);
            }
            return list2;
        }
        ArrayList arrayList = parents;
        if (arrayList == null) {
            JSImportPathBuilder.$$$reportNull$$$0(70);
        }
        return arrayList;
    }

    @Nullable
    protected JSSymlinkLinkedProject getLinkedProject(@NotNull VirtualFile importRoot, @Nullable VirtualFile nodeModules, @Nullable String packageName) {
        VirtualFile linkedPackage;
        if (importRoot == null) {
            JSImportPathBuilder.$$$reportNull$$$0(71);
        }
        if ((linkedPackage = JSImportPathBuilder.getLinkedPackage(importRoot, nodeModules, packageName)) == null) {
            return null;
        }
        return new JSSymlinkLinkedProject(importRoot, linkedPackage, packageName);
    }

    @NotNull
    public final List<JSImportDescriptor> getMappingsForBaseUrl(@NotNull VirtualFile baseUrl, @NotNull Collection<? extends JSModulePathSubstitution> mappings) {
        if (baseUrl == null) {
            JSImportPathBuilder.$$$reportNull$$$0(72);
        }
        if (mappings == null) {
            JSImportPathBuilder.$$$reportNull$$$0(73);
        }
        return this.getMappingsForBaseUrl(Collections.singleton(baseUrl), mappings);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public final List<JSImportDescriptor> getMappingsForBaseUrl(@NotNull Collection<VirtualFile> baseUrls, @NotNull Collection<? extends JSModulePathSubstitution> mappings) {
        if (baseUrls == null) {
            JSImportPathBuilder.$$$reportNull$$$0(74);
        }
        if (mappings == null) {
            JSImportPathBuilder.$$$reportNull$$$0(75);
        }
        if (!this.myConfiguration.usePathMappings()) {
            List<JSImportDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                JSImportPathBuilder.$$$reportNull$$$0(76);
            }
            return list2;
        }
        @NotNull @NotNull SmartList candidates = new SmartList();
        for (JSModulePathSubstitution jSModulePathSubstitution : mappings) {
            for (String mapping : jSModulePathSubstitution.getMappings()) {
                if (StringUtil.isEmpty((String)mapping)) continue;
                for (VirtualFile baseUrl : baseUrls) {
                    JSImportDescriptor possibleMapping = this.getModuleNameForMapping(baseUrl, jSModulePathSubstitution, mapping);
                    if (possibleMapping == null) continue;
                    candidates.add(Pair.create((Object)possibleMapping, (Object)mapping));
                }
            }
        }
        Collections.sort(candidates, (el, el2) -> JSImportPathBuilder.compareMappings(((JSImportDescriptor)el.first).getModuleDescriptor(), (String)el.second, ((JSImportDescriptor)el2.first).getModuleDescriptor(), (String)el2.second));
        List list3 = StreamEx.of((Collection)candidates).map(el -> (JSImportDescriptor)el.first).toList();
        if (list3 == null) {
            JSImportPathBuilder.$$$reportNull$$$0(77);
        }
        return list3;
    }

    private static int compareMappings(@Nullable JSModuleDescriptor oldInfo, @Nullable String oldMapping, @NotNull JSModuleDescriptor newInfo, @NotNull String newMapping) {
        if (newInfo == null) {
            JSImportPathBuilder.$$$reportNull$$$0(78);
        }
        if (newMapping == null) {
            JSImportPathBuilder.$$$reportNull$$$0(79);
        }
        if (oldInfo == null || oldMapping == null) {
            return 1;
        }
        String oldInfoPath = oldInfo.getModuleName();
        String newInfoPath = newInfo.getModuleName();
        if (!oldMapping.equals(newMapping)) {
            if (newInfoPath.startsWith(oldInfoPath + "/")) {
                return -1;
            }
            if (oldInfoPath.startsWith(newInfoPath + "/")) {
                return 1;
            }
            if (oldMapping.startsWith(newMapping)) {
                return -1;
            }
            if (newMapping.startsWith(oldMapping)) {
                return 1;
            }
        }
        return oldInfoPath.length() - newInfoPath.length();
    }

    protected boolean processModuleNameInfo(@NotNull JSImportDescriptorProcessor processor, @NotNull JSModuleNameInfo info) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(80);
        }
        if (info == null) {
            JSImportPathBuilder.$$$reportNull$$$0(81);
        }
        return processor.processDescriptor(this.createSimpleDescriptor(info));
    }

    @NotNull
    protected JSImportDescriptor createSimpleDescriptor(@NotNull JSModuleNameInfo info) {
        if (info == null) {
            JSImportPathBuilder.$$$reportNull$$$0(82);
        }
        return new JSSimpleImportDescriptor(info, this.getInfoElementToImport());
    }

    @NotNull
    protected JSImportedElementDescriptor getInfoElementToImport() {
        String elementName;
        if (this.myImportType == ES6ImportPsiUtil.ImportExportType.BARE) {
            ES6ImportPsiUtil.CreateImportExportInfo createImportExportInfo = ES6ImportPsiUtil.BARE_INFO;
            if (createImportExportInfo == null) {
                JSImportPathBuilder.$$$reportNull$$$0(83);
            }
            return createImportExportInfo;
        }
        String string = elementName = this.myElementToImport instanceof JSElement ? ES6ImportPsiUtil.getExportedElementName((JSElement)this.myElementToImport) : null;
        if (elementName == null) {
            ES6ImportPsiUtil.CreateImportExportInfo createImportExportInfo = ES6ImportPsiUtil.BARE_INFO;
            if (createImportExportInfo == null) {
                JSImportPathBuilder.$$$reportNull$$$0(84);
            }
            return createImportExportInfo;
        }
        return new ES6ImportPsiUtil.CreateImportExportInfo(elementName, this.myImportedName, this.myImportType, ES6AddImportExecutor.detectPrefixKind(this.myElementToImport, this.myPlace));
    }

    @Nullable
    protected static VirtualFile getLinkedPackage(@NotNull VirtualFile importRoot, @Nullable VirtualFile nodeModules, @Nullable String packageName) {
        if (importRoot == null) {
            JSImportPathBuilder.$$$reportNull$$$0(85);
        }
        if (packageName == null || nodeModules == null) {
            return null;
        }
        VirtualFile linkedPackage = nodeModules.findFileByRelativePath(packageName);
        if (linkedPackage == null || importRoot.equals(linkedPackage)) {
            return null;
        }
        if (!Objects.equals(linkedPackage.getCanonicalFile(), importRoot)) {
            return null;
        }
        return linkedPackage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 37: 
            case 43: 
            case 45: 
            case 69: 
            case 70: 
            case 76: 
            case 77: 
            case 83: 
            case 84: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 37: 
            case 43: 
            case 45: 
            case 69: 
            case 70: 
            case 76: 
            case 77: 
            case 83: 
            case 84: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 59: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 22: 
            case 27: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFileOrDirectory";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 23: 
            case 28: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedModuleFile";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIterateDirectory";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeDirectory";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedDescriptor";
                break;
            }
            case 25: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedNames";
                break;
            }
            case 37: 
            case 43: 
            case 45: 
            case 69: 
            case 70: 
            case 76: 
            case 77: 
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/JSImportPathBuilder";
                break;
            }
            case 39: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveCandidate";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathFile";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 49: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOrFileToImport";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFile";
                break;
            }
            case 51: 
            case 57: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 53: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startDirectory";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDirectory";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryToCalcModuleName";
                break;
            }
            case 63: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentToStop";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFileProcessor";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToProcess";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProcessor";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstFile";
                break;
            }
            case 71: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importRoot";
                break;
            }
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrls";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfo";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/JSImportPathBuilder";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchProcessor";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeNameForImportDescriptor";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFileAsNpmPackage";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "collectParents";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingsForBaseUrl";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoElementToImport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processRootPaths";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createModuleNameInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processDirectModuleNames";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processDirectImportDescriptors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processForNodeResolutionSymlinks";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processSymlinkForNodeModules";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processModuleFileWithNodeResolution";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "iterateParentDirectoriesForNodeResolution";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processForModuleFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processContributorsForModuleFile";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processPathForRoot";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processDescriptorsWithModuleName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNames";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processDescriptors";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNamesWithoutExistingImports";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processExistingImports";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createSearchProcessor";
                break;
            }
            case 37: 
            case 43: 
            case 45: 
            case 69: 
            case 70: 
            case 76: 
            case 77: 
            case 83: 
            case 84: {
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedName";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkSymbol";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "supportsNodeResolution";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "normalizeNameForImportDescriptor";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "resolveFileAsNpmPackage";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsNpmPackage";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeToRoots";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createNodeModuleNameInfo";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameForMapping";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "checkCircularDependency";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isIndexFile";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isPlaceFromSamePaths";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleFileWithExtension";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNameUsingNodeModules";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getNodeModulePath";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "processHierarchy";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "collectParents";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedProject";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsForBaseUrl";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "compareMappings";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNameInfo";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleDescriptor";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 37: 
            case 43: 
            case 45: 
            case 69: 
            case 70: 
            case 76: 
            case 77: 
            case 83: 
            case 84: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ResolvedElement {
        final VirtualFile moduleFileOrDirectory;
        final VirtualFile resolvedFile;
        final JSImportedElementDescriptor importedDescriptor;

        public ResolvedElement(@Nullable VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedFile, @NotNull JSImportedElementDescriptor descriptor2) {
            if (resolvedFile == null) {
                ResolvedElement.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                ResolvedElement.$$$reportNull$$$0(1);
            }
            this.moduleFileOrDirectory = moduleFileOrDirectory;
            this.resolvedFile = resolvedFile;
            this.importedDescriptor = descriptor2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolvedFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/ecmascript6/psi/impl/JSImportPathBuilder$ResolvedElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static interface HierarchyProcessor {
        public boolean process(@NotNull VirtualFile var1, @NotNull VirtualFile var2, @NotNull JSImportedElementDescriptor var3);
    }
}

