/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ReplaceImportFromClauseFix
extends FixAndIntentionAction {
    @NlsSafe
    private final String myUnquotedNewName;

    public ES6ReplaceImportFromClauseFix(@NotNull ES6ImportExportDeclaration importDeclaration, @NotNull @IntentionName String unquotedNewName) {
        if (importDeclaration == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(0);
        }
        if (unquotedNewName == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(1);
        }
        this.myUnquotedNewName = unquotedNewName;
        this.registerElementRefForFix((PsiElement)importDeclaration, null);
    }

    @IntentionName
    @NotNull
    public String getName() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return ES6ReplaceImportFromClauseFix.getActionText("");
        }
        return ES6ReplaceImportFromClauseFix.getActionText(StringUtil.wrapWithDoubleQuote((String)this.myUnquotedNewName));
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"es6.replace.import.family.name", (Object[])new Object[0]);
        if (string == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, @NotNull PsiFile file2, @Nullable Editor editor) {
        if (file2 == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(3);
        }
        if (!psiElement.isValid()) {
            return;
        }
        if (!(psiElement instanceof ES6ImportExportDeclaration)) {
            return;
        }
        ES6ImportExportDeclaration importDeclaration = (ES6ImportExportDeclaration)psiElement;
        ES6FromClause clause = importDeclaration.getFromClause();
        ES6ReplaceImportFromClauseFix.changeImportFromText(clause, this.myUnquotedNewName);
    }

    public static void changeImportFromText(@Nullable ES6FromClause clause, @NlsSafe String unquotedText) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (clause == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(clause.getContainingFile())) {
            return;
        }
        ASTNode node = clause.getNode();
        ASTNode oldValue = node.findChildByType(JSTokenTypes.STRING_LITERALS);
        if (oldValue == null) {
            return;
        }
        String quote = ES6ImportPsiUtil.getQuote((PsiElement)clause, oldValue);
        String x = "import {a} from " + quote + unquotedText + quote;
        ES6ImportDeclaration createdDeclaration = JSPsiElementFactory.createJSSourceElement(x, (PsiElement)clause, ES6ImportDeclaration.class);
        if (createdDeclaration.getFromClause() == null) {
            return;
        }
        clause.replace((PsiElement)createdDeclaration.getFromClause());
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public static String getActionText(@NotNull String with) {
        if (with == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(4);
        }
        String string = JavaScriptBundle.message((String)"es6.replace.import.action.name", (Object[])new Object[]{with});
        if (string == null) {
            ES6ReplaceImportFromClauseFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDeclaration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedNewName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/intentions/ES6ReplaceImportFromClauseFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "with";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/intentions/ES6ReplaceImportFromClauseFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getActionText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

