/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.actionscript.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.actionscript.ActionScriptElementTypes;
import com.intellij.lang.actionscript.parsing.ActionScriptParser;
import com.intellij.lang.actionscript.parsing.ActionScriptStatementParser;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSAttributeNameValuePairImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;

public class ActionScriptFunctionParser
extends FunctionParser<ActionScriptParser> {
    private static final Logger LOG = Logger.getInstance(ActionScriptFunctionParser.class);

    protected ActionScriptFunctionParser(ActionScriptParser parser2) {
        super(parser2);
    }

    @Override
    public boolean parseFunctionName(boolean functionKeywordWasOmitted, FunctionParser.Context context) {
        if (this.parseGetSetAndNameAfterFunctionKeyword(context)) {
            return true;
        }
        return super.parseFunctionName(functionKeywordWasOmitted, context);
    }

    @Override
    public void parseFunctionIdentifier() {
        if (!JSKeywordSets.PROPERTY_NAMES.contains(this.builder.getTokenType())) {
            LOG.error(this.builder.getTokenText());
        }
        ((ActionScriptStatementParser)((ActionScriptParser)this.myJavaScriptParser).getStatementParser()).parsePossiblyQualifiedName();
    }

    @Override
    public IElementType getFunctionDeclarationElementType() {
        return ActionScriptElementTypes.FUNCTION_DECLARATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parseAttributesList() {
        PsiBuilder.Marker modifierList = this.builder.mark();
        boolean seenNs = false;
        boolean seenAnyAttributes = false;
        try {
            boolean hasSomethingInAttrList = true;
            boolean hadConditionalCompileBlock = false;
            boolean doNotAllowAttributes = false;
            while (hasSomethingInAttrList) {
                IElementType tokenType;
                hasSomethingInAttrList = false;
                while (this.builder.getTokenType() == JSTokenTypes.LBRACKET) {
                    if (doNotAllowAttributes) {
                        this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.declaration", (Object[])new Object[0]));
                        break;
                    }
                    PsiBuilder.Marker attribute = this.builder.mark();
                    this.builder.advanceLexer();
                    IElementType tokenType2 = this.builder.getTokenType();
                    if (tokenType2 == JSTokenTypes.RBRACKET) {
                        this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
                    } else {
                        if (tokenType2 == null || !this.isIdentifierToken(tokenType2)) {
                            if (seenAnyAttributes) {
                                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
                            }
                            attribute.drop();
                            boolean bl = seenAnyAttributes;
                            return bl;
                        }
                        this.builder.advanceLexer();
                    }
                    while (this.builder.getTokenType() != JSTokenTypes.RBRACKET) {
                        this.parseAttributeBody();
                        if (!this.builder.eof()) continue;
                        attribute.done(JSStubElementTypes.ATTRIBUTE);
                        this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.rbracket", (Object[])new Object[0]));
                        boolean bl = true;
                        return bl;
                    }
                    this.builder.advanceLexer();
                    attribute.done(JSStubElementTypes.ATTRIBUTE);
                    hasSomethingInAttrList = true;
                }
                if (this.builder.getTokenType() == JSTokenTypes.INCLUDE_KEYWORD) {
                    hasSomethingInAttrList = true;
                    ((ActionScriptStatementParser)((ActionScriptParser)this.myJavaScriptParser).getStatementParser()).parseIncludeDirective();
                }
                if (this.builder.getTokenType() == JSTokenTypes.USE_KEYWORD && !doNotAllowAttributes) {
                    hasSomethingInAttrList = true;
                    ((ActionScriptStatementParser)((ActionScriptParser)this.myJavaScriptParser).getStatementParser()).parseUseNamespaceDirective();
                }
                if (this.builder.getTokenType() == JSTokenTypes.IDENTIFIER && !seenNs) {
                    PsiBuilder.Marker identifier = this.builder.mark();
                    hasSomethingInAttrList = true;
                    seenNs = true;
                    PsiBuilder.Marker marker = this.builder.mark();
                    this.builder.advanceLexer();
                    marker.done(JSElementTypes.REFERENCE_EXPRESSION);
                    IElementType tokenType3 = this.builder.getTokenType();
                    if (!hadConditionalCompileBlock) {
                        if (tokenType3 == JSTokenTypes.COLON_COLON && ((ExpressionParser)((ActionScriptParser)this.myJavaScriptParser).getExpressionParser()).proceedWithNamespaceReference(identifier, false)) {
                            identifier = identifier.precede();
                            identifier.done(JSElementTypes.REFERENCE_EXPRESSION);
                            identifier.precede().done(JSElementTypes.CONDITIONAL_COMPILE_VARIABLE_REFERENCE);
                            hadConditionalCompileBlock = true;
                            seenNs = false;
                        } else if (tokenType3 == JSTokenTypes.DOT) {
                            while (this.builder.getTokenType() == JSTokenTypes.DOT) {
                                this.builder.advanceLexer();
                                boolean identifierToken = this.isIdentifierToken(this.builder.getTokenType());
                                if (identifierToken) {
                                    this.builder.advanceLexer();
                                }
                                identifier.done(JSElementTypes.REFERENCE_EXPRESSION);
                                identifier = identifier.precede();
                                if (identifierToken) continue;
                                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.name", (Object[])new Object[0]));
                                break;
                            }
                            identifier.drop();
                        } else {
                            identifier.drop();
                        }
                    } else {
                        identifier.drop();
                    }
                }
                while (JSTokenTypes.MODIFIERS.contains(tokenType = this.builder.getTokenType()) || tokenType == JSTokenTypes.GET_KEYWORD || tokenType == JSTokenTypes.SET_KEYWORD) {
                    doNotAllowAttributes = true;
                    seenAnyAttributes = true;
                    hasSomethingInAttrList = true;
                    if (this.builder.getTokenType() == JSTokenTypes.NATIVE_KEYWORD || this.builder.getTokenType() == JSTokenTypes.DECLARE_KEYWORD) {
                        this.builder.putUserData(methodsEmptinessKey, (Object)"a");
                    }
                    this.builder.advanceLexer();
                }
                if (!this.builder.eof()) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            IElementType currentTokenType = this.builder.getTokenType();
            if (seenNs && !seenAnyAttributes && ActionScriptFunctionParser.isNonAttrListOwner(currentTokenType)) {
                modifierList.rollbackTo();
            } else {
                modifierList.done(this.getAttributeListElementType());
            }
        }
        return true;
    }

    @Override
    public IElementType getAttributeListElementType() {
        return JSStubElementTypes.ACTION_SCRIPT_ATTRIBUTE_LIST;
    }

    public void parseAttributeBody() {
        boolean haveLParen = ActionScriptFunctionParser.checkMatches(this.builder, JSTokenTypes.LPAR, "javascript.parser.message.expected.lparen");
        while (haveLParen) {
            boolean hasName = JSAttributeNameValuePairImpl.IDENTIFIER_TOKENS_SET.contains(this.builder.getTokenType());
            if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.identifier.or.value", (Object[])new Object[0]));
                break;
            }
            IElementType tokenType = this.builder.getTokenType();
            if (tokenType == JSTokenTypes.RBRACKET || tokenType == JSTokenTypes.RPAR) break;
            PsiBuilder.Marker attributeNameValuePair = this.builder.mark();
            this.builder.advanceLexer();
            if (hasName && this.builder.getTokenType() != JSTokenTypes.COMMA && this.builder.getTokenType() != JSTokenTypes.RPAR) {
                ActionScriptFunctionParser.checkMatches(this.builder, JSTokenTypes.EQ, "javascript.parser.message.expected.equal");
                IElementType type = this.builder.getTokenType();
                if (type != JSTokenTypes.COMMA && type != JSTokenTypes.RBRACKET && type != JSTokenTypes.RPAR) {
                    if (type == JSTokenTypes.IDENTIFIER) {
                        PsiBuilder.Marker ident = this.builder.mark();
                        this.builder.advanceLexer();
                        IElementType nextTokenType = this.builder.getTokenType();
                        ident.rollbackTo();
                        if (!JSTokenTypes.STRING_LITERALS.contains(nextTokenType)) {
                            ((ExpressionParser)((ActionScriptParser)this.myJavaScriptParser).getExpressionParser()).parseSimpleExpression();
                        } else {
                            this.builder.advanceLexer();
                        }
                    } else {
                        this.builder.advanceLexer();
                    }
                } else {
                    this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.value", (Object[])new Object[0]));
                }
            }
            attributeNameValuePair.done(JSStubElementTypes.ATTRIBUTE_NAME_VALUE_PAIR);
            if (this.builder.getTokenType() != JSTokenTypes.COMMA) break;
            this.builder.advanceLexer();
            if (!this.builder.eof()) continue;
            this.builder.error(JavaScriptBundle.message((String)"javascript.parser.message.expected.rparen", (Object[])new Object[0]));
            return;
        }
        if (haveLParen) {
            ActionScriptFunctionParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
        } else {
            this.builder.advanceLexer();
        }
    }

    private static boolean isNonAttrListOwner(IElementType currentTokenType) {
        return currentTokenType != JSTokenTypes.VAR_KEYWORD && currentTokenType != JSTokenTypes.CONST_KEYWORD && currentTokenType != JSTokenTypes.FUNCTION_KEYWORD && currentTokenType != JSTokenTypes.CLASS_KEYWORD && currentTokenType != JSTokenTypes.INTERFACE_KEYWORD && currentTokenType != JSTokenTypes.NAMESPACE_KEYWORD;
    }

    @Override
    public void parseFunctionExpressionAttributeList() {
        PsiBuilder.Marker mark = this.builder.mark();
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.GET_KEYWORD || type == JSTokenTypes.SET_KEYWORD) {
            this.builder.advanceLexer();
        }
        mark.done(this.getAttributeListElementType());
    }

    @Override
    protected IElementType getFunctionExpressionElementType() {
        return ActionScriptElementTypes.FUNCTION_EXPRESSION;
    }
}

