/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.insight;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.ide.DataManager;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.AbstractTestFileStructureBuilder;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.JsTestFileIndexingHandler;
import com.intellij.javascript.testing.JSTestFailedLineManager;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.content.Content;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SelectInTestTree
implements LocalQuickFix,
Iconable {
    private final SmartPsiElementPointer<PsiElement> myPointer;
    private final ConfigurationType myConfigurationType;
    private final Icon myIcon;

    private SelectInTestTree(@NotNull PsiElement element, @NotNull ConfigurationType configurationType, @Nullable Icon icon) {
        if (element == null) {
            SelectInTestTree.$$$reportNull$$$0(0);
        }
        if (configurationType == null) {
            SelectInTestTree.$$$reportNull$$$0(1);
        }
        this.myPointer = SmartPointerManager.createPointer((PsiElement)element);
        this.myConfigurationType = configurationType;
        this.myIcon = icon;
    }

    @Nullable
    public static SelectInTestTree create(@NotNull PsiElement element) {
        ConfigurationContext context;
        RunnerAndConfigurationSettings settings;
        if (element == null) {
            SelectInTestTree.$$$reportNull$$$0(2);
        }
        RunConfiguration conf = (settings = (context = new ConfigurationContext(element)).getConfiguration()) != null ? settings.getConfiguration() : null;
        return conf != null ? new SelectInTestTree(element, conf.getType(), conf.getIcon()) : null;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"intention.family.name.select.in.test.tree", (Object[])new Object[0]);
        if (string == null) {
            SelectInTestTree.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        JsTestElementPath path;
        if (project == null) {
            SelectInTestTree.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            SelectInTestTree.$$$reportNull$$$0(5);
        }
        if ((path = SelectInTestTree.findContextTestPath(this.myPointer.getElement())) != null) {
            this.selectTest(project, proxy -> {
                String locationUrl = proxy.getLocationUrl();
                return locationUrl != null && (locationUrl.equals(JSTestFailedLineManager.locationUrl(path, false)) || locationUrl.equals(JSTestFailedLineManager.locationUrl(path, true)));
            });
        }
    }

    private void selectTest(@NotNull Project project, @NotNull Predicate<SMTestProxy> testAcceptor) {
        if (project == null) {
            SelectInTestTree.$$$reportNull$$$0(6);
        }
        if (testAcceptor == null) {
            SelectInTestTree.$$$reportNull$$$0(7);
        }
        List descriptors = RunContentManager.getInstance((Project)project).getAllDescriptors();
        for (RunContentDescriptor contentDescriptor : descriptors) {
            SMTestProxy testProxy;
            SMTRunnerConsoleView consoleView;
            RunConfiguration configuration;
            ExecutionEnvironment environment = SelectInTestTree.getExecutionEnvironment(contentDescriptor);
            if (environment == null || (configuration = (RunConfiguration)ObjectUtils.tryCast((Object)environment.getRunProfile(), RunConfiguration.class)) == null || !this.myConfigurationType.equals(configuration.getType()) || (consoleView = (SMTRunnerConsoleView)ObjectUtils.tryCast((Object)contentDescriptor.getExecutionConsole(), SMTRunnerConsoleView.class)) == null || (testProxy = SelectInTestTree.findTestProxy(consoleView.getResultsViewer().getTestsRootNode(), testAcceptor)) == null) continue;
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(environment.getExecutor().getToolWindowId());
            if (toolWindow != null) {
                Content consoleContent;
                RunnerLayoutUi ui = contentDescriptor.getRunnerLayoutUi();
                if (ui != null && (consoleContent = ui.findContent("ConsoleContent")) != null) {
                    ui.selectAndFocus(consoleContent, true, false);
                }
                toolWindow.activate(() -> consoleView.getResultsViewer().selectAndNotify((AbstractTestProxy)testProxy), true);
            }
            return;
        }
    }

    @Nullable
    private static ExecutionEnvironment getExecutionEnvironment(@NotNull RunContentDescriptor descriptor2) {
        JComponent component;
        if (descriptor2 == null) {
            SelectInTestTree.$$$reportNull$$$0(8);
        }
        if ((component = descriptor2.getComponent()) == null) {
            return null;
        }
        return (ExecutionEnvironment)LangDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext((Component)component));
    }

    @Nullable
    private static SMTestProxy findTestProxy(@NotNull SMTestProxy.SMRootTestProxy root, @NotNull Predicate<SMTestProxy> testAcceptor) {
        if (root == null) {
            SelectInTestTree.$$$reportNull$$$0(9);
        }
        if (testAcceptor == null) {
            SelectInTestTree.$$$reportNull$$$0(10);
        }
        for (SMTestProxy test : root.getAllTests()) {
            if (!test.isLeaf() || !testAcceptor.test(test)) continue;
            return test;
        }
        return null;
    }

    public Icon getIcon(int flags) {
        return this.myIcon;
    }

    @Nullable
    private static JsTestElementPath findContextTestPath(@Nullable PsiElement element) {
        JSFile file2 = (JSFile)ObjectUtils.tryCast((Object)(element != null ? element.getContainingFile() : null), JSFile.class);
        if (file2 == null) {
            return null;
        }
        for (AbstractTestFileStructureBuilder builder : JsTestFileIndexingHandler.getFileStructureBuilders()) {
            AbstractTestFileStructure structure = builder.fetchCachedTestFileStructure(file2);
            JsTestElementPath path = structure.findTestElementPath(element.getTextRange());
            if (path == null) continue;
            return path;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/insight/SelectInTestTree";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testAcceptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/insight/SelectInTestTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectTest";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExecutionEnvironment";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findTestProxy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

