/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.terminal;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;

public class NodeModulesEnvTerminalCustomizer
extends LocalTerminalCustomizer {
    private static final String PATH_ENV_NAME = "PATH";

    public String[] customizeCommandAndEnvironment(Project project, String[] command, Map<String, String> envs) {
        VirtualFile root = NodeModulesEnvTerminalCustomizer.getNodeModulesRoot(project);
        if (root != null && TerminalSettings.getInstance().isNodeModulesBinAdded()) {
            File binDir = new File(VfsUtilCore.virtualToIoFile((VirtualFile)root), "node_modules" + File.separator + ".bin");
            String pathValue = envs.get(PATH_ENV_NAME);
            envs.put(PATH_ENV_NAME, binDir.getPath() + File.pathSeparator + pathValue);
        }
        return super.customizeCommandAndEnvironment(project, command, envs);
    }

    @Nullable
    private static VirtualFile getNodeModulesRoot(@Nullable Project project) {
        VirtualFile baseDir;
        VirtualFile virtualFile = baseDir = project != null ? project.getBaseDir() : null;
        if (baseDir != null && (NodeModuleUtil.findChildNodeModulesDir(baseDir) != null || PackageJsonUtil.findChildPackageJsonFile(baseDir) != null)) {
            return baseDir;
        }
        return null;
    }

    @Nullable
    public UnnamedConfigurable getConfigurable(Project project) {
        return NodeModulesEnvTerminalCustomizer.getNodeModulesRoot(project) != null ? new NodeModulesBinConfigurable() : null;
    }

    @State(name="NodeModulesEnvTerminalCustomizer", storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)})
    private static class TerminalSettings
    implements PersistentStateComponent<SettingsState> {
        private SettingsState myState = new SettingsState();

        private TerminalSettings() {
        }

        private boolean isNodeModulesBinAdded() {
            return this.myState.myAddNodeModulesBin;
        }

        private void setNodeModulesBinAdded(boolean nodeModulesBinAdded) {
            this.myState.myAddNodeModulesBin = nodeModulesBinAdded;
        }

        @Nullable
        public SettingsState getState() {
            return this.myState;
        }

        public void loadState(@NotNull SettingsState state) {
            if (state == null) {
                TerminalSettings.$$$reportNull$$$0(0);
            }
            this.myState = state;
        }

        @NotNull
        private static TerminalSettings getInstance() {
            TerminalSettings terminalSettings = (TerminalSettings)ApplicationManager.getApplication().getService(TerminalSettings.class);
            if (terminalSettings == null) {
                TerminalSettings.$$$reportNull$$$0(1);
            }
            return terminalSettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer$TerminalSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/terminal/NodeModulesEnvTerminalCustomizer$TerminalSettings";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "loadState";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static class SettingsState {
            public boolean myAddNodeModulesBin = true;
        }
    }

    private static class NodeModulesBinConfigurable
    implements UnnamedConfigurable {
        private final JCheckBox myCheckbox = new JCheckBox(JavaScriptBundle.message((String)"terminal.add_node_modules_bin_to_path.label", (Object[])new Object[]{SystemInfo.isWindows ? "%PATH%" : "$PATH"}));
        private final TerminalSettings mySettings = TerminalSettings.getInstance();

        NodeModulesBinConfigurable() {
        }

        @Nullable
        public JComponent createComponent() {
            return this.myCheckbox;
        }

        public boolean isModified() {
            return this.mySettings.isNodeModulesBinAdded() != this.myCheckbox.isSelected();
        }

        public void apply() throws ConfigurationException {
            this.mySettings.setNodeModulesBinAdded(this.myCheckbox.isSelected());
        }

        public void reset() {
            this.myCheckbox.setSelected(this.mySettings.isNodeModulesBinAdded());
        }
    }
}

