/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.notification;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packageJson.notification.PackageVersionRangeMatchRequest;
import com.intellij.javascript.nodejs.packageJson.notification.PackageVersionRangeMatchResponse;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import com.vdurmont.semver4j.Requirement;
import com.vdurmont.semver4j.Semver;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageVersionRangeMatcher {
    private static final Logger LOG = Logger.getInstance(PackageVersionRangeMatcher.class);
    private static final long TOTAL_WAIT_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private static volatile File WORKING_DIRECTORY;
    private static final Map<Key, Value> CACHE;

    private PackageVersionRangeMatcher() {
    }

    public static boolean isMatched(@NotNull NodeJsLocalInterpreter interpreter, @NotNull List<PackageVersionRangeMatchRequest> requests) {
        if (interpreter == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(0);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(1);
        }
        try {
            List<PackageVersionRangeMatchResponse> mismatches = PackageVersionRangeMatcher.findMismatches(requests, (ThrowableComputable<NodeJsInterpreter, ExecutionException>)((ThrowableComputable)() -> interpreter));
            return mismatches.isEmpty();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    @NotNull
    public static List<PackageVersionRangeMatchResponse> findMismatches(@NotNull Project project, @NotNull List<PackageVersionRangeMatchRequest> requests) throws ExecutionException {
        if (project == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(2);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(3);
        }
        return PackageVersionRangeMatcher.findMismatches(requests, (ThrowableComputable<NodeJsInterpreter, ExecutionException>)((ThrowableComputable)() -> {
            NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(project).getInterpreter();
            return NodeInterpreterUtil.getValidInterpreterOrThrow(interpreter);
        }));
    }

    @NotNull
    private static List<PackageVersionRangeMatchResponse> findMismatches(@NotNull List<PackageVersionRangeMatchRequest> requests, @NotNull ThrowableComputable<NodeJsInterpreter, ExecutionException> interpreterComputable) throws ExecutionException {
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(4);
        }
        if (interpreterComputable == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(5);
        }
        RequestsAndResponses requestsAndResponses = PackageVersionRangeMatcher.getCached(requests);
        ArrayList<PackageVersionRangeMatchResponse> responses = new ArrayList<PackageVersionRangeMatchResponse>(requestsAndResponses.myCachedResponses);
        if (!requestsAndResponses.myRequestsToRun.isEmpty()) {
            responses.addAll(PackageVersionRangeMatcher.match(requestsAndResponses.myRequestsToRun, interpreterComputable));
        }
        PackageVersionRangeMatcher.validateResponses(requests, responses);
        List list2 = ContainerUtil.filter(responses, response -> !response.isMatched() && !response.hasErrors());
        if (list2 == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    private static RequestsAndResponses getCached(@NotNull List<PackageVersionRangeMatchRequest> requests) {
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(7);
        }
        ArrayList<PackageVersionRangeMatchResponse> responses = new ArrayList<PackageVersionRangeMatchResponse>();
        ArrayList<PackageVersionRangeMatchRequest> requestsToRun = new ArrayList<PackageVersionRangeMatchRequest>();
        for (PackageVersionRangeMatchRequest request : requests) {
            Key key = new Key(request.getVersionRange(), request.getVersion());
            Value value = CACHE.get(key);
            if (value != null) {
                responses.add(new PackageVersionRangeMatchResponse(request, value.myMatched, value.myInvalidVersion, value.myInvalidVersionRange));
                continue;
            }
            requestsToRun.add(request);
        }
        return new RequestsAndResponses(requestsToRun, responses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    static List<PackageVersionRangeMatchResponse> match(@NotNull List<PackageVersionRangeMatchRequest> requests, @NotNull ThrowableComputable<? extends NodeJsInterpreter, ? extends ExecutionException> interpreterComputable) {
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(8);
        }
        if (interpreterComputable == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(9);
        }
        Map<Key, Value> map = CACHE;
        // MONITORENTER : map
        RequestsAndResponses requestsAndResponses = PackageVersionRangeMatcher.getCached(requests);
        ArrayList<PackageVersionRangeMatchResponse> responses = new ArrayList<PackageVersionRangeMatchResponse>(requestsAndResponses.myCachedResponses);
        if (!requestsAndResponses.myRequestsToRun.isEmpty()) {
            NodeJsInterpreter interpreter = null;
            try {
                interpreter = (NodeJsInterpreter)interpreterComputable.compute();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            responses.addAll(PackageVersionRangeMatcher.handle(requestsAndResponses.myRequestsToRun, interpreter));
        }
        ArrayList<PackageVersionRangeMatchResponse> arrayList = responses;
        // MONITOREXIT : map
        if (arrayList != null) return arrayList;
        PackageVersionRangeMatcher.$$$reportNull$$$0(10);
        return arrayList;
    }

    @NotNull
    private static List<PackageVersionRangeMatchResponse> handle(@NotNull List<PackageVersionRangeMatchRequest> requests, @Nullable NodeJsInterpreter interpreter) {
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(11);
        }
        List<PackageVersionRangeMatchResponse> semver4jResult = PackageVersionRangeMatcher.runWithSemver4j(requests);
        PackageVersionRangeMatcher.storeResponses(semver4jResult);
        if (!ApplicationManager.getApplication().isUnitTestMode() && (ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isReadAccessAllowed())) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> PackageVersionRangeMatcher.verifySemver4jResult(semver4jResult, requests, interpreter, true));
            List<PackageVersionRangeMatchResponse> list2 = semver4jResult;
            if (list2 == null) {
                PackageVersionRangeMatcher.$$$reportNull$$$0(12);
            }
            return list2;
        }
        return PackageVersionRangeMatcher.verifySemver4jResult(semver4jResult, requests, interpreter, false);
    }

    @NotNull
    private static List<PackageVersionRangeMatchResponse> verifySemver4jResult(@NotNull List<PackageVersionRangeMatchResponse> semver4jResult, @NotNull List<PackageVersionRangeMatchRequest> requests, @Nullable NodeJsInterpreter interpreter, boolean restartCodeAnalysisIfMismatched) {
        List<PackageVersionRangeMatchResponse> nodeResult;
        if (semver4jResult == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(13);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(14);
        }
        if (interpreter == null) {
            List<PackageVersionRangeMatchResponse> list2 = semver4jResult;
            if (list2 == null) {
                PackageVersionRangeMatcher.$$$reportNull$$$0(15);
            }
            return list2;
        }
        try {
            nodeResult = PackageVersionRangeMatcher.runWithNode(requests, interpreter);
        }
        catch (ExecutionException e) {
            LOG.info("Cannot check requests", (Throwable)e);
            List<PackageVersionRangeMatchResponse> list3 = semver4jResult;
            if (list3 == null) {
                PackageVersionRangeMatcher.$$$reportNull$$$0(16);
            }
            return list3;
        }
        Object errorMessage = PackageVersionRangeMatcher.getErrorMessageIfUnequal(nodeResult, semver4jResult);
        if (errorMessage != null) {
            if (restartCodeAnalysisIfMismatched) {
                PackageVersionRangeMatcher.restartCodeAnalysis();
            }
            errorMessage = "Different node and semver4j results: " + (String)errorMessage;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.error((String)errorMessage);
            } else {
                LOG.info((String)errorMessage);
            }
        }
        PackageVersionRangeMatcher.storeResponses(nodeResult);
        List<PackageVersionRangeMatchResponse> list4 = nodeResult;
        if (list4 == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(17);
        }
        return list4;
    }

    private static void restartCodeAnalysis() {
        ReadAction.run(() -> {
            Project[] projects;
            for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
                if (project.isDisposed()) continue;
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeResponses(@NotNull List<PackageVersionRangeMatchResponse> result2) {
        if (result2 == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(18);
        }
        Map<Key, Value> map = CACHE;
        synchronized (map) {
            for (PackageVersionRangeMatchResponse response : result2) {
                CACHE.put(new Key(response.getRequest().getVersionRange(), response.getRequest().getVersion()), new Value(response.isMatched(), response.isInvalidVersion(), response.isInvalidVersionRange()));
            }
        }
    }

    @Nullable
    private static String getErrorMessageIfUnequal(@NotNull List<PackageVersionRangeMatchResponse> nodeResponses, @NotNull List<PackageVersionRangeMatchResponse> semver4jResponses) {
        if (nodeResponses == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(19);
        }
        if (semver4jResponses == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(20);
        }
        if (nodeResponses.size() != semver4jResponses.size()) {
            return "node size: " + nodeResponses.size() + ", semver4j size: " + semver4jResponses.size();
        }
        for (int i = 0; i < nodeResponses.size(); ++i) {
            PackageVersionRangeMatchResponse node = nodeResponses.get(i);
            PackageVersionRangeMatchResponse semver4j = semver4jResponses.get(i);
            if (!node.getRequest().equals(semver4j.getRequest())) {
                return "(request) node: " + node.getRequest() + ", semver4j: " + semver4j.getRequest();
            }
            if (node.hasErrors() == semver4j.hasErrors() && node.isMatched() == semver4j.isMatched()) continue;
            return "\n    node: " + node + ",\nsemver4j: " + semver4j;
        }
        return null;
    }

    @NotNull
    private static List<PackageVersionRangeMatchResponse> runWithSemver4j(@NotNull List<PackageVersionRangeMatchRequest> requestsToRun) {
        if (requestsToRun == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(21);
        }
        List list2 = ContainerUtil.map(requestsToRun, request -> {
            Semver version = null;
            try {
                version = new Semver(request.getVersion(), Semver.SemverType.NPM);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Requirement range = null;
            try {
                if (!request.getVersionRange().contains("latest")) {
                    range = Requirement.buildNPM((String)request.getVersionRange());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean matched = false;
            if (version != null && range != null) {
                try {
                    matched = request.getVersionRange().equals(request.getVersion()) || range.isSatisfiedBy(version);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new PackageVersionRangeMatchResponse((PackageVersionRangeMatchRequest)request, matched, version == null, range == null);
        });
        if (list2 == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(22);
        }
        return list2;
    }

    @NotNull
    private static List<PackageVersionRangeMatchResponse> runWithNode(@NotNull List<PackageVersionRangeMatchRequest> requests, @NotNull NodeJsInterpreter interpreter) throws ExecutionException {
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(23);
        }
        if (interpreter == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(24);
        }
        GeneralCommandLine commandLine = PackageVersionRangeMatcher.createCommandLine(interpreter, requests);
        long startNano = System.nanoTime();
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler(commandLine, false);
        CapturingProcessRunner runner = new CapturingProcessRunner((BaseProcessHandler)processHandler);
        ProcessOutput output = runner.runProcess((int)TOTAL_WAIT_TIMEOUT_MILLIS, true);
        if (output.isTimeout()) {
            throw new ExecutionException("'" + commandLine.getCommandLineString() + "' command run is timed out (>" + TOTAL_WAIT_TIMEOUT_MILLIS + " ms)");
        }
        if (output.getExitCode() != 0) {
            throw new ExecutionException("Failed to run " + NodeCommandLineUtil.formatErrorMessage(commandLine, output));
        }
        List<PackageVersionRangeMatchResponse> result2 = PackageVersionRangeMatcher.parse(output.getStdout(), interpreter);
        PackageVersionRangeMatcher.validateResponses(requests, result2);
        LOG.info("Matching " + requests.size() + " done in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms");
        List<PackageVersionRangeMatchResponse> list2 = result2;
        if (list2 == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(25);
        }
        return list2;
    }

    private static void validateResponses(@NotNull List<PackageVersionRangeMatchRequest> requests, @NotNull List<PackageVersionRangeMatchResponse> responses) throws ExecutionException {
        List processed;
        HashSet processedSet;
        HashSet<PackageVersionRangeMatchRequest> original;
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(26);
        }
        if (responses == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(27);
        }
        if (!(original = new HashSet<PackageVersionRangeMatchRequest>(requests)).equals(processedSet = new HashSet(processed = ContainerUtil.map(responses, response -> response.getRequest())))) {
            throw new ExecutionException("Responses do not match requests: requests: " + requests + ", responses: " + processed);
        }
    }

    @NotNull
    private static GeneralCommandLine createCommandLine(@NotNull NodeJsInterpreter interpreter, @NotNull List<PackageVersionRangeMatchRequest> requests) throws ExecutionException {
        if (interpreter == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(28);
        }
        if (requests == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(29);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setCharset(StandardCharsets.UTF_8);
        commandLine.setWorkDirectory(PackageVersionRangeMatcher.getWorkingDirectory());
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.addParameter(HelperFilesLocator.resolvePathForExecution("package-version-range-matcher/bin/batch-matcher"));
        for (PackageVersionRangeMatchRequest request : requests) {
            commandLine.addParameter("--package");
            commandLine.addParameter(request.getPackageName());
            commandLine.addParameter(request.getVersionRange());
            commandLine.addParameter(request.getVersion());
        }
        NodeCommandLineConfigurator.find(interpreter).configure(commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(30);
        }
        return generalCommandLine;
    }

    @NotNull
    private static File getWorkingDirectory() throws ExecutionException {
        File workingDirectory = WORKING_DIRECTORY;
        if (workingDirectory == null || !workingDirectory.isDirectory()) {
            try {
                WORKING_DIRECTORY = workingDirectory = FileUtil.createTempDirectory((String)"intellij-package-json-version-range-check", null, (boolean)true);
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
        File file2 = workingDirectory;
        if (file2 == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(31);
        }
        return file2;
    }

    @NotNull
    private static List<PackageVersionRangeMatchResponse> parse(@NotNull String content, @NotNull NodeJsInterpreter interpreter) throws ExecutionException {
        JsonArray array;
        if (content == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(32);
        }
        if (interpreter == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(33);
        }
        ArrayList<PackageVersionRangeMatchResponse> result2 = new ArrayList<PackageVersionRangeMatchResponse>();
        try {
            array = JsonUtil.parseJsonArray((String)content);
        }
        catch (Exception e) {
            throw new ExecutionException("Cannot parse result from " + interpreter.getReferenceName() + ": " + content, (Throwable)e);
        }
        for (JsonElement element : array) {
            JsonObject obj = element.getAsJsonObject();
            String packageName = JsonUtil.getChildAsString((JsonObject)obj, (String)"packageName");
            String versionRange = JsonUtil.getChildAsString((JsonObject)obj, (String)"versionRange");
            String version = JsonUtil.getChildAsString((JsonObject)obj, (String)"version");
            Boolean matched = JsonUtil.getChildAsBooleanObj((JsonObject)obj, (String)"matched");
            boolean invalidVersion = JsonUtil.getChildAsBoolean((JsonObject)obj, (String)"invalidVersion", (boolean)false);
            boolean invalidVersionRange = JsonUtil.getChildAsBoolean((JsonObject)obj, (String)"invalidVersionRange", (boolean)false);
            if (invalidVersion || invalidVersionRange) {
                matched = false;
            }
            if (packageName == null || versionRange == null || version == null || matched == null) {
                throw new ExecutionException("packageName: " + packageName + ", versionRange: " + versionRange + ", version: " + version + ", matched: " + matched);
            }
            result2.add(new PackageVersionRangeMatchResponse(new PackageVersionRangeMatchRequest(packageName, versionRange, version), matched, invalidVersion, invalidVersionRange));
        }
        ArrayList<PackageVersionRangeMatchResponse> arrayList = result2;
        if (arrayList == null) {
            PackageVersionRangeMatcher.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    static {
        CACHE = ContainerUtil.createConcurrentSoftMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 25: 
            case 30: 
            case 31: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 25: 
            case 30: 
            case 31: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterComputable";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 25: 
            case 30: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/notification/PackageVersionRangeMatcher";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semver4jResult";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeResponses";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semver4jResponses";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestsToRun";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responses";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageVersionRangeMatcher";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findMismatches";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "match";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "handle";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "verifySemver4jResult";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "runWithSemver4j";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "runWithNode";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingDirectory";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMatched";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findMismatches";
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 25: 
            case 30: 
            case 31: 
            case 34: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCached";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handle";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "verifySemver4jResult";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "storeResponses";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessageIfUnequal";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "runWithSemver4j";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "runWithNode";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "validateResponses";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 25: 
            case 30: 
            case 31: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RequestsAndResponses {
        public final List<PackageVersionRangeMatchRequest> myRequestsToRun;
        public final List<PackageVersionRangeMatchResponse> myCachedResponses;

        RequestsAndResponses(@NotNull List<PackageVersionRangeMatchRequest> requestsToRun, @NotNull List<PackageVersionRangeMatchResponse> cachedResponses) {
            if (requestsToRun == null) {
                RequestsAndResponses.$$$reportNull$$$0(0);
            }
            if (cachedResponses == null) {
                RequestsAndResponses.$$$reportNull$$$0(1);
            }
            this.myRequestsToRun = requestsToRun;
            this.myCachedResponses = cachedResponses;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "requestsToRun";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cachedResponses";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageVersionRangeMatcher$RequestsAndResponses";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Value {
        private final boolean myMatched;
        private final boolean myInvalidVersion;
        private final boolean myInvalidVersionRange;

        Value(boolean matched, boolean invalidVersion, boolean invalidVersionRange) {
            this.myMatched = matched;
            this.myInvalidVersion = invalidVersion;
            this.myInvalidVersionRange = invalidVersionRange;
        }
    }

    private static class Key {
        private final String myVersionRange;
        private final String myVersion;

        Key(@NotNull String versionRange, @NotNull String version) {
            if (versionRange == null) {
                Key.$$$reportNull$$$0(0);
            }
            if (version == null) {
                Key.$$$reportNull$$$0(1);
            }
            this.myVersionRange = versionRange;
            this.myVersion = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.myVersionRange.equals(key.myVersionRange) && this.myVersion.equals(key.myVersion);
        }

        public int hashCode() {
            int result2 = this.myVersionRange.hashCode();
            result2 = 31 * result2 + this.myVersion.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "versionRange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "version";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/packageJson/notification/PackageVersionRangeMatcher$Key";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

