/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.codeInsight.popularPackages;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryServiceImpl;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.nodejs.packageJson.codeInsight.popularPackages.PopularNodePackagesProvider;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PopularPackageListGenerator {
    private static final List<String> EXPLICITLY_REQUIRED_PACKAGES = List.of("svelte", "@angular/core", "@angular/material", "react", "@material-ui/core", "react-bootstrap", "ionic", "cordova", "vue", "vuetify", "bootstrap-vue", "quasar", "ember-cli", "react-native", "electron", "express", "gatsby", "next", "graphql", "graphql-relay", "apollo-client", "jest", "enzyme", "mocha", "karma", "protractor", "cucumber", "ava", "eslint", "tslint", "flow-bin", "prettier", "nuxt", "tailwindcss");
    private static final String MOST_DEPENDED_UPON_PACKAGES_DIR = "most-depended-upon-packages";
    private static final int PACKAGES_PER_PAGE = 36;
    private static final int MAX_OFFSET = 360;
    private static final int N = 1000;

    public static void main(String[] args) throws IOException {
        File downloadRoot = PopularPackageListGenerator.download();
        List<NodePackageBasicInfo> infos = PopularPackageListGenerator.parseAll(downloadRoot);
        PopularPackageListGenerator.addRequiredPackages(infos);
        PopularPackageListGenerator.addPrevPackagesIfNeeded(infos);
        PopularPackageListGenerator.writePackagesWithInfo(infos, PopularPackageListGenerator.getFile("./plugins/JavaScriptLanguage/src/com/intellij/javascript/nodejs/packageJson/codeInsight/popularPackages/popular-node-packages.json"));
        PopularPackageListGenerator.writeDict(infos, PopularPackageListGenerator.getFile("./plugins/JavaScriptLanguage/src/com/intellij/lang/javascript/highlighting/dictionary/packages.dic"));
    }

    @NotNull
    private static File getFile(@NotNull String relativePath) throws IOException {
        File file2;
        File dir;
        if (relativePath == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(0);
        }
        if (!(dir = (file2 = new File(relativePath)).getParentFile()).isDirectory()) {
            throw new IOException("No such directory " + dir.getAbsolutePath());
        }
        File file3 = file2;
        if (file3 == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(1);
        }
        return file3;
    }

    private static void addRequiredPackages(@NotNull List<NodePackageBasicInfo> result2) {
        if (result2 == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(2);
        }
        PopularPackageListGenerator.addPackages(result2, EXPLICITLY_REQUIRED_PACKAGES, false);
    }

    private static void addPrevPackagesIfNeeded(@NotNull List<NodePackageBasicInfo> result2) throws IOException {
        if (result2 == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(3);
        }
        PopularPackageListGenerator.addPackages(result2, ContainerUtil.map(PopularNodePackagesProvider.parse(), NodePackageBasicInfo::getName), true);
    }

    private static void addPackages(@NotNull List<NodePackageBasicInfo> result2, @NotNull List<String> namesToAdd, boolean withLimit) {
        if (result2 == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(4);
        }
        if (namesToAdd == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(5);
        }
        namesToAdd = new ArrayList<String>(namesToAdd);
        namesToAdd.removeAll(ContainerUtil.map(result2, NodePackageBasicInfo::getName));
        if (withLimit) {
            namesToAdd = namesToAdd.subList(0, Math.max(1000 - result2.size(), 0));
        }
        PopularPackageListGenerator.log("Fetching metadata for " + namesToAdd.size() + " packages...", new Object[0]);
        long startNano = System.nanoTime();
        result2.addAll(ContainerUtil.map(namesToAdd, name -> PopularPackageListGenerator.createInfo(name)));
        long durationMillis = TimeoutUtil.getDurationMillis((long)startNano);
        PopularPackageListGenerator.log("Done in " + durationMillis + " ms (single fetch: " + durationMillis / (long)namesToAdd.size() + " ms)\n", new Object[0]);
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static NodePackageBasicInfo createInfo(@NotNull String packageName) {
        if (packageName == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(6);
        }
        String metadata = NpmRegistryServiceImpl.fetchPackageMetadata(packageName, false);
        JsonReader reader = new JsonReader((Reader)new StringReader(metadata));
        NodePackageBasicInfo info = NpmRegistryServiceImpl.readPackageInfo(reader);
        if (info == null || !info.getName().equals(packageName)) {
            throw new RuntimeException("Cannot parse metadata for " + packageName + ": " + info);
        }
        NodePackageBasicInfo nodePackageBasicInfo = new NodePackageBasicInfo(info.getName(), PopularPackageListGenerator.normalizeDescription(info.getDescription()));
        reader.close();
        NodePackageBasicInfo nodePackageBasicInfo2 = nodePackageBasicInfo;
        if (nodePackageBasicInfo2 == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(7);
        }
        return nodePackageBasicInfo2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot fetch package info for " + packageName, e);
                }
            }
        }
    }

    private static File download() throws IOException {
        File baseDir = FileUtil.createTempDirectory((String)"popular-node-packages-data", null, (boolean)false);
        if (!baseDir.isDirectory()) {
            throw new RuntimeException("Not a directory: " + baseDir.getAbsolutePath());
        }
        PopularPackageListGenerator.download("https://www.npmjs.com/browse/depended?offset=%d", new File(baseDir, MOST_DEPENDED_UPON_PACKAGES_DIR));
        return baseDir;
    }

    private static void download(@NotNull String urlPrefix, @NotNull File dir) throws IOException {
        if (urlPrefix == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(8);
        }
        if (dir == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(9);
        }
        PopularPackageListGenerator.log("\n=== Downloading to " + dir.getAbsolutePath() + " ===", new Object[0]);
        for (int i = 0; i < 10; ++i) {
            int finalInd = i;
            String url = String.format(urlPrefix, i * 36);
            long startNano = System.nanoTime();
            RequestBuilder requestBuilder = HttpRequests.request((String)url);
            requestBuilder.connectTimeout(10000);
            requestBuilder.readTimeout(10000);
            requestBuilder.tuner(new HttpRequests.ConnectionTuner(){

                public void tune(@NotNull URLConnection connection) {
                    if (connection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        connection.setRequestProperty("Cookie", FileUtil.loadFile((File)new File("plugins/JavaScriptLanguage/src/com/intellij/javascript/nodejs/packageJson/codeInsight/popularPackages/cookie.txt")).trim());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/javascript/nodejs/packageJson/codeInsight/popularPackages/PopularPackageListGenerator$1", "tune"));
                }
            });
            boolean ok = false;
            int retries = 0;
            while (!ok && retries < 10) {
                int finalRetries = retries++;
                ok = (Boolean)requestBuilder.connect(request -> {
                    String content = request.readString(null);
                    HttpURLConnection connection = (HttpURLConnection)ObjectUtils.tryCast((Object)request.getConnection(), HttpURLConnection.class);
                    int responseCode = Objects.requireNonNull(connection).getResponseCode();
                    File file2 = new File(dir, finalInd + ".html");
                    PopularPackageListGenerator.log("Downloaded in %d ms, content: %s, %s, response: %d, retries: %d, file: %s, ", TimeoutUtil.getDurationMillis((long)startNano), content.length(), url, responseCode, finalRetries, file2.getName());
                    FileUtil.writeToFile((File)file2, (String)content);
                    TimeoutUtil.sleep((long)1000L);
                    List<NodePackageBasicInfo> infos = PopularPackageListGenerator.parsedInfos(content);
                    return infos.size() > 0;
                });
            }
        }
    }

    private static void log(String format, Object ... args) {
        System.out.printf(format + "\n", args);
    }

    @NotNull
    public static List<NodePackageBasicInfo> parseAll(@NotNull File downloadRoot) throws IOException {
        if (downloadRoot == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(10);
        }
        List<NodePackageBasicInfo> mostDependedUponInfos = PopularPackageListGenerator.parse(new File(downloadRoot, MOST_DEPENDED_UPON_PACKAGES_DIR));
        PopularPackageListGenerator.log("", new Object[0]);
        PopularPackageListGenerator.log("Most depended upon: " + mostDependedUponInfos.size(), new Object[0]);
        List<NodePackageBasicInfo> list2 = mostDependedUponInfos.stream().limit(1000L).collect(Collectors.toList());
        if (list2 == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @NotNull
    private static List<NodePackageBasicInfo> parse(@NotNull File dir) throws IOException {
        if (dir == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(12);
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException();
        }
        File[] files = (File[])ObjectUtils.notNull((Object)dir.listFiles(), (Object)ArrayUtilRt.EMPTY_FILE_ARRAY);
        Arrays.sort(files, (o1, o2) -> {
            String name1 = o1.getName();
            String name2 = o2.getName();
            int id1 = Integer.parseInt(FileUtilRt.getNameWithoutExtension((String)name1));
            int id2 = Integer.parseInt(FileUtilRt.getNameWithoutExtension((String)name2));
            return id1 - id2;
        });
        ArrayList<NodePackageBasicInfo> infos = new ArrayList<NodePackageBasicInfo>();
        HashSet<String> names = new HashSet<String>();
        for (File file2 : files) {
            PopularPackageListGenerator.log("Parsing " + file2.getAbsolutePath(), new Object[0]);
            String content = FileUtil.loadFile((File)file2);
            List<NodePackageBasicInfo> parsed = PopularPackageListGenerator.parsedInfos(content);
            for (NodePackageBasicInfo info : parsed) {
                if (!names.add(info.getName())) {
                    throw new RuntimeException("Duplicated name " + info.getName());
                }
                infos.add(info);
            }
        }
        ArrayList<NodePackageBasicInfo> arrayList = infos;
        if (arrayList == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    private static List<NodePackageBasicInfo> parsedInfos(@NotNull String content) {
        Matcher matcher;
        if (content == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(14);
        }
        if (!(matcher = Pattern.compile("<script integrity=\"[^\"]*\">").matcher(content)).find()) {
            throw new RuntimeException("Cannot find script content");
        }
        int start = matcher.end();
        int end = content.indexOf("</script>", start);
        if (start == -1 || end == -1) {
            throw new RuntimeException("Cannot find script content");
        }
        String inner = content.substring(start, end);
        int startObj = inner.indexOf(123);
        if (startObj == -1) {
            throw new RuntimeException("Cannot find script content");
        }
        JsonElement element = JsonParser.parseString((String)inner.substring(startObj));
        JsonArray packages = element.getAsJsonObject().getAsJsonObject("context").getAsJsonArray("packages");
        if (packages == null) {
            throw new RuntimeException("No packages parsed");
        }
        ArrayList<NodePackageBasicInfo> infos = new ArrayList<NodePackageBasicInfo>();
        for (JsonElement pkg : packages) {
            JsonObject obj = pkg.getAsJsonObject();
            String name = JsonUtil.getChildAsString((JsonObject)obj, (String)"name");
            String description = JsonUtil.getChildAsString((JsonObject)obj, (String)"description");
            NodePackageBasicInfo info = new NodePackageBasicInfo(Objects.requireNonNull(name), PopularPackageListGenerator.normalizeDescription(description));
            infos.add(info);
        }
        if (infos.size() != 36) {
            throw new RuntimeException("Unexpected parsed packages count. Actual: " + infos.size() + ", expected: 36");
        }
        ArrayList<NodePackageBasicInfo> arrayList = infos;
        if (arrayList == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Nullable
    private static String normalizeDescription(@Nullable String description) {
        if (description == null) {
            return null;
        }
        if (!(description = StringUtil.unescapeXmlEntities((String)description)).contains(". ")) {
            description = StringUtil.trimEnd((String)description, (String)".");
        }
        if (description.startsWith("[![")) {
            return null;
        }
        return description;
    }

    private static void writeDict(@NotNull List<NodePackageBasicInfo> names, @NotNull File outputFile) throws IOException {
        if (names == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(16);
        }
        if (outputFile == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(17);
        }
        HashSet<String> words = new HashSet<String>();
        for (NodePackageBasicInfo name : names) {
            String[] split;
            for (String s : split = name.getName().split("[/\\-.]")) {
                if ((s = StringUtil.trimStart((String)s, (String)"@")).length() <= 3) continue;
                words.add(s);
            }
        }
        String collect = words.stream().sorted().collect(Collectors.joining("\n"));
        FileUtil.writeToFile((File)outputFile, (String)collect);
        PopularPackageListGenerator.log(words.size() + " names written to " + outputFile.getAbsolutePath(), new Object[0]);
    }

    private static void writePackagesWithInfo(@NotNull List<NodePackageBasicInfo> names, @NotNull File outputFile) throws IOException {
        if (names == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(18);
        }
        if (outputFile == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(19);
        }
        try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8));){
            writer.setIndent(" ");
            writer.beginArray();
            for (NodePackageBasicInfo info : names) {
                writer.beginArray();
                writer.setIndent("");
                writer.value(info.getName());
                if (info.getDescription() != null) {
                    writer.value(info.getDescription());
                }
                writer.endArray();
                writer.setIndent(" ");
            }
            writer.endArray();
        }
        PopularPackageListGenerator.log(names.size() + " packages are written to " + outputFile.getAbsolutePath(), new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/popularPackages/PopularPackageListGenerator";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesToAdd";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlPrefix";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadRoot";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/popularPackages/PopularPackageListGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAll";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "parsedInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addRequiredPackages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addPrevPackagesIfNeeded";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPackages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseAll";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parsedInfos";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "writeDict";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "writePackagesWithInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

