/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkingDirectoryDependentNpmPackageVersionManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(WorkingDirectoryDependentNpmPackageVersionManager.class);
    private static final ExecutorService ourExecutorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)(WorkingDirectoryDependentNpmPackageVersionManager.class.getSimpleName() + " Pool"));
    private final Project myProject;
    private final ConcurrentMap<InputData, VersionInfo> myVersionCache;
    private final ConcurrentMap<InputData, Fetch> myFetchInProgressByPkgMap;
    private final List<ModificationTracker> myModificationTrackers;

    public WorkingDirectoryDependentNpmPackageVersionManager(@NotNull Project project) {
        if (project == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(0);
        }
        this.myVersionCache = new ConcurrentHashMap<InputData, VersionInfo>();
        this.myFetchInProgressByPkgMap = new ConcurrentHashMap<InputData, Fetch>();
        this.myProject = project;
        final SimpleModificationTracker switchedOutModificationTracker = new SimpleModificationTracker();
        this.myModificationTrackers = ContainerUtil.newArrayList((Object[])new ModificationTracker[]{switchedOutModificationTracker, VirtualFileManager.getInstance()});
        project.getMessageBus().connect((Disposable)this).subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    1.$$$reportNull$$$0(0);
                }
                switchedOutModificationTracker.incModificationCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/javascript/nodejs/npm/WorkingDirectoryDependentNpmPackageVersionManager$1", "applicationDeactivated"));
            }
        });
    }

    public void dispose() {
    }

    @NotNull
    public static WorkingDirectoryDependentNpmPackageVersionManager getInstance(@NotNull Project project) {
        if (project == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(1);
        }
        WorkingDirectoryDependentNpmPackageVersionManager workingDirectoryDependentNpmPackageVersionManager = (WorkingDirectoryDependentNpmPackageVersionManager)ServiceManager.getService((Project)project, WorkingDirectoryDependentNpmPackageVersionManager.class);
        if (workingDirectoryDependentNpmPackageVersionManager == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(2);
        }
        return workingDirectoryDependentNpmPackageVersionManager;
    }

    public void fetchVersion(@NotNull NodePackage pkg, @NotNull Consumer<SemVer> versionConsumer) {
        if (pkg == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(3);
        }
        if (versionConsumer == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(4);
        }
        this.fetchVersion(pkg, null, versionConsumer);
    }

    public void fetchVersion(@NotNull NodePackage pkg, @Nullable File workingDirectory, @NotNull Consumer<SemVer> versionConsumer) {
        if (pkg == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(5);
        }
        if (versionConsumer == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(6);
        }
        File effectiveWorkingDirectory = workingDirectory != null ? workingDirectory : this.getDefaultWorkingDir();
        InputData inputData = new InputData(pkg, effectiveWorkingDirectory.getAbsolutePath());
        VersionInfo info = (VersionInfo)this.myVersionCache.get(inputData);
        NullableLazyValue pkgVersionFromPackageJsonValue = NullableLazyValue.createValue(() -> pkg.getVersion());
        SemVer initialVersion = info != null && info.myPkgVersionInProjectRoot != null ? info.myPkgVersionInProjectRoot : (SemVer)pkgVersionFromPackageJsonValue.getValue();
        versionConsumer.accept(initialVersion);
        if (info != null && info.isModCountsUpToDate() && Objects.equals(pkgVersionFromPackageJsonValue.getValue(), info.myPkgVersionFromPackageJson)) {
            return;
        }
        Fetch newFetch = new Fetch(inputData);
        Fetch prevFetch = this.myFetchInProgressByPkgMap.putIfAbsent(inputData, newFetch);
        Fetch fetch = (Fetch)ObjectUtils.notNull((Object)prevFetch, (Object)newFetch);
        fetch.notifyWhenDone(versionConsumer, initialVersion);
    }

    @NotNull
    private SemVer fetchProjectVersion(@NotNull NodePackage pkg, @NotNull File workingDirectory) throws com.intellij.execution.ExecutionException {
        ProcessOutput output;
        NodeJsInterpreter interpreter;
        if (pkg == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(7);
        }
        if (workingDirectory == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(8);
        }
        if ((interpreter = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreter()) == null) {
            throw new com.intellij.execution.ExecutionException("Unresolved interpreter");
        }
        if (interpreter instanceof NodeJsLocalInterpreter && ((NodeJsLocalInterpreter)interpreter).isElectron()) {
            throw new com.intellij.execution.ExecutionException("Electron Node.js interpreter is not supported");
        }
        GeneralCommandLine commandLine = NpmUtil.createNpmCommandLine(workingDirectory, interpreter, pkg, null, Collections.singletonList("--version"));
        try {
            output = NodeCommandLineUtil.execute(commandLine, 5000L);
        }
        catch (com.intellij.execution.ExecutionException e) {
            throw new com.intellij.execution.ExecutionException("Cannot fetch version (" + commandLine.getCommandLineString() + ")", (Throwable)e);
        }
        if (output.isTimeout()) {
            throw new com.intellij.execution.ExecutionException("Cannot fetch version: timed out (" + commandLine.getCommandLineString() + ")");
        }
        if (output.getExitCode() != 0) {
            throw new com.intellij.execution.ExecutionException("Cannot fetch version: non-zero exit code " + output.getExitCode() + " (" + commandLine.getCommandLineString() + "), stdout: " + output.getStdout() + ", stderr: " + output.getStderr());
        }
        List stdout = output.getStdoutLines(true);
        if (stdout.size() != 1) {
            throw new com.intellij.execution.ExecutionException("Cannot parse version: expected single line, actual lines " + stdout + " (" + commandLine.getCommandLineString() + ")");
        }
        SemVer version = SemVer.parseFromText((String)StringUtil.trimStart((String)((String)stdout.get(0)), (String)"v"));
        if (version == null) {
            throw new com.intellij.execution.ExecutionException("Cannot parse version from '" + (String)stdout.get(0) + "' (" + commandLine.getCommandLineString() + ")");
        }
        SemVer semVer = version;
        if (semVer == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(9);
        }
        return semVer;
    }

    @NotNull
    private File getDefaultWorkingDir() {
        VirtualFile projectRoot = ProjectUtil.guessProjectDir((Project)this.myProject);
        if (projectRoot != null) {
            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)projectRoot);
            if (file2 == null) {
                WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(10);
            }
            return file2;
        }
        return new File(SystemProperties.getUserHome());
    }

    private long @NotNull [] createModCounts() {
        long[] counts = new long[this.myModificationTrackers.size()];
        for (int i = 0; i < this.myModificationTrackers.size(); ++i) {
            counts[i] = this.myModificationTrackers.get(i).getModificationCount();
        }
        if (counts == null) {
            WorkingDirectoryDependentNpmPackageVersionManager.$$$reportNull$$$0(11);
        }
        return counts;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/WorkingDirectoryDependentNpmPackageVersionManager";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionConsumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/WorkingDirectoryDependentNpmPackageVersionManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchProjectVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultWorkingDir";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createModCounts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fetchVersion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fetchProjectVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InputData {
        private final NodePackage myPkg;
        private final String myWorkingDirectory;

        private InputData(@NotNull NodePackage pkg, @NotNull String workingDirectory) {
            if (pkg == null) {
                InputData.$$$reportNull$$$0(0);
            }
            if (workingDirectory == null) {
                InputData.$$$reportNull$$$0(1);
            }
            this.myPkg = pkg;
            this.myWorkingDirectory = workingDirectory;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InputData data = (InputData)o;
            return this.myPkg.equals(data.myPkg) && this.myWorkingDirectory.equals(data.myWorkingDirectory);
        }

        public int hashCode() {
            return Objects.hash(this.myPkg, this.myWorkingDirectory);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pkg";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workingDirectory";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/npm/WorkingDirectoryDependentNpmPackageVersionManager$InputData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class VersionInfo {
        private final SemVer myPkgVersionFromPackageJson;
        private final SemVer myPkgVersionInProjectRoot;
        private final long[] myModificationCounts;

        VersionInfo(@Nullable SemVer pkgVersionFromPackageJson, SemVer pkgVersionInProjectRoot) {
            this.myPkgVersionFromPackageJson = pkgVersionFromPackageJson;
            this.myPkgVersionInProjectRoot = pkgVersionInProjectRoot;
            this.myModificationCounts = WorkingDirectoryDependentNpmPackageVersionManager.this.createModCounts();
        }

        boolean isModCountsUpToDate() {
            return Arrays.equals(this.myModificationCounts, WorkingDirectoryDependentNpmPackageVersionManager.this.createModCounts());
        }
    }

    private final class Fetch {
        private final AtomicBoolean myStarted;
        private final FutureTask<SemVer> myFuture;

        private Fetch(InputData inputData) {
            if (inputData == null) {
                Fetch.$$$reportNull$$$0(0);
            }
            this.myStarted = new AtomicBoolean(false);
            this.myFuture = new FutureTask<SemVer>(() -> {
                SemVer version = null;
                try {
                    version = WorkingDirectoryDependentNpmPackageVersionManager.this.fetchProjectVersion(inputData.myPkg, new File(inputData.myWorkingDirectory));
                }
                catch (Throwable t) {
                    LOG.warn("Failed to fetch version for " + inputData.myPkg.getSystemDependentPath(), t);
                }
                finally {
                    WorkingDirectoryDependentNpmPackageVersionManager.this.myVersionCache.put(inputData, new VersionInfo(inputData.myPkg.getVersion(), version));
                    WorkingDirectoryDependentNpmPackageVersionManager.this.myFetchInProgressByPkgMap.remove(inputData);
                }
                return version;
            });
        }

        public void notifyWhenDone(@NotNull Consumer<SemVer> consumer, @Nullable SemVer initialVersion) {
            if (consumer == null) {
                Fetch.$$$reportNull$$$0(1);
            }
            if (this.myStarted.compareAndSet(false, true)) {
                ourExecutorService.execute(this.myFuture);
            }
            ourExecutorService.execute(() -> {
                SemVer version = null;
                try {
                    version = this.myFuture.get();
                }
                catch (InterruptedException e) {
                    LOG.warn("Fetch interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.warn("Unexpected exception", (Throwable)e);
                }
                if (!Objects.equals(initialVersion, version)) {
                    consumer.accept(version);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/npm/WorkingDirectoryDependentNpmPackageVersionManager$Fetch";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyWhenDone";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

