/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodePackage;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmPackageDescriptor;
import com.intellij.javascript.nodejs.util.DefaultNodePackageRefResolver;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NpmUtil {
    @NlsSafe
    public static final String NPM_PACKAGE_NAME = "npm";
    @NlsSafe
    public static final String YARN_PACKAGE_NAME = "yarn";
    @NlsSafe
    public static final String PNPM_PACKAGE_NAME = "pnpm";
    @NlsSafe
    public static final String YARN_LOCK_FILENAME = "yarn.lock";
    public static final String PACKAGE_LOCK_JSON_FILENAME = "package-lock.json";
    public static final String PNPM_LOCK_FILENAME = "pnpm-lock.yaml";
    public static final String PROJECT_PACKAGE_MANAGER_REFERENCE_NAME = "Project";
    public static final NodePackageDescriptor DESCRIPTOR = new NpmPackageDescriptor(false);
    private static final String NPM_CLI_JS_RELATIVE_PATH = "bin" + File.separator + "npm-cli.js";
    private static final String YARN_CLI_JS_RELATIVE_PATH = "bin" + File.separator + "yarn.js";
    private static final String PNPM_CLI_JS_RELATIVE_PATH = "bin" + File.separator + "pnpm.js";
    private static final NodePackageRefResolver RESOLVER = new DefaultNodePackageRefResolver(null, DESCRIPTOR, null);

    private NpmUtil() {
    }

    @NotNull
    public static NodePackageRef createProjectPackageManagerPackageRef() {
        NodePackageRef nodePackageRef = NodePackageRef.create(PROJECT_PACKAGE_MANAGER_REFERENCE_NAME);
        if (nodePackageRef == null) {
            NpmUtil.$$$reportNull$$$0(0);
        }
        return nodePackageRef;
    }

    public static boolean isProjectPackageManagerPackageRef(@NotNull NodePackageRef packageRef) {
        if (packageRef == null) {
            NpmUtil.$$$reportNull$$$0(1);
        }
        return PROJECT_PACKAGE_MANAGER_REFERENCE_NAME.equals(packageRef.getReferenceName());
    }

    @NotNull
    @NlsContexts.Label
    public static String getPackageManagerPackageFieldLabelText() {
        String string = JavaScriptBundle.message((String)"node.package.manager.label", (Object[])new Object[0]);
        if (string == null) {
            NpmUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static NodePackageField createPackageManagerPackageField(@NotNull NodeJsInterpreterField interpreterField, boolean projectField) {
        if (interpreterField == null) {
            NpmUtil.$$$reportNull$$$0(3);
        }
        return new NodePackageField(interpreterField, new NpmPackageDescriptor(projectField), null);
    }

    @NotNull
    public static String getValidNpmCliJsFilePath(@NotNull NodePackage packageManagerPkg) throws ExecutionException {
        if (packageManagerPkg == null) {
            NpmUtil.$$$reportNull$$$0(4);
        }
        if (packageManagerPkg instanceof WslNodePackage) {
            if (NpmUtil.isYarnAlikePackage(packageManagerPkg)) {
                String string = packageManagerPkg.getSystemIndependentPath() + "/" + FileUtil.toSystemIndependentName((String)YARN_CLI_JS_RELATIVE_PATH);
                if (string == null) {
                    NpmUtil.$$$reportNull$$$0(5);
                }
                return string;
            }
            if (NpmUtil.isPnpmPackage(packageManagerPkg)) {
                String string = packageManagerPkg.getSystemIndependentPath() + "/" + FileUtil.toSystemIndependentName((String)PNPM_CLI_JS_RELATIVE_PATH);
                if (string == null) {
                    NpmUtil.$$$reportNull$$$0(6);
                }
                return string;
            }
            String string = packageManagerPkg.getSystemIndependentPath() + "/" + FileUtil.toSystemIndependentName((String)NPM_CLI_JS_RELATIVE_PATH);
            if (string == null) {
                NpmUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (packageManagerPkg.isEmptyPath()) {
            throw new ExecutionException(JavaScriptBundle.message((String)"node.npm.specify_npm_or_yarn_package.dialog.message", (Object[])new Object[0]));
        }
        if (!packageManagerPkg.isValid()) {
            throw new ExecutionException(JavaScriptBundle.message((String)"node.npm.correct_path_to_npm_or_yarn_package.dialog.message", (Object[])new Object[]{packageManagerPkg.getSystemDependentPath()}));
        }
        return NpmUtil.findBinCliFile(packageManagerPkg);
    }

    public static boolean isYarnAlikePackageRef(@NotNull NodePackageRef packageManagerPkgRef) {
        NodePackage pkg;
        if (packageManagerPkgRef == null) {
            NpmUtil.$$$reportNull$$$0(8);
        }
        if ((pkg = packageManagerPkgRef.getConstantPackage()) != null) {
            return NpmUtil.isYarnAlikePackage(pkg);
        }
        return StringUtil.containsIgnoreCase((String)Objects.requireNonNull(packageManagerPkgRef.getReferenceName()), (String)YARN_PACKAGE_NAME);
    }

    public static boolean isPnpmPackageRef(@NotNull NodePackageRef packageManagerPkgRef) {
        NodePackage pkg;
        if (packageManagerPkgRef == null) {
            NpmUtil.$$$reportNull$$$0(9);
        }
        if ((pkg = packageManagerPkgRef.getConstantPackage()) != null) {
            return PNPM_PACKAGE_NAME.equals(pkg.getName());
        }
        return PNPM_PACKAGE_NAME.equals(packageManagerPkgRef.getReferenceName());
    }

    public static boolean isYarnAlikePackage(@NotNull NodePackage packageManagerPkg) {
        String packageName;
        if (packageManagerPkg == null) {
            NpmUtil.$$$reportNull$$$0(10);
        }
        if (StringUtil.containsIgnoreCase((String)(packageName = packageManagerPkg.getName()), (String)YARN_PACKAGE_NAME)) {
            return true;
        }
        String path = packageManagerPkg.getSystemIndependentPath();
        if (!packageName.contains(NPM_PACKAGE_NAME) && path.contains("/yarn/")) {
            return true;
        }
        return (path.contains("/.yvm/") || path.contains("/yvm/")) && !packageName.contains(NPM_PACKAGE_NAME);
    }

    public static boolean isPnpmPackage(@NotNull NodePackage pkg) {
        String packageName;
        if (pkg == null) {
            NpmUtil.$$$reportNull$$$0(11);
        }
        if (StringUtil.containsIgnoreCase((String)(packageName = pkg.getName()), (String)PNPM_PACKAGE_NAME)) {
            return true;
        }
        String path = pkg.getSystemIndependentPath();
        return path.contains("/pnpm/");
    }

    @NotNull
    private static String findBinCliFile(@NotNull NodePackage pkg) throws ExecutionException {
        File binFile;
        if (pkg == null) {
            NpmUtil.$$$reportNull$$$0(12);
        }
        String failoverBinRelativePath = NPM_CLI_JS_RELATIVE_PATH;
        if (NpmUtil.isYarnAlikePackage(pkg)) {
            failoverBinRelativePath = YARN_CLI_JS_RELATIVE_PATH;
        }
        if (NpmUtil.isPnpmPackage(pkg)) {
            failoverBinRelativePath = PNPM_CLI_JS_RELATIVE_PATH;
        }
        if ((binFile = pkg.findBinFile(pkg.getName(), failoverBinRelativePath)) == null) {
            throw new ExecutionException(JavaScriptBundle.message((String)"node.npm.invalid_package_manager.binary_file_not_found.dialog.message", (Object[])new Object[]{pkg.getSystemDependentPath()}));
        }
        String string = binFile.getAbsolutePath();
        if (string == null) {
            NpmUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public static NodePackage resolveRef(@NotNull NodePackageRef ref, @NotNull Project project, @Nullable NodeJsInterpreter interpreter) {
        if (ref == null) {
            NpmUtil.$$$reportNull$$$0(14);
        }
        if (project == null) {
            NpmUtil.$$$reportNull$$$0(15);
        }
        return RESOLVER.resolve(DESCRIPTOR.dereferenceIfProjectRef(project, ref), interpreter);
    }

    @NotNull
    public static NodePackage resolvePackageRefOrThrow(@NotNull NodePackageRef packageRef, @Nullable Project project, @Nullable NodeJsInterpreter interpreter) throws ExecutionException {
        if (packageRef == null) {
            NpmUtil.$$$reportNull$$$0(16);
        }
        if (project != null) {
            packageRef = DESCRIPTOR.dereferenceIfProjectRef(project, packageRef);
        } else if (NpmUtil.isProjectPackageManagerPackageRef(packageRef)) {
            throw new ExecutionException(JavaScriptBundle.message((String)"node.npm.project_package_manager_disallowed_here.dialog.message", (Object[])new Object[0]));
        }
        if (StringUtil.isEmptyOrSpaces((String)packageRef.getIdentifier())) {
            throw new ExecutionException(JavaScriptBundle.message((String)"node.npm.unspecified_package_manager.dialog.message", (Object[])new Object[0]));
        }
        NodePackage npmPkg = RESOLVER.resolve(packageRef, interpreter);
        if (npmPkg == null) {
            throw new ExecutionException(JavaScriptBundle.message((String)"node.npm.cannot_resolve_package_manager.dialog.message", (Object[])new Object[]{packageRef.getIdentifier()}));
        }
        NodePackage nodePackage = npmPkg;
        if (nodePackage == null) {
            NpmUtil.$$$reportNull$$$0(17);
        }
        return nodePackage;
    }

    @NotNull
    public static GeneralCommandLine createNpmCommandLine(@Nullable Project project, @Nullable File workingDir, @NotNull NodeJsInterpreter interpreter, @NotNull NpmCommand command, @NotNull List<String> arguments) throws ExecutionException {
        NodePackage pkg;
        if (interpreter == null) {
            NpmUtil.$$$reportNull$$$0(18);
        }
        if (command == null) {
            NpmUtil.$$$reportNull$$$0(19);
        }
        if (arguments == null) {
            NpmUtil.$$$reportNull$$$0(20);
        }
        if (project != null) {
            pkg = NpmManager.getInstance(project).getPackageOrThrow(interpreter);
        } else {
            pkg = interpreter instanceof NodeJsLocalInterpreter ? new NodePackage(((NodeJsLocalInterpreter)interpreter).getNpmPackageDir()) : (interpreter instanceof WslNodeInterpreter ? WslNodePackage.resolvePackageRefAsWsl((WslNodeInterpreter)interpreter, NodePackageRef.create(NPM_PACKAGE_NAME)) : null);
            if (pkg == null) {
                throw new ExecutionException(JavaScriptBundle.message((String)"node.npm.no_bundled_npm_detected.dialog.message", (Object[])new Object[]{interpreter.getReferenceName()}));
            }
        }
        return NpmUtil.createNpmCommandLine(workingDir, interpreter, pkg, command, arguments);
    }

    @NotNull
    public static GeneralCommandLine createNpmCommandLine(@Nullable File workingDir, @NotNull NodeJsInterpreter interpreter, @NotNull NodePackage npmPackage, @Nullable NpmCommand command, @NotNull List<String> arguments) throws ExecutionException {
        if (interpreter == null) {
            NpmUtil.$$$reportNull$$$0(21);
        }
        if (npmPackage == null) {
            NpmUtil.$$$reportNull$$$0(22);
        }
        if (arguments == null) {
            NpmUtil.$$$reportNull$$$0(23);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        NpmUtil.configureNpmCommandLine(commandLine, workingDir, interpreter, npmPackage, command, arguments);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            NpmUtil.$$$reportNull$$$0(24);
        }
        return generalCommandLine;
    }

    public static void configureNpmCommandLine(@NotNull GeneralCommandLine commandLine, @Nullable File workingDir, @NotNull NodeJsInterpreter interpreter, @NotNull NodePackage npmPackage, @Nullable NpmCommand command, @NotNull List<String> arguments) throws ExecutionException {
        if (commandLine == null) {
            NpmUtil.$$$reportNull$$$0(25);
        }
        if (interpreter == null) {
            NpmUtil.$$$reportNull$$$0(26);
        }
        if (npmPackage == null) {
            NpmUtil.$$$reportNull$$$0(27);
        }
        if (arguments == null) {
            NpmUtil.$$$reportNull$$$0(28);
        }
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
        commandLine.withCharset(StandardCharsets.UTF_8);
        if (workingDir != null) {
            commandLine.withWorkDirectory(workingDir);
        }
        String cliJsFilePath = NpmUtil.getValidNpmCliJsFilePath(npmPackage);
        commandLine.addParameter(cliJsFilePath);
        if (command != null) {
            boolean yarn = NpmUtil.isYarnAlikePackage(npmPackage);
            commandLine.addParameter(command.getCliOption(yarn));
            if ((command == NpmCommand.RUN_SCRIPT || command == NpmCommand.TEST || command == NpmCommand.INSTALL || command == NpmCommand.UPDATE) && npmPackage.getName().equals(NPM_PACKAGE_NAME)) {
                commandLine.addParameter("--scripts-prepend-node-path=auto");
            }
        }
        commandLine.addParameters(arguments);
        NodeCommandLineConfigurator.find(interpreter).configure(commandLine);
    }

    @Nullable
    @Nls
    public static String getInstallSaveOption(@NotNull NodePackageRef packageRef, boolean asDevDependency) {
        if (packageRef == null) {
            NpmUtil.$$$reportNull$$$0(29);
        }
        boolean yarn = NpmUtil.isYarnAlikePackageRef(packageRef);
        if (asDevDependency) {
            return yarn ? "--dev" : "--save-dev";
        }
        return yarn ? null : "--save";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/NpmUtil";
                break;
            }
            case 1: 
            case 16: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterField";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagerPkg";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagerPkgRef";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 20: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPackage";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectPackageManagerPackageRef";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/NpmUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageManagerPackageFieldLabelText";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidNpmCliJsFilePath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinCliFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePackageRefOrThrow";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createNpmCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isProjectPackageManagerPackageRef";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPackageManagerPackageField";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValidNpmCliJsFilePath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isYarnAlikePackageRef";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPnpmPackageRef";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isYarnAlikePackage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isPnpmPackage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findBinCliFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveRef";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolvePackageRefOrThrow";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createNpmCommandLine";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "configureNpmCommandLine";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getInstallSaveOption";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class YarnSnapPackage
    extends NodePackage {
        private static final String PATH = "/snap/node/current/bin/yarn.js";

        private YarnSnapPackage(@NotNull String path) {
            if (path == null) {
                YarnSnapPackage.$$$reportNull$$$0(0);
            }
            super(path);
        }

        @Override
        @Nullable
        public SemVer getVersion() {
            return null;
        }

        @Override
        @NotNull
        public String getName() {
            return NpmUtil.YARN_PACKAGE_NAME;
        }

        @Override
        public boolean nameMatches(@NotNull String packageName) {
            if (packageName == null) {
                YarnSnapPackage.$$$reportNull$$$0(1);
            }
            return NpmUtil.YARN_PACKAGE_NAME.equals(packageName);
        }

        @Override
        public boolean isValid() {
            return new File(this.getSystemDependentPath()).isFile();
        }

        @Override
        @Nullable
        public String getErrorMessage(@NotNull String packageName) {
            File file2;
            if (packageName == null) {
                YarnSnapPackage.$$$reportNull$$$0(2);
            }
            if (!(file2 = new File(this.getSystemDependentPath())).isAbsolute() || !file2.isFile()) {
                return JavaScriptBundle.message((String)"dialog.message.invalid.package.no.such.file", (Object[])new Object[]{packageName});
            }
            return null;
        }

        @Override
        @Nullable
        public File findBinFile(@NotNull String executableName, @Nullable String failoverBinRelativePath) {
            if (executableName == null) {
                YarnSnapPackage.$$$reportNull$$$0(3);
            }
            return NpmUtil.YARN_PACKAGE_NAME.equals(executableName) ? new File(this.getSystemDependentPath()) : null;
        }

        @Nullable
        static YarnSnapPackage createIfPathMatched(@NotNull String path) {
            if (path == null) {
                YarnSnapPackage.$$$reportNull$$$0(4);
            }
            return SystemInfo.isLinux && PATH.equals(path) ? new YarnSnapPackage(PATH) : null;
        }

        @Nullable
        public static YarnSnapPackage createIfInstalled() {
            return SystemInfo.isLinux && new File(PATH).isFile() ? new YarnSnapPackage(PATH) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executableName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/npm/NpmUtil$YarnSnapPackage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "nameMatches";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getErrorMessage";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findBinFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createIfPathMatched";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

