/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.javascript.nodejs.settings.NodeSettingsConfigurable;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Objects;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmManager {
    private static final Logger LOG = Logger.getInstance(NpmManager.class);
    private static final String PACKAGE_MANAGER_PACKAGE_REF = "nodejs_package_manager_path";
    private final Project myProject;
    private volatile NodePackageRef myPackageManagerPackageRef;

    public NpmManager(@NotNull Project project) {
        if (project == null) {
            NpmManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public static NpmManager getInstance(@NotNull Project project) {
        if (project == null) {
            NpmManager.$$$reportNull$$$0(1);
        }
        NpmManager npmManager = (NpmManager)ServiceManager.getService((Project)project, NpmManager.class);
        if (npmManager == null) {
            NpmManager.$$$reportNull$$$0(2);
        }
        return npmManager;
    }

    public void setPackageRef(@NotNull NodePackageRef packageRef) {
        if (packageRef == null) {
            NpmManager.$$$reportNull$$$0(3);
        }
        if (NpmUtil.isProjectPackageManagerPackageRef(packageRef)) {
            LOG.warn("Project package manager cannot be set to itself");
        }
        this.myPackageManagerPackageRef = packageRef;
        String identifier = packageRef.getIdentifier();
        if (StringUtil.isEmpty((String)identifier)) {
            identifier = null;
        }
        PropertiesComponent.getInstance((Project)this.myProject).setValue(PACKAGE_MANAGER_PACKAGE_REF, identifier);
    }

    @NotNull
    public NodePackageRef getPackageRef() {
        NodePackageRef packageRef = this.myPackageManagerPackageRef;
        if (packageRef == null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
            String value = propertiesComponent.getValue(PACKAGE_MANAGER_PACKAGE_REF);
            if (StringUtil.isEmpty((String)value)) {
                if (this.myProject.isDefault()) {
                    packageRef = NodePackageRef.create(new NodePackage(""));
                } else {
                    packageRef = this.detectPackageRef();
                    if (this.isDetectionTemporary()) {
                        NodePackageRef nodePackageRef = packageRef;
                        if (nodePackageRef == null) {
                            NpmManager.$$$reportNull$$$0(4);
                        }
                        return nodePackageRef;
                    }
                    propertiesComponent.setValue(PACKAGE_MANAGER_PACKAGE_REF, packageRef.getIdentifier());
                }
            } else {
                packageRef = NpmUtil.DESCRIPTOR.createPackageRef(value);
            }
            this.myPackageManagerPackageRef = packageRef;
        }
        NodePackageRef nodePackageRef = packageRef;
        if (nodePackageRef == null) {
            NpmManager.$$$reportNull$$$0(5);
        }
        return nodePackageRef;
    }

    private boolean isDetectionTemporary() {
        return NpmPackageProjectGenerator.isGenerating(this.myProject);
    }

    @Nullable
    public NodePackage getPackage() {
        return this.getPackage(NodeJsInterpreterManager.getInstance(this.myProject).getInterpreter());
    }

    @Nullable
    public NodePackage getPackage(@Nullable NodeJsInterpreter interpreter) {
        NodePackageRef ref = this.getPackageRef();
        return NpmUtil.resolveRef(ref, this.myProject, interpreter);
    }

    @NotNull
    public NodePackage getPackageOrThrow() throws ExecutionException {
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreter();
        NodePackage nodePackage = this.getPackageOrThrow(interpreter);
        if (nodePackage == null) {
            NpmManager.$$$reportNull$$$0(6);
        }
        return nodePackage;
    }

    @NotNull
    NodePackage getPackageOrThrow(@Nullable NodeJsInterpreter interpreter) throws ExecutionException {
        NodePackageRef ref = this.getPackageRef();
        NodePackage pkg = NpmUtil.resolveRef(ref, this.myProject, interpreter);
        if (pkg == null) {
            throw new ExecutionException(JavaScriptBundle.message((String)"node.npm.cannot_find_package_by_reference.dialog.message", (Object[])new Object[]{ref.getIdentifier()}));
        }
        NodePackage nodePackage = pkg;
        if (nodePackage == null) {
            NpmManager.$$$reportNull$$$0(7);
        }
        return nodePackage;
    }

    @NotNull
    private NodePackageRef detectPackageRef() {
        VirtualFile root = ProjectUtil.guessProjectDir((Project)this.myProject);
        NodePackageRef pkgRef = NpmManager.detectPackageManagerRefInDirectory(root);
        if (pkgRef != null) {
            NodePackageRef nodePackageRef = pkgRef;
            if (nodePackageRef == null) {
                NpmManager.$$$reportNull$$$0(8);
            }
            return nodePackageRef;
        }
        Set<VirtualFile> packageJsonFiles = PackageJsonFileManager.getInstance(this.myProject).getValidPackageJsonFiles();
        for (VirtualFile packageJson : packageJsonFiles) {
            VirtualFile dir = packageJson.getParent();
            if (Objects.equals(dir, root) || (pkgRef = NpmManager.detectPackageManagerRefInDirectory(dir)) == null) continue;
            NodePackageRef nodePackageRef = pkgRef;
            if (nodePackageRef == null) {
                NpmManager.$$$reportNull$$$0(9);
            }
            return nodePackageRef;
        }
        NodePackageRef nodePackageRef = NodePackageRef.create("npm");
        if (nodePackageRef == null) {
            NpmManager.$$$reportNull$$$0(10);
        }
        return nodePackageRef;
    }

    @Nullable
    private static NodePackageRef detectPackageManagerRefInDirectory(@Nullable VirtualFile dir) {
        if (dir == null) {
            return null;
        }
        if (NpmManager.fileExists(dir, "yarn.lock")) {
            return NodePackageRef.create("yarn");
        }
        if (NpmManager.fileExists(dir, "package-lock.json")) {
            return NodePackageRef.create("npm");
        }
        if (NpmManager.fileExists(dir, "pnpm-lock.yaml")) {
            return NodePackageRef.create("pnpm");
        }
        return null;
    }

    private static boolean fileExists(@NotNull VirtualFile dir, @NotNull String fileName) {
        VirtualFile child;
        if (dir == null) {
            NpmManager.$$$reportNull$$$0(11);
        }
        if (fileName == null) {
            NpmManager.$$$reportNull$$$0(12);
        }
        return (child = dir.findChild(fileName)) != null && !child.isDirectory();
    }

    @NotNull
    public String getNpmInstallPresentableText() {
        return NpmManager.getNpmCommandPresentableText(this.getPackageRef(), NpmCommand.INSTALL);
    }

    @NotNull
    @Nls
    public static String getNpmInstallPresentableText(@NotNull NodePackage pkg) {
        if (pkg == null) {
            NpmManager.$$$reportNull$$$0(13);
        }
        return NpmManager.getNpmCommandPresentableText(NodePackageRef.create(pkg), NpmCommand.INSTALL);
    }

    @NlsSafe
    @NotNull
    public static String getNpmCommandPresentableText(@NotNull NodePackageRef npmPkgRef, @NotNull NpmCommand command) {
        if (npmPkgRef == null) {
            NpmManager.$$$reportNull$$$0(14);
        }
        if (command == null) {
            NpmManager.$$$reportNull$$$0(15);
        }
        String string = NpmManager.getNpmPackagePresentableName(npmPkgRef) + " " + command.getCliOption(NpmUtil.isYarnAlikePackageRef(npmPkgRef));
        if (string == null) {
            NpmManager.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getNpmPackagePresentableName(@NotNull NodePackage npmPkg) {
        if (npmPkg == null) {
            NpmManager.$$$reportNull$$$0(17);
        }
        return NpmManager.getNpmPackagePresentableName(NodePackageRef.create(npmPkg));
    }

    @NlsSafe
    @NotNull
    public static String getNpmPackagePresentableName(@NotNull NodePackageRef npmPkgRef) {
        if (npmPkgRef == null) {
            NpmManager.$$$reportNull$$$0(18);
        }
        if (NpmUtil.isYarnAlikePackageRef(npmPkgRef)) {
            return "yarn";
        }
        if (NpmUtil.isPnpmPackageRef(npmPkgRef)) {
            return "pnpm";
        }
        return "npm";
    }

    @NotNull
    public static String getNpmPackagePresentableName(boolean yarn) {
        return yarn ? "yarn" : "npm";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/NpmManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageRef";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPkgRef";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPkg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/NpmManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageRef";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageOrThrow";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "detectPackageRef";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpmCommandPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPackageRef";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fileExists";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNpmInstallPresentableText";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNpmCommandPresentableText";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNpmPackagePresentableName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InvalidNpmPackageException
    extends ExecutionException
    implements HyperlinkListener {
        private final Project myProject;
        private final Runnable myRunWhenNpmPackageIsValid;

        public InvalidNpmPackageException(@NotNull Project project, @NlsContexts.DialogMessage @NotNull String details, @Nullable Runnable runWhenNpmPackageIsValid) {
            if (project == null) {
                InvalidNpmPackageException.$$$reportNull$$$0(0);
            }
            if (details == null) {
                InvalidNpmPackageException.$$$reportNull$$$0(1);
            }
            super(details);
            this.myProject = project;
            this.myRunWhenNpmPackageIsValid = runWhenNpmPackageIsValid;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent event) {
            if (event != null && event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                NodeSettingsConfigurable.showSettingsDialog(this.myProject);
                if (this.myRunWhenNpmPackageIsValid != null) {
                    try {
                        NpmManager.getInstance(this.myProject).getPackageOrThrow();
                        this.myRunWhenNpmPackageIsValid.run();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public String toString() {
            return this.getMessage();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "details";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/npm/NpmManager$InvalidNpmPackageException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

