/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpDependency;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpWorkspace;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class YarnPnpResolvedDependencyTree {
    private static final Logger LOG = Logger.getInstance(YarnPnpResolvedDependencyTree.class);
    private static final Pattern VIRTUAL_FS_PATTERN = Pattern.compile("/virtual/[^/]+/(\\d+)/[^/]+/");
    private final ImmutableList<ResolvedDependency> myDependencies;
    private final ImmutableMap<String, ResolvedDependency> myDependencyByName;

    YarnPnpResolvedDependencyTree(@NotNull List<ResolvedDependency> dependencies) {
        if (dependencies == null) {
            YarnPnpResolvedDependencyTree.$$$reportNull$$$0(0);
        }
        this.myDependencies = ImmutableList.copyOf(dependencies);
        this.myDependencyByName = ImmutableMap.copyOf((Map)ContainerUtil.map2Map(dependencies, dependency -> Pair.create((Object)dependency.myDependency.getName(), (Object)dependency)));
    }

    @NotNull
    List<ResolvedDependency> getResolvedDependencies() {
        ImmutableList<ResolvedDependency> immutableList = this.myDependencies;
        if (immutableList == null) {
            YarnPnpResolvedDependencyTree.$$$reportNull$$$0(1);
        }
        return immutableList;
    }

    @Nullable
    ResolvedDependency findResolvedDependency(@NotNull String dependencyName) {
        if (dependencyName == null) {
            YarnPnpResolvedDependencyTree.$$$reportNull$$$0(2);
        }
        return (ResolvedDependency)this.myDependencyByName.get((Object)dependencyName);
    }

    @NotNull
    static YarnPnpResolvedDependencyTree create(@NotNull YarnPnpWorkspace workspace) {
        if (workspace == null) {
            YarnPnpResolvedDependencyTree.$$$reportNull$$$0(3);
        }
        ArrayList<String> notFoundDependencyLocations = new ArrayList<String>();
        ArrayList<ResolvedDependency> result2 = new ArrayList<ResolvedDependency>();
        for (YarnPnpDependency dep : workspace.getDeps().values()) {
            ResolvedDependency resolvedDependency = new ResolvedDependency(dep, workspace.isVirtualResolved());
            result2.add(resolvedDependency);
            if (resolvedDependency.getDependencyRoot() != null) continue;
            notFoundDependencyLocations.add(resolvedDependency.myDependency.getRequireableLocation());
        }
        if (!notFoundDependencyLocations.isEmpty()) {
            LOG.info("Cannot find " + notFoundDependencyLocations.size() + " dependency locations: " + notFoundDependencyLocations);
        }
        return new YarnPnpResolvedDependencyTree(result2);
    }

    @Nullable
    private static VirtualFile resolveDependencyRoot(@NotNull YarnPnpDependency dependency, boolean virtualResolved) {
        String location;
        Pair<File, String> zipPath;
        if (dependency == null) {
            YarnPnpResolvedDependencyTree.$$$reportNull$$$0(4);
        }
        if ((zipPath = YarnPnpResolvedDependencyTree.resolveZipPath(location = (String)ObjectUtils.notNull((Object)dependency.getRequireableLocationWithVirtualResolved(), (Object)dependency.getRequireableLocation()), virtualResolved)) != null) {
            String fullPath = ((File)zipPath.first).getAbsolutePath() + "!/" + StringUtil.trimLeading((String)((String)zipPath.second), (char)'/');
            return JarFileSystem.getInstance().findLocalVirtualFileByPath(fullPath);
        }
        return LocalFileSystem.getInstance().findFileByPath(location);
    }

    @Nullable
    private static Pair<File, String> resolveZipPath(@NotNull String location, boolean virtualResolved) {
        if (location == null) {
            YarnPnpResolvedDependencyTree.$$$reportNull$$$0(5);
        }
        String dotZip = ".zip";
        int dotZipStartIndex = location.lastIndexOf(dotZip);
        while (dotZipStartIndex > 0) {
            File zipArchive = YarnPnpResolvedDependencyTree.resolveZipArchive(location.substring(0, dotZipStartIndex + dotZip.length()), virtualResolved);
            if (zipArchive != null) {
                return Pair.create((Object)zipArchive, (Object)location.substring(dotZipStartIndex + dotZip.length()));
            }
            dotZipStartIndex = location.lastIndexOf(dotZip, dotZipStartIndex - 1);
        }
        return null;
    }

    @Nullable
    private static File resolveZipArchive(@NotNull String path, boolean virtualResolved) {
        File file2;
        if (path == null) {
            YarnPnpResolvedDependencyTree.$$$reportNull$$$0(6);
        }
        if ((file2 = new File(path)).exists()) {
            return file2;
        }
        return virtualResolved ? null : YarnPnpResolvedDependencyTree.resolveVirtual(path);
    }

    @Nullable
    private static File resolveVirtual(@NotNull String path) {
        Matcher matcher;
        if (path == null) {
            YarnPnpResolvedDependencyTree.$$$reportNull$$$0(7);
        }
        if ((matcher = VIRTUAL_FS_PATTERN.matcher(path)).find()) {
            String baseDir = path.substring(0, matcher.start(0));
            int upCount = StringUtil.parseInt((String)matcher.group(1), (int)-1);
            if (upCount < 0) {
                return null;
            }
            for (int i = 0; i < upCount; ++i) {
                String parentDir = PathUtil.getParentPath((String)baseDir);
                if (parentDir.equals(baseDir)) {
                    return null;
                }
                baseDir = parentDir;
            }
            if (baseDir.isEmpty()) {
                return null;
            }
            File file2 = new File(baseDir + path.substring(matcher.end(1)));
            if (file2.isFile()) {
                return file2;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpResolvedDependencyTree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpResolvedDependencyTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findResolvedDependency";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveDependencyRoot";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveZipPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveZipArchive";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveVirtual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class ResolvedDependency {
        private final YarnPnpDependency myDependency;
        private final boolean myVirtualResolved;
        private volatile VirtualFile myRoot;
        private volatile boolean myResolvePerformed;

        private ResolvedDependency(@NotNull YarnPnpDependency dependency, boolean virtualResolved) {
            if (dependency == null) {
                ResolvedDependency.$$$reportNull$$$0(0);
            }
            this.myResolvePerformed = false;
            this.myDependency = dependency;
            this.myVirtualResolved = virtualResolved;
        }

        @NotNull
        YarnPnpDependency getDependency() {
            YarnPnpDependency yarnPnpDependency = this.myDependency;
            if (yarnPnpDependency == null) {
                ResolvedDependency.$$$reportNull$$$0(1);
            }
            return yarnPnpDependency;
        }

        @Nullable
        VirtualFile getDependencyRoot() {
            VirtualFile resolvedRoot = this.myRoot;
            if (!(this.myResolvePerformed || resolvedRoot != null && resolvedRoot.isValid())) {
                resolvedRoot = YarnPnpResolvedDependencyTree.resolveDependencyRoot(this.myDependency, this.myVirtualResolved);
                this.myResolvePerformed = true;
                this.myRoot = resolvedRoot;
            }
            return resolvedRoot != null && resolvedRoot.isValid() ? resolvedRoot : null;
        }

        @NotNull
        String getLocation() {
            String string = this.myDependency.getRequireableLocation();
            if (string == null) {
                ResolvedDependency.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependency";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpResolvedDependencyTree$ResolvedDependency";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpResolvedDependencyTree$ResolvedDependency";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependency";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

