/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn;

import com.intellij.javascript.nodejs.library.yarn.YarnPnpFile;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpWorkspace;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpWorkspaceList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YarnPnpManagerState {
    @XCollection(propertyElementName="pnp-files")
    private List<PnpFileState> myFileStates;

    @NotNull
    List<YarnPnpFile> convertStateToFileList(@NotNull Project project) {
        if (project == null) {
            YarnPnpManagerState.$$$reportNull$$$0(0);
        }
        List list2 = ContainerUtil.mapNotNull((Collection)ContainerUtil.notNullize(this.myFileStates), state -> YarnPnpManagerState.convertStateToFile(state, project));
        if (list2 == null) {
            YarnPnpManagerState.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Nullable
    private static YarnPnpFile convertStateToFile(@NotNull PnpFileState state, @NotNull Project project) {
        if (state == null) {
            YarnPnpManagerState.$$$reportNull$$$0(2);
        }
        if (project == null) {
            YarnPnpManagerState.$$$reportNull$$$0(3);
        }
        if (state.myPath == null) {
            return null;
        }
        VirtualFile pnpFile = LocalFileSystem.getInstance().findFileByPath(state.myPath);
        if (pnpFile == null) {
            return null;
        }
        YarnPnpFile file2 = new YarnPnpFile(pnpFile, project);
        if (state.myWorkspaces != null && new File(state.myPath).lastModified() == state.myLastModified) {
            YarnPnpWorkspaceList.Builder builder = new YarnPnpWorkspaceList.Builder();
            builder.setVirtualResolved(state.myPnpVirtualResolved);
            for (WorkspaceState workspaceState : state.myWorkspaces) {
                YarnPnpWorkspace workspace = YarnPnpManagerState.convertStateToWorkspace(workspaceState);
                if (workspace == null) continue;
                builder.add(workspace);
            }
            file2.setWorkspaceList(builder.build());
        }
        return file2;
    }

    @Nullable
    private static YarnPnpWorkspace convertStateToWorkspace(@NotNull WorkspaceState state) {
        if (state == null) {
            YarnPnpManagerState.$$$reportNull$$$0(4);
        }
        YarnPnpWorkspace.Builder builder = new YarnPnpWorkspace.Builder();
        if (state.myLocation == null || state.myLibraryName == null) {
            return null;
        }
        builder.setLocation(state.myLocation);
        builder.setLibraryName(state.myLibraryName);
        for (PnpDependencyState dependencyState : state.myDependencies) {
            if (dependencyState.myName == null || dependencyState.myRequireableLocation == null) continue;
            builder.addDependency(dependencyState.myName, dependencyState.myRequireableLocation, dependencyState.myRequireableLocationWithVirtualResolved);
        }
        return builder.build();
    }

    @NotNull
    static YarnPnpManagerState convertFileListToState(@NotNull Collection<YarnPnpFile> files) {
        if (files == null) {
            YarnPnpManagerState.$$$reportNull$$$0(5);
        }
        YarnPnpManagerState state = new YarnPnpManagerState();
        List fileStates = ContainerUtil.map(files, file2 -> YarnPnpManagerState.convertFileToState(file2));
        fileStates.sort(Comparator.comparing(s -> s.myPath));
        state.myFileStates = (List)ContainerUtil.nullize((Collection)fileStates);
        YarnPnpManagerState yarnPnpManagerState = state;
        if (yarnPnpManagerState == null) {
            YarnPnpManagerState.$$$reportNull$$$0(6);
        }
        return yarnPnpManagerState;
    }

    @NotNull
    private static PnpFileState convertFileToState(@NotNull YarnPnpFile file2) {
        if (file2 == null) {
            YarnPnpManagerState.$$$reportNull$$$0(7);
        }
        PnpFileState fileState = new PnpFileState();
        fileState.myPath = file2.getPnpFile().getPath();
        fileState.myLastModified = VfsUtilCore.virtualToIoFile((VirtualFile)file2.getPnpFile()).lastModified();
        YarnPnpWorkspaceList workspaceList = file2.getWorkspaceList();
        if (workspaceList != null) {
            fileState.myPnpVirtualResolved = workspaceList.isVirtualResolved();
            fileState.myWorkspaces = ContainerUtil.map(workspaceList.getWorkspaces(), workspace -> YarnPnpManagerState.convertWorkspaceToState(workspace));
        }
        PnpFileState pnpFileState = fileState;
        if (pnpFileState == null) {
            YarnPnpManagerState.$$$reportNull$$$0(8);
        }
        return pnpFileState;
    }

    @NotNull
    private static WorkspaceState convertWorkspaceToState(@NotNull YarnPnpWorkspace workspace) {
        if (workspace == null) {
            YarnPnpManagerState.$$$reportNull$$$0(9);
        }
        WorkspaceState state = new WorkspaceState();
        state.myLocation = workspace.getLocation();
        state.myLibraryName = workspace.getLibraryName();
        state.myDependencies = ContainerUtil.map((Collection)workspace.getDeps().values(), dependency -> {
            PnpDependencyState dependencyState = new PnpDependencyState();
            dependencyState.myName = dependency.getName();
            dependencyState.myRequireableLocation = dependency.getRequireableLocation();
            dependencyState.myRequireableLocationWithVirtualResolved = dependency.getRequireableLocationWithVirtualResolved();
            return dependencyState;
        });
        WorkspaceState workspaceState = state;
        if (workspaceState == null) {
            YarnPnpManagerState.$$$reportNull$$$0(10);
        }
        return workspaceState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpManagerState";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpManagerState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "convertStateToFileList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFileListToState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFileToState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertWorkspaceToState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertStateToFileList";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "convertStateToFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertStateToWorkspace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "convertFileListToState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertFileToState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertWorkspaceToState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="dependency")
    public static class PnpDependencyState {
        @Attribute(value="name")
        private String myName;
        @Attribute(value="requireableLocation")
        private String myRequireableLocation;
        @Attribute(value="requireableLocationWithVirtualResolved")
        private String myRequireableLocationWithVirtualResolved;
    }

    @Tag(value="workspace")
    public static class WorkspaceState {
        @Attribute(value="name")
        private String myLocation;
        @Attribute(value="library-name")
        private String myLibraryName;
        @XCollection(propertyElementName="dependencies")
        private List<PnpDependencyState> myDependencies;
    }

    @Tag(value="pnp-file")
    public static class PnpFileState {
        @Attribute(value="path")
        private String myPath;
        @Attribute(value="last-modified")
        private long myLastModified;
        @Attribute(value="pnp-virtual-resolved")
        private boolean myPnpVirtualResolved = false;
        @XCollection(propertyElementName="workspaces")
        private List<WorkspaceState> myWorkspaces;
    }
}

