/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpDependency;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpFile;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpManagerState;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpResolvedDependencyTree;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpWorkspace;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpWorkspaceList;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="YarnPnpManager", storages={@Storage(value="$CACHE_FILE$")})
public final class YarnPnpManager
implements PersistentStateComponent<YarnPnpManagerState>,
Disposable {
    private static final Logger LOG = Logger.getInstance(YarnPnpManager.class);
    private static final String PNP_JS = ".pnp.js";
    private static final ExecutorService ourExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)(YarnPnpManager.class.getSimpleName() + " Pool"), (int)2);
    private final Project myProject;
    private final ConcurrentMap<VirtualFile, YarnPnpFile> myFileMap;
    private volatile List<YarnPnpFile> myPnpFilesSnapshot;
    private volatile Set<VirtualFile> myPnpRootsSnapshot;
    private JSLibraryManager myLibraryManager;
    private final AtomicBoolean myInterpreterChangeListenerAdded;

    public YarnPnpManager(@NotNull Project project) {
        if (project == null) {
            YarnPnpManager.$$$reportNull$$$0(0);
        }
        this.myFileMap = new ConcurrentHashMap<VirtualFile, YarnPnpFile>();
        this.myInterpreterChangeListenerAdded = new AtomicBoolean(false);
        this.myProject = project;
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new YarnPnpFileListener(), (Disposable)this);
    }

    public void dispose() {
    }

    @NotNull
    public static YarnPnpManager getInstance(@NotNull Project project) {
        if (project == null) {
            YarnPnpManager.$$$reportNull$$$0(1);
        }
        YarnPnpManager yarnPnpManager = (YarnPnpManager)ServiceManager.getService((Project)project, YarnPnpManager.class);
        if (yarnPnpManager == null) {
            YarnPnpManager.$$$reportNull$$$0(2);
        }
        return yarnPnpManager;
    }

    @NotNull
    public YarnPnpManagerState getState() {
        YarnPnpManagerState yarnPnpManagerState = YarnPnpManagerState.convertFileListToState(this.myFileMap.values());
        if (yarnPnpManagerState == null) {
            YarnPnpManager.$$$reportNull$$$0(3);
        }
        return yarnPnpManagerState;
    }

    public void loadState(@NotNull YarnPnpManagerState state) {
        if (state == null) {
            YarnPnpManager.$$$reportNull$$$0(4);
        }
        Map map = ContainerUtil.map2Map(state.convertStateToFileList(this.myProject), file2 -> Pair.create((Object)file2.getPnpFile(), (Object)file2));
        this.myFileMap.clear();
        this.myFileMap.putAll(map);
        this.resetSnapshot();
        this.refreshLibrariesAsync(this.myFileMap.values(), true);
    }

    private void refreshLibrariesAsync(@NotNull Collection<YarnPnpFile> files, boolean deleteIfNotAccepted) {
        if (files == null) {
            YarnPnpManager.$$$reportNull$$$0(5);
        }
        if (files.isEmpty()) {
            return;
        }
        ourExecutorService.execute(() -> {
            boolean reloadLibrariesNeeded = false;
            for (YarnPnpFile file2 : files) {
                boolean accepted;
                if (deleteIfNotAccepted && !(accepted = ((Boolean)ReadAction.compute(() -> this.acceptPnpJsFile(file2.getPnpFile()))).booleanValue())) {
                    this.handleFileDeleted(file2.getPnpFile(), false);
                    reloadLibrariesNeeded = true;
                    continue;
                }
                reloadLibrariesNeeded |= file2.refresh();
            }
            LOG.info(reloadLibrariesNeeded ? "Libraries roots changed, reloading" : "No libraries roots changed");
            if (reloadLibrariesNeeded) {
                this.reloadLibrariesLater();
            }
            this.scheduleUpdateOnNodeInterpreterChange();
        });
    }

    @TestOnly
    public void awaitModelSynced() throws ExecutionException, InterruptedException, TimeoutException {
        ((BoundedTaskExecutor)ourExecutorService).waitAllTasksExecuted(20L, TimeUnit.MINUTES);
    }

    private void scheduleUpdateOnNodeInterpreterChange() {
        ReadAction.run(() -> {
            if (!this.myProject.isDisposed() && this.myInterpreterChangeListenerAdded.compareAndSet(false, true)) {
                NodeJsInterpreterManager.getInstance(this.myProject).addChangeListener(new NodeJsInterpreterChangeListener(){

                    @Override
                    public void interpreterChanged(@Nullable NodeJsInterpreter newInterpreter) {
                        YarnPnpManager.this.refreshLibrariesAsync(YarnPnpManager.this.myFileMap.values(), false);
                    }
                });
            }
        });
    }

    public void addPnpJsFile(@NotNull VirtualFile pnpJsFile) {
        YarnPnpFile file2;
        if (pnpJsFile == null) {
            YarnPnpManager.$$$reportNull$$$0(6);
        }
        if (this.myFileMap.get(pnpJsFile) == null && this.acceptPnpJsFile(pnpJsFile) && this.myFileMap.putIfAbsent(pnpJsFile, file2 = new YarnPnpFile(pnpJsFile, this.myProject)) == null) {
            this.resetSnapshot();
            this.refreshLibrariesAsync(Collections.singletonList(file2), false);
        }
    }

    private boolean acceptPnpJsFile(@NotNull VirtualFile pnpJsFile) {
        ProjectFileIndex fileIndex;
        VirtualFile contentRoot;
        if (pnpJsFile == null) {
            YarnPnpManager.$$$reportNull$$$0(7);
        }
        return pnpJsFile.isValid() && YarnPnpManager.isPnpJsFile(pnpJsFile) && (contentRoot = (fileIndex = ProjectFileIndex.getInstance((Project)this.myProject)).getContentRootForFile(pnpJsFile, false)) != null && !JSLibraryUtil.hasDirectoryInPath(pnpJsFile, "node_modules", contentRoot) && !fileIndex.isInLibrary(pnpJsFile);
    }

    private void resetSnapshot() {
        this.myPnpFilesSnapshot = null;
        this.myPnpRootsSnapshot = null;
    }

    @NotNull
    public List<YarnPnpFile> getPnpFiles() {
        ImmutableList files = this.myPnpFilesSnapshot;
        if (files == null) {
            this.myPnpFilesSnapshot = files = ImmutableList.copyOf(this.myFileMap.values());
        }
        ImmutableList immutableList = files;
        if (immutableList == null) {
            YarnPnpManager.$$$reportNull$$$0(8);
        }
        return immutableList;
    }

    public boolean isUnderPnp(@NotNull VirtualFile fileOrDirectory) {
        if (fileOrDirectory == null) {
            YarnPnpManager.$$$reportNull$$$0(9);
        }
        return this.findAncestorRoot(fileOrDirectory) != null;
    }

    @NotNull
    private Set<VirtualFile> getPnpRoots() {
        ImmutableSet roots2 = this.myPnpRootsSnapshot;
        if (roots2 == null) {
            this.myPnpRootsSnapshot = roots2 = ImmutableSet.copyOf((Collection)ContainerUtil.mapNotNull(this.myFileMap.keySet(), pnpJs -> pnpJs.getParent()));
        }
        ImmutableSet immutableSet = roots2;
        if (immutableSet == null) {
            YarnPnpManager.$$$reportNull$$$0(10);
        }
        return immutableSet;
    }

    private void reloadLibrariesLater() {
        JSLibraryManager libraryManager = this.getLibraryManager();
        if (libraryManager != null) {
            libraryManager.scheduleCommitChanges();
        }
    }

    @Nullable
    private JSLibraryManager getLibraryManager() {
        JSLibraryManager libraryManager = this.myLibraryManager;
        if (libraryManager == null) {
            this.myLibraryManager = libraryManager = (JSLibraryManager)((Object)ReadAction.compute(() -> this.myProject.isDisposed() ? null : JSLibraryManager.getInstance(this.myProject)));
        }
        return libraryManager;
    }

    private void handleFileDeleted(@NotNull VirtualFile pnpJsFile, boolean reloadLibraries) {
        if (pnpJsFile == null) {
            YarnPnpManager.$$$reportNull$$$0(11);
        }
        if (this.myFileMap.remove(pnpJsFile) != null) {
            this.resetSnapshot();
            if (reloadLibraries) {
                this.reloadLibrariesLater();
            }
        }
    }

    private void handleFileContentChanged(@NotNull VirtualFile pnpJsFile) {
        YarnPnpFile pnpFile;
        if (pnpJsFile == null) {
            YarnPnpManager.$$$reportNull$$$0(12);
        }
        if ((pnpFile = (YarnPnpFile)this.myFileMap.get(pnpJsFile)) != null) {
            this.refreshLibrariesAsync(Collections.singletonList(pnpFile), false);
        }
    }

    @Nullable
    public VirtualFile findInstalledPackageDir(@NotNull VirtualFile packageJson, @NotNull String dependencyName) {
        YarnPnpResolvedDependencyTree.ResolvedDependency dependency;
        YarnPnpWorkspace workspace;
        YarnPnpFile pnpFile;
        YarnPnpWorkspaceList workspaceList;
        if (packageJson == null) {
            YarnPnpManager.$$$reportNull$$$0(13);
        }
        if (dependencyName == null) {
            YarnPnpManager.$$$reportNull$$$0(14);
        }
        YarnPnpWorkspaceList yarnPnpWorkspaceList = workspaceList = (pnpFile = this.findYarnPnpJsFile(packageJson)) != null ? pnpFile.getWorkspaceList() : null;
        if (workspaceList != null && (workspace = workspaceList.findWorkspaceByFile(packageJson)) != null && (dependency = workspace.getResolvedDependencyTree().findResolvedDependency(dependencyName)) != null) {
            return dependency.getDependencyRoot();
        }
        return null;
    }

    @Nullable
    public String getDependencyRequireableLocation(@NotNull VirtualFile packageJson, @NotNull String dependencyName) {
        YarnPnpDependency dependency;
        YarnPnpWorkspace workspace;
        YarnPnpFile pnpFile;
        YarnPnpWorkspaceList workspaceList;
        if (packageJson == null) {
            YarnPnpManager.$$$reportNull$$$0(15);
        }
        if (dependencyName == null) {
            YarnPnpManager.$$$reportNull$$$0(16);
        }
        YarnPnpWorkspaceList yarnPnpWorkspaceList = workspaceList = (pnpFile = this.findYarnPnpJsFile(packageJson)) != null ? pnpFile.getWorkspaceList() : null;
        if (workspaceList != null && (workspace = workspaceList.findWorkspaceByFile(packageJson)) != null && (dependency = (YarnPnpDependency)workspace.getDeps().get((Object)dependencyName)) != null) {
            return dependency.getRequireableLocation();
        }
        return null;
    }

    @Nullable
    private YarnPnpFile findYarnPnpJsFile(@NotNull VirtualFile packageJson) {
        VirtualFile root;
        if (packageJson == null) {
            YarnPnpManager.$$$reportNull$$$0(17);
        }
        VirtualFile pnpJsFile = (root = this.findAncestorRoot(packageJson)) != null ? root.findChild(PNP_JS) : null;
        return pnpJsFile != null ? (YarnPnpFile)this.myFileMap.get(pnpJsFile) : null;
    }

    @Nullable
    private VirtualFile findAncestorRoot(@NotNull VirtualFile file2) {
        Set<VirtualFile> roots2;
        if (file2 == null) {
            YarnPnpManager.$$$reportNull$$$0(18);
        }
        if ((roots2 = this.getPnpRoots()).isEmpty()) {
            return null;
        }
        for (VirtualFile dir = file2; dir != null; dir = dir.getParent()) {
            if (!roots2.contains(dir)) continue;
            return dir;
        }
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isPnpJsFile(@Nullable VirtualFile file2) {
        return file2 != null && !file2.isDirectory() && YarnPnpManager.isPnpJsFileName(file2.getNameSequence());
    }

    @Contract(value="null -> false")
    public static boolean isPnpJsFileName(@Nullable CharSequence fileName) {
        return StringUtil.equals((CharSequence)fileName, (CharSequence)PNP_JS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pnpJsFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDirectory";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPnpFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPnpRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refreshLibrariesAsync";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addPnpJsFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptPnpJsFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isUnderPnp";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleFileDeleted";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleFileContentChanged";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findInstalledPackageDir";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyRequireableLocation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findYarnPnpJsFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findAncestorRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class YarnPnpFileListener
    implements AsyncFileListener {
        private YarnPnpFileListener() {
        }

        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
            List relevantEvents;
            if (events == null) {
                YarnPnpFileListener.$$$reportNull$$$0(0);
            }
            return (relevantEvents = ContainerUtil.filter(events, this::isRelevantEvent)).isEmpty() ? null : new AsyncFileListener.ChangeApplier(){

                public void afterVfsChange() {
                    for (VFileEvent event : relevantEvents) {
                        if (event instanceof VFileDeleteEvent) {
                            YarnPnpFileListener.this.tryDelete(event.getFile());
                            continue;
                        }
                        if (event instanceof VFileContentChangeEvent) {
                            YarnPnpFileListener.this.tryHandleFileContentChanged(event.getFile());
                            continue;
                        }
                        if (event instanceof VFilePropertyChangeEvent) {
                            VFilePropertyChangeEvent renameEvent = (VFilePropertyChangeEvent)event;
                            if (!renameEvent.isRename() || Objects.equals(renameEvent.getOldValue(), renameEvent.getNewValue())) continue;
                            YarnPnpFileListener.this.tryDelete(renameEvent.getFile());
                            YarnPnpFileListener.this.tryAdd(renameEvent.getFile());
                            continue;
                        }
                        if (event instanceof VFileMoveEvent) {
                            YarnPnpFileListener.this.tryDelete(event.getFile());
                            YarnPnpFileListener.this.tryAdd(event.getFile());
                            continue;
                        }
                        if (event instanceof VFileCreateEvent) {
                            YarnPnpFileListener.this.tryAdd(event.getFile());
                            continue;
                        }
                        if (!(event instanceof VFileCopyEvent)) continue;
                        YarnPnpFileListener.this.tryAdd(event.getFile());
                    }
                }
            };
        }

        private void tryAdd(@Nullable VirtualFile pnpJsFile) {
            if (pnpJsFile != null) {
                YarnPnpManager.this.addPnpJsFile(pnpJsFile);
            }
        }

        private void tryDelete(@Nullable VirtualFile pnpJsFile) {
            if (pnpJsFile != null) {
                YarnPnpManager.this.handleFileDeleted(pnpJsFile, true);
            }
        }

        private void tryHandleFileContentChanged(@Nullable VirtualFile pnpJsFile) {
            if (pnpJsFile != null) {
                YarnPnpManager.this.handleFileContentChanged(pnpJsFile);
            }
        }

        private boolean isRelevantEvent(@NotNull VFileEvent event) {
            if (event == null) {
                YarnPnpFileListener.$$$reportNull$$$0(1);
            }
            if (event instanceof VFileCreateEvent) {
                return !((VFileCreateEvent)event).isDirectory() && YarnPnpManager.isPnpJsFileName(((VFileCreateEvent)event).getChildName());
            }
            if (event instanceof VFilePropertyChangeEvent) {
                VFilePropertyChangeEvent e = (VFilePropertyChangeEvent)event;
                return e.isRename() && (YarnPnpManager.PNP_JS.equals(e.getOldValue()) || YarnPnpManager.PNP_JS.equals(e.getNewValue()));
            }
            return YarnPnpManager.isPnpJsFile(event.getFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpManager$YarnPnpFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isRelevantEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

