/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core.codeInsight;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryConfigurator;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.javascript.nodejs.settings.NodeCoreSourcesView;
import com.intellij.javascript.nodejs.settings.NodeSettingsConfigurable;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NullableConsumer;
import com.intellij.util.text.SemVer;
import icons.JavaScriptLanguageIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleNodeCoreCodingAssistanceAction
extends ToggleAction
implements DumbAware {
    private static final Key<Boolean> ENABLING_IN_PROGRESS = Key.create((String)"Coding assistance enabling is in progress");

    public ToggleNodeCoreCodingAssistanceAction() {
        super(JavaScriptBundle.messagePointer((String)"action.ToggleNodeCoreCodingAssistanceAction.toggle.coding.assistance.for.node.js.text", (Object[])new Object[0]), JavaScriptLanguageIcons.Nodejs.Nodejs);
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ToggleNodeCoreCodingAssistanceAction.$$$reportNull$$$0(0);
        }
        return (project = e.getProject()) != null && (NodeCoreLibraryManager.getInstance(project).hasAssociatedRoots() || ToggleNodeCoreCodingAssistanceAction.isEnablingInProgress(project));
    }

    private static boolean isEnablingInProgress(@NotNull Project project) {
        if (project == null) {
            ToggleNodeCoreCodingAssistanceAction.$$$reportNull$$$0(1);
        }
        return Boolean.TRUE.equals(project.getUserData(ENABLING_IN_PROGRESS));
    }

    private static void setEnablingInProgress(@NotNull Project project, boolean enablingInProgress) {
        if (project == null) {
            ToggleNodeCoreCodingAssistanceAction.$$$reportNull$$$0(2);
        }
        project.putUserData(ENABLING_IN_PROGRESS, (Object)(enablingInProgress ? Boolean.TRUE : null));
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Project project;
        if (e == null) {
            ToggleNodeCoreCodingAssistanceAction.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) != null) {
            if (state) {
                ToggleNodeCoreCodingAssistanceAction.enableNodeCoreLibrary(project, null);
            } else {
                NodeCoreLibraryConfigurator.getInstance(project).disable();
            }
        }
    }

    public static void enableNodeCoreLibrary(@NotNull Project project, @Nullable VirtualFile requestor) {
        NodeJsInterpreter interpreter;
        if (project == null) {
            ToggleNodeCoreCodingAssistanceAction.$$$reportNull$$$0(4);
        }
        if ((interpreter = NodeJsInterpreterManager.getInstance(project).getInterpreter()) == null) {
            ToggleNodeCoreCodingAssistanceAction.showSettings(project, requestor);
            return;
        }
        ModalityState modalityState = ModalityState.current();
        interpreter.provideCachedVersionOrFetch((NullableConsumer<SemVer>)((NullableConsumer)version -> ApplicationManager.getApplication().invokeLater(() -> {
            if (version != null) {
                ToggleNodeCoreCodingAssistanceAction.setEnablingInProgress(project, true);
                NodeCoreSourcesView.enableCodeAssistance(project, interpreter, version, requestor, () -> ToggleNodeCoreCodingAssistanceAction.setEnablingInProgress(project, false));
            } else {
                ToggleNodeCoreCodingAssistanceAction.showSettings(project, requestor);
            }
        }, modalityState, project.getDisposed())));
    }

    private static void showSettings(@NotNull Project project, @Nullable VirtualFile requestor) {
        if (project == null) {
            ToggleNodeCoreCodingAssistanceAction.$$$reportNull$$$0(5);
        }
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new NodeSettingsConfigurable(project, requestor, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/library/core/codeInsight/ToggleNodeCoreCodingAssistanceAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelected";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnablingInProgress";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setEnablingInProgress";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelected";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "enableNodeCoreLibrary";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

