/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.wsl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLDistributionLegacy;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="WslNodeInterpreters", storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)})
public class WslNodeInterpreterManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(WslNodeInterpreterManager.class);
    private static final String PREFIX = "wsl://";
    private static final String INTERPRETERS_TAG_NAME = "wsl-interpreters";
    private static final String INTERPRETER_TAG_NAME = "wsl-interpreter";
    private static final String DISTRIBUTION_ATTR_NAME = "distribution";
    private static final String PATH_ATTR_NAME = "path";
    private final ExecutorService myExecutorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"WslNodeInterpreter Pool");
    private volatile List<WslNodeInterpreter> myInterpreters;
    private volatile Distributions myDistributions;
    private final ConcurrentMap<WslNodeInterpreter, Future<SemVer>> myRunningFetches = new ConcurrentHashMap<WslNodeInterpreter, Future<SemVer>>();
    private final ConcurrentMap<WslNodeInterpreter, Ref<SemVer>> myVersionCache = new ConcurrentHashMap<WslNodeInterpreter, Ref<SemVer>>();
    private boolean myAllDistributionsFetched = false;

    @Nullable
    public Element getState() {
        List<WslNodeInterpreter> interpreters = this.myInterpreters;
        if (interpreters == null) {
            return null;
        }
        Element parent = new Element(INTERPRETERS_TAG_NAME);
        for (WslNodeInterpreter interpreter : interpreters) {
            Element interpreterElement = new Element(INTERPRETER_TAG_NAME);
            interpreterElement.setAttribute(DISTRIBUTION_ATTR_NAME, interpreter.getWslDistributionId());
            interpreterElement.setAttribute(PATH_ATTR_NAME, interpreter.getWslInterpreterPath());
            parent.addContent(interpreterElement);
        }
        return parent;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(0);
        }
        List children = state.getChildren(INTERPRETER_TAG_NAME);
        ArrayList<WslNodeInterpreter> interpreters = new ArrayList<WslNodeInterpreter>();
        for (Element interpreterElement : children) {
            String distributionId = interpreterElement.getAttributeValue(DISTRIBUTION_ATTR_NAME);
            String interpreterPath = interpreterElement.getAttributeValue(PATH_ATTR_NAME);
            if (distributionId == null || interpreterPath == null) continue;
            interpreters.add(new WslNodeInterpreter(distributionId, interpreterPath));
        }
        this.setInterpreters(interpreters);
    }

    public void setInterpreters(@NotNull List<WslNodeInterpreter> interpreters) {
        if (interpreters == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(1);
        }
        this.myInterpreters = interpreters;
    }

    String getReferenceName(@NotNull WslNodeInterpreter interpreter) {
        if (interpreter == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(2);
        }
        return PREFIX + interpreter.getWslDistributionId() + "@" + interpreter.getWslInterpreterPath();
    }

    @Nullable
    public WslNodeInterpreter findByReferenceName(@NotNull String referenceName) {
        int distInd;
        if (referenceName == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(3);
        }
        if (referenceName.startsWith(PREFIX) && (distInd = referenceName.indexOf("@", PREFIX.length())) > 0) {
            String wslId = referenceName.substring(PREFIX.length(), distInd);
            String path = referenceName.substring(distInd + 1);
            return new WslNodeInterpreter(wslId, path);
        }
        return null;
    }

    @NotNull
    Distributions updateAvailableDistributionsAndGet(boolean fetchFromWslList) {
        Distributions distributions;
        this.myDistributions = distributions = new Distributions(fetchFromWslList);
        Distributions distributions2 = distributions;
        if (distributions2 == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(4);
        }
        return distributions2;
    }

    @Nullable
    WSLDistribution findDistribution(@NotNull WslNodeInterpreter interpreter) {
        Distributions distributions;
        if (interpreter == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(5);
        }
        if ((distributions = this.myDistributions) == null) {
            distributions = this.updateAvailableDistributionsAndGet(false);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                this.myDistributions = this.updateAvailableDistributionsAndGet(true);
                this.myAllDistributionsFetched = true;
            });
        }
        WSLDistribution distribution = distributions.findById(interpreter.getWslDistributionId());
        if (this.myAllDistributionsFetched) {
            return distribution;
        }
        return new WSLDistribution(interpreter.getWslDistributionId());
    }

    @NotNull
    public List<WslNodeInterpreter> getInterpreters() {
        List list2 = ContainerUtil.notNullize(this.myInterpreters);
        if (list2 == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Nullable
    public Ref<SemVer> getCachedVersion(@NotNull WslNodeInterpreter interpreter) {
        if (interpreter == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(7);
        }
        return (Ref)this.myVersionCache.get(interpreter);
    }

    public void fetchVersion(@NotNull WslNodeInterpreter interpreter, @Nullable NullableConsumer<? super SemVer> consumer) {
        if (interpreter == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(8);
        }
        Future<SemVer> future = this.getOrCreateFetch(interpreter);
        if (consumer != null) {
            this.myExecutorService.execute(() -> {
                SemVer version = null;
                try {
                    version = (SemVer)future.get();
                }
                catch (InterruptedException e) {
                    LOG.warn("Fetch interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.warn("Fetch failed", (Throwable)e);
                }
                consumer.consume((Object)version);
            });
        }
    }

    @NotNull
    private Future<SemVer> getOrCreateFetch(@NotNull WslNodeInterpreter interpreter) {
        FutureTask<SemVer> newFetch;
        Future running;
        if (interpreter == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(9);
        }
        if ((running = (Future)this.myRunningFetches.putIfAbsent(interpreter, newFetch = new FutureTask<SemVer>(() -> {
            SemVer version = null;
            try {
                version = WslNodeInterpreterManager.doFetchVersion(interpreter);
            }
            catch (Throwable t) {
                LOG.warn("Failed to fetch version for " + interpreter, t);
            }
            finally {
                this.myVersionCache.put(interpreter, (Ref<SemVer>)Ref.create((Object)version));
                this.myRunningFetches.remove(interpreter);
            }
            return version;
        }))) != null) {
            Future future = running;
            if (future == null) {
                WslNodeInterpreterManager.$$$reportNull$$$0(10);
            }
            return future;
        }
        this.myExecutorService.execute(newFetch);
        FutureTask<SemVer> futureTask = newFetch;
        if (futureTask == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(11);
        }
        return futureTask;
    }

    private static SemVer doFetchVersion(@NotNull WslNodeInterpreter interpreter) throws com.intellij.execution.ExecutionException {
        if (interpreter == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(12);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.withCharset(StandardCharsets.UTF_8);
        commandLine.setExePath(interpreter.getWslInterpreterPath());
        commandLine.addParameter("--version");
        WSLDistribution distribution = interpreter.getDistribution();
        if (distribution == null) {
            throw new RuntimeException("WSL " + interpreter.getWslDistributionId() + " is not available");
        }
        CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine = distribution.patchCommandLine(commandLine, null, new WSLCommandLineOptions()));
        ProcessOutput output = processHandler.runProcess(5000);
        if (output.isTimeout()) {
            LOG.info("Cannot fetch version: timed out (" + commandLine.getCommandLineString() + ")");
            return null;
        }
        if (output.getExitCode() != 0) {
            LOG.info("Cannot fetch version: non-zero exit code " + output.getExitCode() + " (" + commandLine.getCommandLineString() + "), stdout: " + output.getStdout() + ", stderr: " + output.getStderr());
            return null;
        }
        List lines = output.getStdoutLines(true);
        for (String line : lines) {
            SemVer version = SemVer.parseFromText((String)StringUtil.trimStart((String)line, (String)"v"));
            if (version == null) continue;
            return version;
        }
        LOG.info("Cannot parse version from '" + lines + "' (" + commandLine.getCommandLineString() + ")");
        return null;
    }

    @NotNull
    public static WslNodeInterpreterManager getInstance() {
        WslNodeInterpreterManager wslNodeInterpreterManager = (WslNodeInterpreterManager)ApplicationManager.getApplication().getService(WslNodeInterpreterManager.class);
        if (wslNodeInterpreterManager == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(13);
        }
        return wslNodeInterpreterManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/wsl/WslNodeInterpreterManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/wsl/WslNodeInterpreterManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateAvailableDistributionsAndGet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreters";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateFetch";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreters";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findByReferenceName";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findDistribution";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCachedVersion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fetchVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateFetch";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doFetchVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Distributions {
        private final List<WSLDistribution> myDistributions;
        private final Map<String, WSLDistribution> myDistributionMap;

        Distributions(boolean fetchFromWslList) {
            this.myDistributions = fetchFromWslList ? WslDistributionManager.getInstance().getInstalledDistributions() : WSLUtil.getAvailableDistributions();
            ArrayList<WSLDistribution> all = new ArrayList<WSLDistribution>(this.myDistributions);
            ContainerUtil.addIfNotNull(all, (Object)WSLDistributionLegacy.getInstance());
            Map msIdMap = ContainerUtil.newMapFromValues(all.iterator(), d -> d.getId());
            Map idMap = ContainerUtil.newMapFromValues(all.iterator(), d -> d.getMsId());
            this.myDistributionMap = new HashMap<String, WSLDistribution>();
            this.myDistributionMap.putAll(msIdMap);
            this.myDistributionMap.putAll(idMap);
        }

        @NotNull
        public List<WSLDistribution> getDistributions() {
            List<WSLDistribution> list2 = this.myDistributions;
            if (list2 == null) {
                Distributions.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Nullable
        public WSLDistribution findById(@NotNull String id) {
            if (id == null) {
                Distributions.$$$reportNull$$$0(1);
            }
            return this.myDistributionMap.get(id);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/wsl/WslNodeInterpreterManager$Distributions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDistributions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/wsl/WslNodeInterpreterManager$Distributions";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findById";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

