/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreterType;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.text.SemVer;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WslNodeInterpreter
extends NodeJsInterpreter {
    @NlsSafe
    private final String myWslDistributionId;
    @NlsSafe
    private final String myWslInterpreterPath;
    private WSLDistribution myDistribution;

    public WslNodeInterpreter(@NotNull @NlsSafe String wslDistributionId, @NotNull @NlsSafe String wslInterpreterPath) {
        if (wslDistributionId == null) {
            WslNodeInterpreter.$$$reportNull$$$0(0);
        }
        if (wslInterpreterPath == null) {
            WslNodeInterpreter.$$$reportNull$$$0(1);
        }
        this.myWslDistributionId = wslDistributionId;
        this.myWslInterpreterPath = FileUtil.toSystemIndependentName((String)wslInterpreterPath);
    }

    @NotNull
    @NlsSafe
    public String getWslDistributionId() {
        String string = this.myWslDistributionId;
        if (string == null) {
            WslNodeInterpreter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getWslInterpreterPath() {
        String string = this.myWslInterpreterPath;
        if (string == null) {
            WslNodeInterpreter.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public WSLDistribution getDistribution() {
        WSLDistribution distribution = this.myDistribution;
        if (distribution == null) {
            this.myDistribution = distribution = WslNodeInterpreterManager.getInstance().findDistribution(this);
        }
        return distribution;
    }

    @Override
    @NotNull
    public NodeJsInterpreterType<? extends NodeJsInterpreter> getType() {
        WslNodeInterpreterType wslNodeInterpreterType = WslNodeInterpreterType.getInstance();
        if (wslNodeInterpreterType == null) {
            WslNodeInterpreter.$$$reportNull$$$0(4);
        }
        return wslNodeInterpreterType;
    }

    @Override
    @NotNull
    public String getReferenceName() {
        String string = WslNodeInterpreterManager.getInstance().getReferenceName(this);
        if (string == null) {
            WslNodeInterpreter.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        WSLDistribution dist = this.getDistribution();
        String name = dist != null ? dist.getPresentableName() : this.myWslDistributionId;
        String string = name + " " + this.getWslInterpreterPath();
        if (string == null) {
            WslNodeInterpreter.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @Nullable
    public Ref<SemVer> getCachedVersion() {
        return WslNodeInterpreterManager.getInstance().getCachedVersion(this);
    }

    @Override
    public void fetchVersion(@NotNull NullableConsumer<? super SemVer> consumer) {
        if (consumer == null) {
            WslNodeInterpreter.$$$reportNull$$$0(7);
        }
        WslNodeInterpreterManager.getInstance().fetchVersion(this, consumer);
    }

    @Override
    @Nullable
    public String validate(@Nullable Project project) {
        if (this.getDistribution() == null) {
            return JavaScriptBundle.message((String)"node.wsl.cannot_find_installed_wsl_distribution.message", (Object[])new Object[]{this.getWslDistributionId()});
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WslNodeInterpreter that = (WslNodeInterpreter)o;
        return Objects.equals(this.myWslDistributionId, that.myWslDistributionId) && Objects.equals(this.myWslInterpreterPath, that.myWslInterpreterPath);
    }

    public int hashCode() {
        return Objects.hash(this.myWslDistributionId, this.myWslInterpreterPath);
    }

    public String toString() {
        return "wsl_id=" + this.myWslDistributionId + ", wsl_path=" + this.myWslInterpreterPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslDistributionId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslInterpreterPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/wsl/WslNodeInterpreter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/wsl/WslNodeInterpreter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslDistributionId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslInterpreterPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fetchVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

