/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.filter;

import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.FileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternBasedFileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternHyperlinkFormat;
import com.intellij.execution.filters.PatternHyperlinkPart;
import com.intellij.javascript.nodejs.filter.WebpackErrorFilterState;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebpackErrorLinkFinder
implements FileHyperlinkRawDataFinder {
    private static final PatternBasedFileHyperlinkRawDataFinder PATTERN_FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^\\s*(?:\\[tsl] )?ERROR in (?:\\[default] )?((.+?)\\((\\d+),(\\d+)\\)):?\\s*$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.HYPERLINK, PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^\\s*TypeScript error in ((.+?)\\((\\d+),(\\d+)\\)):\\s*$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.HYPERLINK, PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^\\s*\\[at-loader] (.+?):(\\d+):(\\d+)\\s*$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^\\s*ERROR: (.+?):(\\d+):(\\d+) - .*$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^\\s*ERROR in (?:\\[default] )?(.+?):(\\d+):(\\d+)(?:\\s*| - error.*)$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^\\s*ERROR at ((.+?)\\((\\d+),(\\d+)\\)): .*$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.HYPERLINK, PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN}), new PatternHyperlinkFormat(Pattern.compile("^\\s*(.+?):(\\d+):(\\d+) - error .*$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN})});
    private static final String FAILED_TO_COMPILE = "Failed to compile.";
    private static final String COMPILED_SUCCESSFULLY = "Compiled successfully!";
    private static final PatternBasedFileHyperlinkRawDataFinder LINE_FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^\\s+(Line( )(\\d+):(\\d+)): .*$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.HYPERLINK, PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN})});

    @NotNull
    public List<FileHyperlinkRawData> find(@NotNull String line) {
        if (line == null) {
            WebpackErrorLinkFinder.$$$reportNull$$$0(0);
        }
        List list2 = PATTERN_FINDER.find(line);
        if (list2 == null) {
            WebpackErrorLinkFinder.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Nullable
    public WebpackErrorFilterState findWithState(@NotNull String line, @Nullable WebpackErrorFilterState prevState) {
        List links;
        if (line == null) {
            WebpackErrorLinkFinder.$$$reportNull$$$0(2);
        }
        if (WebpackErrorLinkFinder.equalsIgnoringLineSeparator(line, FAILED_TO_COMPILE)) {
            return new WebpackErrorFilterState(line, null, prevState, Collections.emptyList());
        }
        if (prevState == null || WebpackErrorLinkFinder.equalsIgnoringLineSeparator(line, COMPILED_SUCCESSFULLY)) {
            return null;
        }
        String filePath = prevState.getFilePath();
        if (filePath != null && !(links = LINE_FINDER.find(line)).isEmpty()) {
            return new WebpackErrorFilterState(line, prevState.getFilePath(), prevState, ContainerUtil.map((Collection)links, data -> new FileHyperlinkRawData(filePath, data.getDocumentLine(), data.getDocumentColumn(), data.getHyperlinkStartInd(), data.getHyperlinkEndInd())));
        }
        if (line.isEmpty() || StringUtil.startsWithWhitespace((String)line)) {
            return new WebpackErrorFilterState(line, prevState.getFilePath(), prevState, Collections.emptyList());
        }
        String path = StringUtil.trimTrailing((String)line);
        return new WebpackErrorFilterState(line, path, prevState, Collections.singletonList(new FileHyperlinkRawData(path, -1, -1, 0, path.length())));
    }

    private static boolean equalsIgnoringLineSeparator(@NotNull String line, @NotNull String pattern) {
        if (line == null) {
            WebpackErrorLinkFinder.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            WebpackErrorLinkFinder.$$$reportNull$$$0(4);
        }
        return line.startsWith(pattern) && line.length() <= pattern.length() + LineSeparator.CRLF.getSeparatorString().length() && line.trim().equals(pattern);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/filter/WebpackErrorLinkFinder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/filter/WebpackErrorLinkFinder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findWithState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "equalsIgnoringLineSeparator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

