/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.env;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunDialog;
import com.intellij.javascript.nodejs.env.DotEnvFileManager;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiManager;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeEnvironmentVariablesProvider
implements Disposable {
    private final Project myProject;
    private final DotEnvFileManager myDotEnvManager;
    private volatile Map<String, String> myEnvironment;

    public NodeEnvironmentVariablesProvider(@NotNull Project project) {
        if (project == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDotEnvManager = DotEnvFileManager.getInstance(project);
        project.getMessageBus().connect((Disposable)this).subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(0);
                }
                NodeEnvironmentVariablesProvider.this.onRunConfigurationChanged(new ChangeEvent(settings, false));
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(1);
                }
                NodeEnvironmentVariablesProvider.this.onRunConfigurationChanged(new ChangeEvent(settings, false));
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    1.$$$reportNull$$$0(2);
                }
                NodeEnvironmentVariablesProvider.this.onRunConfigurationChanged(new ChangeEvent(settings, false));
            }

            public void runConfigurationSelected(@Nullable RunnerAndConfigurationSettings settings) {
                NodeEnvironmentVariablesProvider.this.onRunConfigurationChanged(new ChangeEvent(settings, true));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "com/intellij/javascript/nodejs/env/NodeEnvironmentVariablesProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void onRunConfigurationChanged(@NotNull ChangeEvent event) {
        RunnerAndConfigurationSettings changed;
        if (event == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(1);
        }
        if ((changed = event.getSource()) != null && NodeEnvironmentVariablesProvider.getEnvironment(changed.getConfiguration()) != null) {
            this.myEnvironment = this.collectCommonEnvironment(event);
            this.invalidateIndexingHandlerCache();
        }
    }

    @NotNull
    public Map<String, String> getEnvironment(@Nullable VirtualFile contextFile) {
        List<DotEnvFileManager.EnvFileData> envFileDataList = this.myDotEnvManager.findEnvs(contextFile);
        Map<String, String> staticEnvs = this.getEnvironment();
        if (envFileDataList.isEmpty()) {
            Map<String, String> map = staticEnvs;
            if (map == null) {
                NodeEnvironmentVariablesProvider.$$$reportNull$$$0(2);
            }
            return map;
        }
        EnvMerger envMerger = new EnvMerger();
        for (DotEnvFileManager.EnvFileData envFileData : envFileDataList) {
            envMerger.addEnvsIfAbsent(envFileData.getEnvs());
        }
        envMerger.addEnvsIfAbsent(staticEnvs);
        LinkedHashMap<String, String> linkedHashMap = envMerger.myOrderedEnvs;
        if (linkedHashMap == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(3);
        }
        return linkedHashMap;
    }

    @NotNull
    private Map<String, String> getEnvironment() {
        Map<String, String> envs = this.myEnvironment;
        if (envs == null) {
            this.myEnvironment = envs = this.collectCommonEnvironment(null);
        }
        Map<String, String> map = envs;
        if (map == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    private Map<String, String> collectCommonEnvironment(@Nullable ChangeEvent event) {
        EnvMerger envMerger = new EnvMerger();
        for (RunConfiguration configuration : this.getConfigurations(event)) {
            Map<String, String> environment = NodeEnvironmentVariablesProvider.getEnvironment(configuration);
            if (environment == null) continue;
            envMerger.addEnvsIfAbsent(environment);
        }
        envMerger.addEnvsIfAbsent(EnvironmentUtil.getEnvironmentMap());
        LinkedHashMap<String, String> linkedHashMap = envMerger.myOrderedEnvs;
        if (linkedHashMap == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(5);
        }
        return linkedHashMap;
    }

    private void invalidateIndexingHandlerCache() {
        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> PsiManager.getInstance((Project)this.myProject).dropPsiCaches(), ModalityState.defaultModalityState(), this.myProject.getDisposed());
    }

    @NotNull
    private List<RunConfiguration> getConfigurations(@Nullable ChangeEvent event) {
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        RunnerAndConfigurationSettings selected = ChangeEvent.getSelected(event, runManager);
        RunConfiguration selectedConfiguration = selected != null ? selected.getConfiguration() : null;
        ArrayList<RunConfiguration> configurations = new ArrayList<RunConfiguration>(runManager.getAllConfigurationsList());
        if (selectedConfiguration != null) {
            configurations.remove(selectedConfiguration);
            configurations.add(0, selectedConfiguration);
        }
        ArrayList<RunConfiguration> arrayList = configurations;
        if (arrayList == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull String envVarName, @Nullable VirtualFile contextFile) {
        if (envVarName == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(7);
        }
        return contextFile != null ? this.myDotEnvManager.getNavigatable(envVarName, contextFile) : null;
    }

    public boolean navigate(@NotNull String envVarName, @Nullable VirtualFile contextFile) {
        if (envVarName == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(8);
        }
        if (contextFile != null) {
            Navigatable navigatable = this.getNavigatable(envVarName, contextFile);
            if (navigatable != null) {
                navigatable.navigate(true);
            }
            return true;
        }
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        for (RunConfiguration configuration : runManager.getAllConfigurationsList()) {
            Map<String, String> environment = NodeEnvironmentVariablesProvider.getEnvironment(configuration);
            RunnerAndConfigurationSettings settings = runManager.findSettings(configuration);
            if (environment == null || !environment.containsKey(envVarName) || settings == null || !RunDialog.editConfiguration((Project)this.myProject, (RunnerAndConfigurationSettings)settings, (String)JavaScriptBundle.message((String)"dialog.title.edit.run.debug.configuration", (Object[])new Object[]{settings.getName()}))) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
    }

    @Nullable
    private static Map<String, String> getEnvironment(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(9);
        }
        if (configuration instanceof CommonProgramRunConfigurationParameters) {
            return ((CommonProgramRunConfigurationParameters)configuration).getEnvs();
        }
        if (configuration instanceof NpmRunConfiguration) {
            return ((NpmRunConfiguration)configuration).getRunSettings().getEnvData().getEnvs();
        }
        return null;
    }

    @NotNull
    public static NodeEnvironmentVariablesProvider getInstance(@NotNull Project project) {
        if (project == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(10);
        }
        NodeEnvironmentVariablesProvider nodeEnvironmentVariablesProvider = (NodeEnvironmentVariablesProvider)ServiceManager.getService((Project)project, NodeEnvironmentVariablesProvider.class);
        if (nodeEnvironmentVariablesProvider == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(11);
        }
        return nodeEnvironmentVariablesProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/env/NodeEnvironmentVariablesProvider";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVarName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/env/NodeEnvironmentVariablesProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommonEnvironment";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onRunConfigurationChanged";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ChangeEvent {
        private final RunnerAndConfigurationSettings mySource;
        private final boolean mySelectChanged;

        private ChangeEvent(@Nullable RunnerAndConfigurationSettings source, boolean selectChanged) {
            this.mySource = source;
            this.mySelectChanged = selectChanged;
        }

        @Nullable
        private RunnerAndConfigurationSettings getSource() {
            return this.mySource;
        }

        @Nullable
        private static RunnerAndConfigurationSettings getSelected(@Nullable ChangeEvent event, @NotNull RunManager runManager) {
            if (runManager == null) {
                ChangeEvent.$$$reportNull$$$0(0);
            }
            return event != null && event.mySelectChanged ? event.getSource() : runManager.getSelectedConfiguration();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runManager", "com/intellij/javascript/nodejs/env/NodeEnvironmentVariablesProvider$ChangeEvent", "getSelected"));
        }
    }

    private static final class EnvMerger {
        private final Set<String> myEnvNames;
        private final LinkedHashMap<String, String> myOrderedEnvs = new LinkedHashMap();

        private EnvMerger() {
            this.myEnvNames = new THashSet((TObjectHashingStrategy)(SystemInfo.isWindows ? CaseInsensitiveStringHashingStrategy.INSTANCE : ContainerUtil.canonicalStrategy()));
        }

        private void addEnvsIfAbsent(@NotNull Map<String, String> envs) {
            if (envs == null) {
                EnvMerger.$$$reportNull$$$0(0);
            }
            for (Map.Entry<String, String> entry : envs.entrySet()) {
                if (!this.myEnvNames.add(entry.getKey())) continue;
                this.myOrderedEnvs.put(entry.getKey(), entry.getValue());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/intellij/javascript/nodejs/env/NodeEnvironmentVariablesProvider$EnvMerger", "addEnvsIfAbsent"));
        }
    }
}

