/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices.express;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/microservices/express/ExpressFrameworkHandler;", "Lcom/intellij/lang/javascript/index/FrameworkIndexingHandler;", "()V", "getCustomStringIndexKey", "", "elementToIndex", "Lcom/intellij/psi/PsiElement;", "hasSignificantValue", "", "node", "Lcom/intellij/lang/ASTNode;", "expression", "Lcom/intellij/lang/javascript/psi/JSLiteralExpression;", "shouldCreateStubForLiteral", "shouldProcess", "Companion", "intellij.javascript.langInjection"})
public final class ExpressFrameworkHandler
extends FrameworkIndexingHandler {
    @NotNull
    public static final String KEY = "Express";
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean shouldCreateStubForLiteral(@Nullable ASTNode node) {
        return this.hasSignificantValue(node);
    }

    @Override
    public boolean hasSignificantValue(@NotNull JSLiteralExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return this.hasSignificantValue(expression.getNode());
    }

    private final boolean hasSignificantValue(ASTNode node) {
        block8: {
            block7: {
                ASTNode aSTNode = node;
                if (aSTNode == null || (aSTNode = aSTNode.getFirstChildNode()) == null) {
                    return false;
                }
                ASTNode leaf = aSTNode;
                if (Intrinsics.areEqual((Object)leaf.getElementType(), (Object)JSTokenTypes.STRING_LITERAL) ^ true) {
                    return false;
                }
                String string = leaf.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"leaf.text");
                String text = string;
                if (text.length() < 2) break block7;
                String string2 = StringUtil.unquoteString((String)text);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.unquoteString(text)");
                if (StringsKt.startsWith$default((String)string2, (String)"/", (boolean)false, (int)2, null)) break block8;
            }
            return false;
        }
        ASTNode aSTNode = node.getTreeParent();
        if (aSTNode == null || (aSTNode = aSTNode.getTreeParent()) == null) {
            return false;
        }
        ASTNode treeParent = aSTNode;
        IElementType iElementType = treeParent.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"treeParent.elementType");
        IElementType parentType = iElementType;
        if (Intrinsics.areEqual((Object)parentType, (Object)JSElementTypes.CALL_EXPRESSION)) {
            return this.shouldProcess(treeParent);
        }
        return false;
    }

    @Override
    @Nullable
    public String getCustomStringIndexKey(@NotNull PsiElement elementToIndex) {
        Intrinsics.checkNotNullParameter((Object)elementToIndex, (String)"elementToIndex");
        return elementToIndex instanceof JSLiteralExpression && this.hasSignificantValue(((JSLiteralExpression)elementToIndex).getNode()) ? KEY : null;
    }

    public final boolean shouldProcess(@NotNull ASTNode node) {
        ASTNode methodExpression;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        ASTNode aSTNode = methodExpression = node.getFirstChildNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"methodExpression");
        if (aSTNode.getElementType() != JSElementTypes.REFERENCE_EXPRESSION) {
            return false;
        }
        ASTNode qualifierElement = JSReferenceExpressionImpl.getQualifierNode(methodExpression);
        if (qualifierElement == null) {
            return false;
        }
        String refText = JSReferenceExpressionImpl.getReferenceName(methodExpression);
        return Intrinsics.areEqual((Object)refText, (Object)"use") || Intrinsics.areEqual((Object)refText, (Object)"get") || Intrinsics.areEqual((Object)refText, (Object)"post");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/javascript/microservices/express/ExpressFrameworkHandler$Companion;", "", "()V", "KEY", "", "intellij.javascript.langInjection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

