/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest.snapshot;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.jest.JestUpdateSnapshotHyperlinkInfo;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestSnapshotEventsListener
extends SMTRunnerEventsAdapter {
    private static final String FILE_SCHEME = "file://";
    @NonNls
    private static final String[] SNAPSHOT_PATTERN = new String[]{").toMatchSnapshot(", ").toMatchInlineSnapshot("};
    private static final String[] SNAPSHOT_WORDS = (String[])ContainerUtil.map((Object[])SNAPSHOT_PATTERN, s -> s.substring(2, s.length() - 1), (Object[])new String[SNAPSHOT_PATTERN.length]);
    @NonNls
    private static final String LINK_START = "<link>";
    @NonNls
    private static final String LINK_END = "</link>";
    private final Multiset<SMTestProxy> myFailedFileProxies = HashMultiset.create();
    private boolean myAllTestsLinkAdded = false;

    public void onTestingStarted(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        if (testsRoot == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(0);
        }
        this.myFailedFileProxies.clear();
        this.myAllTestsLinkAdded = false;
    }

    public void onTestFailed(@NotNull SMTestProxy test) {
        if (test == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(1);
        }
        if (test.isDefect() && JestSnapshotEventsListener.isSnapshotMatchFailed(test)) {
            List<String> testLocationPath = JestUtil.getTestLocationPath((AbstractTestProxy)test);
            if (testLocationPath == null || testLocationPath.size() <= 1) {
                return;
            }
            String testFilePath = Objects.requireNonNull(testLocationPath.get(0));
            List<String> testFqn = testLocationPath.subList(1, testLocationPath.size());
            test.insert(printer -> JestSnapshotEventsListener.printLink(printer, JavaScriptBundle.message((String)"jest.snapshot.update.single.test.text", (Object[])new Object[]{Objects.requireNonNull((String)ContainerUtil.getLastItem((List)testFqn))}) + "\n", new JestUpdateSnapshotHyperlinkInfo(testFilePath, testFqn)), 0);
            SMTestProxy fileProxy = JestSnapshotEventsListener.findTestFileProxy(test);
            if (fileProxy != null && this.myFailedFileProxies.add((Object)fileProxy, 1) == 1) {
                fileProxy.insert(printer -> JestSnapshotEventsListener.printLink(printer, JavaScriptBundle.message((String)"jest.snapshot.update.test.file.text", (Object[])new Object[]{PathUtil.getFileName((String)testFilePath)}) + "\n\n", new JestUpdateSnapshotHyperlinkInfo(testFilePath, null)), 0);
            }
            if (fileProxy != null && fileProxy.getParent() instanceof SMTestProxy.SMRootTestProxy && !this.myAllTestsLinkAdded && this.myFailedFileProxies.entrySet().size() > 1) {
                this.myAllTestsLinkAdded = true;
                fileProxy.getParent().insert(printer -> JestSnapshotEventsListener.printLink(printer, JavaScriptBundle.message((String)"jest.snapshot.update.all.tests.text", (Object[])new Object[0]) + "\n\n", new JestUpdateSnapshotHyperlinkInfo(null, null)), 1);
            }
        }
    }

    private static void printLink(@NotNull Printer printer, @NotNull String message, @NotNull JestUpdateSnapshotHyperlinkInfo linkInfo) {
        if (printer == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(2);
        }
        if (message == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(3);
        }
        if (linkInfo == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(4);
        }
        int linkStartInd = message.indexOf(LINK_START);
        int linkEndInd = message.indexOf(LINK_END, linkStartInd + LINK_START.length());
        if (linkStartInd >= 0 && linkEndInd >= 0) {
            if (linkStartInd > 0) {
                printer.print(message.substring(0, linkStartInd), ConsoleViewContentType.NORMAL_OUTPUT);
            }
            printer.printHyperlink(message.substring(linkStartInd + LINK_START.length(), linkEndInd), (HyperlinkInfo)linkInfo);
            message = message.substring(linkEndInd + LINK_END.length());
        }
        if (!message.isEmpty()) {
            printer.print(message, ConsoleViewContentType.NORMAL_OUTPUT);
        }
    }

    private static boolean isSnapshotMatchFailed(@NotNull SMTestProxy test) {
        String text;
        if (test == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(5);
        }
        if ((text = test.getErrorMessage()).isEmpty()) {
            text = test.getStacktrace();
        }
        if (text != null && JestSnapshotEventsListener.containsAny(text, SNAPSHOT_WORDS)) {
            StringBuilder result2 = new StringBuilder();
            AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
            decoder.escapeText(text, ProcessOutputTypes.STDOUT, (chunk, attributes) -> result2.append(chunk));
            return JestSnapshotEventsListener.containsAny(result2.toString(), SNAPSHOT_PATTERN);
        }
        return false;
    }

    private static boolean containsAny(@NotNull String text, String @NotNull [] patterns) {
        if (text == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(6);
        }
        if (patterns == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(7);
        }
        for (String pattern : patterns) {
            if (!text.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static SMTestProxy findTestFileProxy(@NotNull SMTestProxy test) {
        if (test == null) {
            JestSnapshotEventsListener.$$$reportNull$$$0(8);
        }
        for (SMTestProxy proxy = test; proxy != null; proxy = proxy.getParent()) {
            String locationUrl = proxy.getLocationUrl();
            if (locationUrl == null || !locationUrl.startsWith(FILE_SCHEME)) continue;
            return proxy;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testsRoot";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/jest/snapshot/JestSnapshotEventsListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onTestingStarted";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onTestFailed";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "printLink";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isSnapshotMatchFailed";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "containsAny";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findTestFileProxy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

