/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.jest.JestPkgInfo;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.javascript.testing.JSTestRunnerUtil;
import com.intellij.json.JsonFileType;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JestUtil {
    private static final Logger LOG = Logger.getInstance(JestUtil.class);
    public static final String JEST_PACKAGE_NAME = "jest";
    public static final String PACKAGE_JSON_TOP_LEVEL_KEY = "jest";
    public static final String VUE_CLI_SERVICE = "@vue/cli-service";
    public static final String ANGULAR_CLI = "@angular/cli";
    private static final String JEST_CLI_PACKAGE_NAME = "jest-cli";
    private static final Map<String, JestPkgInfo> PKG_INFO_MAP = ContainerUtil.newLinkedHashMap((Pair)Pair.create((Object)"@angular/cli", (Object)new JestPkgInfo("bin/ng", false)), (Pair[])new Pair[]{Pair.create((Object)"@vue/cli-service", (Object)new JestPkgInfo("bin/vue-cli-service.js", false)), Pair.create((Object)"react-scripts-ts", (Object)new JestPkgInfo("bin/react-scripts-ts.js", true)), Pair.create((Object)"react-super-scripts", (Object)new JestPkgInfo("bin/react-scripts.js", true)), Pair.create((Object)"react-awesome-scripts", (Object)new JestPkgInfo("bin/react-scripts.js", true)), Pair.create((Object)"custom-react-scripts", (Object)new JestPkgInfo("bin/react-scripts.js", true)), Pair.create((Object)"react-scripts", (Object)new JestPkgInfo("bin/react-scripts.js", true)), Pair.create((Object)"jest", (Object)new JestPkgInfo("bin/jest.js", false)), Pair.create((Object)"jest-cli", (Object)new JestPkgInfo("bin/jest.js", false))});
    public static final NodePackageDescriptor PKG_DESCRIPTOR = new NodePackageDescriptor(ContainerUtil.filter(PKG_INFO_MAP.keySet(), pkg -> !ANGULAR_CLI.equals(pkg)), ContainerUtil.newHashMap((Pair)Pair.create((Object)"@vue/cli-service", (Object)"@vue/cli-plugin-unit-jest"), (Pair[])new Pair[0]), JavaScriptBundle.message((String)"jest.package.placeholder.text", (Object[])new Object[0])){

        @Override
        @NotNull
        public List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject) {
            if (project == null) {
                1.$$$reportNull$$$0(0);
            }
            List<NodePackage> packages = new NodePackageDescriptor(JestUtil.ANGULAR_CLI).listAvailable(project, interpreter, contextFileOrDirectory, directDependenciesInsideProject, true);
            ArrayList<NodePackage> result2 = new ArrayList<NodePackage>();
            for (NodePackage pkg : packages) {
                Object path = pkg.getSystemIndependentPath();
                path = StringUtil.trimEnd((String)path, (String)JestUtil.ANGULAR_CLI) + "@angular-builders/jest";
                if (LocalFileSystem.getInstance().findFileByPath((String)path) == null) continue;
                result2.add(pkg);
            }
            result2.addAll(super.listAvailable(project, interpreter, contextFileOrDirectory, directDependenciesInsideProject));
            ArrayList<NodePackage> arrayList = result2;
            if (arrayList == null) {
                1.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/jest/JestUtil$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/jest/JestUtil$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "listAvailable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "listAvailable";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final String TEST_PROTOCOL_PREFIX = "test://";
    private static final String TAG__CONFIG_FILE = "config-file";
    private static final String TAG__NODE_INTERPRETER = "node-interpreter";
    private static final String TAG__NODE_OPTIONS = "node-options";
    private static final String TAG__JEST_PACKAGE = "jest-package";
    private static final String KEY__JEST_PACKAGE_DIR = "nodejs.jest.jest_package";
    private static final String TAG__WORKING_DIR = "working-dir";
    private static final String TAG__JEST_OPTIONS = "jest-options";
    private static final String TAG__SCOPE_KIND = "scope-kind";
    private static final String TAG__TEST_FILE = "test-file";
    private static final String TAG__TEST_NAMES = "test-names";
    private static final String TAG__TEST_NAME = "test-name";
    static final String DEFAULT_CONFIG_FILE_NAME = "jest.config.js";
    public static final String CONFIG_PREFIX = "jest.config";
    private static final String[] EXTENSIONS = new String[]{".js", ".json"};

    private JestUtil() {
    }

    @NotNull
    public static JestRunSettings readXml(@NotNull Element element) {
        if (element == null) {
            JestUtil.$$$reportNull$$$0(0);
        }
        JestRunSettings.Builder builder = JestRunSettings.builder();
        builder.setConfigFilePath(JestUtil.readValue(element, TAG__CONFIG_FILE));
        String interpreterRefName = JDOMExternalizerUtil.readCustomField((Element)element, (String)TAG__NODE_INTERPRETER);
        builder.setInterpreterRef(NodeJsInterpreterRef.create(interpreterRefName));
        builder.setNodeOptions(JestUtil.readValue(element, TAG__NODE_OPTIONS));
        String pkg = JDOMExternalizerUtil.readCustomField((Element)element, (String)TAG__JEST_PACKAGE);
        if (pkg != null) {
            builder.setJestPackage(PKG_DESCRIPTOR.createPackage(pkg));
        }
        builder.setWorkingDir(JestUtil.readValue(element, TAG__WORKING_DIR));
        builder.setJestOptions(JestUtil.readValue(element, TAG__JEST_OPTIONS));
        builder.setEnvData(EnvironmentVariablesData.readExternal((Element)element));
        JestScopeKind scopeKind = JestUtil.readScopeKind(element);
        builder.setScopeKind(scopeKind);
        if (scopeKind == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            builder.setTestFilePath(JestUtil.readValue(element, TAG__TEST_FILE));
        }
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            builder.setTestNames(JestUtil.readTestNames(element));
        }
        JestRunSettings jestRunSettings = builder.build();
        if (jestRunSettings == null) {
            JestUtil.$$$reportNull$$$0(1);
        }
        return jestRunSettings;
    }

    @NotNull
    private static JestScopeKind readScopeKind(@NotNull Element element) {
        JestScopeKind jestScopeKind;
        if (element == null) {
            JestUtil.$$$reportNull$$$0(2);
        }
        String scopeKindStr = JestUtil.readValue(element, TAG__SCOPE_KIND);
        try {
            jestScopeKind = JestScopeKind.valueOf(scopeKindStr);
        }
        catch (Exception ignored) {
            JestScopeKind jestScopeKind2 = JestScopeKind.ALL;
            if (jestScopeKind2 == null) {
                JestUtil.$$$reportNull$$$0(4);
            }
            return jestScopeKind2;
        }
        if (jestScopeKind == null) {
            JestUtil.$$$reportNull$$$0(3);
        }
        return jestScopeKind;
    }

    @NotNull
    private static String readValue(@NotNull Element element, @NotNull String key) {
        if (element == null) {
            JestUtil.$$$reportNull$$$0(5);
        }
        if (key == null) {
            JestUtil.$$$reportNull$$$0(6);
        }
        String string = StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)element, (String)key));
        if (string == null) {
            JestUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static List<String> readTestNames(@NotNull Element parent) {
        Element testNamesElement;
        if (parent == null) {
            JestUtil.$$$reportNull$$$0(8);
        }
        if ((testNamesElement = parent.getChild(TAG__TEST_NAMES)) == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                JestUtil.$$$reportNull$$$0(9);
            }
            return list2;
        }
        List list3 = JDOMExternalizerUtil.getChildrenValueAttributes((Element)testNamesElement, (String)TAG__TEST_NAME);
        if (list3 == null) {
            JestUtil.$$$reportNull$$$0(10);
        }
        return list3;
    }

    private static void writeValue(@NotNull Element element, @NotNull String tagName, @Nullable String value) {
        if (element == null) {
            JestUtil.$$$reportNull$$$0(11);
        }
        if (tagName == null) {
            JestUtil.$$$reportNull$$$0(12);
        }
        if (value != null) {
            JDOMExternalizerUtil.writeCustomField((Element)element, (String)tagName, (String)value);
        }
    }

    public static void writeXml(@NotNull Element element, @NotNull JestRunSettings settings) {
        if (element == null) {
            JestUtil.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            JestUtil.$$$reportNull$$$0(14);
        }
        if (!StringUtil.isEmptyOrSpaces((String)settings.getConfigFileSystemDependentPath())) {
            JestUtil.writeValue(element, TAG__CONFIG_FILE, FileUtil.toSystemIndependentName((String)settings.getConfigFileSystemDependentPath()));
        }
        JestUtil.writeValue(element, TAG__NODE_INTERPRETER, settings.getInterpreterRef().getReferenceName());
        JestUtil.writeValue(element, TAG__NODE_OPTIONS, settings.getNodeOptions());
        if (settings.getJestPackage() != null) {
            JestUtil.writeValue(element, TAG__JEST_PACKAGE, settings.getJestPackage().getSystemIndependentPath());
        }
        JestUtil.writeValue(element, TAG__WORKING_DIR, FileUtil.toSystemIndependentName((String)settings.getWorkingDirSystemDependentPath()));
        if (StringUtil.isNotEmpty((String)settings.getJestOptions())) {
            JestUtil.writeValue(element, TAG__JEST_OPTIONS, settings.getJestOptions());
        }
        settings.getEnvData().writeExternal(element);
        JestScopeKind scopeKind = settings.getScopeKind();
        JestUtil.writeValue(element, TAG__SCOPE_KIND, scopeKind.name());
        if (scopeKind == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            JestUtil.writeValue(element, TAG__TEST_FILE, FileUtil.toSystemIndependentName((String)settings.getTestFileSystemDependentPath()));
        }
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            Element testNamesElement = new Element(TAG__TEST_NAMES);
            if (!settings.getTestNames().isEmpty()) {
                JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)testNamesElement, (String)TAG__TEST_NAME, settings.getTestNames());
            }
            element.addContent(testNamesElement);
        }
    }

    @NotNull
    public static List<VirtualFile> listPossibleConfigFilesInProject(@NotNull Project project) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(15);
        }
        GlobalSearchScope contentScope = ProjectScope.getContentScope((Project)project);
        GlobalSearchScope scope = contentScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)ProjectScope.getLibrariesScope((Project)project)));
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (FileType type : new FileType[]{JsonFileType.INSTANCE, JavaScriptFileType.INSTANCE}) {
            Collection files = FileTypeIndex.getFiles((FileType)type, (GlobalSearchScope)scope);
            for (VirtualFile file2 : files) {
                if (file2 == null || !file2.isValid() || file2.isDirectory() || !JestUtil.isJestConfigFile(file2.getNameSequence()) || JSLibraryUtil.isProbableLibraryFile(file2)) continue;
                result2.add(file2);
            }
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            JestUtil.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    public static boolean isJestConfigFile(@NotNull CharSequence sequence) {
        if (sequence == null) {
            JestUtil.$$$reportNull$$$0(17);
        }
        String prefix = "jest";
        String suffix = "config.js";
        String delimiter = ".-_";
        if (StringUtil.startsWith((CharSequence)sequence, (CharSequence)prefix) && StringUtil.endsWith((CharSequence)sequence, (CharSequence)suffix) && StringUtil.containsChar((String)delimiter, (char)sequence.charAt(prefix.length())) && StringUtil.containsChar((String)delimiter, (char)sequence.charAt(sequence.length() - suffix.length() - 1))) {
            return true;
        }
        if (!StringUtil.startsWith((CharSequence)sequence, (CharSequence)CONFIG_PREFIX)) {
            return false;
        }
        if (StringUtil.equals((CharSequence)sequence, (CharSequence)CONFIG_PREFIX)) {
            return true;
        }
        if (sequence.length() > CONFIG_PREFIX.length() && sequence.charAt(CONFIG_PREFIX.length()) != '.') {
            return false;
        }
        if (StringUtil.endsWith((CharSequence)sequence, (CharSequence)".test.js")) {
            return false;
        }
        return Arrays.stream(EXTENSIONS).anyMatch(extension -> StringUtil.endsWith((CharSequence)sequence, (CharSequence)extension));
    }

    @NotNull
    public static NodePackage getJestPackage(@NotNull Project project) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(18);
        }
        String packagePath = JestUtil.getPackagePath(project);
        NodePackage nodePackage = PKG_DESCRIPTOR.createPackage(StringUtil.notNullize((String)packagePath));
        if (nodePackage == null) {
            JestUtil.$$$reportNull$$$0(19);
        }
        return nodePackage;
    }

    public static void setJestPackage(@NotNull Project project, @NotNull NodePackage jestPackage) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(20);
        }
        if (jestPackage == null) {
            JestUtil.$$$reportNull$$$0(21);
        }
        JestUtil.setPackagePath(project, jestPackage.getSystemIndependentPath());
    }

    private static void setPackagePath(@NotNull Project project, @NotNull String value) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(22);
        }
        if (value == null) {
            JestUtil.$$$reportNull$$$0(23);
        }
        PropertiesComponent.getInstance((Project)project).setValue(KEY__JEST_PACKAGE_DIR, value);
    }

    @Nullable
    private static String getPackagePath(@NotNull Project project) {
        if (project == null) {
            JestUtil.$$$reportNull$$$0(24);
        }
        return PropertiesComponent.getInstance((Project)project).getValue(KEY__JEST_PACKAGE_DIR);
    }

    @NotNull
    public static File getJestMainJsFile(@NotNull NodePackage pkg) throws ExecutionException {
        File bin;
        if (pkg == null) {
            JestUtil.$$$reportNull$$$0(25);
        }
        String pkgName = pkg.getName();
        JestPkgInfo info = PKG_INFO_MAP.get(pkg.getName());
        if (info != null && (bin = new File(pkg.getSystemDependentPath(), info.getBinFilePath())).isFile()) {
            File file2 = bin;
            if (file2 == null) {
                JestUtil.$$$reportNull$$$0(26);
            }
            return file2;
        }
        String binaryName = PackageJsonUtil.guessDefaultBinaryNameOfDependency(pkg);
        File binFile = pkg.findBinFile(binaryName, null);
        if (binFile != null) {
            File file3 = binFile;
            if (file3 == null) {
                JestUtil.$$$reportNull$$$0(27);
            }
            return file3;
        }
        throw new ExecutionException(JavaScriptBundle.message((String)"jest.cannot.find.bin.file.for.package.dialog.message", (Object[])new Object[]{pkgName}));
    }

    @Deprecated
    @NotNull
    public static String escapeJavaScriptRegexp(@NotNull String str) {
        if (str == null) {
            JestUtil.$$$reportNull$$$0(28);
        }
        String string = JSTestRunnerUtil.escapeJavaScriptRegexp(str);
        if (string == null) {
            JestUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    public static void checkRunConfiguration(@NotNull JestRunConfiguration configuration) throws RuntimeConfigurationException {
        JestRunSettings settings;
        if (configuration == null) {
            JestUtil.$$$reportNull$$$0(30);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(settings = configuration.getRunSettings()).getConfigFileSystemDependentPath())) {
            JestUtil.validatePath(false, "configuration file", settings.getConfigFileSystemDependentPath());
        }
        JestUtil.validatePath(true, "working directory", settings.getWorkingDirSystemDependentPath());
        NodeInterpreterUtil.checkForRunConfiguration(settings.getInterpreterRef().resolve(configuration.getProject()));
        configuration.getJestPackage().validateForRunConfiguration("jest");
        JestUtil.validatePath(true, "working directory", settings.getWorkingDirSystemDependentPath());
        JestScopeKind scopeKind = settings.getScopeKind();
        if (scopeKind == JestScopeKind.TEST_FILE || scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            JestUtil.validatePath(false, "test file", settings.getTestFileSystemDependentPath());
            if (scopeKind == JestScopeKind.SUITE && settings.getTestNames().isEmpty()) {
                throw new RuntimeConfigurationError(JavaScriptBundle.message((String)"dialog.message.unspecified.suite.name", (Object[])new Object[0]));
            }
            if (scopeKind == JestScopeKind.TEST && settings.getTestNames().isEmpty()) {
                throw new RuntimeConfigurationError(JavaScriptBundle.message((String)"dialog.message.unspecified.test.name", (Object[])new Object[0]));
            }
        }
    }

    private static void validatePath(boolean shouldBeDirectory, @NotNull String pathLabelName, @Nullable String path) throws RuntimeConfigurationException {
        boolean exists;
        if (pathLabelName == null) {
            JestUtil.$$$reportNull$$$0(31);
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            throw new RuntimeConfigurationError(JavaScriptBundle.message((String)"dialog.message.unspecified", (Object[])new Object[]{pathLabelName}));
        }
        File file2 = new File(path);
        if (!file2.isAbsolute()) {
            throw new RuntimeConfigurationError(JavaScriptBundle.message((String)"dialog.message.no.such", (Object[])new Object[]{pathLabelName}));
        }
        boolean bl = exists = shouldBeDirectory ? file2.isDirectory() : file2.isFile();
        if (!exists) {
            throw new RuntimeConfigurationError(JavaScriptBundle.message((String)"dialog.message.no.such", (Object[])new Object[]{pathLabelName}));
        }
    }

    public static boolean isReactScriptsFamilyPackage(@NotNull NodePackage pkg) {
        JestPkgInfo info;
        if (pkg == null) {
            JestUtil.$$$reportNull$$$0(32);
        }
        if ((info = PKG_INFO_MAP.get(pkg.getName())) != null) {
            return info.isReactScriptsFamily();
        }
        return new File(pkg.getSystemDependentPath(), "scripts/test.js").isFile();
    }

    public static void emitNewLineToFlushTrailingOutput(final @NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            JestUtil.$$$reportNull$$$0(33);
        }
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private static final String LINE = "Watch Usage: Press w to show more.";
            private Alarm myAlarm;
            private int myInd = 0;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (ProcessOutputType.isStdout((Key)outputType)) {
                    this.disposeAlarm();
                    String text = event.getText();
                    if (LINE.regionMatches(this.myInd, text, 0, text.length())) {
                        this.myInd += text.length();
                        if (this.myInd == LINE.length()) {
                            Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
                            alarm.addRequest(() -> {
                                processHandler.notifyTextAvailable("\n", outputType);
                                this.disposeAlarm();
                            }, 100);
                            this.myAlarm = alarm;
                        }
                    } else {
                        this.myInd = 0;
                    }
                }
            }

            private void disposeAlarm() {
                if (this.myAlarm != null) {
                    Disposer.dispose((Disposable)this.myAlarm);
                    this.myAlarm = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/jest/JestUtil$2";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public static String resolveFilePath(@NotNull String filePath) {
        String string;
        if (filePath == null) {
            JestUtil.$$$reportNull$$$0(34);
        }
        try {
            Path path = Paths.get(filePath, new String[0]);
            Path realPath = path.toRealPath(new LinkOption[0]);
            string = realPath.toString();
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            String string2 = filePath;
            if (string2 == null) {
                JestUtil.$$$reportNull$$$0(36);
            }
            return string2;
        }
        if (string == null) {
            JestUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public static String getTestFilePathPattern(@NotNull String filePath) {
        String resolvedTestFilePath;
        if (filePath == null) {
            JestUtil.$$$reportNull$$$0(37);
        }
        if (!filePath.equals(resolvedTestFilePath = JestUtil.resolveFilePath(filePath))) {
            String string = JestUtil.createTestPathPattern(filePath) + "|" + JestUtil.createTestPathPattern(resolvedTestFilePath);
            if (string == null) {
                JestUtil.$$$reportNull$$$0(38);
            }
            return string;
        }
        return JestUtil.createTestPathPattern(filePath);
    }

    @NotNull
    private static String createTestPathPattern(@NotNull String testFilePath) {
        if (testFilePath == null) {
            JestUtil.$$$reportNull$$$0(39);
        }
        if (SystemInfo.isWindows) {
            String pattern = "^" + JSTestRunnerUtil.escapeJavaScriptRegexp(testFilePath.replace('\\', '\u0000'), ".") + "$";
            String string = pattern.replace('\u0000', '.');
            if (string == null) {
                JestUtil.$$$reportNull$$$0(40);
            }
            return string;
        }
        String string = "^" + JSTestRunnerUtil.escapeJavaScriptRegexp(testFilePath) + "$";
        if (string == null) {
            JestUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    @Nullable
    public static List<String> getTestLocationPath(@NotNull AbstractTestProxy proxy) {
        String locationUrl;
        if (proxy == null) {
            JestUtil.$$$reportNull$$$0(42);
        }
        if ((locationUrl = proxy.getLocationUrl()) != null && locationUrl.startsWith(TEST_PROTOCOL_PREFIX)) {
            String locationPath = locationUrl.substring(TEST_PROTOCOL_PREFIX.length());
            return EscapeUtils.split((String)locationPath, (char)'.');
        }
        return null;
    }

    @Nullable
    public static VirtualFile findContextFile(@NotNull JestRunSettings settings) {
        VirtualFile f;
        if (settings == null) {
            JestUtil.$$$reportNull$$$0(43);
        }
        if ((f = JestUtil.findFile(settings.getConfigFileSystemDependentPath())) == null) {
            f = JestUtil.findFile(settings.getTestFileSystemDependentPath());
        }
        if (f == null) {
            f = JestUtil.findFile(settings.getWorkingDirSystemDependentPath());
        }
        return f;
    }

    @Nullable
    private static VirtualFile findFile(@NotNull String path) {
        if (path == null) {
            JestUtil.$$$reportNull$$$0(44);
        }
        return FileUtil.isAbsolute((String)path) ? LocalFileSystem.getInstance().findFileByPath(path) : null;
    }

    public static boolean isJestOrJestCliPackage(@NotNull String packageName) {
        if (packageName == null) {
            JestUtil.$$$reportNull$$$0(45);
        }
        return "jest".equals(packageName) || JEST_CLI_PACKAGE_NAME.equals(packageName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 26: 
            case 27: 
            case 29: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 26: 
            case 27: 
            case 29: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 26: 
            case 27: 
            case 29: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/JestUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 14: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jestPackage";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathLabelName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFilePath";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxy";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/JestUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readXml";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readScopeKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readTestNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "listPossibleConfigFilesInProject";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getJestPackage";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getJestMainJsFile";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeJavaScriptRegexp";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFilePath";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestFilePathPattern";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestPathPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readXml";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 26: 
            case 27: 
            case 29: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readScopeKind";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readTestNames";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeValue";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeXml";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "listPossibleConfigFilesInProject";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isJestConfigFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getJestPackage";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setJestPackage";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setPackagePath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPackagePath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getJestMainJsFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "escapeJavaScriptRegexp";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkRunConfiguration";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "validatePath";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isReactScriptsFamilyPackage";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "emitNewLineToFlushTrailingOutput";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "resolveFilePath";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getTestFilePathPattern";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createTestPathPattern";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getTestLocationPath";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findContextFile";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isJestOrJestCliPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 16: 
            case 19: 
            case 26: 
            case 27: 
            case 29: 
            case 35: 
            case 36: 
            case 38: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

