/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.fileDependency;

import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.fileDependency.RuntimeDependencyEdge;
import com.intellij.lang.javascript.ui.FileColor;
import com.intellij.lang.javascript.ui.NodeModuleNamesUtil;
import com.intellij.openapi.util.NlsSafe;
import java.awt.Color;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileNode {
    @NotNull
    private final String myId;
    @NotNull
    private final String myUrl;
    private final HashSet<RuntimeDependencyEdge> myOutgoingEdges;
    private final HashSet<Long> myEventsUsedIn;

    public FileNode(@NotNull String fileId, @NotNull String fileUrl) {
        if (fileId == null) {
            FileNode.$$$reportNull$$$0(0);
        }
        if (fileUrl == null) {
            FileNode.$$$reportNull$$$0(1);
        }
        this.myOutgoingEdges = new HashSet();
        this.myEventsUsedIn = new HashSet();
        this.myId = fileId;
        this.myUrl = fileUrl;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            FileNode.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            FileNode.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void addOutgoingEdge(@NotNull RuntimeDependencyEdge edge) {
        if (edge == null) {
            FileNode.$$$reportNull$$$0(4);
        }
        this.myOutgoingEdges.add(edge);
    }

    public RuntimeDependencyEdge @NotNull [] getOutgoingEdges() {
        RuntimeDependencyEdge[] runtimeDependencyEdgeArray = this.myOutgoingEdges.toArray(new RuntimeDependencyEdge[0]);
        if (runtimeDependencyEdgeArray == null) {
            FileNode.$$$reportNull$$$0(5);
        }
        return runtimeDependencyEdgeArray;
    }

    @NotNull
    public Color getFileColor() {
        Color color = FileColor.getColor((String)this.getUrl());
        if (color == null) {
            FileNode.$$$reportNull$$$0(6);
        }
        return color;
    }

    @NotNull
    public Icon getFileIcon() {
        Icon icon = FileColor.getIcon((String)this.getUrl());
        if (icon == null) {
            FileNode.$$$reportNull$$$0(7);
        }
        return icon;
    }

    @NlsSafe
    @NotNull
    public String getShortFileName() {
        String string = Utils.getShortFileName(this.getUrl());
        if (string == null) {
            FileNode.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getNodeModule() {
        String string = NodeModuleNamesUtil.getModule((String)this.getUrl());
        if (string == null) {
            FileNode.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean isUsedInEvent(long eventId) {
        return this.myEventsUsedIn.contains(eventId);
    }

    public void usedInEvent(long eventId) {
        this.myEventsUsedIn.add(eventId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/fileDependency/FileNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/fileDependency/FileNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutgoingEdges";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileColor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileIcon";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortFileName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addOutgoingEdge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

