/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.context;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.context.CommentedValuePresentation;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XKeywordValuePresentation;
import com.intellij.xdebugger.frame.presentation.XNumericValuePresentation;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XStringValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

public class TraceValue
extends XNamedValue {
    private final boolean myNoValueCaptured;
    private Object myValue;

    public TraceValue(@NotNull String name, Object value) {
        if (name == null) {
            TraceValue.$$$reportNull$$$0(0);
        }
        super(name);
        this.myValue = value;
        this.myNoValueCaptured = false;
    }

    protected TraceValue() {
        super("...");
        this.myNoValueCaptured = true;
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            TraceValue.$$$reportNull$$$0(1);
        }
        if (place == null) {
            TraceValue.$$$reportNull$$$0(2);
        }
        boolean isArray = this.myValue instanceof JSONArray;
        boolean isObject = this.myValue instanceof JSONObject;
        boolean isString = this.myValue instanceof String;
        boolean isBoolean = this.myValue instanceof Boolean;
        if (this.myNoValueCaptured) {
            node.setPresentation(AllIcons.Debugger.Value, (XValuePresentation)new XRegularValuePresentation("", null, ""), false);
        } else if (this.myValue == null) {
            node.setPresentation(AllIcons.Debugger.Db_primitive, (XValuePresentation)new XKeywordValuePresentation("null"), false);
        } else if (isArray) {
            JSONArray jsonArray = (JSONArray)this.myValue;
            int capturedElementCount = jsonArray.length();
            boolean anyElements = capturedElementCount > 0;
            Object last = jsonArray.opt(capturedElementCount - 1);
            int allElementsCount = capturedElementCount--;
            if (last != null && last.toString().startsWith("A")) {
                allElementsCount = Integer.parseInt(last.toString().substring(1));
            }
            String comment = anyElements ? (capturedElementCount != allElementsCount ? TraceBundle.message("console.trace.context.arrayCommentTemplate", capturedElementCount, capturedElementCount == 1 ? 1 : 2, allElementsCount) : TraceBundle.message("console.trace.context.arrayCommentTotalOnlyTemplate", allElementsCount, allElementsCount == 1 ? 1 : 2)) : "";
            node.setPresentation(AllIcons.Debugger.Db_array, (XValuePresentation)new CommentedValuePresentation(node, "[" + (anyElements ? "..." : " ") + "]", comment, false), anyElements);
        } else if (isObject) {
            boolean anyProperties;
            JSONObject jsonObject = (JSONObject)this.myValue;
            int capturedPropCount = jsonObject.length();
            boolean bl = anyProperties = capturedPropCount > 0;
            if (jsonObject.opt("P") != null) {
                --capturedPropCount;
            }
            node.setPresentation(AllIcons.Debugger.Value, (XValuePresentation)new CommentedValuePresentation(node, "{" + (anyProperties ? "..." : " ") + "}", anyProperties ? TraceBundle.message("console.trace.context.objectCommentTemplate", capturedPropCount, capturedPropCount == 1 ? 1 : 2) : "", false), anyProperties);
        } else if (isString) {
            final String dumpString = (String)this.myValue;
            if (dumpString.indexOf("F") == 0) {
                node.setPresentation(AllIcons.Nodes.Function, new XValuePresentation(){

                    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                        if (renderer == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        renderer.renderKeywordValue(TraceBundle.message("console.trace.context.function", new Object[0]));
                        if (dumpString.length() > 1) {
                            renderer.renderValue(" " + dumpString.substring(1));
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/javascript/trace/execution/context/TraceValue$1", "renderValue"));
                    }
                }, false);
            } else if (dumpString.equals("LA")) {
                node.setPresentation(AllIcons.Debugger.Db_array, (XValuePresentation)new XRegularValuePresentation("[...]", null), false);
            } else if (dumpString.equals("LO")) {
                node.setPresentation(AllIcons.Debugger.Value, (XValuePresentation)new XRegularValuePresentation("{...}", null), false);
            } else if (dumpString.startsWith("A")) {
                node.setPresentation(AllIcons.Debugger.Value, (XValuePresentation)new XRegularValuePresentation("...", null), false);
            } else if (dumpString.equals("EA")) {
                node.setPresentation(AllIcons.Debugger.Db_array, (XValuePresentation)new XRegularValuePresentation("[ ]", null), false);
            } else if (dumpString.equals("U")) {
                node.setPresentation(AllIcons.Debugger.Db_primitive, (XValuePresentation)new XKeywordValuePresentation("undefined"), false);
            } else if (dumpString.equals("NN")) {
                node.setPresentation(AllIcons.Debugger.Db_primitive, (XValuePresentation)new XKeywordValuePresentation("Number.NaN"), false);
            } else if (dumpString.equals("IP")) {
                node.setPresentation(AllIcons.Debugger.Db_primitive, (XValuePresentation)new XKeywordValuePresentation("Number.POSITIVE_INFINITY"), false);
            } else if (dumpString.equals("IN")) {
                node.setPresentation(AllIcons.Debugger.Db_primitive, (XValuePresentation)new XKeywordValuePresentation("Number.NEGATIVE_INFINITY"), false);
            } else if (dumpString.equals("KW")) {
                node.setPresentation(AllIcons.Debugger.Value, (XValuePresentation)new XKeywordValuePresentation("window"), false);
            } else if (dumpString.equals("KD")) {
                node.setPresentation(AllIcons.Debugger.Value, (XValuePresentation)new XKeywordValuePresentation("window.document"), false);
            } else if (dumpString.equals("KB")) {
                node.setPresentation(AllIcons.Debugger.Value, (XValuePresentation)new XKeywordValuePresentation("window.document.body"), false);
            } else if (dumpString.equals("K$")) {
                node.setPresentation(AllIcons.Debugger.Value, (XValuePresentation)new XKeywordValuePresentation("$"), false);
            } else if (dumpString.equals("K_")) {
                node.setPresentation(AllIcons.Debugger.Value, (XValuePresentation)new XKeywordValuePresentation("_"), false);
            } else if (dumpString.equals("KG")) {
                node.setPresentation(AllIcons.Debugger.Value, (XValuePresentation)new XKeywordValuePresentation("global"), false);
            } else if (dumpString.equals("KP")) {
                node.setPresentation(AllIcons.Debugger.Value, (XValuePresentation)new XKeywordValuePresentation("process"), false);
            } else if (dumpString.equals("KC")) {
                node.setPresentation(AllIcons.Debugger.Value, (XValuePresentation)new XKeywordValuePresentation("console"), false);
            } else {
                if (dumpString.indexOf("E") == 0) {
                    node.setPresentation(AllIcons.General.BalloonError, (XValuePresentation)new XRegularValuePresentation("error getting value: " + dumpString.substring(1), null), false);
                }
                if (dumpString.indexOf("D") == 0) {
                    node.setPresentation(AllIcons.Debugger.Value, (XValuePresentation)new XNumericValuePresentation(dumpString.substring(1)), false);
                } else {
                    Object value = dumpString.substring(1);
                    boolean truncated = false;
                    int length = 0;
                    if (((String)value).endsWith("$$")) {
                        truncated = true;
                        int lengthEndIndex = ((String)value).indexOf("$");
                        length = Integer.parseInt(((String)value).substring(0, lengthEndIndex));
                        value = ((String)value).substring(lengthEndIndex + 1, ((String)value).length() - 3) + "...";
                    }
                    if (truncated) {
                        node.setPresentation(AllIcons.Debugger.Value, (XValuePresentation)new CommentedValuePresentation(node, (String)value, String.format(TraceBundle.message("console.trace.context.stringLengthCommentTemplate", new Object[0]), length), true), false);
                    } else {
                        node.setPresentation(AllIcons.Debugger.Value, (XValuePresentation)new XStringValuePresentation((String)value), false);
                    }
                }
            }
        } else if (isBoolean) {
            node.setPresentation(AllIcons.Debugger.Db_primitive, (XValuePresentation)new XKeywordValuePresentation(String.valueOf(this.myValue)), false);
        } else {
            node.setPresentation(AllIcons.Debugger.Db_primitive, (XValuePresentation)new XNumericValuePresentation(String.valueOf(this.myValue)), false);
        }
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            TraceValue.$$$reportNull$$$0(3);
        }
        XValueChildrenList childrenList = new XValueChildrenList();
        if (this.myValue instanceof JSONArray) {
            JSONArray dumpArray = (JSONArray)this.myValue;
            for (int i = 0; i < dumpArray.length(); ++i) {
                childrenList.add((XNamedValue)new TraceValue(String.valueOf(i), dumpArray.opt(i)));
            }
        } else if (this.myValue instanceof JSONObject) {
            final JSONObject dumpObject = (JSONObject)this.myValue;
            for (Object key : new Iterable(){

                public Iterator iterator() {
                    return dumpObject.keys();
                }
            }) {
                String propName = key.toString();
                if (propName.equals("P")) {
                    childrenList.add((XNamedValue)new TraceValue());
                    continue;
                }
                Object element = dumpObject.opt(propName);
                childrenList.add((XNamedValue)new TraceValue(propName, element));
            }
        }
        node.addChildren(childrenList, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/trace/execution/context/TraceValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "computePresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "computeChildren";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

