/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.javascript.trace.editor.TraceResultTextAttributes;
import com.intellij.javascript.trace.execution.code.StaticAnotherStatement;
import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.code.StaticConditionalAlternate;
import com.intellij.javascript.trace.execution.code.StaticConditionalConsequent;
import com.intellij.javascript.trace.execution.code.StaticElementVisitor;
import com.intellij.javascript.trace.execution.code.StaticInReturn;
import com.intellij.javascript.trace.execution.code.StaticLogicalLeft;
import com.intellij.javascript.trace.execution.code.StaticLogicalRight;
import com.intellij.javascript.trace.execution.code.StaticReturn;
import com.intellij.javascript.trace.execution.code.StaticSwitch;
import com.intellij.javascript.trace.execution.code.StaticTest;
import com.intellij.javascript.trace.execution.common.IndexedPsiFile;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.common.RuntimeReturnStatement;
import com.intellij.javascript.trace.execution.common.RuntimeStatement;
import com.intellij.javascript.trace.execution.common.TraceRangeValue;
import com.intellij.javascript.trace.execution.common.TraceVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TraceResultEditor
extends PsiAwareTextEditorImpl {
    private final EditorEx myEditor;
    private final PsiFile myPsiFile;
    private EditorColorsScheme myColorScheme;
    private final List<RangeHighlighter> myRangeHighlighters;
    private final TraceVirtualFile myFile;

    TraceResultEditor(final @NotNull Project project, final @NotNull TraceVirtualFile file) {
        if (project == null) {
            TraceResultEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            TraceResultEditor.$$$reportNull$$$0(1);
        }
        super(project, (VirtualFile)file, new TextEditorProvider());
        this.myRangeHighlighters = new ArrayList<RangeHighlighter>();
        this.myFile = file;
        this.myEditor = (EditorEx)this.getEditor();
        this.myColorScheme = this.myEditor.getColorsScheme();
        this.myPsiFile = PsiUtilBase.getPsiFileInEditor((Editor)this.myEditor, (Project)project);
        if (this.myPsiFile != null) {
            IndexedPsiFile.getIndexedPsiFile(project, this.myPsiFile, false);
        }
        this.changeHighlightingContext(file);
        file.addContextChangedHandler(() -> this.changeHighlightingContext(file));
        final VirtualFile projectFile = file.getProjectFile();
        this.myEditor.setRendererMode(true);
        if (projectFile != null && projectFile.isValid()) {
            this.myEditor.getContentComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent event) {
                    PsiNavigationSupport.getInstance().createNavigatable(project, projectFile, file.getCurrentScopeApproxRange((Editor)TraceResultEditor.this.myEditor).getStartOffset()).navigate(true);
                }
            });
        }
        project.getMessageBus().connect((Disposable)this).subscribe(EditorColorsManager.TOPIC, scheme -> {
            this.myColorScheme = scheme;
            this.updateHighlighters(file);
        });
    }

    private void changeHighlightingContext(TraceVirtualFile file) {
        if (this.myPsiFile != null) {
            file.updateRangeValues((Editor)this.myEditor, this.myPsiFile);
        }
        this.updateHighlighters(file);
    }

    private void updateHighlighters(TraceVirtualFile file) {
        this.disposeRangeHighlighters();
        this.createRangeHighlighters(file.getCurrentContext().getStackFrame(), file.getActiveRangeValues());
    }

    private void createRangeHighlighters(final RuntimeFunctionScope functionScope, TraceRangeValue[] rangeValues) {
        TextRange functionRange = this.myFile.getFunctionRange((Editor)this.myEditor, functionScope);
        Boolean isProgram = functionScope.isProgram();
        boolean hasException = functionScope.hasException();
        for (TraceRangeValue rangeValue : rangeValues) {
            this.myRangeHighlighters.add(this.createRangeHighlighter(TraceResultTextAttributes.VALUE_HINT, rangeValue.getTextRange()));
        }
        if (!hasException) {
            this.myRangeHighlighters.add(this.createRangeHighlighter(isProgram != false ? TraceResultTextAttributes.PROGRAM_SCOPE : TraceResultTextAttributes.FUNCTION_SCOPE, functionRange));
        } else {
            this.myRangeHighlighters.add(this.createRangeHighlighter(TraceResultTextAttributes.EXCEPTION, functionRange));
        }
        StaticElementVisitor highlightsAggregator = new StaticElementVisitor(){

            @Override
            public void visit(StaticReturn element) {
                RuntimeReturnStatement returnStatement = functionScope.getReturnStatement();
                if (returnStatement == null || !returnStatement.getCodeRange().equals(element.getCodeRange())) {
                    return;
                }
                TraceResultEditor.this.myRangeHighlighters.add(TraceResultEditor.this.createRangeHighlighter(TraceResultTextAttributes.PATH_LEVEL_ONE, TraceResultEditor.this.myFile.getReturnStatementRange((Editor)TraceResultEditor.this.myEditor, returnStatement)));
            }

            @Override
            public void visit(StaticInReturn element) {
                this.addStatementHighlight(element, TraceResultTextAttributes.PATH_LEVEL_ONE);
            }

            @Override
            public void visit(StaticConditionalAlternate element) {
                this.addHighlight(element);
            }

            @Override
            public void visit(StaticConditionalConsequent element) {
                this.addHighlight(element);
            }

            @Override
            public void visit(StaticLogicalLeft element) {
                this.addHighlight(element);
            }

            @Override
            public void visit(StaticLogicalRight element) {
                this.addHighlight(element);
            }

            @Override
            public void visit(StaticTest element) {
                this.addStatementHighlight(element, TraceResultTextAttributes.PATH_LEVEL_ONE);
            }

            @Override
            public void visit(StaticSwitch element) {
                this.addStatementHighlight(element, TraceResultTextAttributes.PATH_LEVEL_ONE);
            }

            @Override
            public void visit(StaticAnotherStatement element) {
                this.addStatementHighlight(element, TraceResultTextAttributes.PATH_LEVEL_ONE);
            }

            private void addHighlight(StaticCodeElement element) {
                this.addStatementHighlight(element, TraceResultTextAttributes.PATH_LEVEL_TWO);
            }

            private void addStatementHighlight(StaticCodeElement element, TextAttributesKey highlightKey) {
                TextRange statementRange = TraceResultEditor.this.myFile.getStatementRange((Editor)TraceResultEditor.this.myEditor, functionScope, element);
                TraceResultEditor.this.myRangeHighlighters.add(TraceResultEditor.this.createRangeHighlighter(highlightKey, statementRange));
            }
        };
        HashSet<RuntimeStatement> highlightedStatements = new HashSet<RuntimeStatement>();
        for (RuntimeStatement s : functionScope.getStatements()) {
            if (highlightedStatements.contains(s)) continue;
            highlightedStatements.add(s);
            s.accept(highlightsAggregator);
        }
    }

    @NotNull
    private RangeHighlighter createRangeHighlighter(TextAttributesKey textAttributesKey, @NotNull TextRange range) {
        if (range == null) {
            TraceResultEditor.$$$reportNull$$$0(2);
        }
        RangeHighlighter rangeHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(textAttributesKey, range.getStartOffset(), range.getEndOffset(), 3000, HighlighterTargetArea.EXACT_RANGE);
        if (rangeHighlighter == null) {
            TraceResultEditor.$$$reportNull$$$0(3);
        }
        return rangeHighlighter;
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            TraceResultEditor.$$$reportNull$$$0(4);
        }
        return new TextEditorState();
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void dispose() {
        super.dispose();
        this.disposeRangeHighlighters();
    }

    private void disposeRangeHighlighters() {
        MarkupModelEx markupModel = this.myEditor.getMarkupModel();
        for (RangeHighlighter highlighter : this.myRangeHighlighters) {
            markupModel.removeHighlighter(highlighter);
            highlighter.dispose();
        }
        this.myRangeHighlighters.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/editor/TraceResultEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/editor/TraceResultEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRangeHighlighter";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

