/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.execution.testframework.ui.SameHeightPanel;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyDetailsPanel;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyGraph;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyGraphPresentation;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyVirtualFile;
import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.javascript.trace.execution.fileDependency.RuntimeDependencyEdge;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.NavigatableFileEditor;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBuilderFactory;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.pom.Navigatable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.Consumer;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDependencyGraphViewer
extends UserDataHolderBase
implements NavigatableFileEditor,
DataProvider {
    private final JPanel myMainPanel;
    private JComponent myGraphComponent;
    private GraphBuilder<FileNode, RuntimeDependencyEdge> myBuilder;
    private final Project myProject;
    private final FileDependencyVirtualFile myFile;

    public FileDependencyGraphViewer(@NotNull Project project, @NotNull FileDependencyVirtualFile file) {
        if (project == null) {
            FileDependencyGraphViewer.$$$reportNull$$$0(0);
        }
        if (file == null) {
            FileDependencyGraphViewer.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFile = file;
        this.myMainPanel = new JPanel(new BorderLayout());
        this.renderGraph();
    }

    private void renderGraph() {
        FileDependencyGraph dependencyGraph = this.myFile.getFileDependencyGraph();
        TraceContext traceContext = this.myFile.getTraceContext();
        TraceProjectSettings.EventFilterState activeFilter = traceContext.getTraceSettingsManager().getActiveFilter();
        dependencyGraph.addNodeFilter((Predicate<FileNode>)((Predicate)input -> input != null && !activeFilter.matchesFileName(input.getUrl())));
        boolean isEmptyGraph = dependencyGraph.getEdges().isEmpty();
        if (isEmptyGraph) {
            JPanel panel = new JPanel(new GridBagLayout());
            JLabel label = new JLabel(traceContext.getTraceSession().isRunning() ? TraceBundle.message("fileDependency.emptyGraph.message", new Object[0]) : TraceBundle.message("fileDependency.sessionStopped.message", new Object[0]));
            label.setBorder((Border)JBUI.Borders.empty((int)0, (int)25));
            panel.add((Component)label, new GridBagConstraints());
            this.myMainPanel.add((Component)panel, "Center");
        } else {
            JPanel rightPanel = new JPanel(new BorderLayout());
            JPanel leftPanel = new JPanel(new BorderLayout());
            JPanel graphPanel = new JPanel(new BorderLayout());
            JPanel graphToolbar = new JPanel(new BorderLayout());
            JPanel detailsToolbar = new JPanel(new BorderLayout());
            FileDependencyDetailsPanel detailsPanel = new FileDependencyDetailsPanel(traceContext, rightPanel, detailsToolbar);
            detailsPanel.setBorder(IdeBorderFactory.createBorder((int)3));
            Consumer nodeSelectedConsumer = node -> detailsPanel.displayNodeDetails(dependencyGraph.getStreamId(), (FileNode)node);
            Consumer edgeSelectedConsumer = edge -> detailsPanel.displayEdgeDetails(dependencyGraph.getStreamId(), (RuntimeDependencyEdge)edge);
            Graph2D graph2D = GraphManager.getGraphManager().createGraph2D();
            Graph2DView view = GraphManager.getGraphManager().createGraph2DView();
            GraphViewUtil.addDataProvider((Graph2DView)view, (DataProvider)this);
            FileDependencyGraphPresentation presentation = new FileDependencyGraphPresentation((Graph)graph2D, (Consumer<? super FileNode>)nodeSelectedConsumer, (Consumer<? super RuntimeDependencyEdge>)edgeSelectedConsumer);
            this.myBuilder = GraphBuilderFactory.getInstance((Project)this.myProject).createGraphBuilder(graph2D, view, (GraphDataModel)dependencyGraph, (GraphPresentationModel)presentation);
            this.myGraphComponent = (JComponent)this.myBuilder.getView().getComponent();
            graphPanel.add((Component)this.myGraphComponent, "Center");
            graphPanel.setBorder(IdeBorderFactory.createBorder((int)6));
            this.myBuilder.initialize();
            ActionManager actionManager = ActionManager.getInstance();
            ActionToolbar toolbar = actionManager.createActionToolbar("toolbar", (ActionGroup)GraphViewUtil.getCommonToolbarActions(), true);
            toolbar.setTargetComponent(this.myGraphComponent);
            graphToolbar.add((Component)toolbar.getComponent(), "Center");
            leftPanel.add((Component)graphPanel, "Center");
            leftPanel.add((Component)graphToolbar, "North");
            rightPanel.add((Component)detailsPanel, "Center");
            rightPanel.add((Component)SameHeightPanel.wrap((JComponent)detailsToolbar, (JComponent)graphToolbar), "North");
            Splitter splitter = new Splitter();
            splitter.setFirstComponent((JComponent)leftPanel);
            splitter.setSecondComponent((JComponent)rightPanel);
            splitter.setHonorComponentsMinimumSize(false);
            splitter.setProportion(0.8f);
            this.myMainPanel.add((Component)splitter, "Center");
        }
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            FileDependencyGraphViewer.$$$reportNull$$$0(2);
        }
        return false;
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        if (navigatable == null) {
            FileDependencyGraphViewer.$$$reportNull$$$0(3);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            FileDependencyGraphViewer.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myGraphComponent;
    }

    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            FileDependencyGraphViewer.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            FileDependencyGraphViewer.$$$reportNull$$$0(6);
        }
        FileEditorState fileEditorState = (otherState, level1) -> false;
        if (fileEditorState == null) {
            FileDependencyGraphViewer.$$$reportNull$$$0(7);
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            FileDependencyGraphViewer.$$$reportNull$$$0(8);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        if (this.myFile.hasChanged()) {
            this.myFile.setUpdated();
            if (this.myBuilder != null) {
                Disposer.dispose(this.myBuilder);
            }
            this.myMainPanel.removeAll();
            this.renderGraph();
        }
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            FileDependencyGraphViewer.$$$reportNull$$$0(9);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            FileDependencyGraphViewer.$$$reportNull$$$0(10);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            FileDependencyGraphViewer.$$$reportNull$$$0(11);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myBuilder.getProject();
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.myFile;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/editor/FileDependencyGraphViewer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/editor/FileDependencyGraphViewer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canNavigateTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "navigateTo";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

